/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Map;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;
import org.netbeans.modules.cnd.remote.support.ShellUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCommandSupport
extends RemoteConnectionSupport {
    private BufferedReader in;
    private StringWriter out;
    private final String cmd;
    private final Map<String, String> env;
    private boolean preserveCommand = false;

    public static int run(String string, String string2) {
        RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(string, string2);
        return remoteCommandSupport.run();
    }

    public RemoteCommandSupport(String string, String string2, Map<String, String> map, int n) {
        super(string, n);
        this.cmd = string2;
        this.env = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        if (!this.isFailedOrCancelled()) {
            log.fine("RemoteCommandSupport<Init>: Running [" + this.cmd + "] on " + this.key);
            try {
                String string;
                this.channel = this.createChannel();
                InputStream inputStream = this.channel.getInputStream();
                this.in = new BufferedReader(new InputStreamReader(inputStream));
                this.out = new StringWriter();
                while ((string = this.in.readLine()) != null || !this.channel.isClosed()) {
                    if (string == null) continue;
                    this.out.write(string + '\n');
                    this.out.flush();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.in.close();
                inputStream.close();
                this.setExitStatus(this.channel.getExitStatus());
            }
            catch (JSchException jSchException) {
                log.warning("Jsch failure during running " + this.cmd);
            }
            catch (IOException iOException) {
                log.warning("IO failure during running " + this.cmd);
            }
            finally {
                this.disconnect();
            }
        }
        return this.getExitStatus();
    }

    public RemoteCommandSupport(String string, String string2) {
        this(string, string2, null, 22);
    }

    public RemoteCommandSupport(String string, String string2, Map<String, String> map) {
        this(string, string2, map, 22);
    }

    public String toString() {
        return this.getOutput();
    }

    public String getOutput() {
        if (this.out != null) {
            return this.out.toString();
        }
        return "";
    }

    public void setPreserveCommand(boolean bl) {
        this.preserveCommand = bl;
    }

    @Override
    protected Channel createChannel() throws JSchException {
        String string;
        ChannelExec channelExec = (ChannelExec)this.session.openChannel("exec");
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.preserveCommand) {
            if (this.env != null) {
                stringBuilder.append(ShellUtils.prepareExportString(this.env));
            }
            string = "PATH";
            if (this.env == null || this.env.get(string) == null) {
                stringBuilder.append(ShellUtils.prepareExportString(new String[]{string + "=/bin:/usr/bin:$PATH"}));
            }
        } else assert (this.env == null || this.env.size() == 0);
        stringBuilder.append(this.cmd);
        string = stringBuilder.toString();
        if (!this.preserveCommand) {
            string = ShellUtils.wrapCommand(this.key, string);
        }
        channelExec.setCommand(string);
        channelExec.setInputStream(null);
        channelExec.setErrStream((OutputStream)System.err);
        channelExec.connect();
        return channelExec;
    }
}

