/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.includeview;

import java.awt.Image;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.AbstractCsmNode;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.includeview.GoToFileAction;
import org.netbeans.modules.cnd.navigation.includeview.IncludedChildren;
import org.netbeans.modules.cnd.navigation.services.IncludedModel;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class IncludeNode
extends AbstractCsmNode {
    private Image icon;
    private CsmFile object;
    private IncludedModel model;
    private boolean isRoot = false;
    private static Image downBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/navigation/includeview/resources/down_20.png");
    private static Image upBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/navigation/includeview/resources/up_8.png");
    private static Image emptyBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/navigation/includeview/resources/empty_20.png");

    public IncludeNode(CsmFile csmFile, IncludedModel includedModel, IncludedChildren includedChildren) {
        this(csmFile, (Children)new IncludedChildren(csmFile, includedModel, includedChildren), includedModel, false);
        this.isRoot = includedChildren == null;
    }

    public IncludeNode(CsmFile csmFile, Children children, IncludedModel includedModel, boolean bl) {
        super(children);
        if (bl) {
            this.setName(csmFile.getName() + " " + this.getString("CTL_Recuesion"));
        } else {
            this.setName(((Object)csmFile.getName()).toString());
        }
        this.model = includedModel;
        this.object = csmFile;
    }

    public CsmObject getCsmObject() {
        return this.object;
    }

    public Image getIcon(int n) {
        Image image = null;
        DataObject dataObject = CsmUtilities.getDataObject((CsmFile)this.object);
        image = dataObject != null ? dataObject.getNodeDelegate().getIcon(n) : super.getIcon(n);
        return this.mergeBadge(image);
    }

    private Image mergeBadge(Image image) {
        if (this.model.isDownDirection()) {
            return ImageUtilities.mergeImages((Image)image, (Image)downBadge, (int)0, (int)0);
        }
        if (this.isRoot) {
            return image;
        }
        Image image2 = ImageUtilities.mergeImages((Image)emptyBadge, (Image)image, (int)4, (int)0);
        return ImageUtilities.mergeImages((Image)image2, (Image)upBadge, (int)0, (int)0);
    }

    public int compareTo(Object object) {
        if (object instanceof IncludeNode) {
            return this.getDisplayName().compareTo(((IncludeNode)((Object)object)).getDisplayName());
        }
        return 0;
    }

    public Action getPreferredAction() {
        if (this.object.isValid()) {
            Node node = this.getParentNode();
            if (node instanceof IncludeNode) {
                CsmFile csmFile = ((IncludeNode)node).object;
                for (CsmInclude csmInclude : this.object.getIncludes()) {
                    if (csmFile.equals(csmInclude.getIncludeFile())) {
                        if (!CsmKindUtilities.isOffsetable((Object)csmInclude)) break;
                        return new GoToFileAction((CsmObject)csmInclude, this.model.getCloseWindowAction());
                    }
                    if (!this.object.equals(csmInclude.getIncludeFile()) || !CsmKindUtilities.isOffsetable((Object)csmInclude)) continue;
                    return new GoToFileAction((CsmObject)csmInclude, this.model.getCloseWindowAction());
                }
            }
            return new GoToFileAction((CsmObject)this.object, this.model.getCloseWindowAction());
        }
        return null;
    }

    public Action[] getActions(boolean bl) {
        Action action = this.getPreferredAction();
        if (action != null) {
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(action);
            arrayList.add(null);
            for (Action action2 : this.model.getDefaultActions()) {
                arrayList.add(action2);
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }
        return this.model.getDefaultActions();
    }

    private String getString(String string) {
        return NbBundle.getMessage(IncludeNode.class, (String)string);
    }

    public String getShortDescription() {
        if (this.object.isValid()) {
            return ((Object)this.object.getAbsolutePath()).toString();
        }
        return super.getShortDescription();
    }
}

