/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.callgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmCondition;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.CallModel;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.navigation.callgraph.CallImpl;
import org.netbeans.modules.cnd.navigation.callgraph.FunctionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallModelImpl
implements CallModel {
    private CsmReferenceRepository repository = CsmReferenceRepository.getDefault();
    private CsmFileReferences references = CsmFileReferences.getDefault();
    private CsmProject project;
    private String name;
    private FunctionUIN uin;

    public CallModelImpl(CsmProject csmProject, CsmFunction csmFunction) {
        this.project = csmProject;
        this.uin = new FunctionUIN(csmProject, csmFunction);
        this.name = ((Object)csmFunction.getName()).toString();
    }

    public Function getRoot() {
        CsmFunction csmFunction = this.uin.getFunction();
        if (csmFunction != null) {
            return new FunctionImpl(csmFunction);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setRoot(Function function) {
        FunctionImpl functionImpl;
        CsmFunction csmFunction;
        if (function instanceof FunctionImpl && (csmFunction = (functionImpl = (FunctionImpl)function).getDefinition()) != null) {
            this.uin = new FunctionUIN(this.project, csmFunction);
            this.name = ((Object)csmFunction.getName()).toString();
        }
    }

    public List<Call> getCallers(Function function) {
        FunctionImpl functionImpl = (FunctionImpl)function;
        CsmFunction csmFunction = functionImpl.getDeclaration();
        if (CsmKindUtilities.isFunction((CsmObject)csmFunction) && csmFunction.getContainingFile().isValid()) {
            HashMap<CsmFunction, Object> hashMap = new HashMap<CsmFunction, Object>();
            block3: for (Object object : this.repository.getReferences((CsmObject)csmFunction, this.project, CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE, null)) {
                if (object == null) continue;
                switch (object.getKind()) {
                    case IN_PREPROCESSOR_DIRECTIVE: 
                    case IN_DEAD_BLOCK: 
                    case DEFINITION: 
                    case DECLARATION: {
                        continue block3;
                    }
                }
                CsmFunction entry = this.getFunctionDeclaration(this.getOwner((CsmReference)object));
                if (entry == null || hashMap.containsKey(entry)) continue;
                hashMap.put(entry, object);
            }
            ArrayList arrayList = new ArrayList();
            for (Map.Entry entry : hashMap.entrySet()) {
                arrayList.add(new CallImpl((CsmFunction)entry.getKey(), (CsmReference)entry.getValue(), this.getFunctionDeclaration(csmFunction), true));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private CsmFunction getFunctionDeclaration(CsmFunction csmFunction) {
        if (csmFunction != null && CsmKindUtilities.isFunctionDefinition((CsmObject)csmFunction)) {
            return ((CsmFunctionDefinition)csmFunction).getDeclaration();
        }
        return csmFunction;
    }

    private CsmFunction getOwner(CsmReference csmReference) {
        CsmObject csmObject = csmReference.getOwner();
        if (CsmKindUtilities.isExpression((CsmObject)csmObject)) {
            csmObject = ((CsmExpression)csmObject).getScope();
        } else if (csmObject instanceof CsmCondition) {
            csmObject = ((CsmCondition)csmObject).getScope();
        } else if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
            return (CsmFunction)csmObject;
        }
        if (CsmKindUtilities.isStatement((CsmObject)csmObject)) {
            CsmScope csmScope = ((CsmStatement)csmObject).getScope();
            while (csmScope != null) {
                if (CsmKindUtilities.isFunction((CsmObject)csmScope)) {
                    return (CsmFunction)csmScope;
                }
                if (CsmKindUtilities.isStatement((CsmObject)csmScope)) {
                    csmScope = ((CsmStatement)csmScope).getScope();
                    continue;
                }
                return null;
            }
        }
        return null;
    }

    public List<Call> getCallees(Function function) {
        FunctionImpl functionImpl = (FunctionImpl)function;
        CsmFunction csmFunction = functionImpl.getDefinition();
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmFunction) && csmFunction.getContainingFile().isValid()) {
            final List list = CsmFileInfoQuery.getDefault().getUnusedCodeBlocks(csmFunction.getContainingFile());
            final HashMap hashMap = new HashMap();
            this.references.accept((CsmScope)csmFunction, new CsmFileReferences.Visitor(){

                public void visit(CsmReferenceContext csmReferenceContext) {
                    CsmReference csmReference = csmReferenceContext.getReference();
                    if (csmReference == null) {
                        return;
                    }
                    switch (csmReference.getKind()) {
                        case IN_PREPROCESSOR_DIRECTIVE: 
                        case IN_DEAD_BLOCK: {
                            return;
                        }
                    }
                    for (CsmOffsetable csmOffsetable : list) {
                        if (csmOffsetable.getStartOffset() > csmReference.getStartOffset() || csmOffsetable.getEndOffset() < csmReference.getEndOffset()) continue;
                        return;
                    }
                    try {
                        CsmObject csmObject = csmReference.getReferencedObject();
                        if (CsmKindUtilities.isFunction((CsmObject)csmObject) && !CsmKindUtilities.isFunction((CsmObject)csmReference.getOwner()) && !hashMap.containsKey(csmObject = CallModelImpl.this.getFunctionDeclaration((CsmFunction)csmObject))) {
                            hashMap.put((CsmFunction)csmObject, csmReference);
                        }
                    }
                    catch (AssertionError assertionError) {
                        ((Throwable)((Object)assertionError)).printStackTrace();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            ArrayList<Call> arrayList = new ArrayList<Call>();
            for (Map.Entry entry : hashMap.entrySet()) {
                arrayList.add(new CallImpl(this.getFunctionDeclaration(csmFunction), (CsmReference)entry.getValue(), (CsmFunction)entry.getKey(), false));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private static class FunctionUIN {
        private CsmProject project;
        private CharSequence functionUin;
        private CsmUID<CsmFile> fileUid;

        private FunctionUIN(CsmProject csmProject, CsmFunction csmFunction) {
            this.project = csmProject;
            this.functionUin = csmFunction.getUniqueName();
            this.fileUid = csmFunction.getContainingFile().getUID();
        }

        private CsmFunction getFunction() {
            if (!this.project.isValid()) {
                return null;
            }
            CsmFunction csmFunction = (CsmFunction)this.project.findDeclaration(this.functionUin);
            if (csmFunction != null) {
                return csmFunction;
            }
            CsmFile csmFile = (CsmFile)this.fileUid.getObject();
            if (!csmFile.isValid()) {
                return null;
            }
            for (CsmOffsetableDeclaration csmOffsetableDeclaration : csmFile.getDeclarations()) {
                csmFunction = this.findFunction((CsmDeclaration)csmOffsetableDeclaration);
                if (csmFunction == null) continue;
                return csmFunction;
            }
            return null;
        }

        private CsmFunction findFunction(CsmDeclaration csmDeclaration) {
            if (CsmKindUtilities.isTypedef((CsmObject)csmDeclaration)) {
                CsmClassifier csmClassifier;
                CsmTypedef csmTypedef = (CsmTypedef)csmDeclaration;
                if (csmTypedef.isTypeUnnamed() && (csmClassifier = csmTypedef.getType().getClassifier()) != null && csmClassifier.getName().length() == 0 && csmClassifier instanceof CsmCompoundClassifier) {
                    return this.findFunction((CsmDeclaration)((CsmCompoundClassifier)csmClassifier));
                }
                return null;
            }
            if (CsmKindUtilities.isClassifier((CsmObject)csmDeclaration)) {
                Object object;
                String string = ((Object)((CsmClassifier)csmDeclaration).getName()).toString();
                if (string.length() == 0 && csmDeclaration instanceof CsmCompoundClassifier && (object = ((CsmCompoundClassifier)csmDeclaration).getEnclosingTypedefs()).size() > 0) {
                    return null;
                }
                if (CsmKindUtilities.isClass((CsmObject)csmDeclaration)) {
                    CsmFunction csmFunction;
                    object = (CsmClass)csmDeclaration;
                    for (CsmMember csmMember : object.getMembers()) {
                        csmFunction = this.findFunction((CsmDeclaration)csmMember);
                        if (csmFunction == null) continue;
                        return csmFunction;
                    }
                    for (CsmMember csmMember : object.getFriends()) {
                        csmFunction = this.findFunction((CsmDeclaration)csmMember);
                        if (csmFunction == null) continue;
                        return csmFunction;
                    }
                }
                return null;
            }
            if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmDeclaration)) {
                for (CsmOffsetableDeclaration csmOffsetableDeclaration : ((CsmNamespaceDefinition)csmDeclaration).getDeclarations()) {
                    CsmFunction csmFunction = this.findFunction((CsmDeclaration)csmOffsetableDeclaration);
                    if (csmFunction == null) continue;
                    return csmFunction;
                }
            } else if (CsmKindUtilities.isFunction((CsmObject)csmDeclaration) && csmDeclaration.getUniqueName().equals(this.functionUin)) {
                return (CsmFunction)csmDeclaration;
            }
            return null;
        }
    }
}

