/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.faces.refactoring;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.visualweb.insync.Model;
import org.netbeans.modules.visualweb.insync.faces.AnyAttrValueScanner;
import org.netbeans.modules.visualweb.insync.faces.FacesUnit;
import org.netbeans.modules.visualweb.insync.faces.refactoring.FacesRefactoringPlugin;
import org.netbeans.modules.visualweb.insync.faces.refactoring.FacesRefactoringUtils;
import org.netbeans.modules.visualweb.insync.faces.refactoring.FacesRefactoringsPluginFactory;
import org.netbeans.modules.visualweb.insync.faces.refactoring.JSFConfigRenameFromViewIdElement;
import org.netbeans.modules.visualweb.insync.faces.refactoring.JSFConfigRenameToViewIdElement;
import org.netbeans.modules.visualweb.insync.faces.refactoring.RenameResourceReferencesRefactoringElement;
import org.netbeans.modules.visualweb.insync.faces.refactoring.SetProjectStartPageRefactoringElement;
import org.netbeans.modules.visualweb.insync.markup.MarkupUnit;
import org.netbeans.modules.visualweb.insync.models.FacesModel;
import org.netbeans.modules.visualweb.insync.models.FacesModelSet;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Document;

public class FacesJspFileRenameRefactoringPlugin
extends FacesRefactoringPlugin {
    private static final Logger LOGGER = Logger.getLogger(FacesJspFileRenameRefactoringPlugin.class.getName());

    public FacesJspFileRenameRefactoringPlugin(RenameRefactoring renameRefactoring) {
        super((AbstractRefactoring)renameRefactoring);
    }

    private RenameRefactoring getRenameRefactoring() {
        return (RenameRefactoring)this.getRefactoring();
    }

    public Problem preCheck() {
        return null;
    }

    public Problem fastCheckParameters() {
        if (!FacesJspFileRenameRefactoringPlugin.isDelegatedRefactoring(this.getRefactoring())) {
            FileObject fileObject = (FileObject)this.getRenameRefactoring().getRefactoringSource().lookup(FileObject.class);
            String string = this.getRenameRefactoring().getNewName();
            if (fileObject != null && FacesRefactoringUtils.isFileUnderDocumentRoot(fileObject)) {
                if (string == null) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileRenameRefactoringPlugin.class, (String)"ERR_NewNameCannotBeNull"));
                }
                if ((string = string.trim()).length() == 0) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileRenameRefactoringPlugin.class, (String)"ERR_NewNameCannotBeEmpty"));
                }
                if (string.equals(fileObject.getName())) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileRenameRefactoringPlugin.class, (String)"ERR_NewNameSameAsOldName"));
                }
                if (!Utilities.isJavaIdentifier((String)string)) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileRenameRefactoringPlugin.class, (String)"ERR_NewNameIsNotAValidJavaIdentifier"));
                }
                if (FacesUnit.isImplicitBeanName(string)) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileRenameRefactoringPlugin.class, (String)"ERR_ReservedIdentifier", (Object)string));
                }
                if (!Character.isUpperCase(string.charAt(0))) {
                    return new Problem(false, NbBundle.getMessage(FacesJspFileRenameRefactoringPlugin.class, (String)"WRN_NewNameDoesNotStartWithUppercaseLetter"));
                }
                FileObject fileObject2 = fileObject.getParent().getFileObject(string, fileObject.getExt());
                if (fileObject2 != null && fileObject2.isValid()) {
                    return new Problem(false, NbBundle.getMessage(FacesJspFileRenameRefactoringPlugin.class, (String)"ERR_NewNameJspFileAlreadyExists"));
                }
                FileObject fileObject3 = FacesModel.getJavaForJsp(fileObject);
                if (fileObject3 != null && (fileObject2 = fileObject3.getParent().getFileObject(string, fileObject3.getExt())) != null && fileObject2.isValid()) {
                    return new Problem(false, NbBundle.getMessage(FacesJspFileRenameRefactoringPlugin.class, (String)"ERR_NewNameJavaFileAlreadyExists"));
                }
            }
        }
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        RefactoringSession refactoringSession = refactoringElementsBag.getSession();
        FileObject fileObject = (FileObject)this.getRenameRefactoring().getRefactoringSource().lookup(FileObject.class);
        if (fileObject != null && FacesRefactoringUtils.isFileUnderDocumentRoot(fileObject) && FacesRefactoringUtils.isVisualWebJspFile(fileObject)) {
            Object object;
            Object object2;
            FileObject[] fileObjectArray;
            MarkupUnit markupUnit;
            String string;
            String string2;
            FileObject fileObject2;
            FileObject fileObject3;
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null) {
                return null;
            }
            String string3 = this.getRenameRefactoring().getNewName();
            if (string3 == null) {
                return new Problem(true, NbBundle.getMessage(FacesJspFileRenameRefactoringPlugin.class, (String)"ERR_NewNameCannotBeNull"));
            }
            if (!FacesJspFileRenameRefactoringPlugin.isDelegatedRefactoring(this.getRefactoring())) {
                fileObject3 = FacesModel.getJavaForJsp(fileObject);
                if (fileObject3 == null) {
                    // empty if block
                }
                fileObject2 = new RenameRefactoring(Lookups.singleton((Object)fileObject3));
                fileObject2.setNewName(string3);
                fileObject2.setSearchInComments(this.getRenameRefactoring().isSearchInComments());
                string2 = FacesRefactoringUtils.getClasspathInfoFor(fileObject3);
                fileObject2.getContext().add((Object)string2);
                fileObject2.getContext().add((Object)FacesRefactoringsPluginFactory.DELEGATED_REFACTORING);
                string = fileObject2.prepare(refactoringSession);
                if (string != null) {
                    return string;
                }
            }
            fileObject3 = JsfProjectUtils.getDocumentRoot((Project)project);
            fileObject2 = fileObject.getParent();
            string2 = FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject2);
            string = string2 + (string2.length() > 0 ? "/" : "") + fileObject.getNameExt();
            String string4 = string2 + (string2.length() > 0 ? "/" : "") + string3 + "." + fileObject.getExt();
            FacesModelSet facesModelSet = FacesModelSet.getInstance(fileObject);
            FacesModel facesModel = facesModelSet.getFacesModel(fileObject);
            if (facesModel != null && facesModel.isPageBean() && (markupUnit = facesModel.getMarkupUnit()) != null) {
                fileObjectArray = new AnyAttrValueScanner();
                object2 = facesModelSet.getModels();
                for (int i = 0; i < ((Model[])object2).length; ++i) {
                    String string5;
                    MarkupUnit markupUnit2;
                    FacesModel facesModel2;
                    object = object2[i];
                    if (!(object instanceof FacesModel) || (facesModel2 = (FacesModel)object).isBusted() || !facesModel2.isPageBean()) continue;
                    FileObject fileObject4 = facesModel2.getMarkupFile();
                    if (fileObject4 == null) {
                        FacesJspFileRenameRefactoringPlugin.info(new IllegalStateException("The FacesModel returned null markup file, facesModel=" + facesModel2));
                        continue;
                    }
                    FileObject fileObject5 = fileObject4.getParent();
                    String string6 = FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject5);
                    String string7 = FacesRefactoringUtils.computeRelativePath(fileObject5.getPath(), fileObject.getPath());
                    if (string7 == null || (markupUnit2 = facesModel2.getMarkupUnit()) == null) continue;
                    Document document = markupUnit2.getSourceDom();
                    int n = fileObjectArray.getReferenceCount(document, string7);
                    if (n > 0 && (string5 = FacesRefactoringUtils.computeRelativePath(string6, string4)) != null) {
                        refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new RenameResourceReferencesRefactoringElement(fileObject4, markupUnit2, string7, string5));
                    }
                    if ((n = fileObjectArray.getReferenceCount(document, "/faces/" + string)) <= 0) continue;
                    refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new RenameResourceReferencesRefactoringElement(fileObject4, markupUnit2, "/faces/" + string, "/faces/" + string4));
                }
            }
            if (JsfProjectUtils.isStartPage((FileObject)fileObject)) {
                refactoringElementsBag.addFileChange(this.getRefactoring(), (RefactoringElementImplementation)new SetProjectStartPageRefactoringElement(project, string, string4));
            }
            if ((markupUnit = WebModule.getWebModule((FileObject)project.getProjectDirectory())) != null && (fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)markupUnit)) != null) {
                object2 = FacesRefactoringUtils.getAllFromViewIdOccurrences((WebModule)markupUnit, "/" + string, "/" + string4);
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (FacesRefactoringUtils.OccurrenceItem)iterator.next();
                    refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new JSFConfigRenameFromViewIdElement((FacesRefactoringUtils.OccurrenceItem)object));
                }
                object2 = FacesRefactoringUtils.getAllToViewOccurrences((WebModule)markupUnit, "/" + string, "/" + string4);
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (FacesRefactoringUtils.OccurrenceItem)iterator.next();
                    refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new JSFConfigRenameToViewIdElement((FacesRefactoringUtils.OccurrenceItem)object));
                }
            }
        }
        return null;
    }

    private static void info(Exception exception) {
        Logger.getLogger(FacesJspFileRenameRefactoringPlugin.class.getName()).log(Level.INFO, null, exception);
    }
}

