/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.ide.JBLogWriter;
import org.netbeans.modules.j2ee.jboss4.ide.JBStartServer;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class JBStopRunnable
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(JBStopRunnable.class.getName());
    private static final String SHUTDOWN_SH = "/bin/shutdown.sh";
    private static final String SHUTDOWN_BAT = "/bin/shutdown.bat";
    private static final int TIMEOUT = 300000;
    private final JBDeploymentManager dm;
    private final JBStartServer startServer;

    JBStopRunnable(JBDeploymentManager jBDeploymentManager, JBStartServer jBStartServer) {
        this.dm = jBDeploymentManager;
        this.startServer = jBStartServer;
    }

    private String[] createEnvironment() {
        JBProperties jBProperties = this.dm.getProperties();
        JavaPlatform javaPlatform = jBProperties.getJavaPlatform();
        FileObject fileObject = (FileObject)javaPlatform.getInstallFolders().iterator().next();
        String string = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add("JAVA=" + string + "/bin/java");
        arrayList.add("JAVA_HOME=" + string);
        if (Utilities.isWindows()) {
            arrayList.add("NOPAUSE=true");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void run() {
        InstanceProperties instanceProperties = this.dm.getInstanceProperties();
        String string = instanceProperties.getProperty("server");
        if ("minimal".equals(string)) {
            this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED_MINIMAL")));
            return;
        }
        String string2 = instanceProperties.getProperty("displayName");
        String string3 = instanceProperties.getProperty("root-dir");
        String string4 = string3 + (Utilities.isWindows() ? SHUTDOWN_BAT : SHUTDOWN_SH);
        File file = new File(string4);
        if (!file.exists()) {
            this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED_FNF", (Object)string2)));
            return;
        }
        JBProperties jBProperties = this.dm.getProperties();
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(" -u ").append(jBProperties.getUsername()).append(" -p ").append(jBProperties.getPassword());
        NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(string4, "--shutdown " + stringBuilder);
        Process process = null;
        try {
            String[] stringArray = this.createEnvironment();
            process = nbProcessDescriptor.exec(null, stringArray, true, null);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED_PD", (Object)string2, (Object)string4)));
            return;
        }
        this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)string2)));
        LOGGER.log(Level.FINER, "Entering the loop");
        int n = 0;
        while (n < 300000) {
            try {
                int n2 = process.exitValue();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "The stopping process has terminated with the exit value " + n2);
                }
                if (n2 != 0) {
                    String string5 = NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED", (Object)string2);
                    this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, string5));
                    return;
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
            if (this.startServer.isRunning()) {
                this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)string2)));
                LOGGER.log(Level.FINER, "STOPPING message fired");
                try {
                    n += 500;
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            LOGGER.log(Level.FINER, "JBoss has been stopped, going to stop the Log Writer thread");
            JBLogWriter jBLogWriter = JBLogWriter.getInstance(instanceProperties.getProperty("displayName"));
            if (jBLogWriter != null && jBLogWriter.isRunning()) {
                jBLogWriter.waitForServerProcessFinished(10000L);
                jBLogWriter.stop();
            }
            this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.COMPLETED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_SERVER_STOPPED", (Object)string2)));
            LOGGER.log(Level.FINER, "STOPPED message fired");
            return;
        }
        this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_StopServerTimeout")));
        if (process != null) {
            process.destroy();
        }
        LOGGER.log(Level.FINER, "TIMEOUT expired");
    }
}

