/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.source.ui.DialogBinding;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.FilteredKeymap;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WatchPanel {
    private static RequestProcessor contextRetrievalRP;
    private JPanel panel;
    private JEditorPane editorPane;
    private String expression;

    public WatchPanel(String string) {
        this.expression = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupContext(final JEditorPane jEditorPane) {
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)"text/x-java");
        jEditorPane.setEditorKit(editorKit);
        if (EventQueue.isDispatchThread()) {
            Class<WatchPanel> clazz = WatchPanel.class;
            synchronized (WatchPanel.class) {
                if (contextRetrievalRP == null) {
                    contextRetrievalRP = new RequestProcessor("Context Retrieval", 1);
                }
                contextRetrievalRP.post(new Runnable(){

                    public void run() {
                        final Context context = WatchPanel.retrieveContext();
                        if (context != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    WatchPanel.setupContext(jEditorPane, context.url, context.line);
                                }
                            });
                        }
                    }
                });
                // ** MonitorExit[var2_2] (shouldn't be in output)
                WatchPanel.setupUI(jEditorPane);
            }
        } else {
            Context context = WatchPanel.retrieveContext();
            if (context != null) {
                WatchPanel.setupContext(jEditorPane, context.url, context.line);
            } else {
                WatchPanel.setupUI(jEditorPane);
            }
        }
    }

    private static Context retrieveContext() {
        Object object;
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        CallStackFrame callStackFrame = null;
        if (debuggerEngine != null) {
            object = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
            callStackFrame = object.getCurrentCallStackFrame();
        }
        if (callStackFrame != null) {
            object = DebuggerManager.getDebuggerManager().getCurrentSession().getCurrentLanguage();
            SourcePath sourcePath = (SourcePath)debuggerEngine.lookupFirst(null, SourcePath.class);
            Context context = new Context();
            context.url = sourcePath.getURL(callStackFrame, (String)object);
            context.line = callStackFrame.getLineNumber((String)object);
            return context;
        }
        object = EditorContextBridge.getContext();
        String string = object.getCurrentURL();
        if (string != null) {
            Context context = new Context();
            context.url = string;
            context.line = object.getCurrentLineNumber();
            if (context.line == -1) {
                context.line = 0;
            }
            return context;
        }
        return null;
    }

    public static void setupContext(JEditorPane jEditorPane, String string, int n) {
        StyledDocument styledDocument;
        EditorCookie editorCookie;
        FileObject fileObject;
        WatchPanel.setupUI(jEditorPane);
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
            if (fileObject == null) {
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie == null) {
                    return;
                }
                try {
                    styledDocument = editorCookie.openDocument();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    return;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        try {
            int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
            editorCookie = DialogBinding.bindComponentToFile((FileObject)fileObject, (int)n2, (int)0, (JTextComponent)jEditorPane);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ErrorManager.getDefault().notify(1, (Throwable)indexOutOfBoundsException);
        }
    }

    private static void setupUI(final JEditorPane jEditorPane) {
        Runnable runnable = new Runnable(){

            public void run() {
                EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jEditorPane);
                editorUI.removeLayer("highlight-row-layer");
                try {
                    Field field = EditorUI.class.getDeclaredField("textLimitLineVisible");
                    field.setAccessible(true);
                    field.set(editorUI, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public JComponent getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel();
        ResourceBundle resourceBundle = NbBundle.getBundle(WatchPanel.class);
        this.panel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_WatchPanel"));
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)resourceBundle.getString("CTL_Watch_Name"));
        this.editorPane = new JEditorPane();
        this.editorPane.setText(this.expression);
        WatchPanel.setupContext(this.editorPane);
        JScrollPane jScrollPane = WatchPanel.createScrollableLineEditor(this.editorPane);
        FontMetrics fontMetrics = this.editorPane.getFontMetrics(this.editorPane.getFont());
        int n = 2 * fontMetrics.getLeading() + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 2;
        Insets insets = this.editorPane.getInsets();
        Insets insets2 = jScrollPane.getInsets();
        jScrollPane.setPreferredSize(new Dimension(30 * n, n + 2 + insets.bottom + insets.top + insets2.bottom + insets2.top));
        jLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.panel.add("North", jLabel);
        this.panel.add("Center", jScrollPane);
        this.editorPane.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Watch_Name"));
        this.editorPane.setText(this.expression);
        this.editorPane.selectAll();
        jLabel.setLabelFor(this.editorPane);
        HelpCtx.setHelpIDString((JComponent)this.editorPane, (String)"debug.customize.watch");
        this.editorPane.requestFocus();
        return this.panel;
    }

    public String getExpression() {
        return this.editorPane.getText().trim();
    }

    public static JScrollPane createScrollableLineEditor(JEditorPane jEditorPane) {
        jEditorPane.setKeymap(new FilteredKeymap(jEditorPane));
        JScrollPane jScrollPane = new JScrollPane(21, 31);
        jEditorPane.setBorder(new CompoundBorder(jEditorPane.getBorder(), new EmptyBorder(0, 0, 0, 0)));
        JTextField jTextField = new JTextField("M");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(jTextField.getBackground());
        jScrollPane.setBorder(jTextField.getBorder());
        jScrollPane.setBackground(jTextField.getBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jEditorPane, gridBagConstraints);
        jScrollPane.setViewportView(jPanel);
        int n = jTextField.getPreferredSize().height;
        if (jScrollPane.getPreferredSize().height < n) {
            jScrollPane.setPreferredSize(jTextField.getPreferredSize());
        }
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        WatchPanel.setupUI(jEditorPane);
        Set<AWTKeyStroke> set = jTextField.getFocusTraversalKeys(0);
        jEditorPane.setFocusTraversalKeys(0, set);
        set = jTextField.getFocusTraversalKeys(1);
        jEditorPane.setFocusTraversalKeys(1, set);
        return jScrollPane;
    }

    private static final class Context {
        public String url;
        public int line;

        private Context() {
        }
    }
}

