/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.model;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DisplayItem;
import com.sun.rave.designtime.Result;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseMetaDataTransfer;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.api.designerapi.DesignTimeTransferDataCreator;
import org.netbeans.modules.visualweb.dataconnectivity.DataconnectivitySettings;
import org.netbeans.modules.visualweb.dataconnectivity.datasource.CurrentProject;
import org.netbeans.modules.visualweb.dataconnectivity.datasource.DataSourceResolver;
import org.netbeans.modules.visualweb.dataconnectivity.explorer.RowSetBeanCreateInfoSet;
import org.netbeans.modules.visualweb.dataconnectivity.model.DataSourceInfo;
import org.netbeans.modules.visualweb.dataconnectivity.model.ProjectDataSourceManager;
import org.netbeans.modules.visualweb.dataconnectivity.ui.DataSourceNamePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class DatasourceTransferManager
implements DesignTimeTransferDataCreator {
    protected static String dataProviderClassName = "com.sun.data.provider.impl.CachedRowSetDataProvider";
    public static String rowSetClassName = "com.sun.sql.rowset.CachedRowSetXImpl";
    private static final Logger LOGGER = Logger.getLogger(DatasourceTransferManager.class.getName());
    private static final String UNDERSCORE = "_";
    private static final String SLASH = "/";

    public DisplayItem getDisplayItem(Transferable transferable) {
        Object object = null;
        try {
            DataFlavor dataFlavor = DatabaseMetaDataTransfer.TABLE_FLAVOR;
            DataFlavor dataFlavor2 = DatabaseMetaDataTransfer.VIEW_FLAVOR;
            if (transferable.isDataFlavorSupported(dataFlavor)) {
                object = transferable.getTransferData(dataFlavor);
                if (object != null && object.getClass().isAssignableFrom(DatabaseMetaDataTransfer.Table.class)) {
                    DatabaseMetaDataTransfer.Table table = (DatabaseMetaDataTransfer.Table)object;
                    DatabaseConnection databaseConnection = table.getDatabaseConnection();
                    String string = databaseConnection.getSchema();
                    Connection connection = databaseConnection.getJDBCConnection();
                    DatabaseMetaData databaseMetaData = connection == null ? null : connection.getMetaData();
                    String string2 = string == null || string.equals("") ? table.getTableName() : string + "." + table.getTableName();
                    JDBCDriver jDBCDriver = table.getJDBCDriver();
                    return new DatasourceBeanCreateInfoSet(databaseConnection, jDBCDriver, string2, databaseMetaData);
                }
            } else if (transferable.isDataFlavorSupported(dataFlavor2) && (object = transferable.getTransferData(dataFlavor2)) != null && object.getClass().isAssignableFrom(DatabaseMetaDataTransfer.View.class)) {
                DatabaseMetaDataTransfer.View view = (DatabaseMetaDataTransfer.View)object;
                DatabaseConnection databaseConnection = view.getDatabaseConnection();
                String string = databaseConnection.getSchema();
                Connection connection = databaseConnection.getJDBCConnection();
                DatabaseMetaData databaseMetaData = connection == null ? null : connection.getMetaData();
                String string3 = string == null || string.equals("") ? view.getViewName() : string + "." + view.getViewName();
                JDBCDriver jDBCDriver = view.getJDBCDriver();
                return new DatasourceBeanCreateInfoSet(databaseConnection, jDBCDriver, string3, databaseMetaData);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return null;
    }

    private static final class DatasourceBeanCreateInfoSet
    extends RowSetBeanCreateInfoSet {
        DatabaseConnection dbConnection = null;
        JDBCDriver jdbcDriver = null;

        public DatasourceBeanCreateInfoSet(DatabaseConnection databaseConnection, JDBCDriver jDBCDriver, String string, DatabaseMetaData databaseMetaData) {
            super(string, databaseMetaData);
            this.dbConnection = databaseConnection;
            this.jdbcDriver = jDBCDriver;
        }

        public Result beansCreatedSetup(DesignBean[] designBeanArray) {
            Object object;
            Object object2;
            int n;
            DesignBean designBean = designBeanArray[0];
            boolean bl = false;
            String string = null;
            try {
                string = this.dbConnection.getJDBCConnection().getMetaData().getDatabaseProductName().replaceAll("\\s{1}", "");
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            String string2 = "dataSource";
            String string3 = this.dbConnection.getDriverClass();
            String string4 = this.dbConnection.getDatabaseURL();
            String string5 = null;
            String string6 = this.dbConnection.getUser();
            String string7 = this.dbConnection.getPassword();
            String string8 = this.dbConnection.getSchema();
            if (string8.equals("")) {
                if (string.equals("MySQL") && string4.lastIndexOf("?") == -1) {
                    string2 = string4.substring(string4.lastIndexOf(DatasourceTransferManager.SLASH) + 1, string4.length()) + DatasourceTransferManager.UNDERSCORE + string;
                } else if (string.contains("Firebird")) {
                    string2 = this.getTableName() + DatasourceTransferManager.UNDERSCORE + "Firebird";
                } else if (string.contains(DatasourceTransferManager.SLASH)) {
                    n = string.indexOf(DatasourceTransferManager.SLASH);
                    object2 = string.substring(0, n);
                    object = string.substring(n + 1);
                    string2 = (String)object2 + DatasourceTransferManager.UNDERSCORE + (String)object;
                } else {
                    string2 = string.equals("MySQL") ? string4.substring(string4.lastIndexOf(DatasourceTransferManager.SLASH) + 1, string4.lastIndexOf("?")) + DatasourceTransferManager.UNDERSCORE + string : this.getTableName() + DatasourceTransferManager.UNDERSCORE + string;
                }
            } else if (string.contains(DatasourceTransferManager.SLASH)) {
                n = string.indexOf(DatasourceTransferManager.SLASH);
                object2 = string.substring(0, n);
                object = string.substring(n + 1);
                string2 = (String)object2 + DatasourceTransferManager.UNDERSCORE + (String)object;
            } else {
                string2 = this.dbConnection.getSchema() + DatasourceTransferManager.UNDERSCORE + string;
            }
            Project project = CurrentProject.getInstance().getCurrentProject(designBeanArray);
            if (!DataSourceResolver.getInstance().isDatasourceCreationSupported(project)) {
                bl = true;
                DataSourceResolver.getInstance().postUnsupportedDataSourceCreationDialog();
            }
            if ("Oracle".equals(string)) {
                try {
                    if (this.dbConnection.getJDBCConnection().getMetaData().getDriverMajorVersion() < 10 && this.dbConnection.getJDBCConnection().getMetaData().getDriverMinorVersion() < 2) {
                        bl = true;
                        LOGGER.log(Level.WARNING, "Oracle driver version 10 or later supported.  Drop cancelled.");
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DatasourceBeanCreateInfoSet.class, (String)"ORACLE_DRIVER_WARNING"));
                    }
                }
                catch (SQLException sQLException) {
                    Exceptions.printStackTrace((Throwable)sQLException);
                }
            }
            if (!DataSourceResolver.getInstance().isDataSourceUnique(project, string2, string4)) {
                string2 = this.getUniqueName(string2);
            }
            if (DataconnectivitySettings.promptForName()) {
                object2 = new DataSourceNamePanel(string2);
                object = new DialogDescriptor(object2, NbBundle.getMessage(DataSourceNamePanel.class, (String)"LBL_SpecifyDataSourceName"), true, -1, DialogDescriptor.OK_OPTION, 0, HelpCtx.DEFAULT_HELP, null);
                object.setValid(true);
                Object object3 = DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
                if (object3 == NotifyDescriptor.OK_OPTION) {
                    string2 = ((DataSourceNamePanel)object2).getDataSourceName();
                } else if (object3 == NotifyDescriptor.CANCEL_OPTION) {
                    bl = true;
                }
            }
            if (!bl) {
                object2 = new DataSourceInfo(string2, string3, string4, string5, string6, string7);
                object = new ProjectDataSourceManager(designBean);
                ((ProjectDataSourceManager)object).addDataSource((DataSourceInfo)object2);
                this.setDataSourceInfo((DataSourceInfo)object2);
                return super.beansCreatedSetup(designBeanArray);
            }
            object2 = designBeanArray[0];
            object = object2.getDesignContext();
            object.deleteBean((DesignBean)object2);
            return null;
        }

        private int getIndex(String string) {
            int n = -1;
            if (string.indexOf(95) != -1) {
                try {
                    n = Integer.parseInt(string.substring(string.lastIndexOf(95) + 1, string.length() - 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return n;
        }

        private String getUniqueName(String string) {
            int n = this.getIndex(string);
            if (n != -1) {
                String string2 = string.substring(0, string.indexOf(95));
                return string2 + DatasourceTransferManager.UNDERSCORE + Integer.toString(++n);
            }
            return string + DatasourceTransferManager.UNDERSCORE + 1;
        }
    }
}

