/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.ui.CopyClassRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.MoveClassUI;
import org.netbeans.modules.refactoring.java.ui.MoveClassesUI;
import org.netbeans.modules.refactoring.java.ui.RenameRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.SafeDeleteUI;
import org.netbeans.modules.refactoring.java.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    public void doRename(final Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        Runnable runnable = RefactoringActionsProvider.isFromEditor(editorCookie) ? new TextComponentTask(editorCookie){

            protected RefactoringUI createRefactoringUI(TreePathHandle treePathHandle, int n, int n2, final CompilationInfo compilationInfo) {
                Element element = treePathHandle.resolveElement(compilationInfo);
                if (element == null) {
                    return null;
                }
                if (element.getKind() == ElementKind.CONSTRUCTOR) {
                    element = element.getEnclosingElement();
                    treePathHandle = TreePathHandle.create((TreePath)compilationInfo.getTrees().getPath(element), (CompilationInfo)compilationInfo);
                }
                if (element.getKind() == ElementKind.PACKAGE) {
                    NonRecursiveFolder nonRecursiveFolder = new NonRecursiveFolder(){

                        public FileObject getFolder() {
                            return compilationInfo.getFileObject().getParent();
                        }
                    };
                    return new RenameRefactoringUI(nonRecursiveFolder);
                }
                if (element instanceof TypeElement && !((TypeElement)element).getNestingKind().isNested()) {
                    FileObject fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationInfo.getClasspathInfo());
                    if (fileObject != null && element.getSimpleName().toString().equals(fileObject.getName())) {
                        return new RenameRefactoringUI(fileObject == null ? compilationInfo.getFileObject() : fileObject, treePathHandle, compilationInfo);
                    }
                    return new RenameRefactoringUI(treePathHandle, compilationInfo);
                }
                return new RenameRefactoringUI(treePathHandle, compilationInfo);
            }
        } : (RefactoringActionsProvider.nodeHandle(lookup) ? new TreePathHandleTask(new HashSet(lookup.lookupAll(Node.class)), true){
            RefactoringUI ui;

            @Override
            protected void treePathHandleResolved(TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
                this.ui = this.renameFile ? new RenameRefactoringUI(treePathHandle.getFileObject(), treePathHandle, compilationInfo) : new RenameRefactoringUI(treePathHandle, compilationInfo);
            }

            @Override
            protected RefactoringUI createRefactoringUI(Collection<TreePathHandle> collection) {
                return this.ui;
            }
        } : new NodeToFileObjectTask(Collections.singleton(lookup.lookup(Node.class))){
            RefactoringUI ui;

            @Override
            protected void nodeTranslated(Node node, Collection<TreePathHandle> collection, CompilationInfo compilationInfo) {
                String string = RefactoringActionsProvider.getName(lookup);
                this.ui = string != null ? new RenameRefactoringUI(compilationInfo.getFileObject(), string, collection == null || collection.isEmpty() ? null : collection.iterator().next(), compilationInfo) : new RenameRefactoringUI(compilationInfo.getFileObject(), collection == null || collection.isEmpty() ? null : collection.iterator().next(), compilationInfo);
            }

            @Override
            protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray, Collection<TreePathHandle> collection) {
                if (this.ui == null) {
                    String string = RefactoringActionsProvider.getName(lookup);
                    this.ui = string != null ? (this.pkg[0] != null ? new RenameRefactoringUI(this.pkg[0], string) : new RenameRefactoringUI(fileObjectArray[0], string, null, null)) : (this.pkg[0] != null ? new RenameRefactoringUI(this.pkg[0]) : new RenameRefactoringUI(fileObjectArray[0], null, null));
                }
                return this.ui;
            }
        });
        RetoucheUtils.invokeAfterScanFinished(runnable, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.renameAction()));
    }

    static String getActionName(Action action) {
        String string = (String)action.getValue("Name");
        string = Utilities.replaceString((String)string, (String)"&", (String)"");
        return Utilities.replaceString((String)string, (String)"...", (String)"");
    }

    public boolean canRename(Lookup lookup) {
        HashSet hashSet = new HashSet(lookup.lookupAll(Node.class));
        if (hashSet.size() != 1) {
            return false;
        }
        Node node = (Node)hashSet.iterator().next();
        TreePathHandle treePathHandle = (TreePathHandle)node.getLookup().lookup(TreePathHandle.class);
        if (treePathHandle != null) {
            return RetoucheUtils.isRefactorable(treePathHandle.getFileObject());
        }
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (RetoucheUtils.isRefactorable(fileObject)) {
            return true;
        }
        return dataObject instanceof DataFolder && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject) && !RetoucheUtils.isClasspathRoot(fileObject);
    }

    public void doCopy(final Lookup lookup) {
        NodeToFileObjectTask nodeToFileObjectTask = new NodeToFileObjectTask(new HashSet(lookup.lookupAll(Node.class))){

            @Override
            protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray, Collection<TreePathHandle> collection) {
                return new CopyClassRefactoringUI(fileObjectArray[0], RefactoringActionsProvider.this.getTarget(lookup), RefactoringActionsProvider.this.getPaste(lookup));
            }
        };
        RetoucheUtils.invokeAfterScanFinished(nodeToFileObjectTask, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.copyAction()));
    }

    public boolean canCopy(Lookup lookup) {
        HashSet hashSet = new HashSet(lookup.lookupAll(Node.class));
        if (hashSet.size() != 1) {
            return false;
        }
        Node node = (Node)hashSet.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        ExplorerContext explorerContext = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        FileObject fileObject = this.getTarget(lookup);
        if (explorerContext != null && explorerContext.getTargetNode() != null && fileObject == null) {
            return false;
        }
        if (fileObject != null) {
            if (!fileObject.isFolder() || !RetoucheUtils.isOnSourceClasspath(fileObject)) {
                return false;
            }
            FileObject fileObject2 = dataObject.getPrimaryFile();
            if (RetoucheUtils.isRefactorable(fileObject2)) {
                return true;
            }
        } else {
            FileObject fileObject3 = dataObject.getPrimaryFile();
            if (RetoucheUtils.isRefactorable(fileObject3)) {
                return true;
            }
        }
        return false;
    }

    public boolean canFindUsages(Lookup lookup) {
        HashSet hashSet = new HashSet(lookup.lookupAll(Node.class));
        if (hashSet.size() != 1) {
            return false;
        }
        Node node = (Node)hashSet.iterator().next();
        if (node.getLookup().lookup(TreePathHandle.class) != null) {
            return true;
        }
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        return dataObject != null && RetoucheUtils.isJavaFile(dataObject.getPrimaryFile()) && !"package-info".equals(dataObject.getName());
    }

    public void doFindUsages(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        Runnable runnable = RefactoringActionsProvider.isFromEditor(editorCookie) ? new TextComponentTask(editorCookie){

            protected RefactoringUI createRefactoringUI(TreePathHandle treePathHandle, int n, int n2, CompilationInfo compilationInfo) {
                return new WhereUsedQueryUI(treePathHandle, compilationInfo);
            }
        } : (RefactoringActionsProvider.nodeHandle(lookup) ? new TreePathHandleTask(new HashSet(lookup.lookupAll(Node.class)), true){
            RefactoringUI ui;

            @Override
            protected void treePathHandleResolved(TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
                this.ui = new WhereUsedQueryUI(treePathHandle, compilationInfo);
            }

            @Override
            protected RefactoringUI createRefactoringUI(Collection<TreePathHandle> collection) {
                return this.ui;
            }
        } : new NodeToElementTask(new HashSet(lookup.lookupAll(Node.class))){

            protected RefactoringUI createRefactoringUI(TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
                if (treePathHandle == null) {
                    return null;
                }
                return new WhereUsedQueryUI(treePathHandle, compilationInfo);
            }
        });
        RetoucheUtils.invokeAfterScanFinished(runnable, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.whereUsedAction()));
    }

    public boolean canDelete(Lookup lookup) {
        HashSet hashSet = new HashSet(lookup.lookupAll(Node.class));
        if (RefactoringActionsProvider.isSelectionHeterogeneous(hashSet)) {
            return false;
        }
        for (Node node : hashSet) {
            TreePathHandle treePathHandle = (TreePathHandle)node.getLookup().lookup(TreePathHandle.class);
            if (treePathHandle != null) {
                return RetoucheUtils.isRefactorable(treePathHandle.getFileObject());
            }
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject == null) {
                return false;
            }
            FileObject fileObject = dataObject.getPrimaryFile();
            if (RefactoringActionsProvider.isRefactorableFolder(dataObject)) {
                return true;
            }
            if (RetoucheUtils.isRefactorable(fileObject)) continue;
            return false;
        }
        return !hashSet.isEmpty();
    }

    public void doDelete(Lookup lookup) {
        boolean bl;
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        boolean bl2 = bl = lookup.lookup(ExplorerContext.class) != null;
        Runnable runnable = RefactoringActionsProvider.isFromEditor(editorCookie) ? new TextComponentTask(editorCookie){

            protected RefactoringUI createRefactoringUI(TreePathHandle treePathHandle, int n, int n2, CompilationInfo compilationInfo) {
                Element element = treePathHandle.resolveElement(compilationInfo);
                if (element.getKind() == ElementKind.PACKAGE || element.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
                    FileObject fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationInfo.getClasspathInfo());
                    if (fileObject == null) {
                        return null;
                    }
                    if (fileObject.getName().equals(element.getSimpleName().toString())) {
                        return new SafeDeleteUI(new FileObject[]{fileObject}, Collections.singleton(treePathHandle), bl);
                    }
                }
                return new SafeDeleteUI(new TreePathHandle[]{treePathHandle});
            }
        } : (RefactoringActionsProvider.nodeHandle(lookup) ? new TreePathHandleTask(new HashSet(lookup.lookupAll(Node.class))){

            @Override
            protected RefactoringUI createRefactoringUI(Collection<TreePathHandle> collection) {
                if (this.renameFile) {
                    FileObject[] fileObjectArray = new FileObject[collection.size()];
                    int n = 0;
                    for (TreePathHandle treePathHandle : collection) {
                        fileObjectArray[n++] = treePathHandle.getFileObject();
                    }
                    return new SafeDeleteUI(fileObjectArray, collection, bl);
                }
                return new SafeDeleteUI(collection.toArray(new TreePathHandle[collection.size()]));
            }
        } : new NodeToFileObjectTask(new HashSet(lookup.lookupAll(Node.class))){

            @Override
            protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray, Collection<TreePathHandle> collection) {
                if (this.pkg[0] != null) {
                    return new SafeDeleteUI(this.pkg[0], bl);
                }
                return new SafeDeleteUI(fileObjectArray, collection, bl);
            }
        });
        RetoucheUtils.invokeAfterScanFinished(runnable, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.safeDeleteAction()));
    }

    private FileObject getTarget(Lookup lookup) {
        ExplorerContext explorerContext = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        if (explorerContext == null) {
            return null;
        }
        Node node = explorerContext.getTargetNode();
        if (node == null) {
            return null;
        }
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject != null) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    private PasteType getPaste(Lookup lookup) {
        ExplorerContext explorerContext = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        if (explorerContext == null) {
            return null;
        }
        Transferable transferable = explorerContext.getTransferable();
        if (transferable == null) {
            return null;
        }
        Node node = explorerContext.getTargetNode();
        if (node == null) {
            return null;
        }
        PasteType[] pasteTypeArray = node.getPasteTypes(transferable);
        if (pasteTypeArray.length == 1) {
            return null;
        }
        return pasteTypeArray[1];
    }

    static String getName(Lookup lookup) {
        ExplorerContext explorerContext = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        if (explorerContext == null) {
            return null;
        }
        return explorerContext.getNewName();
    }

    public boolean canMove(Lookup lookup) {
        HashSet hashSet = new HashSet(lookup.lookupAll(Node.class));
        ExplorerContext explorerContext = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        FileObject fileObject = this.getTarget(lookup);
        if (fileObject != null) {
            Object object;
            if (!fileObject.isFolder()) {
                return false;
            }
            if (!RetoucheUtils.isOnSourceClasspath(fileObject)) {
                return false;
            }
            HashSet<DataFolder> hashSet2 = new HashSet<DataFolder>();
            boolean bl = false;
            for (Node node : hashSet) {
                object = (DataObject)node.getCookie(DataObject.class);
                if (object == null) {
                    return false;
                }
                if (!RetoucheUtils.isOnSourceClasspath(object.getPrimaryFile())) {
                    return false;
                }
                if (object instanceof DataFolder) {
                    if (FileUtil.getRelativePath((FileObject)object.getPrimaryFile(), (FileObject)fileObject) != null) {
                        return false;
                    }
                    hashSet2.add((DataFolder)object);
                    continue;
                }
                if (!RetoucheUtils.isJavaFile(object.getPrimaryFile())) continue;
                bl = true;
            }
            if (bl) {
                return true;
            }
            for (DataFolder dataFolder : hashSet2) {
                object = dataFolder.children(true);
                while (object.hasMoreElements()) {
                    if (!RetoucheUtils.isJavaFile(((DataObject)object.nextElement()).getPrimaryFile())) continue;
                    return true;
                }
            }
            return false;
        }
        boolean bl = false;
        for (Node node : hashSet) {
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject == null) {
                return false;
            }
            if (dataObject instanceof DataFolder) {
                return explorerContext != null;
            }
            if (!RetoucheUtils.isOnSourceClasspath(dataObject.getPrimaryFile())) {
                return false;
            }
            if (!RetoucheUtils.isJavaFile(dataObject.getPrimaryFile())) continue;
            bl = true;
        }
        return bl;
    }

    public void doMove(final Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        Runnable runnable = RefactoringActionsProvider.isFromEditor(editorCookie) ? new TextComponentTask(editorCookie){

            protected RefactoringUI createRefactoringUI(TreePathHandle treePathHandle, int n, int n2, CompilationInfo compilationInfo) {
                Element element = treePathHandle.resolveElement(compilationInfo);
                if ((element.getKind().isClass() || element.getKind().isInterface()) && SourceUtils.getOutermostEnclosingTypeElement((Element)element) == element) {
                    try {
                        DataObject dataObject;
                        FileObject fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationInfo.getClasspathInfo());
                        if (fileObject != null && (dataObject = DataObject.find((FileObject)SourceUtils.getFile((Element)element, (ClasspathInfo)compilationInfo.getClasspathInfo()))).getName().equals(element.getSimpleName().toString())) {
                            return new MoveClassUI(dataObject);
                        }
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        throw (RuntimeException)new RuntimeException().initCause(dataObjectNotFoundException);
                    }
                }
                if (treePathHandle.resolve(compilationInfo).getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                    try {
                        return new MoveClassUI(DataObject.find((FileObject)compilationInfo.getFileObject()));
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        throw (RuntimeException)new RuntimeException().initCause(dataObjectNotFoundException);
                    }
                }
                try {
                    return new MoveClassUI(DataObject.find((FileObject)compilationInfo.getFileObject()));
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    throw (RuntimeException)new RuntimeException().initCause(dataObjectNotFoundException);
                }
            }
        } : new NodeToFileObjectTask(new HashSet(lookup.lookupAll(Node.class))){

            @Override
            protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray, Collection<TreePathHandle> collection) {
                PasteType pasteType = RefactoringActionsProvider.this.getPaste(lookup);
                FileObject fileObject = RefactoringActionsProvider.this.getTarget(lookup);
                if (fileObjectArray.length == 1) {
                    if (!fileObjectArray[0].isFolder()) {
                        try {
                            return new MoveClassUI(DataObject.find((FileObject)fileObjectArray[0]), fileObject, pasteType, collection);
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            throw (RuntimeException)new RuntimeException().initCause(dataObjectNotFoundException);
                        }
                    }
                    HashSet<FileObject> hashSet = new HashSet<FileObject>();
                    hashSet.addAll(Arrays.asList(fileObjectArray));
                    return new MoveClassesUI(hashSet, fileObject, pasteType);
                }
                HashSet<FileObject> hashSet = new HashSet<FileObject>();
                hashSet.addAll(Arrays.asList(fileObjectArray));
                return new MoveClassesUI(hashSet, fileObject, pasteType);
            }
        };
        RetoucheUtils.invokeAfterScanFinished(runnable, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.renameAction()));
    }

    private static boolean isSelectionHeterogeneous(Collection<? extends Node> collection) {
        boolean bl = false;
        boolean bl2 = false;
        for (Node node : collection) {
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject == null) continue;
            if (RefactoringActionsProvider.isRefactorableFolder(dataObject)) {
                if (bl || bl2) {
                    return true;
                }
                bl = true;
                continue;
            }
            bl2 = true;
        }
        return false;
    }

    static boolean isFromEditor(EditorCookie editorCookie) {
        TopComponent topComponent;
        return editorCookie != null && editorCookie.getOpenedPanes() != null && (topComponent = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }

    static boolean nodeHandle(Lookup lookup) {
        Node node = (Node)lookup.lookup(Node.class);
        return node != null && node.getLookup().lookup(TreePathHandle.class) != null;
    }

    private static boolean isRefactorableFolder(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (fileObjectArray == null || fileObjectArray.length <= 0) {
            return false;
        }
        return dataObject instanceof DataFolder && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject) && !RetoucheUtils.isClasspathRoot(fileObject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NodeToFileObjectTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private Collection<? extends Node> nodes;
        public NonRecursiveFolder[] pkg;
        Collection<TreePathHandle> handles = new ArrayList<TreePathHandle>();
        private Node currentNode;

        public NodeToFileObjectTask(Collection<? extends Node> collection) {
            this.nodes = collection;
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            ArrayList<TreePathHandle> arrayList = new ArrayList<TreePathHandle>();
            CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
            ArrayList<TreePathHandle> arrayList2 = new ArrayList<TreePathHandle>();
            ArrayList<TreePathHandle> arrayList3 = new ArrayList<TreePathHandle>();
            for (Tree tree : compilationUnitTree.getTypeDecls()) {
                TreePathHandle treePathHandle;
                Element element = compilationController.getTrees().getElement(TreePath.getPath(compilationUnitTree, tree));
                if (element == null || !element.getKind().isClass() && !element.getKind().isInterface()) continue;
                if (element.getSimpleName().toString().equals(compilationController.getFileObject().getName())) {
                    treePathHandle = TreePathHandle.create((TreePath)TreePath.getPath(compilationUnitTree, tree), (CompilationInfo)compilationController);
                    arrayList3.add(treePathHandle);
                }
                if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                treePathHandle = TreePathHandle.create((TreePath)TreePath.getPath(compilationUnitTree, tree), (CompilationInfo)compilationController);
                arrayList2.add(treePathHandle);
            }
            if (!arrayList2.isEmpty()) {
                arrayList.addAll(arrayList2);
            } else {
                arrayList.addAll(arrayList3);
            }
            if (!arrayList.isEmpty()) {
                this.handles.addAll(arrayList);
                this.nodeTranslated(this.currentNode, arrayList, (CompilationInfo)compilationController);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileObject[] fileObjectArray = new FileObject[this.nodes.size()];
            this.pkg = new NonRecursiveFolder[fileObjectArray.length];
            int n = 0;
            for (Node node : this.nodes) {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject == null) continue;
                fileObjectArray[n] = dataObject.getPrimaryFile();
                if (RetoucheUtils.isJavaFile(fileObjectArray[n])) {
                    JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObjectArray[n]);
                    assert (javaSource != null);
                    try {
                        this.currentNode = node;
                        javaSource.runUserActionTask((Task)this, true);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    finally {
                        this.currentNode = null;
                    }
                }
                this.pkg[n++] = (NonRecursiveFolder)node.getLookup().lookup(NonRecursiveFolder.class);
            }
            RefactoringUI refactoringUI = this.createRefactoringUI(fileObjectArray, this.handles);
            if (refactoringUI != null) {
                UI.openRefactoringUI((RefactoringUI)refactoringUI);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_NoTypeDecls"));
            }
        }

        protected void nodeTranslated(Node node, Collection<TreePathHandle> collection, CompilationInfo compilationInfo) {
        }

        protected abstract RefactoringUI createRefactoringUI(FileObject[] var1, Collection<TreePathHandle> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NodeToElementTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private Node node;
        private RefactoringUI ui;

        public NodeToElementTask(Collection<? extends Node> collection) {
            assert (collection.size() == 1);
            this.node = collection.iterator().next();
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
            if (compilationUnitTree.getTypeDecls().isEmpty()) {
                this.ui = this.createRefactoringUI(null, (CompilationInfo)compilationController);
            } else {
                TreePathHandle treePathHandle = TreePathHandle.create((TreePath)TreePath.getPath(compilationUnitTree, compilationUnitTree.getTypeDecls().get(0)), (CompilationInfo)compilationController);
                this.ui = this.createRefactoringUI(treePathHandle, (CompilationInfo)compilationController);
            }
        }

        @Override
        public final void run() {
            DataObject dataObject = (DataObject)this.node.getCookie(DataObject.class);
            JavaSource javaSource = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
            assert (javaSource != null);
            try {
                javaSource.runUserActionTask((Task)this, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_NoTypeDecls"));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(TreePathHandle var1, CompilationInfo var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TextComponentTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private JTextComponent textC;
        private int caret;
        private int start;
        private int end;
        private RefactoringUI ui;

        public TextComponentTask(EditorCookie editorCookie) {
            this.textC = editorCookie.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            this.start = this.textC.getSelectionStart();
            this.end = this.textC.getSelectionEnd();
            assert (this.caret != -1);
            assert (this.start != -1);
            assert (this.end != -1);
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws Exception {
            List<? extends Tree> list;
            TreePath treePath = null;
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            treePath = compilationController.getTreeUtilities().pathFor(this.caret);
            if (treePath.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT && !(list = compilationController.getCompilationUnit().getTypeDecls()).isEmpty()) {
                treePath = TreePath.getPath(compilationController.getCompilationUnit(), list.get(0));
            }
            this.ui = this.createRefactoringUI(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationController), this.start, this.end, (CompilationInfo)compilationController);
        }

        @Override
        public final void run() {
            JavaSource javaSource;
            try {
                javaSource = JavaSource.forDocument((Document)this.textC.getDocument());
                javaSource.runUserActionTask((Task)this, true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return;
            }
            javaSource = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)javaSource);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRenameKeyword"));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(TreePathHandle var1, int var2, int var3, CompilationInfo var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TreePathHandleTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private Collection<TreePathHandle> handles = new ArrayList<TreePathHandle>();
        private TreePathHandle current;
        boolean renameFile;

        public TreePathHandleTask(Collection<? extends Node> collection) {
            this(collection, false);
        }

        public TreePathHandleTask(Collection<? extends Node> collection, boolean bl) {
            for (Node node : collection) {
                TreePathHandle treePathHandle = (TreePathHandle)node.getLookup().lookup(TreePathHandle.class);
                if (treePathHandle == null) continue;
                this.handles.add(treePathHandle);
                if (!bl) continue;
                break;
            }
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            Element element = this.current.resolveElement((CompilationInfo)compilationController);
            if (element != null && element instanceof TypeElement && !((TypeElement)element).getNestingKind().isNested() && compilationController.getFileObject().getName().equals(element.getSimpleName().toString())) {
                this.renameFile = true;
            }
            this.treePathHandleResolved(this.current, (CompilationInfo)compilationController);
        }

        @Override
        public void run() {
            TreePathHandle treePathHandle2;
            for (TreePathHandle treePathHandle2 : this.handles) {
                FileObject fileObject = treePathHandle2.getFileObject();
                this.current = treePathHandle2;
                JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
                assert (javaSource != null);
                try {
                    javaSource.runUserActionTask((Task)this, true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            treePathHandle2 = this.createRefactoringUI(this.handles);
            if (treePathHandle2 != null) {
                UI.openRefactoringUI((RefactoringUI)treePathHandle2, (TopComponent)topComponent);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRenameKeyword"));
            }
        }

        protected void treePathHandleResolved(TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
        }

        protected abstract RefactoringUI createRefactoringUI(Collection<TreePathHandle> var1);
    }
}

