/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.GestureSubmitter;
import org.netbeans.api.debugger.LazyDebuggerManagerListener;
import org.netbeans.api.debugger.Lookup;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.debugger.DelegatingDebuggerEngineProvider;
import org.netbeans.spi.debugger.DelegatingSessionProvider;
import org.netbeans.spi.debugger.SessionProvider;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DebuggerManager
implements ContextProvider {
    public static final String PROP_BREAKPOINTS_INIT = "breakpointsInit";
    public static final String PROP_BREAKPOINTS = "breakpoints";
    public static final String PROP_CURRENT_ENGINE = "currentEngine";
    public static final String PROP_CURRENT_SESSION = "currentSession";
    public static final String PROP_SESSIONS = "sessions";
    public static final String PROP_DEBUGGER_ENGINES = "debuggerEngines";
    public static final String PROP_WATCHES = "watches";
    public static final String PROP_WATCHES_INIT = "watchesInit";
    private static DebuggerManager debuggerManager;
    private Session currentSession;
    private DebuggerEngine currentEngine;
    private List sessions = new ArrayList();
    private Set engines = new HashSet();
    private Vector breakpoints = new Vector();
    private boolean breakpointsInitializing = false;
    private boolean breakpointsInitialized = false;
    private Vector watches = new Vector();
    private boolean watchesInitialized = false;
    private SessionListener sessionListener = new SessionListener();
    private Vector listeners = new Vector();
    private HashMap listenersMap = new HashMap();
    private ActionsManager actionsManager = null;
    private Lookup lookup = new Lookup.MetaInf(null);
    private List<Breakpoint> createdBreakpoints;
    private Map<ClassLoader, Set<Breakpoint>> breakpointsByClassLoaders = new HashMap<ClassLoader, Set<Breakpoint>>();
    private Set<LazyDebuggerManagerListener> loadedListeners;
    private List<? extends LazyDebuggerManagerListener> listenersLookupList;

    public static synchronized DebuggerManager getDebuggerManager() {
        if (debuggerManager == null) {
            debuggerManager = new DebuggerManager();
        }
        return debuggerManager;
    }

    private DebuggerManager() {
    }

    public synchronized ActionsManager getActionsManager() {
        if (this.actionsManager == null) {
            this.actionsManager = new ActionsManager(this.lookup);
        }
        return this.actionsManager;
    }

    @Override
    public <T> List<? extends T> lookup(String string, Class<T> clazz) {
        return this.lookup.lookup(string, clazz);
    }

    @Override
    public <T> T lookupFirst(String string, Class<T> clazz) {
        return this.lookup.lookupFirst(string, clazz);
    }

    public static ContextProvider join(ContextProvider contextProvider, ContextProvider contextProvider2) {
        return new Lookup.Compound(contextProvider, contextProvider2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerEngine[] startDebugging(DebuggerInfo debuggerInfo) {
        Object object;
        Object object2;
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<DebuggerEngine> arrayList2 = new ArrayList<DebuggerEngine>();
        Lookup lookup = debuggerInfo.getLookup();
        Lookup lookup2 = debuggerInfo.getLookup();
        Lookup lookup3 = lookup;
        synchronized (lookup3) {
            arrayList.addAll(lookup.lookup(null, SessionProvider.class));
            arrayList.addAll(lookup.lookup(null, DelegatingSessionProvider.class));
        }
        lookup3 = null;
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object2 = null;
            if (arrayList.get(n) instanceof DelegatingSessionProvider) {
                object2 = ((DelegatingSessionProvider)arrayList.get(n)).getSession(debuggerInfo);
                lookup = new Lookup.Compound(lookup, ((Session)object2).privateLookup);
            } else {
                object = (SessionProvider)arrayList.get(n);
                if (((SessionProvider)object).getSessionName() == null) {
                    throw new NullPointerException("<null> session name provided by: " + object);
                }
                if (((SessionProvider)object).getTypeID() == null) {
                    throw new NullPointerException("<null> type ID provided by: " + object);
                }
                if (((SessionProvider)object).getServices() == null) {
                    throw new NullPointerException("<null> services provided by: " + object);
                }
                object2 = new Session(((SessionProvider)object).getSessionName(), ((SessionProvider)object).getLocationName(), ((SessionProvider)object).getTypeID(), ((SessionProvider)object).getServices(), lookup);
                lookup3 = object2;
                lookup = ((Session)object2).getLookup();
                lookup2 = ((Session)object2).getLookup();
                this.addSession((Session)object2);
            }
            object = new ArrayList();
            Lookup lookup4 = lookup2;
            synchronized (lookup4) {
                ((ArrayList)object).addAll(lookup2.lookup(null, DebuggerEngineProvider.class));
                ((ArrayList)object).addAll(lookup2.lookup(null, DelegatingDebuggerEngineProvider.class));
            }
            int n3 = ((ArrayList)object).size();
            for (int i = 0; i < n3; ++i) {
                Object object3;
                DebuggerEngine debuggerEngine = null;
                String[] stringArray = null;
                if (((ArrayList)object).get(i) instanceof DebuggerEngineProvider) {
                    object3 = (DebuggerEngineProvider)((ArrayList)object).get(i);
                    Object[] objectArray = ((DebuggerEngineProvider)object3).getServices();
                    debuggerEngine = new DebuggerEngine(((DebuggerEngineProvider)object3).getEngineTypeID(), (Session)object2, objectArray, lookup);
                    stringArray = ((DebuggerEngineProvider)object3).getLanguages();
                    ((DebuggerEngineProvider)object3).setDestructor(debuggerEngine.new DebuggerEngine.Destructor());
                    arrayList2.add(debuggerEngine);
                } else {
                    object3 = (DelegatingDebuggerEngineProvider)((ArrayList)object).get(i);
                    stringArray = ((DelegatingDebuggerEngineProvider)object3).getLanguages();
                    debuggerEngine = ((DelegatingDebuggerEngineProvider)object3).getEngine();
                    ((DelegatingDebuggerEngineProvider)object3).setDestructor(debuggerEngine.new DebuggerEngine.Destructor());
                }
                int n4 = stringArray.length;
                for (int j = 0; j < n4; ++j) {
                    ((Session)object2).addLanguage(stringArray[j], debuggerEngine);
                }
            }
        }
        n2 = arrayList2.size();
        for (n = 0; n < n2 && !Thread.interrupted(); ++n) {
            object2 = ((DebuggerEngine)arrayList2.get(n)).getActionsManager().postAction(ActionsManager.ACTION_START);
            if (object2 instanceof Cancellable) {
                try {
                    object2.waitFinished(0L);
                }
                catch (InterruptedException interruptedException) {
                    if (((Cancellable)object2).cancel()) break;
                    object2.waitFinished();
                }
                continue;
            }
            object2.waitFinished();
        }
        if (n < n2) {
            int n5 = n + 1;
            for (n = 0; n < n2; ++n) {
                object = ((DebuggerEngine)arrayList2.get(n)).getActionsManager();
                if (n < n5 - 1) {
                    ((ActionsManager)object).postAction(ActionsManager.ACTION_KILL);
                }
                ((ActionsManager)object).destroy();
            }
            return new DebuggerEngine[0];
        }
        if (lookup3 != null) {
            GestureSubmitter.logDebugStart((Session)((Object)lookup3), arrayList2);
            this.setCurrentSession((Session)((Object)lookup3));
        }
        object2 = new DebuggerEngine[arrayList2.size()];
        return (DebuggerEngine[])arrayList2.toArray((T[])object2);
    }

    public void finishAllSessions() {
        Session[] sessionArray = this.getSessions();
        if (sessionArray.length == 0) {
            return;
        }
        int n = sessionArray.length;
        for (int i = 0; i < n; ++i) {
            sessionArray[i].getCurrentEngine().getActionsManager().doAction(ActionsManager.ACTION_KILL);
        }
    }

    public Session getCurrentSession() {
        return this.currentSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentSession(Session session) {
        DebuggerEngine debuggerEngine;
        DebuggerEngine debuggerEngine2;
        Session session2;
        Session session3;
        List list = this.sessions;
        synchronized (list) {
            if (session != null) {
                int n;
                int n2 = this.sessions.size();
                for (n = 0; n < n2 && session != this.sessions.get(n); ++n) {
                }
                if (n == n2) {
                    return;
                }
            }
            if (session == (session3 = this.getCurrentSession())) {
                return;
            }
            this.currentSession = session2 = session;
            debuggerEngine2 = this.currentEngine;
            debuggerEngine = null;
            if (this.getCurrentSession() != null) {
                debuggerEngine = this.getCurrentSession().getCurrentEngine();
            }
            this.currentEngine = debuggerEngine;
        }
        if (debuggerEngine2 != debuggerEngine) {
            this.firePropertyChange(PROP_CURRENT_ENGINE, debuggerEngine2, debuggerEngine);
        }
        this.firePropertyChange(PROP_CURRENT_SESSION, session3, session2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] getSessions() {
        List list = this.sessions;
        synchronized (list) {
            return this.sessions.toArray(new Session[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerEngine[] getDebuggerEngines() {
        Set set = this.engines;
        synchronized (set) {
            return this.engines.toArray(new DebuggerEngine[this.engines.size()]);
        }
    }

    public DebuggerEngine getCurrentEngine() {
        return this.currentEngine;
    }

    public void addBreakpoint(Breakpoint breakpoint) {
        if (this.initBreakpoints(breakpoint) && this.registerBreakpoint(breakpoint)) {
            this.breakpoints.addElement(breakpoint);
            this.fireBreakpointCreated(breakpoint, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerBreakpoint(Breakpoint breakpoint) {
        Class<?> clazz = breakpoint.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        Map<ClassLoader, Set<Breakpoint>> map = this.breakpointsByClassLoaders;
        synchronized (map) {
            Set<Breakpoint> set = this.breakpointsByClassLoaders.get(classLoader);
            if (set == null) {
                set = new HashSet<Breakpoint>();
                this.breakpointsByClassLoaders.put(classLoader, set);
            }
            return set.add(breakpoint);
        }
    }

    public void removeBreakpoint(Breakpoint breakpoint) {
        this.removeBreakpoint(breakpoint, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBreakpoint(Breakpoint breakpoint, boolean bl) {
        if (!bl) {
            this.initBreakpoints();
            Class<?> clazz = breakpoint.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Map<ClassLoader, Set<Breakpoint>> map = this.breakpointsByClassLoaders;
            synchronized (map) {
                Set<Breakpoint> set = this.breakpointsByClassLoaders.get(classLoader);
                if (set != null) {
                    set.remove(breakpoint);
                    if (set.isEmpty()) {
                        this.breakpointsByClassLoaders.remove(classLoader);
                    }
                }
            }
            this.breakpoints.removeElement(breakpoint);
            breakpoint.disposeOut();
        } else {
            this.breakpoints.removeElement(breakpoint);
            breakpoint.dispose();
        }
        this.fireBreakpointRemoved(breakpoint, bl, null);
    }

    public Breakpoint[] getBreakpoints() {
        this.initBreakpoints();
        return this.breakpoints.toArray(new Breakpoint[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moduleUnloaded(ClassLoader classLoader) {
        Set<Breakpoint> set;
        Map<ClassLoader, Set<Breakpoint>> map = this.breakpointsByClassLoaders;
        synchronized (map) {
            set = this.breakpointsByClassLoaders.remove(classLoader);
        }
        if (set == null) {
            return;
        }
        for (Breakpoint breakpoint : set) {
            this.removeBreakpoint(breakpoint, true);
        }
    }

    public Watch createWatch(String string) {
        this.initWatches();
        Watch watch = new Watch(string);
        this.watches.addElement(watch);
        this.fireWatchCreated(watch);
        return watch;
    }

    public Watch[] getWatches() {
        this.initWatches();
        return this.watches.toArray(new Watch[0]);
    }

    public void removeAllWatches() {
        this.initWatches();
        Vector vector = (Vector)this.watches.clone();
        int n = vector.size();
        for (int i = n - 1; i >= 0; --i) {
            ((Watch)vector.elementAt(i)).remove();
        }
    }

    void removeWatch(Watch watch) {
        this.initWatches();
        this.watches.removeElement(watch);
        this.fireWatchRemoved(watch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String string, Object object, Object object2) {
        int n;
        Vector vector;
        this.initDebuggerManagerListeners();
        Vector vector2 = (Vector)this.listeners.clone();
        Serializable serializable = this.listenersMap;
        synchronized (serializable) {
            vector = (Vector)this.listenersMap.get(string);
            if (vector != null) {
                vector = (Vector)vector.clone();
            }
        }
        serializable = new PropertyChangeEvent(this, string, object, object2);
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            try {
                ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange((PropertyChangeEvent)serializable);
                continue;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        if (vector != null) {
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                try {
                    ((DebuggerManagerListener)vector.elementAt(n)).propertyChange((PropertyChangeEvent)serializable);
                    continue;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    public void addDebuggerListener(DebuggerManagerListener debuggerManagerListener) {
        this.listeners.addElement(debuggerManagerListener);
    }

    public void removeDebuggerListener(DebuggerManagerListener debuggerManagerListener) {
        this.listeners.removeElement(debuggerManagerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDebuggerListener(String string, DebuggerManagerListener debuggerManagerListener) {
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            Vector<DebuggerManagerListener> vector = (Vector<DebuggerManagerListener>)this.listenersMap.get(string);
            if (vector == null) {
                vector = new Vector<DebuggerManagerListener>();
                this.listenersMap.put(string, vector);
            }
            vector.addElement(debuggerManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDebuggerListener(String string, DebuggerManagerListener debuggerManagerListener) {
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            Vector vector = (Vector)this.listenersMap.get(string);
            if (vector == null) {
                return;
            }
            vector.removeElement(debuggerManagerListener);
            if (vector.size() == 0) {
                this.listenersMap.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBreakpointCreated(Breakpoint breakpoint, DebuggerManagerListener debuggerManagerListener) {
        Object object;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_BREAKPOINTS, null, null);
        Vector vector = (Vector)this.listeners.clone();
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            object = (DebuggerManagerListener)vector.elementAt(n);
            if (object == debuggerManagerListener) continue;
            try {
                object.breakpointAdded(breakpoint);
                object.propertyChange(propertyChangeEvent);
                continue;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        Object object2 = this.listenersMap;
        synchronized (object2) {
            object = (Vector)this.listenersMap.get(PROP_BREAKPOINTS);
            if (object != null) {
                object = (Vector)((Vector)object).clone();
            }
        }
        if (object != null) {
            n2 = ((Vector)object).size();
            for (n = 0; n < n2; ++n) {
                object2 = (DebuggerManagerListener)((Vector)object).elementAt(n);
                if (object2 == debuggerManagerListener) continue;
                try {
                    object2.breakpointAdded(breakpoint);
                    object2.propertyChange(propertyChangeEvent);
                    continue;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBreakpointRemoved(Breakpoint breakpoint, boolean bl, DebuggerManagerListener debuggerManagerListener) {
        Object object;
        Object object2;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_BREAKPOINTS, null, null);
        Vector vector = (Vector)this.listeners.clone();
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            object2 = (DebuggerManagerListener)vector.elementAt(n);
            if (object2 == debuggerManagerListener || bl && (object = object2.initBreakpoints()) != null && ((Breakpoint[])object).length > 0) continue;
            try {
                object2.breakpointRemoved(breakpoint);
                object2.propertyChange(propertyChangeEvent);
                continue;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        object = this.listenersMap;
        synchronized (this.listenersMap) {
            object2 = (Vector)this.listenersMap.get(PROP_BREAKPOINTS);
            if (object2 != null) {
                object2 = (Vector)((Vector)object2).clone();
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            if (object2 != null) {
                n2 = ((Vector)object2).size();
                for (n = 0; n < n2; ++n) {
                    Breakpoint[] breakpointArray;
                    object = (DebuggerManagerListener)((Vector)object2).elementAt(n);
                    if (object == debuggerManagerListener || bl && (breakpointArray = object.initBreakpoints()) != null && breakpointArray.length > 0) continue;
                    try {
                        object.breakpointRemoved(breakpoint);
                        object.propertyChange(propertyChangeEvent);
                        continue;
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                }
            }
            return;
        }
    }

    private void initBreakpoints() {
        this.initBreakpoints(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initBreakpoints(Breakpoint breakpoint) {
        List<Breakpoint> list;
        HashMap<Breakpoint, Object> hashMap;
        Vector vector = this.breakpoints;
        synchronized (vector) {
            if (this.breakpointsInitialized) {
                return true;
            }
            if (this.breakpointsInitializing) {
                if (breakpoint != null) {
                    this.createdBreakpoints.add(breakpoint);
                    return false;
                }
                throw new IllegalStateException("Breakpoints not yet initialized and tried to initialize again...");
            }
            this.breakpointsInitializing = true;
            try {
                Object object;
                Object object2;
                int n;
                this.initDebuggerManagerListeners();
                this.createdBreakpoints = new ArrayList<Breakpoint>();
                hashMap = new HashMap<Breakpoint, Object>();
                Vector object3 = (Vector)this.listeners.clone();
                int n2 = object3.size();
                for (n = 0; n < n2; ++n) {
                    object2 = (DebuggerManagerListener)object3.elementAt(n);
                    object = object2.initBreakpoints();
                    this.createdBreakpoints.addAll(Arrays.asList(object));
                    for (int breakpointArray = 0; breakpointArray < ((Breakpoint[])object).length; ++breakpointArray) {
                        hashMap.put(object[breakpointArray], object2);
                    }
                }
                object = this.listenersMap;
                synchronized (this.listenersMap) {
                    object2 = (Vector)this.listenersMap.get(PROP_BREAKPOINTS_INIT);
                    if (object2 != null) {
                        object2 = (Vector)((Vector)object2).clone();
                    }
                    // ** MonitorExit[var9_10] (shouldn't be in output)
                    if (object2 != null) {
                        n2 = ((Vector)object2).size();
                        for (n = 0; n < n2; ++n) {
                            object = (DebuggerManagerListener)((Vector)object2).elementAt(n);
                            Breakpoint[] breakpointArray = object.initBreakpoints();
                            this.createdBreakpoints.addAll(Arrays.asList(breakpointArray));
                            for (int i = 0; i < breakpointArray.length; ++i) {
                                hashMap.put(breakpointArray[i], object);
                            }
                        }
                    }
                    this.breakpoints.addAll(this.createdBreakpoints);
                }
            }
            finally {
                this.breakpointsInitializing = false;
            }
            {
                this.breakpointsInitialized = true;
                list = this.createdBreakpoints;
                this.createdBreakpoints = null;
            }
        }
        {
            for (Breakpoint breakpoint2 : list) {
                this.registerBreakpoint(breakpoint2);
                this.fireBreakpointCreated(breakpoint2, (DebuggerManagerListener)hashMap.get(breakpoint2));
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBreakpoints(DebuggerManagerListener debuggerManagerListener) {
        List<Breakpoint> list;
        if (!this.breakpointsInitialized) {
            return;
        }
        HashMap<Breakpoint, DebuggerManagerListener> hashMap = new HashMap<Breakpoint, DebuggerManagerListener>();
        Vector vector = this.breakpoints;
        synchronized (vector) {
            this.breakpointsInitialized = false;
            this.breakpointsInitializing = true;
            try {
                this.createdBreakpoints = new ArrayList<Breakpoint>();
                Breakpoint[] object = debuggerManagerListener.initBreakpoints();
                this.createdBreakpoints.addAll(Arrays.asList(object));
                for (int i = 0; i < object.length; ++i) {
                    hashMap.put(object[i], debuggerManagerListener);
                }
                this.breakpoints.addAll(this.createdBreakpoints);
            }
            finally {
                this.breakpointsInitializing = false;
                this.breakpointsInitialized = true;
            }
            list = this.createdBreakpoints;
            this.createdBreakpoints = null;
        }
        for (Breakpoint breakpoint : list) {
            this.registerBreakpoint(breakpoint);
            this.fireBreakpointCreated(breakpoint, (DebuggerManagerListener)hashMap.get(breakpoint));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBreakpoints(DebuggerManagerListener debuggerManagerListener) {
        Breakpoint[] breakpointArray;
        if (!this.breakpointsInitialized) {
            return;
        }
        try {
            Breakpoint[] breakpointArray2 = debuggerManagerListener.getClass().getMethod("unloadBreakpoints", new Class[0]);
            breakpointArray = (Breakpoint[])breakpointArray2.invoke((Object)debuggerManagerListener, new Object[0]);
        }
        catch (Exception exception) {
            return;
        }
        this.breakpoints.removeAll(Arrays.asList(breakpointArray));
        for (Breakpoint breakpoint : breakpointArray) {
            Class<?> clazz = breakpoint.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Map<ClassLoader, Set<Breakpoint>> map = this.breakpointsByClassLoaders;
            synchronized (map) {
                Set<Breakpoint> set = this.breakpointsByClassLoaders.get(classLoader);
                if (set != null) {
                    set.remove(breakpoint);
                    if (set.isEmpty()) {
                        this.breakpointsByClassLoaders.remove(classLoader);
                    }
                }
            }
            breakpoint.disposeOut();
        }
        for (Breakpoint breakpoint : breakpointArray) {
            this.fireBreakpointRemoved(breakpoint, false, debuggerManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWatchCreated(Watch watch) {
        Vector vector;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_WATCHES, null, null);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            try {
                ((DebuggerManagerListener)vector2.elementAt(n)).watchAdded(watch);
                ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
                continue;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_WATCHES);
            if (vector != null) {
                vector = (Vector)vector.clone();
            }
        }
        if (vector != null) {
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                try {
                    ((DebuggerManagerListener)vector.elementAt(n)).watchAdded(watch);
                    ((DebuggerManagerListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
                    continue;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWatchRemoved(Watch watch) {
        Vector vector;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_WATCHES, null, null);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            try {
                ((DebuggerManagerListener)vector2.elementAt(n)).watchRemoved(watch);
                ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
                continue;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_WATCHES);
            if (vector != null) {
                vector = (Vector)vector.clone();
            }
        }
        if (vector != null) {
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                try {
                    ((DebuggerManagerListener)vector.elementAt(n)).watchRemoved(watch);
                    ((DebuggerManagerListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
                    continue;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWatches() {
        Vector vector;
        int n;
        Serializable serializable = this.watches;
        synchronized (serializable) {
            if (this.watchesInitialized) {
                return;
            }
            this.watchesInitialized = true;
        }
        this.initDebuggerManagerListeners();
        serializable = new PropertyChangeEvent(this, PROP_WATCHES_INIT, null, null);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            try {
                ((DebuggerManagerListener)vector2.elementAt(n)).initWatches();
                ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange((PropertyChangeEvent)serializable);
                continue;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_WATCHES_INIT);
            if (vector != null) {
                vector = (Vector)vector.clone();
            }
        }
        if (vector != null) {
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                try {
                    ((DebuggerManagerListener)vector.elementAt(n)).initWatches();
                    ((DebuggerManagerListener)vector.elementAt(n)).propertyChange((PropertyChangeEvent)serializable);
                    continue;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSessionAdded(Session session, Session[] sessionArray, Session[] sessionArray2) {
        Vector vector;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_SESSIONS, sessionArray, sessionArray2);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            try {
                ((DebuggerManagerListener)vector2.elementAt(n)).sessionAdded(session);
                ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
                continue;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_SESSIONS);
            if (vector != null) {
                vector = (Vector)vector.clone();
            }
        }
        if (vector != null) {
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                try {
                    ((DebuggerManagerListener)vector.elementAt(n)).sessionAdded(session);
                    ((DebuggerManagerListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
                    continue;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSessionRemoved(Session session, Session[] sessionArray, Session[] sessionArray2) {
        Vector vector;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_SESSIONS, sessionArray, sessionArray2);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            try {
                ((DebuggerManagerListener)vector2.elementAt(n)).sessionRemoved(session);
                ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
                continue;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_SESSIONS);
            if (vector != null) {
                vector = (Vector)vector.clone();
            }
        }
        if (vector != null) {
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                try {
                    ((DebuggerManagerListener)vector.elementAt(n)).sessionRemoved(session);
                    ((DebuggerManagerListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
                    continue;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEngineAdded(DebuggerEngine debuggerEngine, DebuggerEngine[] debuggerEngineArray, DebuggerEngine[] debuggerEngineArray2) {
        Vector vector;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_DEBUGGER_ENGINES, debuggerEngineArray, debuggerEngineArray2);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            try {
                ((DebuggerManagerListener)vector2.elementAt(n)).engineAdded(debuggerEngine);
                ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
                continue;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_DEBUGGER_ENGINES);
            if (vector != null) {
                vector = (Vector)vector.clone();
            }
        }
        if (vector != null) {
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                try {
                    ((DebuggerManagerListener)vector.elementAt(n)).engineAdded(debuggerEngine);
                    ((DebuggerManagerListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
                    continue;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEngineRemoved(DebuggerEngine debuggerEngine, DebuggerEngine[] debuggerEngineArray, DebuggerEngine[] debuggerEngineArray2) {
        Vector vector;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_DEBUGGER_ENGINES, debuggerEngineArray, debuggerEngineArray2);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            try {
                ((DebuggerManagerListener)vector2.elementAt(n)).engineRemoved(debuggerEngine);
                ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
                continue;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_DEBUGGER_ENGINES);
            if (vector != null) {
                vector = (Vector)vector.clone();
            }
        }
        if (vector != null) {
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                try {
                    ((DebuggerManagerListener)vector.elementAt(n)).engineRemoved(debuggerEngine);
                    ((DebuggerManagerListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
                    continue;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDebuggerManagerListeners() {
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            if (this.loadedListeners == null) {
                this.loadedListeners = new HashSet<LazyDebuggerManagerListener>();
                this.listenersLookupList = this.lookup.lookup(null, LazyDebuggerManagerListener.class);
                this.refreshDebuggerManagerListeners(this.listenersLookupList);
                ((Customizer)((Object)this.listenersLookupList)).addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        DebuggerManager.this.refreshDebuggerManagerListeners((List)propertyChangeEvent.getSource());
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void refreshDebuggerManagerListeners(List<? extends LazyDebuggerManagerListener> list) {
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet hashSet2 = new HashSet();
        List<? extends LazyDebuggerManagerListener> list2 = list;
        synchronized (list2) {
            Object object;
            Object object2;
            void lazyDebuggerManagerListener;
            int n = list.size();
            boolean i = false;
            while (lazyDebuggerManagerListener < n) {
                object2 = list.get((int)lazyDebuggerManagerListener);
                if (this.loadedListeners.add((LazyDebuggerManagerListener)object2)) {
                    object = object2.getProperties();
                    if (object == null || ((Object)object).length == 0) {
                        this.addDebuggerListener((DebuggerManagerListener)object2);
                    } else {
                        int stringArray = ((Object)object).length;
                        for (int j = 0; j < stringArray; ++j) {
                            this.addDebuggerListener((String)object[j], (DebuggerManagerListener)object2);
                        }
                    }
                    hashSet.add(object2);
                }
                ++lazyDebuggerManagerListener;
            }
            object2 = new HashSet<LazyDebuggerManagerListener>(this.loadedListeners);
            object2.removeAll(list);
            object = object2.iterator();
            while (object.hasNext()) {
                LazyDebuggerManagerListener lazyDebuggerManagerListener2 = (LazyDebuggerManagerListener)object.next();
                if (!this.loadedListeners.contains(lazyDebuggerManagerListener2)) continue;
                this.removeBreakpoints(lazyDebuggerManagerListener2);
            }
            object = object2.iterator();
            while (object.hasNext()) {
                LazyDebuggerManagerListener lazyDebuggerManagerListener3 = (LazyDebuggerManagerListener)object.next();
                if (!this.loadedListeners.remove(lazyDebuggerManagerListener3)) continue;
                this.moduleUnloaded(lazyDebuggerManagerListener3.getClass().getClassLoader());
                String[] stringArray = lazyDebuggerManagerListener3.getProperties();
                if (stringArray == null || stringArray.length == 0) {
                    this.removeDebuggerListener(lazyDebuggerManagerListener3);
                    continue;
                }
                int n2 = stringArray.length;
                for (int j = 0; j < n2; ++j) {
                    this.removeDebuggerListener(stringArray[j], lazyDebuggerManagerListener3);
                }
            }
        }
        for (LazyDebuggerManagerListener lazyDebuggerManagerListener : hashSet) {
            this.addBreakpoints(lazyDebuggerManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(Session session) {
        Session[] sessionArray;
        Session[] sessionArray2;
        List list = this.sessions;
        synchronized (list) {
            sessionArray2 = this.getSessions();
            int n = sessionArray2.length;
            for (int i = 0; i < n; ++i) {
                if (session != sessionArray2[i]) continue;
                return;
            }
            sessionArray = new Session[sessionArray2.length + 1];
            System.arraycopy(sessionArray2, 0, sessionArray, 0, sessionArray2.length);
            sessionArray[sessionArray2.length] = session;
            this.sessions.add(session);
            session.addPropertyChangeListener(this.sessionListener);
        }
        this.fireSessionAdded(session, sessionArray2, sessionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(Session session) {
        Session[] sessionArray;
        Session[] sessionArray2;
        Session session2 = null;
        List list = this.sessions;
        synchronized (list) {
            int n;
            sessionArray2 = this.getSessions();
            int n2 = sessionArray2.length;
            for (n = 0; n < n2 && sessionArray2[n] != session; ++n) {
                if (session2 != null) continue;
                session2 = sessionArray2[n];
            }
            if (n == n2) {
                return;
            }
            if (session == this.getCurrentSession()) {
                if (session2 == null && n2 > 1) {
                    session2 = sessionArray2[1];
                }
            } else {
                session2 = this.getCurrentSession();
            }
            sessionArray = new Session[sessionArray2.length - 1];
            System.arraycopy(sessionArray2, 0, sessionArray, 0, n);
            if (sessionArray2.length - n > 1) {
                System.arraycopy(sessionArray2, n + 1, sessionArray, n, sessionArray2.length - n - 1);
            }
            this.sessions.remove(n);
            session.removePropertyChangeListener(this.sessionListener);
        }
        this.setCurrentSession(session2);
        this.fireSessionRemoved(session, sessionArray2, sessionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEngine(DebuggerEngine debuggerEngine) {
        DebuggerEngine[] debuggerEngineArray;
        DebuggerEngine[] debuggerEngineArray2;
        Set set = this.engines;
        synchronized (set) {
            if (this.engines.contains(debuggerEngine)) {
                return;
            }
            debuggerEngineArray2 = this.engines.toArray(new DebuggerEngine[this.engines.size()]);
            this.engines.add(debuggerEngine);
            debuggerEngineArray = this.engines.toArray(new DebuggerEngine[this.engines.size()]);
        }
        this.fireEngineAdded(debuggerEngine, debuggerEngineArray2, debuggerEngineArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEngine(DebuggerEngine debuggerEngine) {
        DebuggerEngine[] debuggerEngineArray;
        DebuggerEngine[] debuggerEngineArray2;
        Set set = this.engines;
        synchronized (set) {
            if (!this.engines.contains(debuggerEngine)) {
                return;
            }
            debuggerEngineArray2 = this.engines.toArray(new DebuggerEngine[this.engines.size()]);
            this.engines.remove(debuggerEngine);
            debuggerEngineArray = this.engines.toArray(new DebuggerEngine[this.engines.size()]);
        }
        this.fireEngineRemoved(debuggerEngine, debuggerEngineArray2, debuggerEngineArray);
    }

    private class SessionListener
    implements PropertyChangeListener {
        private SessionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof Session) {
                DebuggerEngine debuggerEngine;
                DebuggerEngine debuggerEngine2;
                if (!propertyChangeEvent.getPropertyName().equals("currentLanguage") && !propertyChangeEvent.getPropertyName().equals("supportedLanguages")) {
                    return;
                }
                Object object = DebuggerManager.this.sessions;
                synchronized (object) {
                    debuggerEngine2 = DebuggerManager.this.currentEngine;
                    debuggerEngine = null;
                    if (DebuggerManager.this.getCurrentSession() != null) {
                        debuggerEngine = DebuggerManager.this.getCurrentSession().getCurrentEngine();
                    }
                    DebuggerManager.this.currentEngine = debuggerEngine;
                }
                if (debuggerEngine != debuggerEngine2) {
                    DebuggerManager.this.firePropertyChange(DebuggerManager.PROP_CURRENT_ENGINE, debuggerEngine2, debuggerEngine);
                }
                if (((Session)(object = (Session)propertyChangeEvent.getSource())).getSupportedLanguages().length == 0) {
                    DebuggerManager.this.removeSession((Session)object);
                }
            }
        }
    }
}

