/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicInfoVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewNbModuleWizardIterator;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class TypeChooserPanelImpl
extends JPanel {
    public static final String IS_STANDALONE_OR_SUITE_COMPONENT = "tc_isStandaloneOrSuiteComp";
    public static final String SUITE_ROOT = "tc_suiteRoot";
    public static final String ACTIVE_PLATFORM_ID = "tc_activePlatform_id";
    public static final String ACTIVE_NB_PLATFORM = "tc_activeNBPlatform";
    public static final String IS_NETBEANS_ORG = "isNetBeansOrg";
    public static final String PROJECT_FOLDER = "tc_projectFolderForTypeChooser";
    private ButtonModel lastSelectedType;
    private static String lastSelectedSuite;
    private boolean moduleTypeGroupAttached = false;
    private WizardDescriptor settings;
    private NewNbModuleWizardIterator.Type wizardType;
    private JButton browseSuiteButton;
    private JLabel chooserFiller;
    private JButton managePlatform;
    private JLabel moduleSuite;
    private JComboBox moduleSuiteValue;
    private ButtonGroup moduleTypeGroup;
    private JLabel platform;
    private JComboBox platformValue;
    private JRadioButton standAloneModule;
    private JRadioButton suiteComponent;
    private JPanel typeChooserPanel;

    public TypeChooserPanelImpl(WizardDescriptor wizardDescriptor) {
        this();
        this.settings = wizardDescriptor;
        this.attachModuleTypeGroup();
        this.storeInitialValuesToWD(this.getSettings());
        this.attachPropertyChangeListener(this.getSettings());
    }

    TypeChooserPanelImpl() {
        this.initComponents();
        this.init();
    }

    TypeChooserPanelImpl(WizardDescriptor wizardDescriptor, NewNbModuleWizardIterator.Type type) {
        this();
        this.settings = wizardDescriptor;
        this.wizardType = type;
        this.storeInitialValuesToWD(this.getSettings());
        this.attachPropertyChangeListener(this.getSettings());
        switch (type) {
            case SUITE: 
            case APPLICATION: {
                this.detachModuleTypeGroup();
                break;
            }
            case LIBRARY_MODULE: {
                this.moduleSuite.setText(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"LBL_Add_to_Suite"));
                this.suiteComponent.setSelected(true);
                ModuleTypePanelExtended.setIsStandaloneOrSuiteComponent(this.getSettings(), false);
                if (this.moduleSuiteValue.getItemCount() <= 0) break;
                this.restoreSelectedSuite();
                break;
            }
            default: {
                if (this.moduleSuiteValue.getItemCount() <= 0) break;
                this.restoreSelectedSuite();
                this.suiteComponent.setSelected(true);
            }
        }
    }

    protected static JComboBox getDefaultSuitesComboBox() {
        return PlatformComponentFactory.getSuitesComboBox();
    }

    private boolean isStandAlone() {
        return this.standAloneModule.isSelected();
    }

    private boolean isSuiteComponent() {
        return this.suiteComponent.isSelected();
    }

    private String getSelectedSuite() {
        return (String)this.moduleSuiteValue.getSelectedItem();
    }

    private boolean isNetBeansOrgFolder() {
        File file = ModuleTypePanelExtended.getProjectFolder(this.getSettings());
        if (file != null) {
            return BasicInfoVisualPanel.isNetBeansOrgFolder(file);
        }
        return false;
    }

    private String getSelectedPlatformId() {
        Object object = this.platformValue.getSelectedItem();
        if (object != null) {
            return ((NbPlatform)this.platformValue.getSelectedItem()).getID();
        }
        return null;
    }

    private NbPlatform getSelectedNbPlatform() {
        Object object = this.platformValue.getSelectedItem();
        if (object != null) {
            return (NbPlatform)this.platformValue.getSelectedItem();
        }
        return null;
    }

    protected void setComponentsVisibility(boolean bl, boolean bl2) {
        this.suiteComponent.setVisible(!bl2);
        this.platform.setVisible(!bl2);
        this.platformValue.setVisible(!bl2);
        this.managePlatform.setVisible(!bl2);
        this.standAloneModule.setVisible(!bl2);
        this.standAloneModule.setVisible(!bl && !bl2);
        this.platform.setVisible(!bl && !bl2);
        this.platformValue.setVisible(!bl && !bl2);
        this.managePlatform.setVisible(!bl && !bl2);
        this.suiteComponent.setVisible(!bl && !bl2);
    }

    private void updateEnabled() {
        boolean bl = this.isNetBeansOrgFolder();
        this.standAloneModule.setEnabled(!bl);
        this.suiteComponent.setEnabled(!bl);
        boolean bl2 = this.isStandAlone();
        boolean bl3 = this.isSuiteComponent();
        this.platform.setEnabled(bl2);
        this.platformValue.setEnabled(bl2);
        this.managePlatform.setEnabled(bl2);
        this.moduleSuite.setEnabled(bl3);
        this.moduleSuiteValue.setEnabled(bl3 && !this.isOneSuiteDedicatedMode());
        this.browseSuiteButton.setEnabled(bl3 && !this.isOneSuiteDedicatedMode());
    }

    private void projectFolderIsUpdated() {
        if (TypeChooserPanelImpl.isSuiteWizard(this.getWizardType()) || this.isNetBeansOrgFolder()) {
            this.detachModuleTypeGroup();
        } else {
            this.attachModuleTypeGroup();
        }
        this.updateEnabled();
        ModuleTypePanelExtended.setIsNetBeansOrg(this.getSettings(), this.isNetBeansOrgFolder());
    }

    private void storeInitialValuesToWD(WizardDescriptor wizardDescriptor) {
        ModuleTypePanelExtended.setIsNetBeansOrg(wizardDescriptor, this.isNetBeansOrgFolder());
        ModuleTypePanelExtended.setIsStandaloneOrSuiteComponent(wizardDescriptor, this.isStandAlone());
        ModuleTypePanelExtended.setSuiteRoot(wizardDescriptor, this.getSelectedSuite());
        ModuleTypePanelExtended.setActivePlatformId(wizardDescriptor, this.getSelectedPlatformId());
        ModuleTypePanelExtended.setActiveNbPlatform(wizardDescriptor, this.getSelectedNbPlatform());
    }

    private void attachPropertyChangeListener(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.addPropertyChangeListener((PropertyChangeListener)new ProjectFolderChangeListener());
    }

    private void detachModuleTypeGroup() {
        if (this.moduleTypeGroupAttached) {
            this.lastSelectedType = this.moduleTypeGroup.getSelection();
            this.moduleTypeGroup.remove(this.standAloneModule);
            this.moduleTypeGroup.remove(this.suiteComponent);
            this.standAloneModule.setSelected(false);
            this.suiteComponent.setSelected(false);
            ModuleTypePanelExtended.setIsStandaloneOrSuiteComponent(this.getSettings(), null);
            this.moduleTypeGroupAttached = false;
        }
    }

    protected void attachModuleTypeGroup() {
        if (!this.moduleTypeGroupAttached) {
            this.moduleTypeGroup.add(this.standAloneModule);
            this.moduleTypeGroup.add(this.suiteComponent);
            if (TypeChooserPanelImpl.isLibraryWizard(this.getWizardType())) {
                this.suiteComponent.setSelected(true);
            } else {
                this.moduleTypeGroup.setSelected(this.lastSelectedType, true);
            }
            this.moduleTypeGroupAttached = true;
        }
    }

    private void init() {
        BasicInfoVisualPanel.initPlatformCombo(this.platformValue);
        if (this.moduleSuiteValue.getItemCount() > 0) {
            this.restoreSelectedSuite();
            this.suiteComponent.setSelected(true);
        }
    }

    private void restoreSelectedSuite() {
        String string = this.getPreferredSuiteDir();
        if (string != null) {
            lastSelectedSuite = string;
        }
        if (lastSelectedSuite != null) {
            int n = this.moduleSuiteValue.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                if (!lastSelectedSuite.equals(this.moduleSuiteValue.getModel().getElementAt(i))) continue;
                this.moduleSuiteValue.setSelectedItem(lastSelectedSuite);
                break;
            }
        }
    }

    private String getPreferredSuiteDir() {
        if (this.getSettings() != null) {
            return (String)this.getSettings().getProperty("preferredSuiteDir");
        }
        return null;
    }

    private boolean isOneSuiteDedicatedMode() {
        Boolean bl = false;
        if (this.getSettings() != null) {
            bl = (Boolean)this.getSettings().getProperty("oneSuiteDedicatedMode");
        }
        return bl != null ? bl : false;
    }

    private void initComponents() {
        this.moduleTypeGroup = new ButtonGroup();
        this.typeChooserPanel = new JPanel();
        this.standAloneModule = new JRadioButton();
        this.platform = new JLabel();
        this.platformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.managePlatform = new JButton();
        this.suiteComponent = new JRadioButton();
        this.moduleSuite = new JLabel();
        this.moduleSuiteValue = TypeChooserPanelImpl.getDefaultSuitesComboBox();
        this.browseSuiteButton = new JButton();
        this.chooserFiller = new JLabel();
        this.setLayout(new BorderLayout());
        this.typeChooserPanel.setLayout(new GridBagLayout());
        this.moduleTypeGroup.add(this.standAloneModule);
        this.standAloneModule.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.standAloneModule, (String)NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"CTL_StandaloneModule"));
        this.standAloneModule.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TypeChooserPanelImpl.this.standAloneModuleTypeChanged(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.typeChooserPanel.add((Component)this.standAloneModule, gridBagConstraints);
        this.standAloneModule.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_StandAloneModule"));
        this.standAloneModule.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_StandAloneModule"));
        this.platform.setLabelFor(this.platformValue);
        Mnemonics.setLocalizedText((JLabel)this.platform, (String)NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 18, 0, 12);
        this.typeChooserPanel.add((Component)this.platform, gridBagConstraints);
        this.platformValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TypeChooserPanelImpl.this.platformChosen(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.typeChooserPanel.add((Component)this.platformValue, gridBagConstraints);
        this.platformValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_PlatformValue"));
        this.platformValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_PlatformValue"));
        Mnemonics.setLocalizedText((AbstractButton)this.managePlatform, (String)NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"CTL_ManagePlatforms_g"));
        this.managePlatform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TypeChooserPanelImpl.this.managePlatformActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.typeChooserPanel.add((Component)this.managePlatform, gridBagConstraints);
        this.managePlatform.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_ManagePlatform"));
        this.managePlatform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_ManagePlatform"));
        this.moduleTypeGroup.add(this.suiteComponent);
        Mnemonics.setLocalizedText((AbstractButton)this.suiteComponent, (String)NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"CTL_AddToModuleSuite"));
        this.suiteComponent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TypeChooserPanelImpl.this.suiteComponentTypeChanged(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.typeChooserPanel.add((Component)this.suiteComponent, gridBagConstraints);
        this.suiteComponent.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_SuiteModule"));
        this.suiteComponent.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_SuiteModule"));
        this.moduleSuite.setLabelFor(this.moduleSuiteValue);
        Mnemonics.setLocalizedText((JLabel)this.moduleSuite, (String)NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"LBL_ModuleSuite"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 0, 12);
        this.typeChooserPanel.add((Component)this.moduleSuite, gridBagConstraints);
        this.moduleSuiteValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TypeChooserPanelImpl.this.moduleSuiteChosen(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.typeChooserPanel.add((Component)this.moduleSuiteValue, gridBagConstraints);
        this.moduleSuiteValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_ModuleSuiteValue"));
        this.moduleSuiteValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_ModuleSuiteValue"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseSuiteButton, (String)NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"CTL_BrowseButton_w"));
        this.browseSuiteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TypeChooserPanelImpl.this.browseModuleSuite(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.typeChooserPanel.add((Component)this.browseSuiteButton, gridBagConstraints);
        this.browseSuiteButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_BrowseSuiteButton"));
        this.browseSuiteButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_BrowseSuiteButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        this.typeChooserPanel.add((Component)this.chooserFiller, gridBagConstraints);
        this.add((Component)this.typeChooserPanel, "Center");
    }

    private void standAloneModuleTypeChanged(ActionEvent actionEvent) {
        ModuleTypePanelExtended.setIsStandaloneOrSuiteComponent(this.getSettings(), this.isStandAlone());
        this.updateEnabled();
    }

    private void platformChosen(ActionEvent actionEvent) {
        ModuleTypePanelExtended.setActivePlatformId(this.getSettings(), this.getSelectedPlatformId());
        ModuleTypePanelExtended.setActiveNbPlatform(this.getSettings(), this.getSelectedNbPlatform());
        this.updateEnabled();
    }

    private void managePlatformActionPerformed(ActionEvent actionEvent) {
        this.managePlatform(this.platformValue);
        ModuleTypePanelExtended.setActivePlatformId(this.getSettings(), this.getSelectedPlatformId());
        ModuleTypePanelExtended.setActiveNbPlatform(this.getSettings(), this.getSelectedNbPlatform());
        this.updateEnabled();
    }

    private void managePlatform(JComboBox jComboBox) {
        NbPlatformCustomizer.showCustomizer();
        jComboBox.setModel(new PlatformComponentFactory.NbPlatformListModel());
        jComboBox.requestFocus();
    }

    private void suiteComponentTypeChanged(ActionEvent actionEvent) {
        ModuleTypePanelExtended.setIsStandaloneOrSuiteComponent(this.getSettings(), this.isStandAlone());
        this.updateEnabled();
    }

    private void moduleSuiteChosen(ActionEvent actionEvent) {
        String string;
        lastSelectedSuite = string = (String)this.moduleSuiteValue.getSelectedItem();
        ModuleTypePanelExtended.setSuiteRoot(this.getSettings(), this.getSelectedSuite());
        this.updateEnabled();
    }

    private void browseModuleSuite(ActionEvent actionEvent) {
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            UIUtil.setProjectChooserDirParent(file);
            try {
                Project project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
                if (project != null) {
                    String string = SuiteUtils.getSuiteDirectoryPath(project);
                    if (string != null) {
                        PlatformComponentFactory.addUserSuite(string);
                        this.moduleSuiteValue.addItem(string);
                        this.moduleSuiteValue.setSelectedItem(string);
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_NotRegularSuite", (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
                    }
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
        }
    }

    protected WizardDescriptor getSettings() {
        return this.settings;
    }

    private NewNbModuleWizardIterator.Type getWizardType() {
        return this.wizardType;
    }

    private static boolean isSuiteWizard(NewNbModuleWizardIterator.Type type) {
        return type != null ? NewNbModuleWizardIterator.isSuiteWizard(type) : false;
    }

    private static boolean isLibraryWizard(NewNbModuleWizardIterator.Type type) {
        return type != null ? NewNbModuleWizardIterator.isLibraryWizard(type) : false;
    }

    private static class ModuleTypePanelExtended {
        private ModuleTypePanelExtended() {
        }

        protected static void setIsStandaloneOrSuiteComponent(WizardDescriptor wizardDescriptor, Boolean bl) {
            if (wizardDescriptor != null) {
                wizardDescriptor.putProperty(TypeChooserPanelImpl.IS_STANDALONE_OR_SUITE_COMPONENT, (Object)bl);
            }
        }

        protected static void setIsNetBeansOrg(WizardDescriptor wizardDescriptor, Boolean bl) {
            if (wizardDescriptor != null) {
                wizardDescriptor.putProperty(TypeChooserPanelImpl.IS_NETBEANS_ORG, (Object)bl);
            }
        }

        protected static void setActivePlatformId(WizardDescriptor wizardDescriptor, String string) {
            if (wizardDescriptor != null) {
                wizardDescriptor.putProperty(TypeChooserPanelImpl.ACTIVE_PLATFORM_ID, (Object)string);
            }
        }

        protected static void setActiveNbPlatform(WizardDescriptor wizardDescriptor, NbPlatform nbPlatform) {
            if (wizardDescriptor != null) {
                wizardDescriptor.putProperty(TypeChooserPanelImpl.ACTIVE_NB_PLATFORM, (Object)nbPlatform);
            }
        }

        protected static void setSuiteRoot(WizardDescriptor wizardDescriptor, String string) {
            if (wizardDescriptor != null) {
                wizardDescriptor.putProperty(TypeChooserPanelImpl.SUITE_ROOT, (Object)string);
            }
        }

        protected static File getProjectFolder(WizardDescriptor wizardDescriptor) {
            Object object;
            if (wizardDescriptor != null && (object = wizardDescriptor.getProperty(TypeChooserPanelImpl.PROJECT_FOLDER)) != null && object instanceof File) {
                return (File)object;
            }
            return null;
        }
    }

    private class ProjectFolderChangeListener
    extends ModuleTypePanelExtended
    implements PropertyChangeListener {
        private ProjectFolderChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (TypeChooserPanelImpl.PROJECT_FOLDER.equals(string)) {
                TypeChooserPanelImpl.this.projectFolderIsUpdated();
            }
        }
    }
}

