/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.api;

import com.sun.tools.ws.processor.model.java.JavaMethod;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.manager.model.WebServiceData;

public class WebServiceMetaDataTransfer {
    public static DataFlavor PORT_FLAVOR;
    public static DataFlavor METHOD_FLAVOR;
    public static final DataFlavor METHOD_NODE_FLAVOR;
    protected static final DataFlavor PORT_NODE_FLAVOR;

    static {
        try {
            PORT_FLAVOR = new DataFlavor("application/x-java-netbeans-websvcmgr-port;class=org.netbeans.modules.websvc.manager.api.WebServiceMetaDataTransfer$Port");
            PORT_NODE_FLAVOR = new DataFlavor("application/x-java-netbeans-websvcmgr-port;class=org.openide.nodes.Node");
            METHOD_FLAVOR = new DataFlavor("application/x-java-netbeans-websvcmgr-method;class=org.netbeans.modules.websvc.manager.api.WebServiceMetaDataTransfer$Method");
            METHOD_NODE_FLAVOR = new DataFlavor("application/x-java-netbeans-websvcmgr-method;class=org.openide.nodes.Node");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
    }

    public static final class PortTransferable
    implements Transferable {
        private static final DataFlavor[] SUPPORTED_FLAVORS = new DataFlavor[]{PORT_FLAVOR, PORT_NODE_FLAVOR};
        private final Port transferData;

        public PortTransferable(Port port) {
            this.transferData = port;
        }

        public PortTransferable(Method method) {
            WebServiceData webServiceData = method.getWebServiceData();
            String string = method.getPortName();
            this.transferData = new Port(webServiceData, string);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return SUPPORTED_FLAVORS;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor == SUPPORTED_FLAVORS[0] || dataFlavor == SUPPORTED_FLAVORS[1];
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.transferData;
        }
    }

    public static final class MethodTransferable
    implements Transferable {
        private static final DataFlavor[] SUPPORTED_FLAVORS = new DataFlavor[]{METHOD_FLAVOR, METHOD_NODE_FLAVOR};
        private final Method transferData;

        public MethodTransferable(Method method) {
            this.transferData = method;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return SUPPORTED_FLAVORS;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor == SUPPORTED_FLAVORS[0] || dataFlavor == SUPPORTED_FLAVORS[1];
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.transferData;
        }
    }

    public static final class Method {
        private final WebServiceData wsData;
        private final JavaMethod method;
        private final String portName;
        private final WsdlOperation operation;

        public Method(WebServiceData webServiceData, JavaMethod javaMethod, String string, WsdlOperation wsdlOperation) {
            this.wsData = webServiceData;
            this.method = javaMethod;
            this.portName = string;
            this.operation = wsdlOperation;
        }

        public WebServiceData getWebServiceData() {
            return this.wsData;
        }

        public JavaMethod getMethod() {
            return this.method;
        }

        public String getPortName() {
            return this.portName;
        }

        public WsdlOperation getOperation() {
            return this.operation;
        }
    }

    public static final class Port {
        private final WebServiceData wsData;
        private final String portName;

        public Port(WebServiceData webServiceData, String string) {
            this.wsData = webServiceData;
            this.portName = string;
        }

        public WebServiceData getWebServiceData() {
            return this.wsData;
        }

        public String getPortName() {
            return this.portName;
        }
    }
}

