/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.screen.display.DisplayableDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.ScreenFileObjectListener;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;
import org.netbeans.modules.vmd.midp.screen.display.property.ScreenStringPropertyEditor;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractInfoDisplayPresenter
extends DisplayableDisplayPresenter {
    private static final String ICON_BROKEN_PATH = "org/netbeans/modules/vmd/midpnb/resources/broken-image.png";
    private static final Icon ICON_BROKEN = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/midpnb/resources/broken-image.png"));
    private JLabel imageLabel = new JLabel();
    private JLabel stringLabel;
    private ScreenFileObjectListener imageFileListener;
    private FileObject imageFileObject;

    public AbstractInfoDisplayPresenter() {
        this.imageLabel.setHorizontalAlignment(0);
        this.stringLabel = new JLabel();
        this.stringLabel.setHorizontalAlignment(0);
        JPanel jPanel = this.getPanel().getContentPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.imageLabel, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.stringLabel, gridBagConstraints);
    }

    public void reload(ScreenDeviceInfo screenDeviceInfo) {
        String string;
        Object object;
        super.reload(screenDeviceInfo);
        PropertyValue propertyValue = this.getComponent().readProperty("image");
        if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) {
            object = propertyValue.getComponent();
            string = null;
            if (object != null && !PropertyValue.Kind.USERCODE.equals((Object)(propertyValue = object.readProperty("resourcePath")).getKind())) {
                string = MidpTypes.getString((PropertyValue)propertyValue);
            }
            Icon icon = ScreenSupport.getIconFromImageComponent((DesignComponent)object);
            this.imageFileObject = ScreenSupport.getFileObjectFromImageComponent((DesignComponent)object);
            if (this.imageFileObject != null) {
                this.imageFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
                this.imageFileListener = new ScreenFileObjectListener(this.getRelatedComponent(), (DesignComponent)object, "resourcePath");
                this.imageFileObject.addFileChangeListener((FileChangeListener)this.imageFileListener);
            }
            if (icon != null) {
                this.imageLabel.setText(null);
                this.imageLabel.setIcon(icon);
            } else if (string != null) {
                this.imageLabel.setText(string);
                this.imageLabel.setIcon(ICON_BROKEN);
            } else {
                this.imageLabel.setIcon(null);
                this.imageLabel.setText(NbBundle.getMessage(AbstractInfoDisplayPresenter.class, (String)"DISP_image_not_specified"));
            }
        } else {
            this.imageLabel.setText(NbBundle.getMessage(AbstractInfoDisplayPresenter.class, (String)"DISP_image_is_usercode"));
        }
        propertyValue = this.getComponent().readProperty("text");
        if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) {
            object = MidpTypes.getString((PropertyValue)this.getComponent().readProperty("text"));
            if (object == null) {
                this.stringLabel.setText(NbBundle.getMessage(AbstractInfoDisplayPresenter.class, (String)"DISP_text_not_specified"));
            } else if (((String)object).length() == 0) {
                this.stringLabel.setText(NbBundle.getMessage(AbstractInfoDisplayPresenter.class, (String)"DISP_text_is_empty"));
            } else {
                this.stringLabel.setText((String)object);
                propertyValue = this.getComponent().readProperty("textFont");
                if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) {
                    string = propertyValue.getComponent();
                    this.stringLabel.setFont(ScreenSupport.getFont((ScreenDeviceInfo)screenDeviceInfo, (DesignComponent)string));
                }
            }
        } else {
            this.stringLabel.setText(NbBundle.getMessage(AbstractInfoDisplayPresenter.class, (String)"DISP_text_is_usercode"));
        }
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        ArrayList<ScreenPropertyDescriptor> arrayList = new ArrayList<ScreenPropertyDescriptor>(super.getPropertyDescriptors());
        ResourcePropertyEditor resourcePropertyEditor = new ResourcePropertyEditor("image", this.getComponent());
        arrayList.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.imageLabel, (ScreenPropertyEditor)resourcePropertyEditor));
        arrayList.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.stringLabel, (ScreenPropertyEditor)new ScreenStringPropertyEditor("text")));
        return arrayList;
    }

    protected void notifyDetached(DesignComponent designComponent) {
        if (this.imageFileObject != null && this.imageFileListener != null) {
            this.imageFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
        }
        this.imageFileObject = null;
        this.imageFileListener = null;
    }
}

