/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.netbeans.modules.vmd.midp.components.categories.CommandsCategoryCD;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.netbeans.modules.vmd.midpnb.components.commands.SVGMenuSelectCommandCD;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorSVGMenuSelectCommand
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private List<String> tags = new ArrayList<String>();
    private Map<String, DesignComponent> values = new TreeMap<String, DesignComponent>();
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private TypeID typeID;
    private String noneItem;
    private String defaultItem;

    public static PropertyEditorSVGMenuSelectCommand createInstanceMenuSelect() {
        String string = NbBundle.getMessage(PropertyEditorSVGMenuSelectCommand.class, (String)"LBL_SEL_COMMAND_STR");
        String string2 = NbBundle.getMessage(PropertyEditorSVGMenuSelectCommand.class, (String)"LBL_SELECTCOMMAND_NONE");
        String string3 = NbBundle.getMessage(PropertyEditorSVGMenuSelectCommand.class, (String)"LBL_SELECTCOMMAND_DEFAULT");
        String string4 = NbBundle.getMessage(PropertyEditorSVGMenuSelectCommand.class, (String)"LBL_SELECTCOMMAND_UCLABEL");
        return new PropertyEditorSVGMenuSelectCommand(SVGMenuSelectCommandCD.TYPEID, string, string2, string3, string4);
    }

    private PropertyEditorSVGMenuSelectCommand(TypeID typeID, String string, String string2, String string3, String string4) {
        super(string4);
        this.initComponents();
        this.typeID = typeID;
        this.noneItem = string2;
        this.defaultItem = string3;
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)string);
        this.radioButton.getAccessibleContext().setAccessibleName(this.radioButton.getText());
        this.radioButton.getAccessibleContext().setAccessibleDescription(this.radioButton.getText());
        this.initElements(Collections.singleton(this));
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
        this.typeID = null;
        if (this.values != null) {
            this.values.clear();
            this.values = null;
        }
        this.tags = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        this.customEditor = new CustomEditor();
        this.radioButton.addActionListener(this.customEditor);
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return false;
    }

    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.isCurrentValueANull()) {
            return this.noneItem;
        }
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return this.getDecodeValue(propertyValue);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public void updateState(PropertyValue propertyValue) {
        this.customEditor.updateModel();
        if (this.isCurrentValueANull() || propertyValue == null) {
            this.customEditor.setValue(null);
        } else {
            this.customEditor.setValue(propertyValue);
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String string) {
        if (string.length() > 0) {
            if (this.noneItem.equals(string)) {
                super.setValue((Object)NULL_VALUE);
            } else {
                super.setValue((Object)PropertyValue.createComponentReference((DesignComponent)this.getCommandEvenSource(string)));
            }
        }
    }

    public void customEditorOKButtonPressed() {
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    public Boolean canEditAsText() {
        return null;
    }

    public String[] getTags() {
        this.tags.clear();
        if (this.isCurrentValueAUserCodeType()) {
            this.tags.add(PropertyEditorUserCode.USER_CODE_TEXT);
        } else {
            this.tags.add(this.noneItem);
            this.values.clear();
            this.values.put(this.noneItem, null);
            if (this.component != null && this.component.get() != null) {
                final DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
                designDocument.getTransactionManager().readAccess(new Runnable(){

                    public void run() {
                        Object object;
                        Collection collection = MidpDocumentSupport.getCategoryComponent((DesignDocument)designDocument, (TypeID)CommandsCategoryCD.TYPEID).getComponents();
                        ArrayList<DesignComponent> arrayList = new ArrayList<DesignComponent>(collection.size());
                        for (DesignComponent designComponent : collection) {
                            object = designComponent.readProperty("ordinary");
                            if (!MidpTypes.getBoolean((PropertyValue)object)) continue;
                            arrayList.add(designComponent);
                        }
                        PropertyEditorSVGMenuSelectCommand.this.tags.add(PropertyEditorSVGMenuSelectCommand.this.defaultItem);
                        PropertyEditorSVGMenuSelectCommand.this.values.put(PropertyEditorSVGMenuSelectCommand.this.defaultItem, PropertyEditorSVGMenuSelectCommand.this.getListSelectCommand(designDocument));
                        for (DesignComponent designComponent : arrayList) {
                            object = PropertyEditorSVGMenuSelectCommand.this.getComponentDisplayName(designComponent);
                            PropertyEditorSVGMenuSelectCommand.this.tags.add(object);
                            PropertyEditorSVGMenuSelectCommand.this.values.put(object, designComponent);
                        }
                    }
                });
            }
        }
        return this.tags.toArray(new String[this.tags.size()]);
    }

    private DesignComponent getListSelectCommand(DesignDocument designDocument) {
        return MidpDocumentSupport.getSingletonCommand((DesignDocument)designDocument, (TypeID)this.typeID);
    }

    private String getComponentDisplayName(DesignComponent designComponent) {
        return MidpValueSupport.getHumanReadableString((DesignComponent)designComponent);
    }

    private String getDecodeValue(final PropertyValue propertyValue) {
        final String[] stringArray = new String[1];
        if (this.component != null && this.component.get() != null) {
            final DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
            designDocument.getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    DesignComponent designComponent;
                    PropertyValue propertyValue2;
                    DesignComponent designComponent2 = propertyValue.getComponent();
                    stringArray[0] = designComponent2 != null ? ((propertyValue2 = designComponent2.readProperty("command")) != null ? ((designComponent = propertyValue2.getComponent()) != null && designComponent.equals(PropertyEditorSVGMenuSelectCommand.this.getListSelectCommand(designDocument)) ? PropertyEditorSVGMenuSelectCommand.this.defaultItem : PropertyEditorSVGMenuSelectCommand.this.getComponentDisplayName(designComponent2)) : PropertyEditorSVGMenuSelectCommand.this.noneItem) : PropertyEditorSVGMenuSelectCommand.this.noneItem;
                }
            });
        }
        return stringArray[0];
    }

    private DesignComponent getCommandEvenSource(final String string) {
        final DesignComponent[] designComponentArray = new DesignComponent[1];
        if (this.component != null && this.component.get() != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    DesignComponent designComponent3 = (DesignComponent)PropertyEditorSVGMenuSelectCommand.this.values.get(string);
                    List list = designComponent.readProperty("commands").getArray();
                    for (PropertyValue propertyValue : list) {
                        DesignComponent designComponent2 = propertyValue.getComponent();
                        if (!designComponent2.readProperty("command").getComponent().equals(designComponent3)) continue;
                        designComponentArray[0] = designComponent2;
                        break;
                    }
                    if (designComponentArray[0] == null) {
                        designComponentArray[0] = MidpDocumentSupport.attachCommandToDisplayable((DesignComponent)designComponent, (DesignComponent)designComponent3);
                    }
                }
            });
        }
        return designComponentArray[0];
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener {
        private JComboBox combobox;

        public CustomEditor() {
            this.initComponents();
        }

        void cleanUp() {
            if (this.combobox != null) {
                this.combobox.removeActionListener(this);
                this.combobox = null;
            }
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.combobox = new JComboBox();
            this.combobox.getAccessibleContext().setAccessibleName(PropertyEditorSVGMenuSelectCommand.this.radioButton.getAccessibleContext().getAccessibleName());
            this.combobox.getAccessibleContext().setAccessibleDescription(PropertyEditorSVGMenuSelectCommand.this.radioButton.getAccessibleContext().getAccessibleDescription());
            this.combobox.setModel(new DefaultComboBoxModel());
            this.combobox.addActionListener(this);
            this.add((Component)this.combobox, "Center");
        }

        public void setValue(final PropertyValue propertyValue) {
            if (propertyValue == null) {
                this.combobox.setSelectedItem(PropertyEditorSVGMenuSelectCommand.this.noneItem);
                return;
            }
            final PropertyValue[] propertyValueArray = new PropertyValue[1];
            if (PropertyEditorSVGMenuSelectCommand.this.component != null && PropertyEditorSVGMenuSelectCommand.this.component.get() != null) {
                ((DesignComponent)PropertyEditorSVGMenuSelectCommand.this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

                    public void run() {
                        propertyValueArray[0] = propertyValue.getComponent().readProperty("command");
                    }
                });
            }
            if (propertyValueArray[0] == null) {
                return;
            }
            DesignComponent designComponent = propertyValueArray[0].getComponent();
            for (String string : PropertyEditorSVGMenuSelectCommand.this.values.keySet()) {
                DesignComponent designComponent2 = (DesignComponent)PropertyEditorSVGMenuSelectCommand.this.values.get(string);
                if (designComponent2 == null || !designComponent2.equals(designComponent)) continue;
                this.combobox.setSelectedItem(string);
                break;
            }
        }

        public String getText() {
            return (String)this.combobox.getSelectedItem();
        }

        public void updateModel() {
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.combobox.getModel();
            defaultComboBoxModel.removeAllElements();
            for (String string : PropertyEditorSVGMenuSelectCommand.this.tags) {
                defaultComboBoxModel.addElement(string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertyEditorSVGMenuSelectCommand.this.radioButton.setSelected(true);
        }
    }
}

