/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.model.tasks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OpenedEditors
implements PropertyChangeListener {
    private List<JTextComponent> visibleEditors = new ArrayList<JTextComponent>();
    private Map<JTextComponent, FileObject> visibleEditors2Files = new HashMap<JTextComponent, FileObject>();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static OpenedEditors DEFAULT;
    static final boolean SHOW_TIME;
    private static final boolean TRACE_FILES;
    private static final List<String> mimeTypesList;

    private OpenedEditors() {
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                OpenedEditors.this.stateChanged();
            }
        });
    }

    public static synchronized OpenedEditors getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new OpenedEditors();
        }
        return DEFAULT;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        if (SHOW_TIME) {
            System.err.println("OpenedEditors.fireChangeEvent()");
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        ArrayList<ChangeListener> arrayList = null;
        OpenedEditors openedEditors = this;
        synchronized (openedEditors) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public synchronized List<JTextComponent> getVisibleEditors() {
        return new ArrayList<JTextComponent>(this.visibleEditors);
    }

    public synchronized Collection<FileObject> getVisibleEditorsFiles() {
        return new ArrayList<FileObject>(this.visibleEditors2Files.values());
    }

    public synchronized void stateChanged() {
        if (SHOW_TIME || TRACE_FILES) {
            System.err.println("OpenedEditors.stateChanged()");
        }
        for (JTextComponent jTextComponent : this.visibleEditors) {
            jTextComponent.removePropertyChangeListener(this);
            this.visibleEditors2Files.remove(jTextComponent);
        }
        this.visibleEditors.clear();
        for (JTextComponent jTextComponent : EditorRegistry.componentList()) {
            FileObject fileObject;
            FileObject fileObject2 = fileObject = jTextComponent != null ? OpenedEditors.getFileObject(jTextComponent) : null;
            if (!(jTextComponent instanceof JEditorPane) || fileObject == null || !OpenedEditors.isSupported(fileObject)) continue;
            boolean bl = this.isOpen((JEditorPane)jTextComponent, fileObject);
            if (TRACE_FILES) {
                System.err.printf("\tfile: %s valid: %b\n", fileObject == null ? "null" : fileObject.toString(), bl);
            }
            if (!bl) continue;
            this.visibleEditors.add(jTextComponent);
        }
        for (JTextComponent jTextComponent : this.visibleEditors) {
            jTextComponent.addPropertyChangeListener(this);
            this.visibleEditors2Files.put(jTextComponent, OpenedEditors.getFileObject(jTextComponent));
        }
        this.fireChangeEvent();
    }

    private boolean isOpen(JEditorPane jEditorPane, FileObject fileObject) {
        try {
            EditorCookie editorCookie;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
                JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                return jEditorPaneArray != null && jEditorPaneArray.length > 0;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        FileObject fileObject;
        JTextComponent jTextComponent;
        FileObject fileObject2;
        if (SHOW_TIME) {
            System.err.println("OpenedEditors.propertyChange()");
        }
        if ((fileObject2 = this.visibleEditors2Files.get(jTextComponent = (JTextComponent)propertyChangeEvent.getSource())) != (fileObject = OpenedEditors.getFileObject(jTextComponent))) {
            if (SHOW_TIME) {
                System.err.println("OpenedEditord: new files found: " + fileObject.getNameExt());
            }
            this.visibleEditors2Files.put(jTextComponent, fileObject);
            this.fireChangeEvent();
        }
    }

    static FileObject getFileObject(JTextComponent jTextComponent) {
        Object object = jTextComponent.getDocument().getProperty("stream");
        if (!(object instanceof DataObject)) {
            return null;
        }
        DataObject dataObject = (DataObject)object;
        if (dataObject != null) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    private static boolean isSupported(FileObject fileObject) throws NullPointerException {
        Parameters.notNull((CharSequence)"files", (Object)fileObject);
        return !OpenedEditors.filterSupportedFiles(Collections.singletonList(fileObject)).isEmpty();
    }

    public static List<FileObject> filterSupportedFiles(Collection<FileObject> collection) throws NullPointerException {
        Parameters.notNull((CharSequence)"files", collection);
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        block0: for (FileObject fileObject : collection) {
            int n;
            int n2;
            String string = FileUtil.getMIMEType((FileObject)fileObject);
            if (string == null) continue;
            if (mimeTypesList.contains(string)) {
                linkedList.add(fileObject);
                continue;
            }
            String string2 = string;
            while ((n2 = string2.indexOf(47)) != -1 && (n = string2.indexOf(43, n2)) != -1) {
                if (!mimeTypesList.contains(string2 = string2.substring(0, n2 + 1) + string2.substring(n + 1))) continue;
                linkedList.add(fileObject);
                continue block0;
            }
        }
        return linkedList;
    }

    static {
        SHOW_TIME = Boolean.getBoolean("cnd.model.tasks.time");
        TRACE_FILES = Boolean.getBoolean("cnd.model.tasks.files");
        mimeTypesList = Arrays.asList("text/x-c++", "text/x-c");
    }
}

