/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath.j2ee;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.api.common.classpath.ClassPathItem;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.classpath.j2ee.BaseClassPathSupport;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class J2EEClassPathSupport
extends BaseClassPathSupport<Item> {
    private final String[] elementsOrder;

    public static J2EEClassPathSupport create(PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, String[] stringArray, String string, String string2, String string3, String string4, String[] stringArray2) {
        return new J2EEClassPathSupport(propertyEvaluator, referenceHelper, antProjectHelper, stringArray, string, string2, string3, string4, stringArray2);
    }

    private J2EEClassPathSupport(PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, String[] stringArray, String string, String string2, String string3, String string4, String[] stringArray2) {
        super(propertyEvaluator, referenceHelper, antProjectHelper, stringArray, string, string2, string3, string4);
        this.elementsOrder = stringArray2;
    }

    @Override
    public List<Item> itemsList(String string, String string2) {
        List<ClassPathSupport.Item> list = this.delegate.itemsList(string);
        List<String> list2 = null;
        list2 = string2 != null ? this.getIncludedLibraries(this.antProjectHelper, string2) : Collections.emptyList();
        ArrayList<Item> arrayList = new ArrayList<Item>(list.size());
        for (ClassPathSupport.Item item : list) {
            arrayList.add(this.createItem(item, list2));
        }
        return arrayList;
    }

    @Override
    public String[] encodeToStrings(List<Item> list, String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Item item : list) {
            String string2 = this.delegate.getReference(item.delegate);
            if (string2 == null) continue;
            arrayList2.add(string2);
            item.setReference(string2);
            if (string == null || !item.isIncludedInDeployment()) continue;
            arrayList.add(CommonProjectUtils.getAntPropertyName(string2));
        }
        if (string != null) {
            stringArray = new ArrayList<Item>(list);
            this.putIncludedLibraries(arrayList, (List<Item>)stringArray, this.antProjectHelper, string);
        }
        stringArray = new String[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            stringArray[i] = i < arrayList2.size() - 1 ? (String)arrayList2.get(i) + ":" : (String)arrayList2.get(i);
        }
        return stringArray;
    }

    private Item createItem(ClassPathSupport.Item item, List<String> list) {
        Item item2 = null;
        switch (item.getType()) {
            case CLASSPATH: {
                item2 = new Item(item, item.getReference(), false, null);
                break;
            }
            case LIBRARY: 
            case ARTIFACT: 
            case JAR: {
                String string = item.getReference();
                item2 = new Item(item, string, list.contains(string), null);
                break;
            }
            default: {
                assert (false) : "Unknown classpath item type for " + item;
                break;
            }
        }
        return item2;
    }

    private List<String> getIncludedLibraries(AntProjectHelper antProjectHelper, String string) {
        assert (antProjectHelper != null);
        assert (string != null);
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagNameNS(this.projectConfigurationNameSpace, string);
        ArrayList<String> arrayList = new ArrayList<String>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            arrayList.add(J2EEClassPathSupport.findText(element2));
        }
        return arrayList;
    }

    private void putIncludedLibraries(List<String> list, List<Item> list2, AntProjectHelper antProjectHelper, String string) {
        Node node;
        assert (list != null);
        assert (antProjectHelper != null);
        assert (string != null);
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagNameNS(this.projectConfigurationNameSpace, string);
        while (nodeList.getLength() > 0) {
            node = nodeList.item(0);
            node.getParentNode().removeChild(node);
        }
        node = element.getOwnerDocument();
        for (String string2 : list) {
            for (Item item : list2) {
                String string3 = "${" + string2 + "}";
                if (!string3.equals(item.getReference())) continue;
                Element element2 = this.createLibraryElement((Document)node, string2, item, string);
                if (this.elementsOrder != null) {
                    J2EEClassPathSupport.appendChildElement(element, element2, this.elementsOrder);
                    continue;
                }
                element.appendChild(element2);
            }
        }
        antProjectHelper.putPrimaryConfigurationData(element, true);
    }

    private static List<Element> findSubElements(Element element) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                arrayList.add((Element)node);
                continue;
            }
            if (node.getNodeType() == 3) {
                String string = ((Text)node).getNodeValue();
                if (string.trim().length() <= 0) continue;
                throw new IllegalArgumentException("non-ws text encountered in " + element + ": " + string);
            }
            if (node.getNodeType() == 8) continue;
            throw new IllegalArgumentException("unexpected non-element child of " + element + ": " + node);
        }
        return arrayList;
    }

    private static void appendChildElement(Element element, Element element2, String[] stringArray) {
        Element element3 = null;
        List<String> list = Arrays.asList(stringArray);
        int n = list.indexOf(element2.getLocalName());
        assert (n != -1) : element2.getLocalName() + " was not found in " + list;
        for (Element element4 : J2EEClassPathSupport.findSubElements(element)) {
            int n2 = list.indexOf(element4.getLocalName());
            assert (n2 != -1) : element4.getLocalName() + " was not found in " + list;
            if (n2 <= n) continue;
            element3 = element4;
            break;
        }
        element.insertBefore(element2, element3);
    }

    private Element createLibraryElement(Document document, String string, Item item, String string2) {
        Element element = document.createElementNS(this.projectConfigurationNameSpace, string2);
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        J2EEClassPathSupport.getFilesForItem(item, arrayList, arrayList2);
        if (arrayList.size() > 0) {
            element.setAttribute("files", "" + arrayList.size());
        }
        if (arrayList2.size() > 0) {
            element.setAttribute("dirs", "" + arrayList2.size());
        }
        element.appendChild(document.createTextNode(string));
        return element;
    }

    public static final class Item
    extends BaseClassPathSupport.Item {
        private boolean includedInDeployment;

        Item(ClassPathSupport.Item item, String string, boolean bl, String string2) {
            super(item, string, string2);
            this.includedInDeployment = bl;
        }

        public static Item create(Library library, String string, boolean bl) {
            ClassPathSupport.Item item = ClassPathSupport.Item.create(library, string);
            String string2 = library.getName();
            return new Item(item, string, bl, "${libs." + string2 + ".classpath}");
        }

        public static Item create(AntArtifact antArtifact, URI uRI, String string, boolean bl) {
            ClassPathSupport.Item item = ClassPathSupport.Item.create(antArtifact, uRI, string);
            return new Item(item, string, bl, null);
        }

        public static Item create(File file, String string, boolean bl) {
            ClassPathSupport.Item item = ClassPathSupport.Item.create(file, string);
            return new Item(item, string, bl, null);
        }

        public static Item create(String string, boolean bl) {
            ClassPathSupport.Item item = ClassPathSupport.Item.create(string);
            return new Item(item, string, bl, null);
        }

        public static Item createBroken(ClassPathItem.Type type, String string, boolean bl) {
            ClassPathSupport.Item item = ClassPathSupport.Item.createBroken(type, string);
            return new Item(item, string, bl, null);
        }

        public static Item createBroken(File file, String string, boolean bl) {
            ClassPathSupport.Item item = ClassPathSupport.Item.createBroken(file, string);
            return new Item(item, string, bl, null);
        }

        public boolean isIncludedInDeployment() {
            return this.includedInDeployment;
        }

        public void setIncludedInDeployment(boolean bl) {
            this.includedInDeployment = bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append(this.delegate.toString());
            stringBuilder.append(", raw = ");
            stringBuilder.append(this.getRaw());
            stringBuilder.append(", includedInDeployment = ");
            stringBuilder.append(this.includedInDeployment);
            return stringBuilder.toString();
        }
    }
}

