/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.java.api.common.classpath.ClassPathItem;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassPathSupport {
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper referenceHelper;
    private final AntProjectHelper antProjectHelper;
    private final Set<String> wellKnownPaths;
    private final String libraryPrefix;
    private final String librarySuffix;
    private final String antArtifactPrefix;

    public static ClassPathSupport create(PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, String[] stringArray, String string, String string2, String string3) {
        Parameters.notNull((CharSequence)"evaluator", (Object)propertyEvaluator);
        Parameters.notNull((CharSequence)"referenceHelper", (Object)referenceHelper);
        Parameters.notNull((CharSequence)"antProjectHelper", (Object)antProjectHelper);
        Parameters.notNull((CharSequence)"libraryPrefix", (Object)string);
        Parameters.notNull((CharSequence)"librarySuffix", (Object)string2);
        Parameters.notNull((CharSequence)"antArtifactPrefix", (Object)string3);
        return new ClassPathSupport(propertyEvaluator, referenceHelper, antProjectHelper, stringArray, string, string2, string3);
    }

    ClassPathSupport(PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, String[] stringArray, String string, String string2, String string3) {
        assert (propertyEvaluator != null);
        assert (referenceHelper != null);
        assert (antProjectHelper != null);
        assert (string != null);
        assert (string2 != null);
        assert (string3 != null);
        this.evaluator = propertyEvaluator;
        this.referenceHelper = referenceHelper;
        this.antProjectHelper = antProjectHelper;
        this.wellKnownPaths = stringArray == null ? null : new HashSet<String>(Arrays.asList(stringArray));
        this.libraryPrefix = string;
        this.librarySuffix = string2;
        this.antArtifactPrefix = string3;
    }

    public Iterator<Item> itemsIterator(String string) {
        return this.itemsList(string).iterator();
    }

    public List<Item> itemsList(String string) {
        String[] stringArray = PropertyUtils.tokenizePath((String)(string == null ? "" : string));
        ArrayList<Item> arrayList = new ArrayList<Item>(stringArray.length);
        for (String string2 : stringArray) {
            Object object;
            Object object2;
            Item item;
            if (this.isWellKnownPath(string2)) {
                item = Item.create(string2);
            } else if (this.isLibrary(string2)) {
                object2 = string2.substring(this.libraryPrefix.length(), string2.lastIndexOf(46));
                object = LibraryManager.getDefault().getLibrary((String)object2);
                item = object == null ? Item.createBroken(ClassPathItem.Type.LIBRARY, string2) : Item.create(object, string2);
            } else if (this.isAntArtifact(string2)) {
                object2 = this.referenceHelper.findArtifactAndLocation(string2);
                if (object2[0] == null || object2[1] == null) {
                    item = Item.createBroken(ClassPathItem.Type.ARTIFACT, string2);
                } else {
                    File file;
                    object = (AntArtifact)object2[0];
                    URI uRI = (URI)object2[1];
                    File file2 = this.antProjectHelper.resolveFile(this.evaluator.evaluate(string2));
                    item = file2.equals(file = new File(object.getScriptLocation().toURI().resolve(uRI).normalize())) ? Item.create((AntArtifact)object, uRI, string2) : Item.createBroken(ClassPathItem.Type.ARTIFACT, string2);
                }
            } else {
                object2 = this.evaluator.evaluate(string2);
                object = null;
                if (object2 != null) {
                    object = this.antProjectHelper.resolveFile((String)object2);
                }
                item = object == null || !object.exists() ? Item.createBroken((File)object, string2) : Item.create((File)object, string2);
            }
            arrayList.add(item);
        }
        return arrayList;
    }

    public String[] encodeToStrings(List<Item> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Item item : list) {
            String string = this.getReference(item);
            if (string == null) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = i < arrayList.size() - 1 ? (String)arrayList.get(i) + ":" : (String)arrayList.get(i);
        }
        return stringArray;
    }

    public String getReference(Item item) {
        String string = null;
        switch (item.getType()) {
            case JAR: {
                string = item.getReference();
                if (item.isBroken() || string != null) break;
                File file = item.getFile();
                string = this.referenceHelper.createForeignFileReference(file, null);
                break;
            }
            case LIBRARY: {
                string = item.getReference();
                if (item.isBroken()) break;
                Library library = item.getLibrary();
                if (string != null || library == null) break;
                string = this.getLibraryReference(item);
                break;
            }
            case ARTIFACT: {
                string = item.getReference();
                if (item.isBroken()) break;
                AntArtifact antArtifact = item.getArtifact();
                if (string != null || antArtifact == null) break;
                string = this.referenceHelper.addReference(item.getArtifact(), item.getArtifactURI());
                break;
            }
            case CLASSPATH: {
                string = item.getReference();
            }
        }
        return string;
    }

    public String getLibraryReference(Item item) {
        if (item.getType() != ClassPathItem.Type.LIBRARY) {
            throw new IllegalArgumentException("Item must be of type LIBRARY");
        }
        return this.libraryPrefix + item.getLibrary().getName() + this.librarySuffix;
    }

    private boolean isWellKnownPath(String string) {
        return this.wellKnownPaths == null ? false : this.wellKnownPaths.contains(string);
    }

    private boolean isAntArtifact(String string) {
        return this.antArtifactPrefix == null ? false : string.startsWith(this.antArtifactPrefix);
    }

    private boolean isLibrary(String string) {
        if (this.libraryPrefix != null && string.startsWith(this.libraryPrefix)) {
            return this.librarySuffix == null ? true : string.endsWith(this.librarySuffix);
        }
        return false;
    }

    public static boolean relativizeLibraryClassPath(EditableProperties editableProperties, AntProjectHelper antProjectHelper, String string) {
        String string2 = PropertyUtils.getGlobalProperties().getProperty(string);
        if (string2 == null) {
            return false;
        }
        String[] stringArray = PropertyUtils.tokenizePath((String)string2);
        StringBuilder stringBuilder = new StringBuilder();
        File file = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = antProjectHelper.resolveFile(stringArray[i]);
            if (!CollocationQuery.areCollocated((File)file2, (File)file)) {
                return false;
            }
            stringBuilder.append(PropertyUtils.relativizeFile((File)file, (File)file2));
            if (i + 1 >= stringArray.length) continue;
            stringBuilder.append(File.pathSeparatorChar);
        }
        if (stringBuilder.length() == 0) {
            return false;
        }
        editableProperties.setProperty(string, stringBuilder.toString());
        editableProperties.setComment(string, new String[]{"# Property " + string + " is set here just to make sharing of project simpler.", "# The library definition has always preference over this property."}, false);
        return true;
    }

    public static final class Item
    implements ClassPathItem {
        private final ClassPathItem.Type type;
        private final Object object;
        private final String property;
        private final boolean broken;
        private URI artifactURI;

        private Item(ClassPathItem.Type type, Object object, String string, boolean bl) {
            this.type = type;
            this.object = object;
            this.property = string;
            this.broken = bl;
        }

        private Item(ClassPathItem.Type type, Object object, String string) {
            this(type, object, string, false);
        }

        private Item(ClassPathItem.Type type, Object object, URI uRI, String string) {
            this(type, object, string, false);
            this.artifactURI = uRI;
        }

        public static Item create(Library library, String string) {
            if (library == null) {
                throw new IllegalArgumentException("library must not be null");
            }
            return new Item(ClassPathItem.Type.LIBRARY, library, string);
        }

        public static Item create(AntArtifact antArtifact, URI uRI, String string) {
            if (uRI == null) {
                throw new IllegalArgumentException("artifactURI must not be null");
            }
            if (antArtifact == null) {
                throw new IllegalArgumentException("artifact must not be null");
            }
            return new Item(ClassPathItem.Type.ARTIFACT, (Object)antArtifact, uRI, string);
        }

        public static Item create(File file, String string) {
            if (file == null) {
                throw new IllegalArgumentException("file must not be null");
            }
            return new Item(ClassPathItem.Type.JAR, file, string);
        }

        public static Item create(String string) {
            if (string == null) {
                throw new IllegalArgumentException("property must not be null");
            }
            return new Item(ClassPathItem.Type.CLASSPATH, null, string);
        }

        public static Item createBroken(ClassPathItem.Type type, String string) {
            if (string == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            return new Item(type, null, string, true);
        }

        public static Item createBroken(File file, String string) {
            if (string == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            return new Item(ClassPathItem.Type.JAR, (Object)file, string, true);
        }

        public ClassPathItem.Type getType() {
            return this.type;
        }

        public Library getLibrary() {
            if (this.getType() != ClassPathItem.Type.LIBRARY) {
                throw new IllegalArgumentException("Item is not of required type - LIBRARY");
            }
            assert (this.object instanceof Library) : "Invalid object type: " + this.object.getClass().getName() + " instance: " + this.object.toString() + " expected type: Library";
            return (Library)this.object;
        }

        public File getFile() {
            if (this.getType() != ClassPathItem.Type.JAR) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            return (File)this.object;
        }

        public AntArtifact getArtifact() {
            if (this.getType() != ClassPathItem.Type.ARTIFACT) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return (AntArtifact)this.object;
        }

        public URI getArtifactURI() {
            if (this.getType() != ClassPathItem.Type.ARTIFACT) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return this.artifactURI;
        }

        public String getReference() {
            return this.property;
        }

        public boolean isBroken() {
            return this.broken;
        }

        public int hashCode() {
            int n = this.getType().ordinal();
            if (this.broken) {
                return 42;
            }
            switch (this.getType()) {
                case ARTIFACT: {
                    n += this.getArtifact().getType().hashCode();
                    n += this.getArtifact().getScriptLocation().hashCode();
                    n += this.getArtifactURI().hashCode();
                    break;
                }
                case CLASSPATH: {
                    n += this.property.hashCode();
                    break;
                }
                default: {
                    n += this.object.hashCode();
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Item)) {
                return false;
            }
            Item item = (Item)object;
            if (this.getType() != item.getType()) {
                return false;
            }
            if (this.isBroken() != item.isBroken()) {
                return false;
            }
            if (this.isBroken()) {
                return this.getReference().equals(item.getReference());
            }
            switch (this.getType()) {
                case ARTIFACT: {
                    if (this.getArtifact().getType() != item.getArtifact().getType()) {
                        return false;
                    }
                    if (!this.getArtifact().getScriptLocation().equals(item.getArtifact().getScriptLocation())) {
                        return false;
                    }
                    return this.getArtifactURI().equals(item.getArtifactURI());
                }
                case CLASSPATH: {
                    return this.property.equals(item.property);
                }
            }
            return this.object.equals(item.object);
        }
    }
}

