/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.awt.Color;
import java.io.IOException;
import java.util.Collection;
import java.util.prefs.Preferences;
import org.netbeans.modules.diff.builtin.provider.BuiltInDiffProvider;
import org.netbeans.modules.diff.cmdline.CmdlineDiffProvider;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class DiffModuleConfig {
    public static final String PREF_EXTERNAL_DIFF_COMMAND = "externalDiffCommand";
    private static final String PREF_IGNORE_LEADINGTRAILING_WHITESPACE = "ignoreWhitespace";
    private static final String PREF_IGNORE_INNER_WHITESPACE = "ignoreInnerWhitespace";
    private static final String PREF_IGNORE_CASE = "ignoreCase";
    private static final String PREF_USE_INTERNAL_DIFF = "useInternalDiff";
    private static final String PREF_ADDED_COLOR = "addedColor";
    private static final String PREF_CHANGED_COLOR = "changedColor";
    private static final String PREF_DELETED_COLOR = "deletedColor";
    private static final String PREF_MERGE_UNRESOLVED_COLOR = "merge.unresolvedColor";
    private static final String PREF_MERGE_APPLIED_COLOR = "merge.appliedColor";
    private static final String PREF_MERGE_NOTAPPLIED_COLOR = "merge.notappliedColor";
    private static final DiffModuleConfig INSTANCE = new DiffModuleConfig();
    private final Color defaultAddedColor = new Color(180, 255, 180);
    private final Color defaultChangedColor = new Color(160, 200, 255);
    private final Color defaultDeletedColor = new Color(255, 160, 180);
    private final Color defaultAppliedColor = new Color(180, 255, 180);
    private final Color defaultNotAppliedColor = new Color(160, 200, 255);
    private final Color defaultUnresolvedColor = new Color(255, 160, 180);

    public static DiffModuleConfig getDefault() {
        return INSTANCE;
    }

    private DiffModuleConfig() {
    }

    public Color getAddedColor() {
        return this.getColor(PREF_ADDED_COLOR, this.defaultAddedColor);
    }

    public Color getChangedColor() {
        return this.getColor(PREF_CHANGED_COLOR, this.defaultChangedColor);
    }

    public Color getDeletedColor() {
        return this.getColor(PREF_DELETED_COLOR, this.defaultDeletedColor);
    }

    public Color getAppliedColor() {
        return this.getColor(PREF_MERGE_APPLIED_COLOR, this.defaultAppliedColor);
    }

    public Color getNotAppliedColor() {
        return this.getColor(PREF_MERGE_NOTAPPLIED_COLOR, this.defaultNotAppliedColor);
    }

    public Color getUnresolvedColor() {
        return this.getColor(PREF_MERGE_UNRESOLVED_COLOR, this.defaultUnresolvedColor);
    }

    public void setChangedColor(Color color) {
        this.putColor(PREF_CHANGED_COLOR, color);
    }

    public void setAddedColor(Color color) {
        this.putColor(PREF_ADDED_COLOR, color);
    }

    public void setDeletedColor(Color color) {
        this.putColor(PREF_DELETED_COLOR, color);
    }

    public void setNotAppliedColor(Color color) {
        this.putColor(PREF_MERGE_NOTAPPLIED_COLOR, color);
    }

    public void setAppliedColor(Color color) {
        this.putColor(PREF_MERGE_APPLIED_COLOR, color);
    }

    public void setUnresolvedColor(Color color) {
        this.putColor(PREF_MERGE_UNRESOLVED_COLOR, color);
    }

    private void putColor(String string, Color color) {
        this.getPreferences().putInt(string, color.getRGB());
    }

    private Color getColor(String string, Color color) {
        int n = this.getPreferences().getInt(string, color.getRGB());
        return new Color(n);
    }

    public DiffProvider getDefaultDiffProvider() {
        Collection collection = Lookup.getDefault().lookup(new Lookup.Template(DiffProvider.class)).allInstances();
        for (DiffProvider diffProvider : collection) {
            if (this.isUseInteralDiff()) {
                if (!(diffProvider instanceof BuiltInDiffProvider)) continue;
                ((BuiltInDiffProvider)diffProvider).setOptions(this.getOptions());
                return diffProvider;
            }
            if (!(diffProvider instanceof CmdlineDiffProvider)) continue;
            ((CmdlineDiffProvider)diffProvider).setDiffCommand(this.getDiffCommand());
            return diffProvider;
        }
        return null;
    }

    private void setDefaultProvider(DiffProvider diffProvider) {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Services/DiffProviders");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        DataObject[] dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            InstanceDataObject instanceDataObject;
            if (!(dataObjectArray[i] instanceof InstanceDataObject) || !(instanceDataObject = (InstanceDataObject)dataObjectArray[i]).instanceOf(diffProvider.getClass())) continue;
            try {
                if (!diffProvider.equals(instanceDataObject.instanceCreate())) continue;
                dataFolder.setOrder(new DataObject[]{instanceDataObject});
                break;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private String getDiffCommand() {
        return this.getPreferences().get(PREF_EXTERNAL_DIFF_COMMAND, "diff {0} {1}");
    }

    public void setOptions(BuiltInDiffProvider.Options options) {
        this.getPreferences().putBoolean(PREF_IGNORE_LEADINGTRAILING_WHITESPACE, options.ignoreLeadingAndtrailingWhitespace);
        this.getPreferences().putBoolean(PREF_IGNORE_INNER_WHITESPACE, options.ignoreInnerWhitespace);
        this.getPreferences().putBoolean(PREF_IGNORE_CASE, options.ignoreCase);
        this.getBuiltinProvider().setOptions(options);
    }

    public BuiltInDiffProvider.Options getOptions() {
        BuiltInDiffProvider.Options options = new BuiltInDiffProvider.Options();
        options.ignoreLeadingAndtrailingWhitespace = this.getPreferences().getBoolean(PREF_IGNORE_LEADINGTRAILING_WHITESPACE, true);
        options.ignoreInnerWhitespace = this.getPreferences().getBoolean(PREF_IGNORE_INNER_WHITESPACE, false);
        options.ignoreCase = this.getPreferences().getBoolean(PREF_IGNORE_CASE, false);
        return options;
    }

    private BuiltInDiffProvider getBuiltinProvider() {
        Collection collection = Lookup.getDefault().lookupAll(DiffProvider.class);
        for (DiffProvider diffProvider : collection) {
            if (!(diffProvider instanceof BuiltInDiffProvider)) continue;
            return (BuiltInDiffProvider)diffProvider;
        }
        throw new IllegalStateException("No builtin diff provider");
    }

    public void setUseInteralDiff(boolean bl) {
        this.getPreferences().putBoolean(PREF_USE_INTERNAL_DIFF, bl);
        Collection collection = Lookup.getDefault().lookupAll(DiffProvider.class);
        if (bl) {
            this.setDefaultProvider(this.getBuiltinProvider());
        } else {
            for (DiffProvider diffProvider : collection) {
                if (!(diffProvider instanceof CmdlineDiffProvider)) continue;
                this.setDefaultProvider(diffProvider);
                break;
            }
        }
    }

    public boolean isUseInteralDiff() {
        return this.getPreferences().getBoolean(PREF_USE_INTERNAL_DIFF, true);
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(DiffModuleConfig.class);
    }
}

