/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.php;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.CustomClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.php.SaasClientPhpAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.php.util.PhpUtil;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.CustomSaasMethod;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomClientPhpCodeGenerator
extends SaasClientCodeGenerator {
    private FileObject saasServiceFile = null;
    private FileObject serviceFolder = null;
    private FileObject saasFolder = null;
    private SaasClientPhpAuthenticationGenerator authGen;

    public CustomClientPhpCodeGenerator() {
        this.setDropFileType(Constants.DropFileType.PHP);
    }

    public boolean canAccept(SaasMethod saasMethod, Document document) {
        return SaasBean.canAccept((SaasMethod)saasMethod, CustomSaasMethod.class, (Constants.DropFileType)this.getDropFileType()) && PhpUtil.isPhp(document);
    }

    public void init(SaasMethod saasMethod, Document document) throws IOException {
        this.init(saasMethod, new CustomClientSaasBean((CustomSaasMethod)saasMethod, true), document);
    }

    public void init(SaasMethod saasMethod, CustomClientSaasBean customClientSaasBean, Document document) throws IOException {
        super.init(saasMethod, document);
        this.setBean((SaasBean)customClientSaasBean);
        this.serviceFolder = null;
        this.saasFolder = null;
        this.authGen = new SaasClientPhpAuthenticationGenerator((SaasBean)this.getBean(), this.getProject());
        this.authGen.setLoginArguments(this.getLoginArguments());
        this.authGen.setAuthenticatorMethodParameters(this.getAuthenticatorMethodParameters());
        this.authGen.setSaasServiceFolder(this.getSaasServiceFolder());
        this.getBean();
        this.authGen.setAuthenticationProfile(CustomClientSaasBean.getProfile((SaasMethod)saasMethod, (Constants.DropFileType)this.getDropFileType()));
        this.authGen.setDropFileType(this.getDropFileType());
    }

    public CustomClientSaasBean getBean() {
        return (CustomClientSaasBean)super.getBean();
    }

    public SaasClientPhpAuthenticationGenerator getAuthenticationGenerator() {
        return this.authGen;
    }

    public FileObject getSaasServiceFolder() throws IOException {
        if (this.serviceFolder == null) {
            FileObject fileObject = this.getSourceRootFolder();
            String string = this.getBean().getSaasServicePackageName().replace(".", "_");
            this.serviceFolder = fileObject.getFileObject(string);
            if (this.serviceFolder == null) {
                this.serviceFolder = FileUtil.createFolder((FileObject)fileObject, (String)string);
            }
        }
        return this.serviceFolder;
    }

    public FileObject getSaasFolder() throws IOException {
        if (this.saasFolder == null) {
            FileObject fileObject = this.getSourceRootFolder();
            String string = "org.netbeans.saas".replace(".", "_");
            this.saasFolder = fileObject.getFileObject(string);
            if (this.saasFolder == null) {
                this.saasFolder = FileUtil.createFolder((FileObject)fileObject, (String)string);
            }
        }
        return this.saasFolder;
    }

    private FileObject getSourceRootFolder() {
        Sources sources = ProjectUtils.getSources((Project)this.getProject());
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("PHPSOURCE");
        FileObject fileObject = this.getProject().getProjectDirectory();
        if (sourceGroupArray != null && sourceGroupArray.length > 0 && sourceGroupArray[0] != null && sourceGroupArray[0].getRootFolder() != null) {
            fileObject = sourceGroupArray[0].getRootFolder();
        }
        return fileObject;
    }

    public Set<FileObject> generate() throws IOException {
        this.preGenerate();
        this.getAuthenticationGenerator().createAuthenticatorClass();
        this.getAuthenticationGenerator().createAuthorizationClasses();
        this.getAuthenticationGenerator().modifyAuthenticationClass();
        this.insertSaasServiceAccessCode(this.isInBlock(this.getTargetDocument()));
        this.addImportsToTargetFile();
        this.finishProgressReporting();
        return new HashSet<FileObject>(Collections.EMPTY_LIST);
    }

    protected void preGenerate() throws IOException {
        this.createRestConnectionFile(this.getProject());
        this.getTargetFolder().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                Map map = CustomClientPhpCodeGenerator.this.getBean().getArtifactTemplates(Constants.DropFileType.PHP.prefix());
                for (Map.Entry entry : map.entrySet()) {
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    Util.createDataObjectFromTemplate((String)string2, (FileObject)CustomClientPhpCodeGenerator.this.getSaasServiceFolder(), (String)string);
                }
            }
        });
    }

    protected void createRestConnectionFile(Project project) throws IOException {
        Util.createDataObjectFromTemplate((String)"Templates/SaaSServices/RestConnection.php", (FileObject)this.getSaasFolder(), null);
        Util.createDataObjectFromTemplate((String)"Templates/SaaSServices/RestResponse.php", (FileObject)this.getSaasFolder(), null);
    }

    protected String getFixedParameterDeclaration() {
        String string = "";
        List list = this.getBean().getInputParameters();
        List list2 = null;
        Constants.SaasAuthenticationType saasAuthenticationType = this.getBean().getAuthenticationType();
        if (saasAuthenticationType == Constants.SaasAuthenticationType.SESSION_KEY) {
            SaasBean.SessionKeyAuthentication sessionKeyAuthentication = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
            list2 = sessionKeyAuthentication.getParameters();
        } else {
            list2 = Collections.emptyList();
        }
        for (ParameterInfo parameterInfo : this.getBean().getInputParameters()) {
            if (!parameterInfo.isFixed() || Util.isContains((ParameterInfo)parameterInfo, (List)list2)) continue;
            string = string + "$" + this.getVariableName(parameterInfo.getName()) + " = $" + PhpUtil.findParamValue(parameterInfo) + ";\n";
        }
        return string;
    }

    protected List<ParameterInfo> getAuthenticatorMethodParameters() {
        return Collections.emptyList();
    }

    protected String getLoginArguments() {
        return "";
    }

    protected void addImportsToTargetFile() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getBean().getSaasServicePackageName() + "->" + this.getBean().getSaasServiceName());
        arrayList.add("org.netbeans.saas->RestResponse");
        this.addImportsToPhp(this.getTargetFile(), arrayList);
    }

    protected void addImportsToSaasService() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("org.netbeans.saas->RestConnection");
        arrayList.add("org.netbeans.saas->RestResponse");
        this.addImportsToPhp(this.saasServiceFile, arrayList);
    }

    protected void insertSaasServiceAccessCode(boolean bl) throws IOException {
        try {
            String string = "\ninclude_once \"" + this.getSaasServiceFolder().getName() + "/" + this.getBean().getSaasServiceName() + ".php\";\n";
            String string2 = PhpUtil.wrapWithTag(string + this.getCustomMethodBody(), this.getTargetDocument(), this.getStartPosition()) + "\n";
            this.insert(string2, true);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public ParameterInfo findParameter(String string) {
        List list = this.getBean().getInputParameters();
        if (list != null) {
            for (ParameterInfo parameterInfo : list) {
                if (!parameterInfo.getName().equals(string)) continue;
                return parameterInfo;
            }
        }
        return null;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> list, String string) {
        if (string == null) {
            string = " ";
        }
        String string2 = "";
        for (ParameterInfo parameterInfo : list) {
            String string3 = this.getVariableName(parameterInfo.getName());
            String string4 = PhpUtil.findParamValue(parameterInfo);
            if (parameterInfo.getType() != String.class) {
                string2 = string2 + string + "$" + string3 + " = " + string4 + ";\n";
                continue;
            }
            if (string4 != null) {
                string2 = string2 + string + "$" + string3 + " = \"" + string4 + "\";\n";
                continue;
            }
            string2 = string2 + string + "$" + string3 + " = null;\n";
        }
        return string2;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> list) {
        String string = "                 ";
        return this.getHeaderOrParameterDeclaration(list, string);
    }

    private void addImportsToPhp(FileObject fileObject, List<String> list) {
    }

    protected String getCustomMethodBody() throws IOException {
        String string = "";
        String string2 = "";
        String string3 = "                    ";
        List<ParameterInfo> list = this.getServiceMethodParameters();
        string = string + CustomClientPhpCodeGenerator.getHeaderOrParameterUsage(list);
        string2 = string2 + this.getHeaderOrParameterDeclaration(list);
        String string4 = "";
        string4 = string4 + string3 + "try {\n";
        string4 = string4 + string2 + "\n";
        string4 = string4 + string3 + "$result = " + this.getBean().getSaasServiceName() + "::" + this.getBean().getSaasServiceMethodName() + "(" + string + ");\n";
        string4 = string4 + string3 + "echo $result->getResponseBody();\n";
        string4 = string4 + string3 + "} catch(Exception $e) {\n";
        string4 = string4 + string3 + "    echo \"Exception occured: \".$e;\n";
        string4 = string4 + string3 + "}\n";
        return string4;
    }

    public static String getHeaderOrParameterUsage(List<ParameterInfo> list) {
        String string = "";
        for (ParameterInfo parameterInfo : list) {
            String string2 = Util.getParameterName((ParameterInfo)parameterInfo, (boolean)true, (boolean)true, (boolean)true);
            string = string + "$" + string2 + ", ";
        }
        if (list.size() > 0) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public static String getHeaderOrParameterDefinitionPart(List<ParameterInfo> list, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (ParameterInfo parameterInfo : list) {
            stringBuffer.append(CustomClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(parameterInfo, string, bl || parameterInfo.isApiKey()));
        }
        return stringBuffer.toString();
    }

    public static String getHeaderOrParameterDefinitionPart(ParameterInfo parameterInfo, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = Util.getParameterName((ParameterInfo)parameterInfo);
        String string3 = null;
        String string4 = "             ";
        if (bl) {
            string3 = PhpUtil.findParamValue(parameterInfo);
            if (parameterInfo.getType() != String.class) {
                stringBuffer.append(string4 + "$" + string + "[\"" + string2 + "\"] = $" + string3 + ";\n");
            } else if (string3 != null) {
                stringBuffer.append(string4 + "$" + string + "[\"" + string2 + "\"] = $" + string3 + ";\n");
            } else {
                stringBuffer.append(string4 + "$" + string + "[\"" + string2 + "\"] = null;\n");
            }
        } else if (parameterInfo.getType() != String.class) {
            stringBuffer.append(string4 + "$" + string + "[\"" + string2 + "\"] = $" + Util.getVariableName((String)parameterInfo.getName()) + ";\n");
        } else {
            stringBuffer.append(string4 + "$" + string + "[\"" + string2 + "\"] = $" + Util.getVariableName((String)parameterInfo.getName()) + ";\n");
        }
        return stringBuffer.toString();
    }

    public static String getHeaderOrParameterDefinition(List<ParameterInfo> list, String string, boolean bl) {
        String string2 = "";
        string2 = string2 + "$" + string + " = array();\n";
        string2 = string2 + CustomClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(list, string, bl) + "\n";
        return string2;
    }

    public static String getHeaderOrParameterDefinition(List<ParameterInfo> list, String string, boolean bl, Constants.HttpMethodType httpMethodType) {
        String string2 = CustomClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(list, string, bl);
        if (!(httpMethodType != Constants.HttpMethodType.PUT && httpMethodType != Constants.HttpMethodType.POST || Util.isContains(list, (ParameterInfo)new ParameterInfo("Content-Type", String.class)))) {
            string2 = string2 + ", array(\"Content-Type\" => " + Util.getVariableName((String)"Content-Type") + ")";
        }
        String string3 = "";
        string3 = string3 + "$" + string + " = array();\n";
        string3 = string3 + string2 + "\n";
        return string3;
    }

    protected List<ParameterInfo> getServiceMethodParameters() {
        List list = this.getBean().filterParametersByAuth(this.getBean().filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
        Constants.HttpMethodType httpMethodType = this.getBean().getHttpMethod();
        if (httpMethodType == Constants.HttpMethodType.PUT || httpMethodType == Constants.HttpMethodType.POST) {
            ParameterInfo parameterInfo = Util.findParameter((List)this.getBean().getInputParameters(), (String)"Content-Type");
            Class clazz = InputStream.class;
            if (parameterInfo == null) {
                list.add(new ParameterInfo("Content-Type", String.class));
            } else if (!parameterInfo.isFixed() && !list.contains(parameterInfo)) {
                list.add(parameterInfo);
            } else {
                String string = Util.findParamValue((ParameterInfo)parameterInfo);
                if (string.equals("text/plain") || string.equals("application/xml") || string.equals("text/xml")) {
                    clazz = String.class;
                }
            }
            list.add(new ParameterInfo("content", clazz));
        }
        return list;
    }

    public static List<ParameterInfo> getAuthenticatorMethodParametersForWeb() {
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
        arrayList.add(new ParameterInfo("request", Object.class, "HttpServletRequest"));
        arrayList.add(new ParameterInfo("response", Object.class, "HttpServletResponse"));
        return arrayList;
    }

    public static List<ParameterInfo> getServiceMethodParametersForWeb(CustomClientSaasBean customClientSaasBean) {
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
        arrayList.addAll(CustomClientPhpCodeGenerator.getAuthenticatorMethodParametersForWeb());
        arrayList.addAll(customClientSaasBean.filterParametersByAuth(customClientSaasBean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED})));
        return arrayList;
    }
}

