/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGLabel;
import org.netbeans.microedition.svg.SVGList;
import org.netbeans.microedition.svg.SVGListCellRenderer;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGLocatableElement;

public class SVGDefaultListCellRenderer
implements SVGListCellRenderer {
    private static final String HEIGHT = "height";
    private static final float ASCENT_SELECTION = 2.0f;
    private static final float DESCENT_SELECTION = 2.0f;
    private float myX;
    private float myY;
    private float myHeight;

    SVGDefaultListCellRenderer(float height) {
        this.myHeight = height;
    }

    public SVGComponent getCellRendererComponent(SVGList list, Object value, int index, boolean isSelected) {
        SVGLocatableElement content = list.getContent();
        SVGLocatableElement hiddenText = list.getHiddenText();
        if (hiddenText == null) {
            throw new IllegalArgumentException("List argument doesn't contain hidden text for access to fontcharacteristics. Unable render any value.");
        }
        this.myX = hiddenText.getFloatTrait("x");
        this.myY = hiddenText.getFloatTrait("y");
        if (isSelected) {
            this.showSelection(list, index);
        }
        SVGLocatableElement textElement = (SVGLocatableElement)list.getForm().getDocument().createElementNS("http://www.w3.org/2000/svg", "text");
        textElement.setFloatTrait("x", this.myX);
        textElement.setFloatTrait("y", this.myY + (float)index * this.myHeight);
        textElement.setFloatTrait("font-size", hiddenText.getFloatTrait("font-size"));
        textElement.setTrait("font-family", hiddenText.getTrait("font-family"));
        textElement.setTrait("visibility", "inherit");
        if (value == null) {
            textElement.setTrait("#text", "");
        } else {
            textElement.setTrait("#text", value.toString());
        }
        content.appendChild((Node)textElement);
        return new SVGLabel(list.getForm(), textElement);
    }

    private void showSelection(SVGList list, int index) {
        SVGLocatableElement selection = list.getSelection();
        if (selection == null) {
            throw new IllegalArgumentException("List argument doesn't contain nested 'selection' element. Unable render any value.");
        }
        selection.setFloatTrait("y", this.myY + (float)(index - 1) * this.myHeight + 2.0f);
        selection.setFloatTrait(HEIGHT, this.myHeight + 2.0f);
        if (!list.isSlave()) {
            selection.setTrait("visibility", "visible");
        }
    }
}

