/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGForm;
import org.netbeans.microedition.svg.input.InputHandler;
import org.w3c.dom.svg.SVGAnimationElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;

public abstract class SVGAbstractButton
extends SVGComponent {
    protected static final String PRESSED = "pressed";
    protected static final String RELEASED = "released";
    protected static final String PRESSED_SUFFIX = "_pressed";
    protected static final String RELEASED_SUFFIX = "_released";
    private static final String BODY = "body";
    private static final String BODY_SUFFIX = "_body";
    private SVGLocatableElement myBodyElement = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + "_body");
    protected SVGAnimationElement myPressedAnimation;
    protected SVGAnimationElement myReleasedAnimation;

    public SVGAbstractButton(SVGForm form, String elemId) {
        super(form, elemId);
        if (this.myBodyElement == null) {
            this.myBodyElement = (SVGLocatableElement)this.getNestedElementByMeta((SVGElement)this.getElement(), "type", BODY);
        }
        this.initAnimation();
    }

    public InputHandler getInputHandler() {
        return InputHandler.BUTTON_INPUT_HANDLER;
    }

    public void pressButton() {
        if (this.getPressedAnimation() != null) {
            this.getForm().invokeLaterSafely(new Runnable(){

                public void run() {
                    SVGAbstractButton.this.getPressedAnimation().beginElementAt(0.0f);
                }
            });
        }
        this.getForm().activate(this);
    }

    public void releaseButton() {
        if (this.getReleasedAnimation() != null) {
            this.getForm().invokeLaterSafely(new Runnable(){

                public void run() {
                    SVGAbstractButton.this.getReleasedAnimation().beginElementAt(0.0f);
                }
            });
        }
    }

    public abstract boolean isSelected();

    public abstract void setSelected(boolean var1);

    protected SVGLocatableElement getBodyElement() {
        return this.myBodyElement;
    }

    private void initAnimation() {
        if (this.getBodyElement() != null) {
            this.myPressedAnimation = (SVGAnimationElement)this.getElementById((SVGElement)this.getBodyElement(), this.getBodyElement().getId() + PRESSED_SUFFIX);
            this.myReleasedAnimation = (SVGAnimationElement)this.getElementById((SVGElement)this.getBodyElement(), this.getBodyElement().getId() + RELEASED_SUFFIX);
            if (this.myPressedAnimation != null) {
                return;
            }
            int count = 0;
            SVGElement animation = (SVGElement)this.getBodyElement().getFirstElementChild();
            while (animation != null) {
                animation = (SVGElement)animation.getNextElementSibling();
                if (count == 1) {
                    this.myPressedAnimation = (SVGAnimationElement)animation;
                } else if (count == 2) {
                    this.myReleasedAnimation = (SVGAnimationElement)animation;
                }
                ++count;
            }
        } else {
            this.myPressedAnimation = null;
            this.myReleasedAnimation = null;
        }
    }

    private SVGAnimationElement getPressedAnimation() {
        return this.myPressedAnimation;
    }

    private SVGAnimationElement getReleasedAnimation() {
        return this.myReleasedAnimation;
    }
}

