/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.core.ui.top;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.asm.core.assistance.RegisterChooser;
import org.netbeans.modules.asm.core.assistance.RegisterChooserListener;
import org.netbeans.modules.asm.core.assistance.RegisterUsageAccesor;
import org.netbeans.modules.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.asm.core.ui.top.NavigatorTab;
import org.netbeans.modules.asm.core.ui.top.ext.TableSorter;
import org.netbeans.modules.asm.model.AsmModel;
import org.netbeans.modules.asm.model.lang.Register;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterUsagesPanel
extends JPanel
implements NavigatorTab,
RegisterUsageAccesor,
PropertyChangeListener {
    private AsmModel model;
    private final DefaultTableModel tableModel;
    private RegisterChooserListener chooserListener;
    private static RegisterUsagesPanel instance;
    public static final Color ARG_COLOR;
    public static final Color READ_COLOR;
    public static final Color USED_COLOR;
    public static final Color WRITE_COLOR;
    private JTable jRegisterTable;
    private JScrollPane jTableScrollPane;

    public static synchronized RegisterUsagesPanel getInstance() {
        if (instance == null) {
            instance = new RegisterUsagesPanel();
        }
        return instance;
    }

    private RegisterUsagesPanel() {
        this.initComponents();
        this.tableModel = new RegisterTableModel();
        TableSorter tableSorter = new TableSorter(this.tableModel);
        tableSorter.setColumnComparator(String.class, TableSorter.LEXICAL_COMPARATOR);
        tableSorter.setTableHeader(this.jRegisterTable.getTableHeader());
        this.jRegisterTable.setDefaultRenderer(Register.class, new RegisterCellRendererForRegister());
        this.jRegisterTable.setDefaultRenderer(RegisterUsageAccesor.RegisterStatus.class, new RegisterCellRendererForUsage());
        this.jRegisterTable.setModel(tableSorter);
        this.jRegisterTable.getSelectionModel().addListSelectionListener(new RegisterSelectionListener());
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(RegisterUsagesPanel.class, (String)"CTL_REGS_NAME");
    }

    public void setChooserListener(RegisterChooserListener registerChooserListener) {
        this.chooserListener = registerChooserListener;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void opened() {
    }

    public void closed() {
    }

    @Override
    public void setDocument(DataObject dataObject) {
        this.model = AsmObjectUtilities.getModel(dataObject);
        if (this.model == null) {
            return;
        }
        Document document = AsmObjectUtilities.getDocument(dataObject);
        this.chooserListener = (RegisterChooserListener)document.getProperty(RegisterChooserListener.class);
        this.setRegisters();
        this.updateRegisterValues();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateRegisterValues();
    }

    private void updateRegisterValues() {
    }

    private static boolean isTheSame(Register register, String string) {
        if (register.getName().equals(string)) {
            return true;
        }
        for (Register register2 : register.getChildren()) {
            if (!register2.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setRegisterStatus(Register register, RegisterUsageAccesor.RegisterStatus registerStatus) {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (register != this.tableModel.getValueAt(i, 0)) continue;
            this.tableModel.setValueAt(registerStatus, i, 1);
            return;
        }
    }

    @Override
    public void setRegisterStatus(Collection<Register> collection, RegisterUsageAccesor.RegisterStatus registerStatus) {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (!collection.contains(this.tableModel.getValueAt(i, 0))) continue;
            this.tableModel.setValueAt(registerStatus, i, 1);
        }
    }

    @Override
    public void clearStatuses() {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            this.tableModel.setValueAt("", i, 1);
        }
    }

    public void clearValues() {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            this.tableModel.setValueAt("", i, 2);
        }
    }

    private void setRegisters() {
        this.tableModel.setNumRows(0);
        for (Register register : this.model.getRegisterSet()) {
            if (register.getDirectParent() != null) continue;
            this.tableModel.addRow(new Object[]{register, "", ""});
        }
    }

    private void initComponents() {
        this.jTableScrollPane = new JScrollPane();
        this.jRegisterTable = new JTable();
        this.jTableScrollPane.setViewportView(this.jRegisterTable);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jTableScrollPane, -1, 445, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jTableScrollPane, -1, 329, Short.MAX_VALUE));
    }

    static {
        ARG_COLOR = new Color(235, 222, 194);
        READ_COLOR = new Color(220, 234, 196);
        USED_COLOR = new Color(253, 242, 196);
        WRITE_COLOR = new Color(235, 199, 194);
    }

    private static class RegisterTableModel
    extends DefaultTableModel {
        public static final int COLUMN_REGISTER = 0;
        public static final int COLUMN_USAGE = 1;
        public static final int COLUMN_VALUE = 2;
        private Class[] types = new Class[]{Register.class, RegisterUsageAccesor.RegisterStatus.class, String.class};

        public RegisterTableModel() {
            super(new Object[0][], new String[]{NbBundle.getMessage(RegisterUsagesPanel.class, (String)"LBL_REGUSAGE_REGISTER"), NbBundle.getMessage(RegisterUsagesPanel.class, (String)"LBL_REGUSAGE_USAGE"), NbBundle.getMessage(RegisterUsagesPanel.class, (String)"LBL_REGUSAGE_VALUE")});
        }

        public Class getColumnClass(int n) {
            return this.types[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private static class RegisterCellRendererForRegister
    extends DefaultTableCellRenderer.UIResource {
        public RegisterCellRendererForRegister() {
            this.setHorizontalAlignment(0);
        }
    }

    private static class RegisterCellRendererForUsage
    extends DefaultTableCellRenderer.UIResource {
        public RegisterCellRendererForUsage() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(jTable == null || jTable.isEnabled());
            if (RegisterUsageAccesor.PredefinedStatuses.STATUS_ARG.equals(object)) {
                this.setBackground(ARG_COLOR);
            } else if (RegisterUsageAccesor.PredefinedStatuses.STATUS_READ.equals(object)) {
                this.setBackground(READ_COLOR);
            } else if (RegisterUsageAccesor.PredefinedStatuses.STATUS_USED.equals(object)) {
                this.setBackground(USED_COLOR);
            } else if (RegisterUsageAccesor.PredefinedStatuses.STATUS_WRITE.equals(object)) {
                this.setBackground(WRITE_COLOR);
            } else {
                this.setBackground(null);
            }
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }
    }

    private class RegisterSelectionListener
    implements ListSelectionListener {
        private RegisterSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = RegisterUsagesPanel.this.jRegisterTable.getSelectedRow();
            if (RegisterUsagesPanel.this.chooserListener != null) {
                if (n != -1) {
                    final Register register = (Register)RegisterUsagesPanel.this.tableModel.getValueAt(n, 0);
                    RegisterUsagesPanel.this.chooserListener.update(new RegisterChooser(){

                        @Override
                        public Collection<Register> getRegisters() {
                            return Arrays.asList(register);
                        }
                    });
                } else {
                    RegisterUsagesPanel.this.chooserListener.update(new RegisterChooser(){

                        @Override
                        public Collection<Register> getRegisters() {
                            return Collections.emptyList();
                        }
                    });
                }
            }
        }
    }
}

