/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.schema.abe.ABEBaseDropPanel;
import org.netbeans.modules.xml.schema.abe.InputValidator;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;
import org.netbeans.modules.xml.schema.abe.NBGlassPaneAccessSupport;
import org.netbeans.modules.xml.schema.abe.UIUtilities;
import org.openide.util.NbBundle;

public class InplaceEditableLabel
extends JLabel {
    private static final long serialVersionUID = 7526472295622776147L;
    boolean editMode = false;
    public static final String PROPERTY_MODE_CHANGE = "PROPERTY_MODE_CHANGE";
    boolean mouseOverMe = false;
    boolean altKeyPressed = false;
    private Color mouseOverColor;
    private JComponent editorComponent;
    JPanel glass;
    boolean drewLine = false;
    String editInfoString = null;
    InstanceUIContext context = null;
    int wMagFactor = 2;
    InputValidator inputValidator;
    String errorMessage;
    CtrlClickHandler ctrlClickHandler;

    public InplaceEditableLabel() {
        this.setForeground(Color.BLUE);
        this.setMouseOverColor(this.getForeground());
        this.setToolTipText(NbBundle.getMessage(InplaceEditableLabel.class, (String)"TTP_DEFAULT_INPLACE_EDIT"));
        this.initialize();
    }

    public InplaceEditableLabel(String string) {
        this();
        super.setText(string);
    }

    public JScrollPane getScrollPane() {
        return ((ABEBaseDropPanel)this.getParent()).context.getInstanceDesignerScrollPane();
    }

    void initialize() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.isShiftDown() && mouseEvent.getClickCount() == 1 || mouseEvent.getClickCount() > 1) {
                    InplaceEditableLabel.this.showEditor();
                } else if (InplaceEditableLabel.this.drewLine) {
                    if (InplaceEditableLabel.this.ctrlClickHandler != null) {
                        InplaceEditableLabel.this.ctrlClickHandler.handleCtrlClick();
                    }
                } else {
                    InplaceEditableLabel.this.getParent().dispatchEvent(mouseEvent);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(mouseEvent);
                InplaceEditableLabel.this.repaint();
                InplaceEditableLabel.this.getParent().dispatchEvent(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                InplaceEditableLabel.this.getParent().dispatchEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (!InplaceEditableLabel.this.drewLine) {
                    InplaceEditableLabel.this.getParent().dispatchEvent(mouseEvent);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!InplaceEditableLabel.this.drewLine) {
                    InplaceEditableLabel.this.getParent().dispatchEvent(mouseEvent);
                }
            }
        });
    }

    protected void paintComponent(Graphics graphics) {
        this.drewLine = false;
        if (this.mouseOverMe && this.altKeyPressed && this.ctrlClickHandler != null) {
            Color color = this.getForeground();
            Font font = new Font(this.getFont().getFontName(), 1, this.getFont().getSize() + 2);
            this.setForeground(this.getMouseOverColor());
            Rectangle rectangle = graphics.getClipBounds();
            super.paintComponent(graphics);
            graphics.setColor(this.getMouseOverColor());
            int n = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this.getText());
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + n, rectangle.y + rectangle.height - 1);
            this.setForeground(color);
            this.setFont(font);
            this.drewLine = true;
        } else {
            super.paintComponent(graphics);
        }
    }

    public Color getMouseOverColor() {
        return this.mouseOverColor;
    }

    public void setMouseOverColor(Color color) {
        this.mouseOverColor = color;
    }

    public void setText(String string) {
        super.setText(string);
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = SwingUtilities.computeStringWidth(fontMetrics, string);
            this.setPreferredSize(new Dimension(n, this.getPreferredSize().height));
        }
        if (this.editMode) {
            this.hideEditor();
        }
    }

    public void showEditor() {
        this.firePropertyChange(PROPERTY_MODE_CHANGE, (Object)Mode.NORMAL, (Object)Mode.EDIT);
        if (this.editorComponent == null && this.editInfoString == null) {
            return;
        }
        this.editMode = true;
        this.glass = NBGlassPaneAccessSupport.getNBGlassPane(this);
        if (this.glass == null) {
            return;
        }
        if (this.editorComponent != null) {
            Rectangle rectangle = SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), this.glass);
            this.glass.add(this.editorComponent);
            rectangle.width = this.getMinimumSize().width * this.wMagFactor + 5;
            rectangle.height += 7;
            this.editorComponent.setBounds(rectangle);
        }
        this.addInfoLabel();
        this.glass.setVisible(true);
        if (this.editorComponent != null) {
            this.editorComponent.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent keyEvent) {
                    super.keyTyped(keyEvent);
                    if (keyEvent.getKeyChar() == '\u001b') {
                        InplaceEditableLabel.this.hideEditor();
                    }
                    if (keyEvent.getKeyChar() == '\n' && InplaceEditableLabel.this.validInput()) {
                        InplaceEditableLabel.this.hideEditor();
                    }
                }
            });
            this.editorComponent.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent focusEvent) {
                    if (InplaceEditableLabel.this.getParent() instanceof ABEBaseDropPanel) {
                        ABEBaseDropPanel aBEBaseDropPanel = (ABEBaseDropPanel)InplaceEditableLabel.this.getParent();
                        if (aBEBaseDropPanel.context.isUserInducedEventMode()) {
                            return;
                        }
                    }
                    InplaceEditableLabel.this.hideEditor();
                }

                public void focusGained(FocusEvent focusEvent) {
                }
            });
            this.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    try {
                        InplaceEditableLabel.this.hideEditor();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.getScrollPane().setWheelScrollingEnabled(false);
            this.editorComponent.requestFocusInWindow();
        }
    }

    public void hideEditor() {
        this.editMode = false;
        this.getScrollPane().setWheelScrollingEnabled(true);
        NBGlassPaneAccessSupport.disposeNBGlassPane();
        ((ABEBaseDropPanel)this.getParent()).context.getComponentSelectionManager().refreshFocus();
    }

    public void setInlineEditorComponent(JComponent jComponent) {
        this.editorComponent = jComponent;
    }

    public Dimension getMaximumSize() {
        return super.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return super.getMinimumSize();
    }

    public void setEditInfoText(String string, InstanceUIContext instanceUIContext) {
        this.editInfoString = string;
        this.context = instanceUIContext;
    }

    private void addInfoLabel() {
        if (this.editInfoString == null) {
            return;
        }
        JLabel jLabel = new JLabel(UIUtilities.getImageIcon("bulb.png"), 2);
        jLabel.setText(this.editInfoString);
        Container container = this.getParent();
        Rectangle rectangle = container.getBounds();
        rectangle = SwingUtilities.convertRectangle(container.getParent(), rectangle, this.glass);
        rectangle.y -= 20;
        Dimension dimension = jLabel.getPreferredSize();
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        this.glass.add(jLabel);
        jLabel.setBackground(new Color(255, 255, 220));
        jLabel.setOpaque(true);
        jLabel.setBounds(rectangle);
    }

    public void setWidthMagnificationFactor(int n) {
        this.wMagFactor = n;
    }

    public void setInputValidator(InputValidator inputValidator, String string) {
        this.inputValidator = inputValidator;
        this.errorMessage = string;
    }

    private boolean validInput() {
        if (this.editorComponent instanceof JTextField) {
            String string = ((JTextField)this.editorComponent).getText();
            if (this.inputValidator != null && string != null) {
                if (!this.inputValidator.isStringValid(string)) {
                    UIUtilities.showErrorMessageFor(this.errorMessage, ((ABEBaseDropPanel)this.getParent()).context, this.glass, this.editorComponent);
                    return false;
                }
                UIUtilities.hideGlassMessage(false);
            }
        }
        return true;
    }

    public void addCtrlClickHandler(CtrlClickHandler ctrlClickHandler) {
        this.ctrlClickHandler = ctrlClickHandler;
    }

    public static interface CtrlClickHandler {
        public void handleCtrlClick();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        EDIT,
        NORMAL;

    }
}

