/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AnyAttribute;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.axi.visitor.AXIVisitor;
import org.netbeans.modules.xml.schema.abe.ABEBaseDropPanel;
import org.netbeans.modules.xml.schema.abe.AnnotatedBorderPanel;
import org.netbeans.modules.xml.schema.abe.GlobalComplextypeContainerPanel;
import org.netbeans.modules.xml.schema.abe.GlobalElementsContainerPanel;
import org.netbeans.modules.xml.schema.abe.InstanceDesignConstants;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;
import org.netbeans.modules.xml.schema.abe.TweenerListener;
import org.netbeans.modules.xml.schema.abe.TweenerPanel;
import org.netbeans.modules.xml.schema.abe.UIUtilities;
import org.netbeans.modules.xml.schema.abe.palette.DnDHelper;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerPanel
extends AnnotatedBorderPanel
implements AXIVisitor {
    private static final long serialVersionUID = 7526472295622776147L;
    private AXIComponent axiParent;
    Component parentPanel;
    private static final int INTER_PANEL_VERTICAL_SPACE = 0;
    private int panelIndendation = InstanceDesignConstants.TAG_INDENT;
    private LinkedList<Component> childrenList = new LinkedList();
    protected Component visitorResult = null;
    boolean openByDefault = true;
    JPanel childrenPanel;
    SpringLayout childrenPanelLayout;
    Component childrenPanelLastComponent;
    boolean childrenAdded = false;
    ProgressHandle progressHandle = null;
    int stepCount = 0;

    public ContainerPanel(InstanceUIContext instanceUIContext, AXIComponent aXIComponent, Component component, boolean bl) {
        super(instanceUIContext);
        this.setAXIParent(aXIComponent);
        this.parentPanel = component;
        this.openByDefault = bl;
        this.initialize();
    }

    protected abstract void setupAXIComponentListener();

    public abstract List<? extends AXIComponent> getAXIChildren();

    private void initialize() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.addHeaderPanel();
        this.initChildrenPanel();
        if (this.openByDefault) {
            this.addAllChildren();
        }
        this.setupAXIComponentListener();
    }

    public void addHeaderPanel() {
    }

    public void initChildrenPanel() {
        this.childrenPanelLayout = new SpringLayout();
        this.childrenPanel = new JPanel(this.childrenPanelLayout);
        this.childrenPanel.setOpaque(false);
        this.add((Component)this.childrenPanel, "Center");
        TweenerPanel tweenerPanel = new TweenerPanel(0, this.context);
        this.childrenPanel.add(tweenerPanel);
        this.getChildrenList().add(tweenerPanel);
        this.addTweenerListener(tweenerPanel);
        this.childrenPanelLayout.putConstraint("West", (Component)tweenerPanel, this.getChildrenIndent(), "West", (Component)this.childrenPanel);
        this.childrenPanelLayout.putConstraint("North", (Component)tweenerPanel, this.getInterComponentVerticalSpacing(), "North", (Component)this.childrenPanel);
        this.adjustChildrenPanelSize();
        this.addComponentEventListener(tweenerPanel);
        this.childrenPanelLastComponent = tweenerPanel;
    }

    public void verifyChildrenWithModel() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : this.getChildrenList()) {
            if (component instanceof TweenerPanel) continue;
            arrayList.add(component);
        }
        if (arrayList.size() != this.getAXIChildren().size()) {
            this.removeAndAddAllChildren();
            return;
        }
        for (AXIComponent aXIComponent : this.getAXIChildren()) {
            if (this.isAlreadyAdded(aXIComponent) != null) continue;
            this.removeAndAddAllChildren();
            return;
        }
    }

    public void removeAndAddAllChildren() {
        this.remove(this.childrenPanel);
        this.childrenPanel = null;
        this.initChildrenPanel();
        this.addAllChildren();
    }

    public void addAllChildren() {
        if (this.childrenAdded) {
            return;
        }
        this.childrenAdded = true;
        final List<? extends AXIComponent> list = this.getAXIChildren();
        if (list.size() < 50) {
            this.addAllChildren(list);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ContainerPanel.this.addAllChildren(list);
                }
            });
        }
    }

    private void addAllChildren(List<? extends AXIComponent> list) {
        for (AXIComponent aXIComponent : list) {
            this.visitorResult = null;
            aXIComponent.accept((AXIVisitor)this);
            Component component = this.visitorResult;
            if (this.visitorResult == null) continue;
            this.appendChild(component, false);
            TweenerPanel tweenerPanel = new TweenerPanel(0, this.context);
            this.addTweenerListener(tweenerPanel);
            this.appendChild(tweenerPanel, false);
        }
        this.adjustChildrenPanelSize();
        this.revalidate();
    }

    private void initProgress(List<? extends AXIComponent> list) {
        int n = list.size();
        if (n < 50) {
            return;
        }
        UIUtilities.showBulbMessage(NbBundle.getMessage(ContainerPanel.class, (String)"MSG_RENDERING_CHILDREN") + "...", this.context);
        this.progressHandle = ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(ContainerPanel.class, (String)"MSG_RENDERING_CHILDREN") + ": "));
        this.progressHandle.setInitialDelay(1);
        this.progressHandle.start(n + 10);
        UIUtilities.setBusyCursor(this.context);
        this.stepCount = 0;
    }

    private void showProgress() {
        if (this.progressHandle != null) {
            this.progressHandle.progress(this.stepCount++);
        }
    }

    private void finishProgress() {
        if (this.progressHandle != null) {
            this.progressHandle.finish();
            this.progressHandle = null;
            UIUtilities.setDefaultCursor(this.context);
            UIUtilities.hideGlassMessage();
            this.stepCount = 0;
        }
    }

    public int getChildrenIndent() {
        return this.getPanelIndendation() + 10;
    }

    public void appendChild(Component component, boolean bl) {
        this.appendChild(component, 0, bl);
    }

    public void appendChild(Component component, int n, boolean bl) {
        this.childrenPanel.add(component);
        this.getChildrenList().add(component);
        this.childrenPanelLayout.putConstraint("West", component, this.getChildrenIndent(), "West", (Component)this.childrenPanel);
        this.childrenPanelLayout.putConstraint("North", component, this.getInterComponentVerticalSpacing() + n, "South", this.childrenPanelLastComponent);
        this.childrenPanelLastComponent = component;
        if (bl) {
            this.adjustChildrenPanelSize();
            this.revalidate();
        }
        this.addComponentEventListener(component);
    }

    public boolean addChildAt(Component component, int n) {
        this.childrenPanel.add(component);
        Component component2 = null;
        Component component3 = null;
        try {
            component2 = this.getAboveAdjacentComponent(n);
            component3 = this.getBelowAdjacentComponent(n);
        }
        catch (Exception exception) {
            this.removeAndAddAllChildren();
            return false;
        }
        if (component2 == null) {
            return false;
        }
        this.childrenPanelLayout.putConstraint("West", component, this.getChildrenIndent(), "West", (Component)this.childrenPanel);
        this.childrenPanelLayout.putConstraint("North", component, this.getInterComponentVerticalSpacing(), "South", component2);
        TweenerPanel tweenerPanel = new TweenerPanel(0, this.context);
        this.addTweenerListener(tweenerPanel);
        this.childrenPanel.add(tweenerPanel);
        this.childrenPanelLayout.putConstraint("West", (Component)tweenerPanel, this.getChildrenIndent(), "West", (Component)this.childrenPanel);
        this.childrenPanelLayout.putConstraint("North", (Component)tweenerPanel, this.getInterComponentVerticalSpacing(), "South", component);
        if (component3 != null) {
            this.childrenPanelLayout.putConstraint("North", component3, this.getInterComponentVerticalSpacing(), "South", (Component)tweenerPanel);
        }
        if (this.getChildrenList().getLast() == component2) {
            this.getChildrenList().add(component);
            this.getChildrenList().add(tweenerPanel);
        } else {
            this.getChildrenList().add(this.getChildrenList().indexOf(component2) + 1, component);
            this.getChildrenList().add(this.getChildrenList().indexOf(component) + 1, tweenerPanel);
        }
        this.adjustChildrenPanelSize();
        this.revalidate();
        this.addComponentEventListener(component);
        this.addComponentEventListener(tweenerPanel);
        return true;
    }

    public void removeComponent(Component component) {
        int n = this.getChildrenList().indexOf(component);
        int n2 = n + 1;
        int n3 = n - 1;
        Component component2 = this.getChildrenList().get(n2);
        Component component3 = this.getChildrenList().get(n3);
        Component component4 = null;
        if (this.getChildrenList().getLast() != component2) {
            component4 = this.getChildrenList().get(n2 + 1);
        }
        this.childrenPanelLayout.removeLayoutComponent(component);
        this.childrenPanelLayout.removeLayoutComponent(component2);
        this.childrenPanel.remove(component);
        this.childrenPanel.remove(component2);
        this.fireComponentRemoved();
        if (component4 != null) {
            this.childrenPanelLayout.putConstraint("North", component4, this.getInterComponentVerticalSpacing(), "South", component3);
        }
        this.getChildrenList().remove(component);
        this.getChildrenList().remove(component2);
        this.adjustChildrenPanelSize();
        this.revalidate();
        this.repaint();
    }

    private void addComponentEventListener(Component component) {
        component.addComponentListener(new ComponentListener(){
            int callCount = 1;

            public void componentHidden(ComponentEvent componentEvent) {
                ContainerPanel.this.adjustChildrenPanelSize();
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                if (this.callCount <= 2 && (ContainerPanel.this instanceof GlobalComplextypeContainerPanel || ContainerPanel.this instanceof GlobalElementsContainerPanel)) {
                    ++this.callCount;
                    return;
                }
                ContainerPanel.this.adjustChildrenPanelSize();
            }

            public void componentShown(ComponentEvent componentEvent) {
                ContainerPanel.this.adjustChildrenPanelSize();
            }
        });
    }

    public Component getAboveAdjacentComponent(int n) {
        return this.getChildrenList().get(n * 2);
    }

    public Component getBelowAdjacentComponent(int n) {
        int n2 = n * 2 + 1;
        if (n2 >= this.getChildrenList().size()) {
            return null;
        }
        return this.getChildrenList().get(n2);
    }

    public void adjustChildrenPanelSize() {
        int n = 0;
        int n2 = 0;
        int n3 = this.getChildrenIndent();
        int n4 = this.getInterComponentVerticalSpacing();
        for (Component component : this.childrenPanel.getComponents()) {
            if (!component.isVisible()) break;
            Dimension dimension = component.getPreferredSize();
            int n5 = dimension.width + n3;
            if (n5 > n) {
                n = n5;
            }
            n2 += dimension.height + n4;
        }
        Dimension dimension = new Dimension(n += 20, n2 + 3);
        Dimension dimension2 = this.childrenPanel.getPreferredSize();
        int n6 = 0;
        if (dimension2.height != dimension.height || dimension2.width != dimension.width) {
            this.childrenPanel.setPreferredSize(dimension);
            this.childrenPanel.setMinimumSize(dimension);
            n6 = 1;
        }
        Dimension dimension3 = this._getMinimumSize();
        dimension2 = this.getPreferredSize();
        boolean bl = false;
        if (dimension2.height != dimension3.height || dimension2.width != dimension3.width) {
            this.setMinimumSize(dimension3);
            this.setPreferredSize(dimension3);
            bl = true;
        }
        if (n6 != 0) {
            this.childrenPanel.revalidate();
        }
        if (bl) {
            this.revalidate();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension _getMinimumSize() {
        int n = 0;
        int n2 = 0;
        for (Component component : this.getComponents()) {
            if (!component.isVisible()) break;
            Dimension dimension = component.getPreferredSize();
            n2 = (int)((double)n2 + dimension.getHeight());
            int n3 = dimension.width;
            n = n < n3 ? n3 : n;
        }
        return new Dimension(n, n2);
    }

    public ABEBaseDropPanel isAlreadyAdded(AXIComponent aXIComponent) {
        for (Component component : this.getChildrenList()) {
            if (!(component instanceof ABEBaseDropPanel) || ((ABEBaseDropPanel)component).getAXIComponent() != aXIComponent) continue;
            return (ABEBaseDropPanel)component;
        }
        return null;
    }

    public boolean tweenerDragAccept(TweenerPanel tweenerPanel, DnDHelper.PaletteItem paletteItem) {
        return true;
    }

    public void tweenerDrop(TweenerPanel tweenerPanel, DnDHelper.PaletteItem paletteItem) {
    }

    public void tweenerDragExited(TweenerPanel tweenerPanel) {
    }

    public void tweenerDragEntered(TweenerPanel tweenerPanel, DnDHelper.PaletteItem paletteItem) {
    }

    protected void addTweenerListener(final TweenerPanel tweenerPanel) {
        tweenerPanel.addTweenerListener(new TweenerListener(){

            public boolean dragAccept(DnDHelper.PaletteItem paletteItem) {
                return ContainerPanel.this.tweenerDragAccept(tweenerPanel, paletteItem);
            }

            public void drop(DnDHelper.PaletteItem paletteItem) {
                ContainerPanel.this.tweenerDrop(tweenerPanel, paletteItem);
            }

            public void dragExited() {
                ContainerPanel.this.tweenerDragExited(tweenerPanel);
            }

            public void dragEntered(DnDHelper.PaletteItem paletteItem) {
                ContainerPanel.this.tweenerDragEntered(tweenerPanel, paletteItem);
            }
        });
    }

    public int getInterComponentVerticalSpacing() {
        return 0;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
    }

    public AXIComponent getAXIParent() {
        return this.axiParent;
    }

    public void setAXIParent(AXIComponent aXIComponent) {
        this.axiParent = aXIComponent;
    }

    public int getPanelIndendation() {
        return this.panelIndendation;
    }

    public void setPanelIndendation(int n) {
        this.panelIndendation = n;
    }

    public LinkedList<Component> getChildrenList() {
        return this.childrenList;
    }

    public void setChildrenList(LinkedList<Component> linkedList) {
        this.childrenList = linkedList;
    }

    public void visit(AnyAttribute anyAttribute) {
    }

    public void visit(Element element) {
    }

    public void visit(ContentModel contentModel) {
    }

    public void visit(Datatype datatype) {
    }

    public void visit(AnyElement anyElement) {
    }

    public void visit(AXIDocument aXIDocument) {
    }

    public void visit(Attribute attribute) {
    }

    public void visit(Compositor compositor) {
    }

    @Override
    public AXIComponent getAXIComponent() {
        return this.getAXIParent();
    }

    @Override
    public ABEBaseDropPanel getChildUIComponentFor(AXIComponent aXIComponent) {
        this.addAllChildren();
        this.setVisible(true);
        for (Component component : this.getChildrenList()) {
            ABEBaseDropPanel aBEBaseDropPanel;
            if (!(component instanceof ABEBaseDropPanel) || (aBEBaseDropPanel = ((ABEBaseDropPanel)component).getUIComponentFor(aXIComponent)) == null) continue;
            return aBEBaseDropPanel;
        }
        return null;
    }

    public ABEBaseDropPanel getParentContainerPanel() {
        return (ABEBaseDropPanel)this.parentPanel;
    }
}

