/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyActionProvider
implements ActionProvider {
    public static final String BUILD_SCRIPT = "buildfile";
    public static final String PROP_CONFIG = "config";
    private static final String[] supportedActions = new String[]{"run.single", "debug.single"};
    private static final String[] platformSensitiveActions = new String[]{"run.single", "debug.single"};
    Map<String, String[]> commands;
    private final Project project;
    final Set<String> bkgScanSensitiveActions;

    public GroovyActionProvider(Project project) {
        this.project = project;
        this.commands = new HashMap<String, String[]>();
        this.commands.put("run.single", new String[]{"run-single"});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("run.single", "debug.single"));
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(final String string, final Lookup lookup) throws IllegalArgumentException {
        Runnable runnable = new Runnable(){

            public void run() {
                Properties properties = new Properties();
                String[] stringArray = GroovyActionProvider.this.getTargetNames(string, lookup, properties);
                if (stringArray == null) {
                    return;
                }
                if (stringArray.length == 0) {
                    stringArray = null;
                }
                if (properties.keySet().size() == 0) {
                    properties = null;
                }
                try {
                    FileObject fileObject = GroovyActionProvider.this.findBuildXml();
                    if (fileObject == null || !fileObject.isValid()) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(GroovyActionProvider.class, (String)"LBL_No_Build_XML_Found"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    } else {
                        ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray, (Properties)properties);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        };
        if (this.bkgScanSensitiveActions.contains(string)) {
            ScanDialog.runWhenScanFinished((Runnable)runnable, (String)NbBundle.getMessage(GroovyActionProvider.class, (String)("ACTION_" + string)));
        } else {
            runnable.run();
        }
    }

    public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
        if (string.equals("run.single")) {
            FileObject[] fileObjectArray = this.findSources(lookup);
            return fileObjectArray != null && fileObjectArray.length == 1;
        }
        return false;
    }

    private String[] getTargetNames(String string, Lookup lookup, Properties properties) throws IllegalArgumentException {
        HashMap<String, String[]> hashMap = this.loadTargetsFromConfig();
        String[] stringArray = new String[]{};
        if (string.equals("run.single") || string.equals("debug.single")) {
            FileObject[] fileObjectArray = this.findTestSources(lookup, false);
            if (fileObjectArray != null) {
                stringArray = string.equals("run.single") ? this.setupTestSingle(properties, fileObjectArray) : this.setupDebugTestSingle(properties, fileObjectArray);
            } else {
                FileObject fileObject = this.findSources(lookup)[0];
                Sources sources = ProjectUtils.getSources((Project)this.project);
                SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
                String string2 = FileUtil.getRelativePath((FileObject)this.getRoot(sourceGroupArray, fileObject), (FileObject)fileObject);
                properties.setProperty("javac.includes", string2);
                if (string2.endsWith(".groovy")) {
                    string2 = string2.substring(0, string2.length() - 7);
                }
                string2 = string2.replace('/', '.');
                if (string.equals("run.single")) {
                    properties.setProperty("run.class", string2);
                    String[] stringArray2 = (String[])hashMap.get(string);
                    stringArray = stringArray2 != null ? stringArray2 : this.commands.get("run.single");
                } else {
                    properties.setProperty("debug.class", string2);
                    String[] stringArray3 = (String[])hashMap.get(string);
                    stringArray = stringArray3 != null ? stringArray3 : this.commands.get("debug.single");
                }
            }
        }
        return stringArray;
    }

    private FileObject getRoot(SourceGroup[] sourceGroupArray, FileObject fileObject) {
        assert (fileObject != null) : "File can't be null";
        FileObject fileObject2 = null;
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            FileObject fileObject3 = sourceGroupArray[i].getRootFolder();
            assert (fileObject3 != null) : "Source Path Root can't be null";
            if (!FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject) && !fileObject3.equals(fileObject)) continue;
            fileObject2 = fileObject3;
            break;
        }
        return fileObject2;
    }

    private FileObject getRoot(FileObject[] fileObjectArray, FileObject fileObject) {
        assert (fileObject != null) : "File can't be null";
        FileObject fileObject2 = null;
        for (FileObject fileObject3 : fileObjectArray) {
            assert (fileObject3 != null) : "Source Path Root can't be null";
            if (!FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject) && !fileObject3.equals(fileObject)) continue;
            fileObject2 = fileObject3;
            break;
        }
        return fileObject2;
    }

    private FileObject[] findSources(Lookup lookup) {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            FileObject[] fileObjectArray = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)sourceGroupArray[i].getRootFolder(), (String)".groovy", (boolean)true);
            if (fileObjectArray == null) continue;
            return fileObjectArray;
        }
        return null;
    }

    private FileObject[] findTestSources(Lookup lookup, boolean bl) {
        FileObject[] fileObjectArray = GroovyActionProvider.getTestSourceRoots(this.project);
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject[] fileObjectArray2 = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObjectArray[i], (String)".groovy", (boolean)true);
            if (fileObjectArray2 == null) continue;
            return fileObjectArray2;
        }
        return null;
    }

    private FileObject findBuildXml() {
        return GroovyActionProvider.getBuildXml(this.project);
    }

    public static String getBuildXmlName(Project project) {
        assert (project != null);
        String string = GroovyActionProvider.evaluateProperty(project, BUILD_SCRIPT);
        if (string == null) {
            string = "build.xml";
        }
        return string;
    }

    public static FileObject getBuildXml(Project project) {
        return project.getProjectDirectory().getFileObject(GroovyActionProvider.getBuildXmlName(project));
    }

    private static FileObject[] getTestSourceRoots(Project project) {
        List<String> list = GroovyActionProvider.getTestRootsNames(project);
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (String string : list) {
            arrayList.add(project.getProjectDirectory().getFileObject(string));
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    private static List<String> getTestRootsNames(Project project) {
        File file = FileUtil.toFile((FileObject)project.getProjectDirectory().getFileObject("nbproject/project.properties"));
        Map map = PropertyUtils.propertiesFilePropertyProvider((File)file).getProperties();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : map.keySet()) {
            if (!string.startsWith("test.") || !string.endsWith(".dir")) continue;
            arrayList.add((String)map.get(string));
        }
        return arrayList;
    }

    private static String evaluateProperty(Project project, String string) {
        File file = FileUtil.toFile((FileObject)project.getProjectDirectory().getFileObject("nbproject/project.properties"));
        Map map = PropertyUtils.propertiesFilePropertyProvider((File)file).getProperties();
        return (String)map.get(string);
    }

    private String[] setupTestSingle(Properties properties, FileObject[] fileObjectArray) {
        FileObject[] fileObjectArray2 = GroovyActionProvider.getTestSourceRoots(this.project);
        FileObject fileObject = this.getRoot(fileObjectArray2, fileObjectArray[0]);
        properties.setProperty("test.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray, (FileObject)fileObject));
        properties.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray, (FileObject)fileObject));
        return new String[]{"test-single"};
    }

    private String[] setupDebugTestSingle(Properties properties, FileObject[] fileObjectArray) {
        FileObject[] fileObjectArray2 = GroovyActionProvider.getTestSourceRoots(this.project);
        FileObject fileObject = this.getRoot(fileObjectArray2, fileObjectArray[0]);
        String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObjectArray[0]);
        properties.setProperty("test.class", string.substring(0, string.length() - 5).replace('/', '.'));
        properties.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray, (FileObject)fileObject));
        return new String[]{"debug-test"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String[]> loadTargetsFromConfig() {
        Object object;
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>(6);
        String string = GroovyActionProvider.evaluateProperty(this.project, PROP_CONFIG);
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/configs/" + string + ".properties");
        if (fileObject == null) {
            return hashMap;
        }
        Properties properties = new Properties();
        try {
            object = fileObject.getInputStream();
            try {
                properties.load((InputStream)object);
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return hashMap;
        }
        object = properties.propertyNames();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            if (!string2.startsWith("$target.")) continue;
            String string3 = properties.getProperty(string2);
            String string4 = null;
            if (string3 == null || string3.equals("")) continue;
            string4 = string2.substring("$target.".length());
            StringTokenizer stringTokenizer = new StringTokenizer(string3.trim(), " ");
            ArrayList<String> arrayList = new ArrayList<String>(3);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            hashMap.put(string4, arrayList.toArray(new String[arrayList.size()]));
        }
        return hashMap;
    }

    private static final class MainClassChooser {
        private static Boolean unitTestingSupport_hasMainMethodResult;

        private MainClassChooser() {
        }
    }
}

