/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.compapp.projects.wizard.ProgressController;
import org.netbeans.modules.compapp.projects.wizard.ProgressDescriptor;
import org.netbeans.modules.compapp.projects.wizard.ProgressPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public final class ProgressDialogFactory {
    static final String CANCEL_OPTION = NbBundle.getMessage((Class)ProgressDialogFactory.class, (String)"ProgressDialogFactory.dialog_cancel_text");
    static final String FINISH_OPTION = "finish";
    static final String UPDATE_OPTION = "update";
    static final String CANCEL_LOCKOUT_OPTION = "lockout";

    private ProgressDialogFactory() {
    }

    public static ProgressDescriptor createProgressDialog(String string, boolean bl) {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        ProgressPanel progressPanel = new ProgressPanel(jComponent);
        JButton jButton = new JButton(CANCEL_OPTION);
        ((Component)jButton).setEnabled(bl);
        ProgressDialogCancellationListener progressDialogCancellationListener = new ProgressDialogCancellationListener(progressPanel, jButton);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)progressPanel, ProgressDialogFactory.makeDialogTitle(string), true, new Object[]{jButton}, (Object)jButton, 0, null, (ActionListener)progressDialogCancellationListener, false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        ProgressDescriptorImpl progressDescriptorImpl = new ProgressDescriptorImpl(dialog, progressHandle);
        if (progressDialogCancellationListener != null) {
            progressDialogCancellationListener.setController(progressDescriptorImpl.getController());
            dialog.addPropertyChangeListener(progressDialogCancellationListener);
        }
        dialog.pack();
        dialog.setResizable(false);
        return progressDescriptorImpl;
    }

    private static String makeDialogTitle(String string) {
        String string2 = NbBundle.getMessage((Class)ProgressDialogFactory.class, (String)"ProgressDialogFactory.dialog_title_prefix");
        return (string2 != null ? string2 : "").concat(string);
    }

    static class ProgressDialogCancellationListener
    implements ActionListener,
    PropertyChangeListener {
        private final Component component;
        private final ProgressPanel panel;
        private ProgressController controller;

        public ProgressDialogCancellationListener(ProgressPanel progressPanel, Component component) {
            if (component == null) {
                throw new NullPointerException("component");
            }
            if (progressPanel == null) {
                throw new NullPointerException("panel");
            }
            this.component = component;
            this.panel = progressPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getID() == 1001 && this.component.equals(actionEvent.getSource())) {
                this.component.setEnabled(false);
                this.controller.setCanceled();
                this.panel.getMessageComponent().setText(NbBundle.getMessage(this.getClass(), (String)"ProgressDialogFactory.progress_msg_canceled"));
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (ProgressDialogFactory.FINISH_OPTION.equals(string)) {
                this.component.setEnabled(false);
                this.panel.getMessageComponent().setText(NbBundle.getMessage(this.getClass(), (String)"ProgressDialogFactory.progress_msg_done"));
            } else if (CANCEL_OPTION.equals(string)) {
                this.component.setEnabled(false);
                this.panel.getMessageComponent().setText(NbBundle.getMessage(this.getClass(), (String)"ProgressDialogFactory.progress_msg_canceled"));
            } else if (ProgressDialogFactory.UPDATE_OPTION.equals(string)) {
                JLabel jLabel = this.panel.getMessageComponent();
                jLabel.setText(String.valueOf(propertyChangeEvent.getNewValue()));
            } else if (ProgressDialogFactory.CANCEL_LOCKOUT_OPTION.equals(string)) {
                this.component.setEnabled(false);
            }
        }

        public void setController(ProgressController progressController) {
            this.controller = progressController;
        }
    }

    static class ProgressDescriptorImpl
    implements ProgressDescriptor {
        private final Dialog dialog;
        private final ProgressController controller;

        public ProgressDescriptorImpl(Dialog dialog, ProgressHandle progressHandle) {
            if (dialog == null) {
                throw new NullPointerException("dialog");
            }
            if (progressHandle == null) {
                throw new NullPointerException("progress");
            }
            this.dialog = dialog;
            this.controller = new ProgressController(progressHandle, dialog);
        }

        public Component getGUIComponent() {
            return this.dialog;
        }

        public ProgressController getController() {
            return this.controller;
        }
    }
}

