/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.customization.model.DefinitionsCustomization;
import org.netbeans.modules.websvc.customization.model.EnableAsyncMapping;
import org.netbeans.modules.websvc.customization.model.EnableWrapperStyle;
import org.netbeans.modules.websvc.customization.model.JavaMethod;
import org.netbeans.modules.websvc.customization.model.PortTypeCustomization;
import org.netbeans.modules.websvc.customization.model.PortTypeOperationCustomization;
import org.netbeans.modules.websvc.customization.multiview.DefinitionsPanel;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class PortTypeOperationPanel
extends SaveableSectionInnerPanel {
    private Operation operation;
    private WSDLModel model;
    private boolean wsdlDirty;
    private DefaultItemListener dil;
    private ModelChangeListener modelListener;
    private ModelChangeListener primaryModelListener;
    private Definitions primaryDefinitions;
    private WSDLModel primaryModel;
    private JCheckBox defaultMethodCB;
    private ButtonGroup eamButtonGroup;
    private JCheckBox enableAsyncMappingCB;
    private JCheckBox enableWrapperStyleCB;
    private ButtonGroup ewsButtonGroup;
    private JLabel jLabel4;
    private JTextField javaMethodName;
    private JLabel portTypeLabel;
    private JLabel portTypeName;

    public PortTypeOperationPanel(SectionView sectionView, Operation operation, Node node, Definitions definitions) {
        super(sectionView);
        this.operation = operation;
        this.primaryDefinitions = definitions;
        this.model = this.operation.getModel();
        this.primaryModel = this.primaryDefinitions.getModel();
        this.initComponents();
        this.disableEnterKey();
        if (!this.isClient(node)) {
            this.enableAsyncMappingCB.setVisible(false);
        }
        this.enableAsyncMappingCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_ASYNC"));
        this.enableWrapperStyleCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_WRAPPER"));
        this.syncButtons();
        this.syncJavaMethod();
        this.dil = new DefaultItemListener();
        ItemListener itemListener = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.dil, (Object)this.defaultMethodCB);
        this.defaultMethodCB.addItemListener(itemListener);
        this.modelListener = new ModelChangeListener();
        PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this.modelListener, (Object)this.model);
        this.model.addPropertyChangeListener(propertyChangeListener);
        if (this.model != this.primaryModel) {
            this.primaryModelListener = new ModelChangeListener();
            PropertyChangeListener propertyChangeListener2 = WeakListeners.propertyChange((PropertyChangeListener)this.primaryModelListener, (Object)this.primaryModel);
            this.primaryModel.addPropertyChangeListener(propertyChangeListener2);
        }
        this.addModifier(this.javaMethodName);
        this.addModifier(this.defaultMethodCB);
        this.addModifier(this.enableAsyncMappingCB);
        this.addModifier(this.enableWrapperStyleCB);
        this.addValidatee(this.javaMethodName);
    }

    private String getParentOfOperation(Operation operation) {
        PortType portType = (PortType)operation.getParent();
        return portType.getName();
    }

    private void syncJavaMethod() {
        List list = this.operation.getExtensibilityElements(PortTypeOperationCustomization.class);
        if (list.size() == 1) {
            PortTypeOperationCustomization portTypeOperationCustomization = (PortTypeOperationCustomization)list.get(0);
            JavaMethod javaMethod = portTypeOperationCustomization.getJavaMethod();
            if (javaMethod != null) {
                this.setJavaMethod(javaMethod.getName());
            } else {
                this.defaultMethodCB.setSelected(true);
                this.javaMethodName.setEnabled(false);
            }
        } else {
            this.defaultMethodCB.setSelected(true);
            this.javaMethodName.setEnabled(false);
        }
    }

    public final void syncButtons() {
        List list = this.operation.getExtensibilityElements(PortTypeOperationCustomization.class);
        if (list.size() == 1) {
            PortTypeOperationCustomization portTypeOperationCustomization = (PortTypeOperationCustomization)list.get(0);
            EnableAsyncMapping enableAsyncMapping = portTypeOperationCustomization.getEnableAsyncMapping();
            if (enableAsyncMapping != null) {
                this.setEnableAsyncMapping(enableAsyncMapping.isEnabled());
            } else {
                this.setEnableAsyncMapping(this.getAsyncMappingOfParent());
            }
            EnableWrapperStyle enableWrapperStyle = portTypeOperationCustomization.getEnableWrapperStyle();
            if (enableWrapperStyle != null) {
                this.setEnableWrapperStyle(enableWrapperStyle.isEnabled());
            } else {
                this.setEnableWrapperStyle(this.getWrapperStyleOfParent());
            }
        } else {
            this.setEnableAsyncMapping(this.getAsyncMappingOfParent());
            this.setEnableWrapperStyle(this.getWrapperStyleOfParent());
            this.defaultMethodCB.setSelected(true);
            this.javaMethodName.setEnabled(false);
        }
    }

    private boolean getAsyncMappingOfParent() {
        PortTypeCustomization portTypeCustomization;
        EnableAsyncMapping enableAsyncMapping;
        boolean bl = false;
        PortType portType = (PortType)this.operation.getParent();
        List list = portType.getExtensibilityElements(PortTypeCustomization.class);
        bl = list.size() > 0 ? ((enableAsyncMapping = (portTypeCustomization = (PortTypeCustomization)list.get(0)).getEnableAsyncMapping()) != null ? enableAsyncMapping.isEnabled() : this.getAsyncMappingFromDefinitions(this.primaryDefinitions)) : this.getAsyncMappingFromDefinitions(this.primaryDefinitions);
        return bl;
    }

    private boolean getAsyncMappingFromDefinitions(Definitions definitions) {
        DefinitionsCustomization definitionsCustomization;
        EnableAsyncMapping enableAsyncMapping;
        List list = definitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (list.size() > 0 && (enableAsyncMapping = (definitionsCustomization = (DefinitionsCustomization)list.get(0)).getEnableAsyncMapping()) != null) {
            return enableAsyncMapping.isEnabled();
        }
        return false;
    }

    private boolean getWrapperStyleFromDefinitions(Definitions definitions) {
        DefinitionsCustomization definitionsCustomization;
        EnableWrapperStyle enableWrapperStyle;
        List list = definitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (list.size() > 0 && (enableWrapperStyle = (definitionsCustomization = (DefinitionsCustomization)list.get(0)).getEnableWrapperStyle()) != null) {
            return enableWrapperStyle.isEnabled();
        }
        return true;
    }

    private boolean getWrapperStyleOfParent() {
        PortTypeCustomization portTypeCustomization;
        EnableWrapperStyle enableWrapperStyle;
        boolean bl = true;
        PortType portType = (PortType)this.operation.getParent();
        List list = portType.getExtensibilityElements(PortTypeCustomization.class);
        bl = list.size() > 0 ? ((enableWrapperStyle = (portTypeCustomization = (PortTypeCustomization)list.get(0)).getEnableWrapperStyle()) != null ? enableWrapperStyle.isEnabled() : this.getWrapperStyleFromDefinitions(this.primaryDefinitions)) : this.getWrapperStyleFromDefinitions(this.primaryDefinitions);
        return bl;
    }

    public void setEnableAsyncMapping(boolean bl) {
        this.enableAsyncMappingCB.setSelected(bl);
    }

    public boolean getEnableAsyncMapping() {
        return this.enableAsyncMappingCB.isSelected();
    }

    public void setEnableWrapperStyle(boolean bl) {
        this.enableWrapperStyleCB.setSelected(bl);
    }

    public boolean getEnableWrapperStyle() {
        return this.enableWrapperStyleCB.isSelected();
    }

    public void setJavaMethod(String string) {
        this.javaMethodName.setText(string);
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(JComponent jComponent, Object object) {
        List list = this.operation.getExtensibilityElements(PortTypeOperationCustomization.class);
        CustomizationComponentFactory customizationComponentFactory = CustomizationComponentFactory.getDefault();
        if (jComponent == this.javaMethodName || jComponent == this.defaultMethodCB) {
            String string = this.javaMethodName.getText();
            if (string != null && !string.trim().equals("") && !this.defaultMethodCB.isSelected()) {
                if (!JaxWsUtils.isJavaIdentifier((String)string)) {
                    return;
                }
                if (list.size() > 0) {
                    PortTypeOperationCustomization portTypeOperationCustomization = (PortTypeOperationCustomization)list.get(0);
                    JavaMethod javaMethod = portTypeOperationCustomization.getJavaMethod();
                    if (javaMethod == null) {
                        try {
                            javaMethod = customizationComponentFactory.createJavaMethod(this.model);
                            this.model.startTransaction();
                            javaMethod.setName(string);
                            portTypeOperationCustomization.setJavaMethod(javaMethod);
                            this.wsdlDirty = true;
                            return;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    } else {
                        try {
                            this.model.startTransaction();
                            javaMethod.setName(string);
                            this.wsdlDirty = true;
                            return;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                } else {
                    PortTypeOperationCustomization portTypeOperationCustomization = customizationComponentFactory.createPortTypeOperationCustomization(this.model);
                    JavaMethod javaMethod = customizationComponentFactory.createJavaMethod(this.model);
                    try {
                        this.model.startTransaction();
                        javaMethod.setName(string);
                        portTypeOperationCustomization.setJavaMethod(javaMethod);
                        this.operation.addExtensibilityElement((ExtensibilityElement)portTypeOperationCustomization);
                        this.wsdlDirty = true;
                        return;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                if (list.size() != 1) return;
                try {
                    PortTypeOperationCustomization portTypeOperationCustomization = (PortTypeOperationCustomization)list.get(0);
                    JavaMethod javaMethod = portTypeOperationCustomization.getJavaMethod();
                    if (javaMethod == null) return;
                    this.model.startTransaction();
                    portTypeOperationCustomization.removeJavaMethod(javaMethod);
                    if (portTypeOperationCustomization.getChildren().size() == 0) {
                        this.operation.removeExtensibilityElement((ExtensibilityElement)portTypeOperationCustomization);
                    }
                    this.wsdlDirty = true;
                    return;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
        if (jComponent == this.enableWrapperStyleCB) {
            if (list.size() > 0) {
                PortTypeOperationCustomization portTypeOperationCustomization = (PortTypeOperationCustomization)list.get(0);
                EnableWrapperStyle enableWrapperStyle = portTypeOperationCustomization.getEnableWrapperStyle();
                if (enableWrapperStyle == null) {
                    try {
                        this.model.startTransaction();
                        enableWrapperStyle = customizationComponentFactory.createEnableWrapperStyle(this.model);
                        enableWrapperStyle.setEnabled(this.getEnableWrapperStyle());
                        portTypeOperationCustomization.setEnableWrapperStyle(enableWrapperStyle);
                        this.wsdlDirty = true;
                        return;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                } else {
                    try {
                        this.model.startTransaction();
                        enableWrapperStyle.setEnabled(this.getEnableWrapperStyle());
                        this.wsdlDirty = true;
                        return;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                PortTypeOperationCustomization portTypeOperationCustomization = customizationComponentFactory.createPortTypeOperationCustomization(this.model);
                EnableWrapperStyle enableWrapperStyle = customizationComponentFactory.createEnableWrapperStyle(this.model);
                try {
                    this.model.startTransaction();
                    enableWrapperStyle.setEnabled(this.getEnableWrapperStyle());
                    portTypeOperationCustomization.setEnableWrapperStyle(enableWrapperStyle);
                    this.operation.addExtensibilityElement((ExtensibilityElement)portTypeOperationCustomization);
                    this.wsdlDirty = true;
                    return;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
        if (jComponent != this.enableAsyncMappingCB) return;
        if (list.size() > 0) {
            PortTypeOperationCustomization portTypeOperationCustomization = (PortTypeOperationCustomization)list.get(0);
            EnableAsyncMapping enableAsyncMapping = portTypeOperationCustomization.getEnableAsyncMapping();
            if (enableAsyncMapping == null) {
                try {
                    this.model.startTransaction();
                    enableAsyncMapping = customizationComponentFactory.createEnableAsyncMapping(this.model);
                    enableAsyncMapping.setEnabled(this.getEnableAsyncMapping());
                    portTypeOperationCustomization.setEnableAsyncMapping(enableAsyncMapping);
                    this.wsdlDirty = true;
                    return;
                }
                finally {
                    this.model.endTransaction();
                }
            } else {
                try {
                    this.model.startTransaction();
                    enableAsyncMapping.setEnabled(this.getEnableAsyncMapping());
                    this.wsdlDirty = true;
                    return;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
        PortTypeOperationCustomization portTypeOperationCustomization = customizationComponentFactory.createPortTypeOperationCustomization(this.model);
        EnableAsyncMapping enableAsyncMapping = customizationComponentFactory.createEnableAsyncMapping(this.model);
        try {
            this.model.startTransaction();
            enableAsyncMapping.setEnabled(this.getEnableAsyncMapping());
            portTypeOperationCustomization.setEnableAsyncMapping(enableAsyncMapping);
            this.operation.addExtensibilityElement((ExtensibilityElement)portTypeOperationCustomization);
            this.wsdlDirty = true;
            return;
        }
        finally {
            this.model.endTransaction();
        }
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        if (jTextComponent == this.javaMethodName && !JaxWsUtils.isJavaIdentifier((String)string)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, string, (JComponent)jTextComponent));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    public void rollbackValue(JTextComponent jTextComponent) {
        if (jTextComponent == this.javaMethodName) {
            PortTypeOperationCustomization portTypeOperationCustomization;
            JavaMethod javaMethod;
            String string = "";
            List list = this.operation.getExtensibilityElements(PortTypeOperationCustomization.class);
            if (list.size() == 1 && (javaMethod = (portTypeOperationCustomization = (PortTypeOperationCustomization)list.get(0)).getJavaMethod()) != null) {
                string = javaMethod.getName();
            }
            this.javaMethodName.setText(string);
        }
    }

    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.ewsButtonGroup = new ButtonGroup();
        this.eamButtonGroup = new ButtonGroup();
        this.jLabel4 = new JLabel();
        this.javaMethodName = new JTextField();
        this.defaultMethodCB = new JCheckBox();
        this.enableWrapperStyleCB = new JCheckBox();
        this.enableAsyncMappingCB = new JCheckBox();
        this.portTypeLabel = new JLabel();
        this.portTypeName = new JLabel();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.jLabel4.setText(resourceBundle.getString("LBL_JAVA_METHOD_NAME"));
        this.javaMethodName.setToolTipText(resourceBundle.getString("TOOLTIP_PORTTYPE_METHOD"));
        this.javaMethodName.setDisabledTextColor(new Color(0, 0, 0));
        this.defaultMethodCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultMethodCB.setText(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.defaultMethodCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultMethodCB.setContentAreaFilled(false);
        this.defaultMethodCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableWrapperStyleCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_WRAPPER_STYLE").charAt(0));
        this.enableWrapperStyleCB.setText(resourceBundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableWrapperStyleCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableWrapperStyleCB.setContentAreaFilled(false);
        this.enableWrapperStyleCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableAsyncMappingCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_ASYNC_CLIENT").charAt(0));
        this.enableAsyncMappingCB.setText(resourceBundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableAsyncMappingCB.setContentAreaFilled(false);
        this.enableAsyncMappingCB.setMargin(new Insets(0, 0, 0, 0));
        this.portTypeLabel.setText(resourceBundle.getString("LBL_ENCLOSING_PORTTYPE"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(22, 22, 22).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.enableAsyncMappingCB).add((Component)this.enableWrapperStyleCB).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.portTypeLabel).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.javaMethodName, -2, 132, -2).add(14, 14, 14).add((Component)this.defaultMethodCB)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.portTypeName).add(106, 106, 106))))).addContainerGap(103, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(9, 9, 9).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.portTypeLabel).add((Component)this.portTypeName)).add(15, 15, 15).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.javaMethodName, -2, 15, -2).add((Component)this.defaultMethodCB)).add(15, 15, 15).add((Component)this.enableWrapperStyleCB).add(12, 12, 12).add((Component)this.enableAsyncMappingCB).addContainerGap(24, Short.MAX_VALUE)));
        this.jLabel4.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_JAVA_METHOD_NAME"));
        this.javaMethodName.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_JAVA_METHOD_NAME"));
        this.javaMethodName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_JAVA_METHOD_NAME"));
        this.defaultMethodCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.defaultMethodCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.enableWrapperStyleCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableWrapperStyleCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableAsyncMappingCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.portTypeLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_ENCLOSING_PORTTYPE"));
    }

    class ModelChangeListener
    implements PropertyChangeListener {
        ModelChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EnableAsyncMapping enableAsyncMapping;
            WSDLComponent wSDLComponent;
            Object object = propertyChangeEvent.getSource();
            if (object instanceof EnableWrapperStyle) {
                EnableWrapperStyle enableWrapperStyle = (EnableWrapperStyle)object;
                WSDLComponent wSDLComponent2 = (WSDLComponent)enableWrapperStyle.getParent();
                if (wSDLComponent2 instanceof DefinitionsCustomization || wSDLComponent2 instanceof PortTypeCustomization) {
                    PortTypeOperationPanel.this.syncButtons();
                }
            } else if (object instanceof EnableAsyncMapping && ((wSDLComponent = (WSDLComponent)(enableAsyncMapping = (EnableAsyncMapping)object).getParent()) instanceof DefinitionsCustomization || wSDLComponent instanceof PortTypeCustomization)) {
                PortTypeOperationPanel.this.syncButtons();
            }
        }
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (PortTypeOperationPanel.this.defaultMethodCB.isSelected()) {
                PortTypeOperationPanel.this.javaMethodName.setEnabled(false);
            } else {
                PortTypeOperationPanel.this.javaMethodName.setEnabled(true);
                PortTypeOperationPanel.this.javaMethodName.requestFocus();
            }
        }
    }
}

