/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Binding;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.customization.multiview.ExternalBindingTablePanel;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public class ExternalBindingPanel
extends SaveableSectionInnerPanel {
    private ExternalBindingTablePanel panel;
    private Node node;
    private JaxWsModel jmodel;
    private boolean jaxwsIsDirty;

    public ExternalBindingPanel(SectionView sectionView, Node node, JaxWsModel jaxWsModel) {
        super(sectionView);
        this.node = node;
        this.jmodel = jaxWsModel;
        ExternalBindingTablePanel.EBTableModel eBTableModel = new ExternalBindingTablePanel.EBTableModel();
        this.panel = new ExternalBindingTablePanel(eBTableModel, node, jaxWsModel);
        this.panel.populateModel();
        this.initComponents2();
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public void setValue(JComponent jComponent, Object object) {
    }

    private void initComponents2() {
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)((Object)this.panel), -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)((Object)this.panel), -2, -1, -2).addContainerGap(19, Short.MAX_VALUE)));
    }

    public boolean wsdlIsDirty() {
        return false;
    }

    public boolean jaxwsIsDirty() {
        return this.jaxwsIsDirty;
    }

    public void save() {
        String string;
        JAXWSClientSupport jAXWSClientSupport;
        FileObject fileObject = (FileObject)this.node.getLookup().lookup(FileObject.class);
        FileObject fileObject2 = null;
        if (this.isClient()) {
            jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)fileObject);
            fileObject2 = jAXWSClientSupport.getBindingsFolderForClient(this.node.getName(), true);
        } else {
            jAXWSClientSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
            fileObject2 = jAXWSClientSupport.getBindingsFolderForService(this.node.getName(), true);
        }
        assert (fileObject != null) : "Cannot find srcRoot";
        jAXWSClientSupport = (Client)this.node.getLookup().lookup(Client.class);
        Service service = (Service)this.node.getLookup().lookup(Service.class);
        Map<String, FileObject> map = this.panel.getAddedBindings();
        Set<String> set = this.panel.getRemovedBindings();
        if (map.size() > 0 || set.size() > 0) {
            this.jaxwsIsDirty = true;
        }
        for (Map.Entry<String, FileObject> object : map.entrySet()) {
            String string2;
            string = object.getKey();
            FileObject fileObject3 = object.getValue();
            if (fileObject3 != null) {
                string2 = string;
                String string3 = fileObject3.getExt();
                if (!string3.equals("")) {
                    int n = string2.indexOf(string3);
                    string2 = string2.substring(0, n - 1);
                }
                try {
                    SaveCookie saveCookie;
                    FileObject iOException = FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject2, (String)string2, (String)fileObject3.getExt());
                    DataObject dataObject = DataObject.find((FileObject)iOException);
                    String string4 = this.panel.getRelativePathToWsdl();
                    boolean bl = JaxWsUtils.addRelativeWsdlLocation((FileObject)iOException, (String)string4);
                    if (bl && dataObject != null && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
                        saveCookie.save();
                    }
                    if (dataObject != null) {
                        saveCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                        saveCookie.open();
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            if (jAXWSClientSupport != null) {
                string2 = jAXWSClientSupport.newBinding();
                string2.setFileName(string);
                jAXWSClientSupport.addBinding((Binding)string2);
                continue;
            }
            if (service == null) continue;
            string2 = service.newBinding();
            string2.setFileName(string);
            service.addBinding((Binding)string2);
        }
        for (String string5 : set) {
            if (jAXWSClientSupport != null) {
                string = jAXWSClientSupport.getBindingByFileName(string5);
                if (string == null) continue;
                jAXWSClientSupport.removeBinding((Binding)string);
                continue;
            }
            if (service == null || (string = service.getBindingByFileName(string5)) == null) continue;
            service.removeBinding((Binding)string);
        }
    }

    private boolean isClient() {
        Client client = (Client)this.node.getLookup().lookup(Client.class);
        return client != null;
    }

    private void initComponents() {
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
    }
}

