/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.diff.DiffActionTooltipWindow;
import org.netbeans.modules.versioning.diff.DiffFileEncodingQueryImpl;
import org.netbeans.modules.versioning.diff.DiffMark;
import org.netbeans.modules.versioning.diff.DiffSidebarDiffPanel;
import org.netbeans.modules.versioning.diff.DiffSidebarManager;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

class DiffSidebar
extends JPanel
implements DocumentListener,
ComponentListener,
FoldHierarchyListener,
FileChangeListener {
    private static final int BAR_WIDTH = 9;
    private final JTextComponent textComponent;
    private FileObject fileObject;
    private final EditorUI editorUI;
    private final FoldHierarchy foldHierarchy;
    private final BaseDocument document;
    private boolean sidebarVisible;
    private boolean sidebarInComponentHierarchy;
    private Difference[] currentDiff;
    private DiffMarkProvider markProvider;
    private Color colorAdded = new Color(150, 255, 150);
    private Color colorChanged = new Color(160, 200, 255);
    private Color colorRemoved = new Color(255, 160, 180);
    private Color colorBorder = new Color(102, 102, 102);
    private int originalContentSerial;
    private int originalContentBufferSerial = -1;
    private String originalContentBuffer;
    private RequestProcessor.Task refreshDiffTask;
    private VersioningSystem ownerVersioningSystem;

    public DiffSidebar(JTextComponent jTextComponent, File file) {
        this.textComponent = jTextComponent;
        this.fileObject = FileUtil.toFileObject((File)file);
        this.editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)this.editorUI.getComponent());
        this.document = this.editorUI.getDocument();
        this.markProvider = new DiffMarkProvider();
        this.setToolTipText("");
        this.refreshDiffTask = DiffSidebarManager.getInstance().createDiffSidebarTask(new RefreshDiffTask());
        this.setMaximumSize(new Dimension(9, Integer.MAX_VALUE));
    }

    FileObject getFileObject() {
        return this.fileObject;
    }

    private void refreshOriginalContent() {
        File file = this.fileObject != null ? FileUtil.toFile((FileObject)this.fileObject) : null;
        this.ownerVersioningSystem = file != null ? VersioningManager.getInstance().getOwner(file) : null;
        ++this.originalContentSerial;
        this.refreshDiff();
    }

    JTextComponent getTextComponent() {
        return this.textComponent;
    }

    Difference[] getCurrentDiff() {
        return this.currentDiff;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Difference difference = this.getDifferenceAt(mouseEvent);
        return DiffSidebar.getShortDescription(difference);
    }

    static String getShortDescription(Difference difference) {
        if (difference == null) {
            return null;
        }
        switch (difference.getType()) {
            case 1: {
                int n = difference.getSecondEnd() - difference.getSecondStart() + 1;
                return MessageFormat.format(new ChoiceFormat(NbBundle.getMessage(DiffSidebar.class, (String)"TT_LinesAdded")).format(n), n);
            }
            case 2: {
                int n = difference.getFirstEnd() - difference.getFirstStart() + 1;
                return MessageFormat.format(new ChoiceFormat(NbBundle.getMessage(DiffSidebar.class, (String)"TT_LinesChanged")).format(n), n);
            }
            case 0: {
                int n = difference.getFirstEnd() - difference.getFirstStart() + 1;
                return MessageFormat.format(new ChoiceFormat(NbBundle.getMessage(DiffSidebar.class, (String)"TT_LinesDeleted")).format(n), n);
            }
        }
        throw new IllegalStateException("Unknown difference type: " + difference.getType());
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500 || mouseEvent.isPopupTrigger()) {
            Difference difference = this.getDifferenceAt(mouseEvent);
            if (difference == null) {
                return;
            }
            this.onClick(mouseEvent, difference);
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    private void onClick(MouseEvent mouseEvent, Difference difference) {
        Point point = new Point(mouseEvent.getPoint());
        SwingUtilities.convertPointToScreen(point, this);
        Point point2 = new Point(point);
        SwingUtilities.convertPointFromScreen(point2, this.textComponent);
        this.showTooltipWindow(new Point(point.x - point2.x, point.y), difference);
    }

    private void showTooltipWindow(Point point, Difference difference) {
        DiffActionTooltipWindow diffActionTooltipWindow = new DiffActionTooltipWindow(this, difference);
        diffActionTooltipWindow.show(new Point(point.x, point.y));
    }

    private Difference getDifferenceAt(MouseEvent mouseEvent) {
        if (this.currentDiff == null) {
            return null;
        }
        int n = this.getLineFromMouseEvent(mouseEvent);
        if (n == -1) {
            return null;
        }
        Difference difference = this.getDifference(n + 1);
        if (difference == null && (difference = this.getDifference(n)) != null && difference.getType() != 0) {
            difference = null;
        }
        return difference;
    }

    void onDiff(Difference difference) {
        try {
            DiffController diffController = DiffController.create((StreamSource)new SidebarStreamSource(true), (StreamSource)new SidebarStreamSource(false));
            DiffTopComponent diffTopComponent = new DiffTopComponent(diffController);
            diffTopComponent.setName(this.fileObject.getNameExt() + " [Diff]");
            diffTopComponent.open();
            diffTopComponent.requestActive();
            diffController.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, this.getDiffIndex(difference));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private int getDiffIndex(Difference difference) {
        for (int i = 0; i < this.currentDiff.length; ++i) {
            if (difference != this.currentDiff[i]) continue;
            return i;
        }
        return -1;
    }

    void onRollback(Difference difference) {
        try {
            if (difference.getType() == 1) {
                int n = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)(difference.getSecondStart() - 1));
                int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)difference.getSecondEnd());
                this.document.remove(n, n2 - n);
            } else if (difference.getType() == 2) {
                int n = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)(difference.getSecondStart() - 1));
                int n3 = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)difference.getSecondEnd());
                this.document.replace(n, n3 - n, difference.getFirstText(), null);
            } else {
                int n = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)difference.getSecondStart());
                this.document.insertString(n, difference.getFirstText(), null);
            }
            this.refreshDiff();
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    boolean canRollback(Difference difference) {
        int n;
        int n2;
        if (!(this.document instanceof GuardedDocument)) {
            return true;
        }
        if (difference.getType() == 0) {
            n = n2 = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)difference.getSecondStart());
        } else {
            n = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)(difference.getSecondStart() - 1));
            n2 = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)difference.getSecondEnd());
        }
        MarkBlockChain markBlockChain = ((GuardedDocument)this.document).getGuardedBlockChain();
        return (markBlockChain.compareBlock(n, n2) & 1) == 0;
    }

    void onPrevious(Difference difference) {
        difference = this.currentDiff[this.getDiffIndex(difference) - 1];
        Point point = this.scrollToDifference(difference);
        this.showTooltipWindow(point, difference);
        this.textComponent.repaint();
    }

    void onNext(Difference difference) {
        difference = this.currentDiff[this.getDiffIndex(difference) + 1];
        Point point = this.scrollToDifference(difference);
        this.showTooltipWindow(point, difference);
        this.textComponent.repaint();
    }

    private Point scrollToDifference(Difference difference) {
        int n = difference.getSecondStart() - 1;
        int n2 = difference.getSecondEnd() - 1;
        if (difference.getType() == 0) {
            n2 = n;
        }
        try {
            int n3 = this.editorUI.getLineHeight() * 5;
            int n4 = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)this.textComponent.getDocument()), (int)n);
            int n5 = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)this.textComponent.getDocument()), (int)n2);
            Rectangle rectangle = this.textComponent.getUI().modelToView(this.textComponent, n4);
            Rectangle rectangle2 = this.textComponent.getUI().modelToView(this.textComponent, n5);
            Rectangle rectangle3 = new Rectangle(rectangle.x - n3, rectangle.y - n3, rectangle.x, rectangle2.y - rectangle.y + rectangle2.height + n3 * 2);
            this.textComponent.scrollRectToVisible(rectangle3);
            Point point = new Point(rectangle2.x, rectangle2.y + rectangle2.height + 1);
            SwingUtilities.convertPointToScreen(point, this.textComponent);
            return point;
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(DiffSidebar.class.getName()).log(Level.WARNING, "scrollToDifference", badLocationException);
            return null;
        }
    }

    String getMimeType() {
        if (this.textComponent instanceof JEditorPane) {
            return ((JEditorPane)this.textComponent).getContentType();
        }
        return "text/plain";
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDeleted(FileEvent fileEvent) {
        DataObject dataObject;
        if (this.fileObject != null) {
            this.fileObject.removeFileChangeListener((FileChangeListener)this);
            this.fileObject = null;
        }
        if ((dataObject = (DataObject)this.document.getProperty((Object)"stream")) != null) {
            this.fileObject = dataObject.getPrimaryFile();
        }
        this.fileRenamed(null);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffSidebar.this.refresh();
            }
        });
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    private int getLineFromMouseEvent(MouseEvent mouseEvent) {
        int n = -1;
        if (this.editorUI != null) {
            try {
                JTextComponent jTextComponent = this.editorUI.getComponent();
                if (jTextComponent != null) {
                    BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                    int n2 = baseTextUI.viewToModel(jTextComponent, new Point(0, mouseEvent.getY()));
                    n = Utilities.getLineOffset((BaseDocument)this.document, (int)n2);
                }
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(DiffSidebar.class.getName()).log(Level.WARNING, "getLineFromMouseEvent", badLocationException);
            }
        }
        return n;
    }

    void refresh() {
        if (!this.sidebarInComponentHierarchy) {
            return;
        }
        this.shutdown();
        this.initialize();
        this.refreshDiff();
        this.revalidate();
    }

    public void setSidebarVisible(boolean bl) {
        if (this.sidebarVisible == bl) {
            return;
        }
        this.sidebarVisible = bl;
        this.refreshDiff();
        this.revalidate();
    }

    public void addNotify() {
        super.addNotify();
        this.sidebarInComponentHierarchy = true;
        this.initialize();
    }

    public void removeNotify() {
        this.shutdown();
        this.sidebarInComponentHierarchy = false;
        super.removeNotify();
    }

    private void initialize() {
        assert (SwingUtilities.isEventDispatchThread());
        this.document.addDocumentListener((DocumentListener)this);
        this.textComponent.addComponentListener(this);
        this.foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)this);
        this.refreshOriginalContent();
        if (this.fileObject != null) {
            this.fileObject.addFileChangeListener((FileChangeListener)this);
        }
    }

    private void shutdown() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.fileObject != null) {
            this.fileObject.removeFileChangeListener((FileChangeListener)this);
        }
        this.foldHierarchy.removeFoldHierarchyListener((FoldHierarchyListener)this);
        this.textComponent.removeComponentListener(this);
        this.document.removeDocumentListener((DocumentListener)this);
    }

    private Reader getDocumentReader() {
        JTextComponent jTextComponent = this.editorUI.getComponent();
        if (jTextComponent == null) {
            return null;
        }
        return Utils.getDocumentReader(jTextComponent.getDocument());
    }

    private void refreshDiff() {
        this.refreshDiffTask.schedule(50);
    }

    MarkProvider getMarkProvider() {
        return this.markProvider;
    }

    private static void copyStreamsCloseAll(Writer writer, Reader reader) throws IOException {
        int n;
        char[] cArray = new char[2048];
        while ((n = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n);
        }
        writer.close();
        reader.close();
    }

    static void copyStreamsCloseAll(OutputStream outputStream, InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.close();
        inputStream.close();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.textComponent.getSize();
        dimension.width = this.sidebarVisible ? 9 : 0;
        return dimension;
    }

    public void paintComponent(Graphics graphics) {
        block13: {
            JTextComponent jTextComponent;
            super.paintComponent(graphics);
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle.y >= 16) {
                rectangle.y -= 16;
                rectangle.height += 16;
            }
            if ((jTextComponent = this.editorUI.getComponent()) == null) {
                return;
            }
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            View view = Utilities.getDocumentView((JTextComponent)jTextComponent);
            if (view == null) {
                return;
            }
            graphics.setColor(this.backgroundColor());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Difference[] differenceArray = this.currentDiff;
            if (differenceArray == null || differenceArray.length == 0) {
                return;
            }
            try {
                int n = baseTextUI.getPosFromY(rectangle.y);
                int n2 = view.getViewIndex(n, Position.Bias.Forward);
                int n3 = view.getViewCount();
                if (n2 < 0 || n2 >= n3) break block13;
                Rectangle rectangle2 = baseTextUI.modelToView(jTextComponent, view.getView(n2).getStartOffset());
                int n4 = rectangle2 == null ? 0 : rectangle2.y;
                int[] nArray = new int[3];
                int n5 = rectangle.y + rectangle.height;
                Element element = baseTextUI.getRootView(jTextComponent).getElement();
                View view2 = view.getView(n2);
                int n6 = element.getElementIndex(view2.getStartOffset());
                if (++n6 == 1 && differenceArray[0].getSecondStart() == 0 && differenceArray[0].getType() == 0) {
                    graphics.setColor(this.getColor(differenceArray[0]));
                    nArray[0] = n4 - this.editorUI.getLineAscent() / 2;
                    nArray[1] = n4;
                    nArray[2] = n4 + this.editorUI.getLineAscent() / 2;
                    graphics.fillPolygon(new int[]{0, 9, 0}, nArray, 3);
                }
                for (int i = n2; i < n3; ++i) {
                    Difference difference;
                    view2 = view.getView(i);
                    n6 = element.getElementIndex(view2.getStartOffset());
                    if ((difference = this.getDifference(++n6)) != null) {
                        graphics.setColor(this.getColor(difference));
                        if (difference.getType() == 0) {
                            nArray[0] = n4 + this.editorUI.getLineAscent();
                            nArray[1] = n4 + this.editorUI.getLineAscent() * 3 / 2;
                            nArray[2] = n4 + this.editorUI.getLineAscent() * 2;
                            graphics.fillPolygon(new int[]{2, 9, 2}, nArray, 3);
                            graphics.setColor(this.colorBorder);
                            graphics.drawLine(2, nArray[0], 2, nArray[2] - 1);
                        } else {
                            graphics.fillRect(3, n4, 6, this.editorUI.getLineHeight());
                            graphics.setColor(this.colorBorder);
                            int n7 = n4 + this.editorUI.getLineHeight();
                            graphics.drawLine(2, n4, 2, n7);
                            if (difference.getSecondStart() == n6) {
                                graphics.drawLine(2, n4, 8, n4);
                            }
                            graphics.drawLine(2, n7, 8, n7);
                        }
                    }
                    if ((n4 += this.editorUI.getLineHeight()) < n5) {
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
    }

    private Color getColor(Difference difference) {
        if (difference.getType() == 1) {
            return this.colorAdded;
        }
        if (difference.getType() == 2) {
            return this.colorChanged;
        }
        return this.colorRemoved;
    }

    private Difference getDifference(int n) {
        if (n < 0) {
            return null;
        }
        for (int i = 0; i < this.currentDiff.length; ++i) {
            Difference difference = this.currentDiff[i];
            if (n < difference.getSecondStart()) {
                return null;
            }
            if (difference.getType() == 0 && n == difference.getSecondStart()) {
                return difference;
            }
            if (n > difference.getSecondEnd()) continue;
            return difference;
        }
        return null;
    }

    private Color backgroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getBackground();
        }
        return Color.WHITE;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.refreshDiff();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.refreshDiff();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.refreshDiff();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.revalidate();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader getText(VersioningSystem versioningSystem) {
        File file4;
        Object object;
        Object object2;
        Object object3;
        if (versioningSystem == null) {
            return null;
        }
        File file2 = FileUtil.toFile((FileObject)this.fileObject);
        if (file2 == null) {
            return null;
        }
        File file3 = Utils.getTempFolder();
        HashSet<File> hashSet = new HashSet<File>(2);
        hashSet.add(file2);
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)this.fileObject);
            object3 = dataObject.files();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (FileObject)object2.next();
                file4 = FileUtil.toFile((FileObject)object);
                hashSet.add(file4);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        object3 = (DiffFileEncodingQueryImpl)((Object)Lookup.getDefault().lookup(DiffFileEncodingQueryImpl.class));
        object2 = new ArrayList();
        try {
            for (File file4 : hashSet) {
                File file5 = new File(file3, file4.getName());
                versioningSystem.getOriginalFile(file4, file5);
                object2.add(file5);
            }
            if (object3 != null) {
                ((DiffFileEncodingQueryImpl)((Object)object3)).associateEncoding(file2, (List<File>)object2);
            }
            object = this.createReader(new File(file3, this.fileObject.getNameExt()));
            return object;
        }
        catch (Exception exception) {
            file4 = null;
            return file4;
        }
        finally {
            if (object3 != null) {
                ((DiffFileEncodingQueryImpl)((Object)object3)).resetEncodingForFiles((List<File>)object2);
            }
            Utils.deleteRecursively(file3);
        }
    }

    private Reader createReader(File file) {
        try {
            MultiDataObject multiDataObject;
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            Document document = null;
            if (dataObject instanceof MultiDataObject) {
                multiDataObject = (MultiDataObject)dataObject;
                for (MultiDataObject.Entry entry : multiDataObject.secondaryEntries()) {
                    if (!fileObject.equals(entry.getFile()) || !(entry instanceof CookieSet.Factory)) continue;
                    CookieSet.Factory factory = (CookieSet.Factory)entry;
                    EditorCookie editorCookie = (EditorCookie)factory.createCookie(EditorCookie.class);
                    document = editorCookie.openDocument();
                }
            }
            if (document == null) {
                multiDataObject = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                document = multiDataObject.openDocument();
            }
            return new StringReader(document.getText(0, document.getLength()));
        }
        catch (Exception exception) {
            try {
                return new FileReader(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
    }

    static /* synthetic */ Difference[] access$002(DiffSidebar diffSidebar, Difference[] differenceArray) {
        diffSidebar.currentDiff = differenceArray;
        return differenceArray;
    }

    private class SidebarStreamSource
    extends StreamSource {
        private final boolean isFirst;

        public SidebarStreamSource(boolean bl) {
            this.isFirst = bl;
        }

        public boolean isEditable() {
            return !this.isFirst;
        }

        public Lookup getLookup() {
            if (this.isFirst) {
                return super.getLookup();
            }
            return Lookups.fixed((Object[])new Object[]{DiffSidebar.this.document});
        }

        public String getName() {
            return DiffSidebar.this.fileObject.getNameExt();
        }

        public String getTitle() {
            if (this.isFirst) {
                return NbBundle.getMessage(DiffSidebar.class, (String)"LBL_DiffPane_Original");
            }
            return NbBundle.getMessage(DiffSidebar.class, (String)"LBL_DiffPane_WorkingCopy");
        }

        public String getMIMEType() {
            return DiffSidebar.this.getMimeType();
        }

        public Reader createReader() throws IOException {
            return this.isFirst ? new StringReader(DiffSidebar.this.originalContentBuffer) : DiffSidebar.this.getDocumentReader();
        }

        public Writer createWriter(Difference[] differenceArray) throws IOException {
            return null;
        }
    }

    public class RefreshDiffTask
    implements Runnable {
        public void run() {
            this.computeDiff();
            DiffSidebar.this.repaint();
            DiffSidebar.this.markProvider.refresh();
        }

        private void computeDiff() {
            if (!DiffSidebar.this.sidebarVisible) {
                DiffSidebar.access$002(DiffSidebar.this, null);
                return;
            }
            this.fetchOriginalContent();
            if (DiffSidebar.this.originalContentBuffer == null) {
                DiffSidebar.access$002(DiffSidebar.this, null);
                return;
            }
            Reader reader = DiffSidebar.this.getDocumentReader();
            if (reader == null) {
                return;
            }
            DiffProvider diffProvider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
            if (diffProvider == null) {
                DiffSidebar.access$002(DiffSidebar.this, null);
                return;
            }
            try {
                DiffSidebar.access$002(DiffSidebar.this, diffProvider.computeDiff((Reader)new StringReader(DiffSidebar.this.originalContentBuffer), reader));
            }
            catch (IOException iOException) {
                DiffSidebar.access$002(DiffSidebar.this, null);
            }
        }

        private void fetchOriginalContent() {
            int n = DiffSidebar.this.originalContentSerial;
            if (DiffSidebar.this.originalContentBuffer != null && DiffSidebar.this.originalContentBufferSerial == n) {
                return;
            }
            DiffSidebar.this.originalContentBufferSerial = n;
            Reader reader = DiffSidebar.this.getText(DiffSidebar.this.ownerVersioningSystem);
            if (reader == null) {
                DiffSidebar.this.originalContentBuffer = null;
                return;
            }
            StringWriter stringWriter = new StringWriter(2048);
            try {
                DiffSidebar.copyStreamsCloseAll(stringWriter, reader);
                DiffSidebar.this.originalContentBuffer = stringWriter.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DiffMarkProvider
    extends MarkProvider {
        private List<DiffMark> marks = this.getMarksForDifferences();

        public List getMarks() {
            return this.marks;
        }

        void refresh() {
            List<DiffMark> list = this.marks;
            this.marks = this.getMarksForDifferences();
            this.firePropertyChange("marks", list, this.marks);
        }

        private List<DiffMark> getMarksForDifferences() {
            if (DiffSidebar.this.currentDiff == null || !DiffSidebar.this.isVisible() || DiffSidebar.this.getWidth() <= 0) {
                return Collections.emptyList();
            }
            ArrayList<DiffMark> arrayList = new ArrayList<DiffMark>(DiffSidebar.this.currentDiff.length);
            for (int i = 0; i < DiffSidebar.this.currentDiff.length; ++i) {
                Difference difference = DiffSidebar.this.currentDiff[i];
                arrayList.add(new DiffMark(difference, DiffSidebar.this.getColor(difference)));
            }
            return arrayList;
        }
    }

    private static class DiffTopComponent
    extends TopComponent {
        private JComponent diffView;

        public DiffTopComponent() {
        }

        public DiffTopComponent(DiffController diffController) {
            this.diffView = diffController.getJComponent();
            this.setLayout(new BorderLayout());
            this.diffView.putClientProperty(TopComponent.class, (Object)this);
            DiffSidebarDiffPanel diffSidebarDiffPanel = new DiffSidebarDiffPanel(diffController);
            this.add(diffSidebarDiffPanel);
        }

        public UndoRedo getUndoRedo() {
            UndoRedo undoRedo = (UndoRedo)this.diffView.getClientProperty(UndoRedo.class);
            return undoRedo == null ? UndoRedo.NONE : undoRedo;
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return "DiffSidebarTopComponent";
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(((Object)((Object)this)).getClass());
        }
    }
}

