/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.modules.editor.completion.CompletionImpl;
import org.netbeans.modules.editor.completion.CompletionLayoutPopup;
import org.netbeans.modules.editor.completion.CompletionScrollPane;
import org.netbeans.modules.editor.completion.CompletionSettings;
import org.netbeans.modules.editor.completion.DocumentationScrollPane;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.util.NbBundle;

public final class CompletionLayout {
    public static final int COMPLETION_ITEM_HEIGHT = 16;
    private static final int COMPLETION_ANCHOR_HORIZONTAL_SHIFT = 22;
    static final int POPUP_VERTICAL_GAP = 1;
    private Reference<JTextComponent> editorComponentRef;
    private final CompletionPopup completionPopup = new CompletionPopup();
    private final DocPopup docPopup;
    private final TipPopup tipPopup;
    private Stack<CompletionLayoutPopup> visiblePopups;

    CompletionLayout() {
        this.completionPopup.setLayout(this);
        this.completionPopup.setPreferDisplayAboveCaret(false);
        this.docPopup = new DocPopup();
        this.docPopup.setLayout(this);
        this.docPopup.setPreferDisplayAboveCaret(false);
        this.tipPopup = new TipPopup();
        this.tipPopup.setLayout(this);
        this.tipPopup.setPreferDisplayAboveCaret(true);
        this.visiblePopups = new Stack();
    }

    public JTextComponent getEditorComponent() {
        return this.editorComponentRef != null ? this.editorComponentRef.get() : null;
    }

    public void setEditorComponent(JTextComponent jTextComponent) {
        this.hideAll();
        this.editorComponentRef = new WeakReference<JTextComponent>(jTextComponent);
    }

    private void hideAll() {
        this.completionPopup.hide();
        this.docPopup.hide();
        this.tipPopup.hide();
        this.visiblePopups.clear();
    }

    public void showCompletion(List list, String string, int n, ListSelectionListener listSelectionListener, String string2, String string3, int n2) {
        this.completionPopup.show(list, string, n, listSelectionListener, string2, string3, n2);
        if (!this.visiblePopups.contains(this.completionPopup)) {
            this.visiblePopups.push(this.completionPopup);
        }
    }

    public boolean hideCompletion() {
        if (this.completionPopup.isVisible()) {
            this.completionPopup.hide();
            this.completionPopup.completionScrollPane = null;
            this.visiblePopups.remove(this.completionPopup);
            return true;
        }
        return false;
    }

    public boolean isCompletionVisible() {
        return this.completionPopup.isVisible();
    }

    public CompletionItem getSelectedCompletionItem() {
        return this.completionPopup.getSelectedCompletionItem();
    }

    public int getSelectedIndex() {
        return this.completionPopup.getSelectedIndex();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        for (int i = this.visiblePopups.size() - 1; i >= 0; --i) {
            CompletionLayoutPopup completionLayoutPopup = (CompletionLayoutPopup)this.visiblePopups.get(i);
            completionLayoutPopup.processKeyEvent(keyEvent);
            if (!keyEvent.isConsumed()) continue;
            return;
        }
    }

    public void showDocumentation(CompletionDocumentation completionDocumentation, int n) {
        this.docPopup.show(completionDocumentation, n);
        if (!this.visiblePopups.contains(this.docPopup)) {
            this.visiblePopups.push(this.docPopup);
        }
    }

    public boolean hideDocumentation() {
        if (this.docPopup.isVisible()) {
            ((DocPopup)this.docPopup).getDocumentationScrollPane().currentDocumentation = null;
            this.docPopup.clearHistory();
            this.docPopup.hide();
            this.visiblePopups.remove(this.docPopup);
            return true;
        }
        return false;
    }

    public boolean isDocumentationVisible() {
        return this.docPopup.isVisible();
    }

    public void clearDocumentationHistory() {
        this.docPopup.clearHistory();
    }

    public void showToolTip(JToolTip jToolTip, int n) {
        this.tipPopup.show(jToolTip, n);
        if (!this.visiblePopups.contains(this.tipPopup)) {
            this.visiblePopups.push(this.tipPopup);
        }
    }

    public boolean hideToolTip() {
        if (this.tipPopup.isVisible()) {
            this.tipPopup.hide();
            this.visiblePopups.remove(this.tipPopup);
            return true;
        }
        return false;
    }

    public boolean isToolTipVisible() {
        return this.tipPopup.isVisible();
    }

    void updateLayout(CompletionLayoutPopup completionLayoutPopup) {
        completionLayoutPopup.resetPreferredSize();
        if (completionLayoutPopup == this.completionPopup) {
            if (this.isToolTipVisible()) {
                boolean bl;
                boolean bl2 = bl = !this.tipPopup.isDisplayAboveCaret();
                if (this.completionPopup.isEnoughSpace(bl)) {
                    this.completionPopup.showAlongAnchorBounds(bl);
                } else {
                    Rectangle rectangle = completionLayoutPopup.getAnchorOffsetBounds();
                    rectangle = this.tipPopup.unionBounds(rectangle);
                    this.completionPopup.showAlongOccupiedBounds(rectangle, this.tipPopup.isDisplayAboveCaret());
                }
            } else {
                completionLayoutPopup.showAlongAnchorBounds();
            }
            if (this.docPopup.isVisible() && (this.docPopup.isOverlapped(completionLayoutPopup) || this.docPopup.isOverlapped(this.tipPopup) || this.docPopup.getAnchorOffset() != this.completionPopup.getAnchorOffset() || !this.docPopup.isShowRetainedPreferredSize())) {
                this.updateLayout(this.docPopup);
            }
        } else if (completionLayoutPopup == this.docPopup) {
            if (this.isCompletionVisible()) {
                completionLayoutPopup.setAnchorOffset(this.completionPopup.getAnchorOffset());
            }
            Rectangle rectangle = completionLayoutPopup.getAnchorOffsetBounds();
            rectangle = this.tipPopup.unionBounds(this.completionPopup.unionBounds(rectangle));
            if (CompletionSettings.getInstance().documentationPopupNextToCC()) {
                this.docPopup.showAlongOrNextOccupiedBounds(this.completionPopup.getPopupBounds(), rectangle);
            } else {
                this.docPopup.showAlongOccupiedBounds(rectangle);
            }
        } else if (completionLayoutPopup == this.tipPopup) {
            completionLayoutPopup.showAlongAnchorBounds();
            if (this.completionPopup.isOverlapped(completionLayoutPopup) || this.docPopup.isOverlapped(completionLayoutPopup)) {
                this.updateLayout(this.completionPopup);
            }
        }
    }

    CompletionPopup testGetCompletionPopup() {
        return this.completionPopup;
    }

    private static final class TipPopup
    extends CompletionLayoutPopup {
        private TipPopup() {
        }

        protected void show(JToolTip jToolTip, int n) {
            JComponent jComponent = null;
            if (this.isVisible()) {
                jComponent = this.getContentComponent();
            }
            this.setContentComponent(jToolTip);
            this.setAnchorOffset(n);
            if (jComponent != jToolTip) {
                this.getLayout().updateLayout(this);
            }
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (this.isVisible() && KeyStroke.getKeyStroke(27, 0).equals(KeyStroke.getKeyStrokeForEvent(keyEvent))) {
                keyEvent.consume();
                CompletionImpl.get().hideToolTip();
            }
        }
    }

    private static final class DocPopup
    extends CompletionLayoutPopup {
        private DocPopup() {
        }

        private DocumentationScrollPane getDocumentationScrollPane() {
            return (DocumentationScrollPane)this.getContentComponent();
        }

        protected void show(CompletionDocumentation completionDocumentation, int n) {
            JTextComponent jTextComponent = this.getEditorComponent();
            if (jTextComponent == null) {
                return;
            }
            if (!this.isVisible()) {
                this.setContentComponent(new DocumentationScrollPane(jTextComponent));
            }
            this.getDocumentationScrollPane().setData(completionDocumentation);
            if (!this.isVisible()) {
                this.setAnchorOffset(n);
                this.getLayout().updateLayout(this);
            }
        }

        protected boolean isFocusable() {
            return true;
        }

        protected JComponent getFocusListeningComponent() {
            return (JComponent)this.getDocumentationScrollPane().getViewport().getView();
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            Action action;
            Object object;
            if (this.isVisible() && (object = this.getDocumentationScrollPane().getInputMap().get(KeyStroke.getKeyStrokeForEvent(keyEvent))) != null && (action = this.getDocumentationScrollPane().getActionMap().get(object)) != null) {
                action.actionPerformed(new ActionEvent(this.getDocumentationScrollPane(), 0, null));
                keyEvent.consume();
            }
        }

        public void clearHistory() {
            if (this.isVisible()) {
                this.getDocumentationScrollPane().clearHistory();
            }
        }

        protected int getAnchorHorizontalShift() {
            return 22;
        }
    }

    private static final class CompletionPopup
    extends CompletionLayoutPopup {
        private CompletionScrollPane completionScrollPane;

        private CompletionPopup() {
        }

        public void show(List list, String string, int n, ListSelectionListener listSelectionListener, String string2, String string3, int n2) {
            Serializable serializable;
            Dimension dimension;
            JTextComponent jTextComponent = this.getEditorComponent();
            if (jTextComponent == null) {
                return;
            }
            int n3 = this.getAnchorOffset();
            if (this.isVisible() && this.getContentComponent() == this.completionScrollPane ^ string3 != null) {
                dimension = this.getContentComponent().getSize();
                this.resetPreferredSize();
            } else {
                dimension = new Dimension(0, 0);
                this.completionScrollPane = new CompletionScrollPane(jTextComponent, listSelectionListener, new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        CompletionItem completionItem;
                        JTextComponent jTextComponent = CompletionPopup.this.getEditorComponent();
                        if (SwingUtilities.isLeftMouseButton(mouseEvent) && jTextComponent != null && mouseEvent.getClickCount() == 2 && (completionItem = CompletionPopup.this.completionScrollPane.getSelectedCompletionItem()) != null) {
                            if (jTextComponent.getDocument() instanceof GuardedDocument && ((GuardedDocument)jTextComponent.getDocument()).isPosGuarded(jTextComponent.getSelectionEnd())) {
                                Toolkit.getDefaultToolkit().beep();
                            } else {
                                LogRecord logRecord = new LogRecord(Level.FINE, "COMPL_MOUSE_SELECT");
                                logRecord.setParameters(new Object[]{null, CompletionPopup.this.completionScrollPane.getSelectedIndex(), completionItem.getClass().getSimpleName()});
                                CompletionImpl.uilog(logRecord);
                                completionItem.defaultAction(jTextComponent);
                            }
                        }
                    }
                });
                if (string3 != null) {
                    serializable = new JPanel();
                    ((Container)serializable).setLayout(new BorderLayout());
                    ((Container)serializable).add(this.completionScrollPane, "Center");
                    JLabel jLabel = new JLabel();
                    jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.white), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.gray), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
                    jLabel.setFont(jLabel.getFont().deriveFont((float)jLabel.getFont().getSize() - 2.0f));
                    jLabel.setHorizontalAlignment(4);
                    jLabel.setText(NbBundle.getMessage(CompletionLayout.class, (String)"TXT_completion_shortcut_tips", (Object)string2, (Object)string3));
                    ((Container)serializable).add(jLabel, "South");
                    this.setContentComponent((JComponent)serializable);
                } else {
                    this.setContentComponent(this.completionScrollPane);
                }
            }
            this.completionScrollPane.setData(list, string, n2);
            this.setAnchorOffset(n);
            serializable = this.getPreferredSize();
            boolean bl = this.isVisible() ? ((Dimension)serializable).height != dimension.height || ((Dimension)serializable).width != dimension.width || n != n3 : true;
            if (bl) {
                this.getLayout().updateLayout(this);
            }
        }

        public CompletionItem getSelectedCompletionItem() {
            return this.isVisible() ? this.completionScrollPane.getSelectedCompletionItem() : null;
        }

        public int getSelectedIndex() {
            return this.isVisible() ? this.completionScrollPane.getSelectedIndex() : -1;
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            Action action;
            Object object;
            if (this.isVisible() && (object = this.completionScrollPane.getInputMap().get(KeyStroke.getKeyStrokeForEvent(keyEvent))) != null && (action = this.completionScrollPane.getActionMap().get(object)) != null) {
                action.actionPerformed(new ActionEvent(this.completionScrollPane, 0, null));
                keyEvent.consume();
            }
        }

        protected int getAnchorHorizontalShift() {
            return 22;
        }
    }
}

