/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.TimedGlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.TimedTakeSnapshotProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.TimedTakeSnapshotCustomizer;
import org.openide.ErrorManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class TimedTakeSnapshotProfilingPointFactory
extends CodeProfilingPointFactory {
    private static final String PP_TYPE = NbBundle.getMessage(TimedTakeSnapshotProfilingPointFactory.class, (String)"TimedTakeSnapshotProfilingPointFactory_PpType");
    private static final String PP_DESCR = NbBundle.getMessage(TimedTakeSnapshotProfilingPointFactory.class, (String)"TimedTakeSnapshotProfilingPointFactory_PpDescr");
    private static final String PP_DEFAULT_NAME = NbBundle.getMessage(TimedTakeSnapshotProfilingPointFactory.class, (String)"TimedTakeSnapshotProfilingPointFactory_PpDefaultName");
    public static final Icon TAKE_SNAPSHOT_PP_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/ppoints/ui/resources/timedTakeSnapshotProfilingPoint.png"));
    public static final String TAKE_SNAPSHOT_PP_TYPE = PP_TYPE;
    public static final String TAKE_SNAPSHOT_PP_DESCR = PP_DESCR;
    private static TimedTakeSnapshotProfilingPointFactory defaultInstance;

    public static TimedTakeSnapshotProfilingPointFactory getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new TimedTakeSnapshotProfilingPointFactory();
        }
        return defaultInstance;
    }

    public String getDescription() {
        return TAKE_SNAPSHOT_PP_DESCR;
    }

    public Icon getIcon() {
        return TAKE_SNAPSHOT_PP_ICON;
    }

    public int getScope() {
        return 2;
    }

    public String getType() {
        return TAKE_SNAPSHOT_PP_TYPE;
    }

    public TimedTakeSnapshotProfilingPoint create(Project project) {
        if (project == null) {
            project = Utils.getCurrentProject();
        }
        String string = Utils.getUniqueName(this.getType(), MessageFormat.format(PP_DEFAULT_NAME, "", ProjectUtils.getInformation((Project)project).getDisplayName()), project);
        return new TimedTakeSnapshotProfilingPoint(string, project);
    }

    public boolean supportsCPU() {
        return true;
    }

    public boolean supportsMemory() {
        return true;
    }

    public boolean supportsMonitor() {
        return false;
    }

    protected Class getProfilingPointsClass() {
        return TimedTakeSnapshotProfilingPoint.class;
    }

    protected String getServerHandlerClassName() {
        throw new UnsupportedOperationException();
    }

    protected TimedTakeSnapshotCustomizer createCustomizer() {
        return new TimedTakeSnapshotCustomizer(this.getType(), this.getIcon());
    }

    protected ProfilingPoint loadProfilingPoint(Project project, Properties properties, int n) {
        String string = properties.getProperty(n + "_" + "p_name", null);
        String string2 = properties.getProperty(n + "_" + "p_enabled", null);
        String string3 = properties.getProperty(n + "_" + "p_snapshot", null);
        String string4 = properties.getProperty(n + "_" + "p_target", null);
        String string5 = properties.getProperty(n + "_" + "p_file", null);
        String string6 = properties.getProperty(n + "_" + "p_reset_results", null);
        TimedGlobalProfilingPoint.TimeCondition timeCondition = TimedGlobalProfilingPoint.TimeCondition.load(project, n, properties);
        if (string == null || string2 == null || timeCondition == null || string3 == null || string4 == null || string5 == null || string6 == null) {
            return null;
        }
        TimedTakeSnapshotProfilingPoint timedTakeSnapshotProfilingPoint = null;
        try {
            timedTakeSnapshotProfilingPoint = new TimedTakeSnapshotProfilingPoint(string, project);
            timedTakeSnapshotProfilingPoint.setEnabled(Boolean.parseBoolean(string2));
            timedTakeSnapshotProfilingPoint.setSnapshotType(string3);
            timedTakeSnapshotProfilingPoint.setSnapshotTarget(string4);
            timedTakeSnapshotProfilingPoint.setSnapshotFile(string5);
            timedTakeSnapshotProfilingPoint.setResetResults(Boolean.parseBoolean(string6));
            timedTakeSnapshotProfilingPoint.setCondition(timeCondition);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().log(65536, exception.getMessage());
        }
        return timedTakeSnapshotProfilingPoint;
    }

    protected void storeProfilingPoint(ProfilingPoint profilingPoint, int n, Properties properties) {
        TimedTakeSnapshotProfilingPoint timedTakeSnapshotProfilingPoint = (TimedTakeSnapshotProfilingPoint)profilingPoint;
        properties.put(n + "_" + "p_name", timedTakeSnapshotProfilingPoint.getName());
        properties.put(n + "_" + "p_enabled", Boolean.toString(timedTakeSnapshotProfilingPoint.isEnabled()));
        properties.put(n + "_" + "p_snapshot", timedTakeSnapshotProfilingPoint.getSnapshotType());
        properties.put(n + "_" + "p_target", timedTakeSnapshotProfilingPoint.getSnapshotTarget());
        properties.put(n + "_" + "p_file", timedTakeSnapshotProfilingPoint.getSnapshotFile() == null ? "" : timedTakeSnapshotProfilingPoint.getSnapshotFile());
        properties.put(n + "_" + "p_reset_results", Boolean.toString(timedTakeSnapshotProfilingPoint.getResetResults()));
        timedTakeSnapshotProfilingPoint.getCondition().store(timedTakeSnapshotProfilingPoint.getProject(), n, properties);
    }
}

