/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.ui.FieldsBrowserControllerUI;
import org.openide.util.NbBundle;

public class FieldsBrowserController
extends AbstractController {
    private static final String NONE_STRING = NbBundle.getMessage(FieldsBrowserController.class, (String)"FieldsBrowserController_NoneString");
    private static final String NO_INSTANCE_SELECTED_STRING = NbBundle.getMessage(FieldsBrowserController.class, (String)"FieldsBrowserController_NoInstanceSelectedString");
    private static final String NO_CLASS_SELECTED_STRING = NbBundle.getMessage(FieldsBrowserController.class, (String)"FieldsBrowserController_NoClassSelectedString");
    public static final int ROOT_INSTANCE = 0;
    public static final int ROOT_CLASS = 1;
    public static final AbstractHeapWalkerNode EMPTY_INSTANCE_NODE = new AbstractHeapWalkerNode(null){

        protected String computeName() {
            return NO_INSTANCE_SELECTED_STRING;
        }

        protected String computeType() {
            return NONE_STRING;
        }

        protected String computeValue() {
            return NONE_STRING;
        }

        protected Icon computeIcon() {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    };
    public static final AbstractHeapWalkerNode EMPTY_CLASS_NODE = new AbstractHeapWalkerNode(null){

        protected String computeName() {
            return NO_CLASS_SELECTED_STRING;
        }

        protected String computeType() {
            return NONE_STRING;
        }

        protected String computeValue() {
            return NONE_STRING;
        }

        protected Icon computeIcon() {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    };
    private Handler instancesControllerHandler;
    private Instance instance;
    private JavaClass javaClass;
    private int rootMode;

    public FieldsBrowserController(Handler handler, int n) {
        this.instancesControllerHandler = handler;
        this.rootMode = n;
    }

    public HeapWalkerNode getFilteredSortedFields(String string, int n, boolean bl) {
        if (this.rootMode == 0) {
            if (this.instance == null) {
                return EMPTY_INSTANCE_NODE;
            }
            return this.getSortedFields(this.getFilteredFields(this.getFields(this.instance), string), n, bl);
        }
        if (this.rootMode == 1) {
            if (this.javaClass == null) {
                return EMPTY_CLASS_NODE;
            }
            return this.getSortedFields(this.getFilteredFields(this.getFields(this.javaClass), string), n, bl);
        }
        return null;
    }

    public void setInstance(Instance instance) {
        this.rootMode = 0;
        this.instance = instance;
        this.javaClass = null;
        this.update();
    }

    public void setJavaClass(JavaClass javaClass) {
        this.rootMode = 1;
        this.instance = null;
        this.javaClass = javaClass;
        this.update();
    }

    public int getRootMode() {
        return this.rootMode;
    }

    public void createNavigationHistoryPoint() {
        this.instancesControllerHandler.getHeapFragmentWalker().createNavigationHistoryPoint();
    }

    public void navigateToClass(JavaClass javaClass) {
        this.instancesControllerHandler.showClass(javaClass);
    }

    public void navigateToInstance(Instance instance) {
        this.instancesControllerHandler.showInstance(instance);
    }

    public void showInstance(Instance instance) {
        if (this.instance != instance) {
            this.setInstance(instance);
        }
    }

    public void showJavaClass(JavaClass javaClass) {
        if (this.javaClass != javaClass) {
            this.setJavaClass(javaClass);
        }
    }

    public void update() {
        ((FieldsBrowserControllerUI)((Object)this.getPanel())).update();
    }

    protected AbstractButton createControllerPresenter() {
        return ((FieldsBrowserControllerUI)((Object)this.getPanel())).getPresenter();
    }

    protected JPanel createControllerUI() {
        return new FieldsBrowserControllerUI(this);
    }

    private HeapWalkerNode getFields(Instance instance) {
        return HeapWalkerNodeFactory.createRootInstanceNode(instance, "this", new Runnable(){

            public void run() {
                ((FieldsBrowserControllerUI)((Object)FieldsBrowserController.this.getPanel())).refreshView();
            }
        }, 1, this.instancesControllerHandler.getHeapFragmentWalker().getHeapFragment());
    }

    private HeapWalkerNode getFields(JavaClass javaClass) {
        return HeapWalkerNodeFactory.createRootClassNode(javaClass, "class", new Runnable(){

            public void run() {
                ((FieldsBrowserControllerUI)((Object)FieldsBrowserController.this.getPanel())).refreshView();
            }
        }, 1, this.instancesControllerHandler.getHeapFragmentWalker().getHeapFragment());
    }

    private HeapWalkerNode getFilteredFields(HeapWalkerNode heapWalkerNode, String string) {
        return heapWalkerNode;
    }

    private HeapWalkerNode getSortedFields(HeapWalkerNode heapWalkerNode, int n, boolean bl) {
        return heapWalkerNode;
    }

    private boolean matchesFilter(FieldValue fieldValue) {
        return true;
    }

    private class FieldsComparator
    implements Comparator {
        private boolean sortingOrder;
        private int sortingColumn;

        public FieldsComparator(int n, boolean bl) {
            this.sortingColumn = n;
            this.sortingOrder = bl;
        }

        public int compare(Object object, Object object2) {
            FieldValue fieldValue = this.sortingOrder ? (FieldValue)object : (FieldValue)object2;
            FieldValue fieldValue2 = this.sortingOrder ? (FieldValue)object2 : (FieldValue)object;
            switch (this.sortingColumn) {
                case 0: {
                    return fieldValue.getField().getName().compareTo(fieldValue2.getField().getName());
                }
                case 1: {
                    return fieldValue.getField().getType().getName().compareTo(fieldValue2.getField().getType().getName());
                }
                case 2: {
                    return fieldValue.getValue().compareTo(fieldValue2.getValue());
                }
            }
            throw new RuntimeException("Unsupported compare operation for " + object + ", " + object2);
        }
    }

    public static interface Handler {
        public HeapFragmentWalker getHeapFragmentWalker();

        public void showClass(JavaClass var1);

        public void showInstance(Instance var1);
    }
}

