/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.utils.IDEUtils;

public final class ProfilingMonitor {
    private UpdateThread monitorThread = new UpdateThread();
    private boolean updateThreadStarted = false;

    public void monitorVM(TargetAppRunner targetAppRunner) {
        if (!this.updateThreadStarted) {
            this.updateThreadStarted = true;
            this.monitorThread.start();
        }
        this.monitorThread.monitor(targetAppRunner);
    }

    public void stopDisplayingVM() {
        if (this.monitorThread != null) {
            this.monitorThread.monitor(null);
        }
    }

    public void stopUpdateThread() {
        if (this.monitorThread != null) {
            this.monitorThread.stopThread();
            this.monitorThread = null;
        }
    }

    static final class UpdateThread
    extends Thread {
        private static final int UPDATE_INTERVAL = 1200;
        private TargetAppRunner runner;
        private ThreadsDataManager threadsDataManager;
        private VMTelemetryDataManager VMTelemetryManager;
        private boolean doUpdateLiveResults;
        private boolean keepRunning = true;

        UpdateThread() {
            super("Profiler Monitor");
        }

        public void monitor(TargetAppRunner targetAppRunner) {
            this.runner = targetAppRunner;
            this.threadsDataManager = Profiler.getDefault().getThreadsManager();
            this.VMTelemetryManager = Profiler.getDefault().getVMTelemetryManager();
            if (targetAppRunner != null) {
                this.VMTelemetryManager.maxHeapSize = targetAppRunner.getProfilingSessionStatus().maxHeapSize;
            }
        }

        public void run() {
            Project project = NetBeansProfiler.getDefaultNB().getProfiledProject();
            final int n = ProfilingPointsManager.getDefault().getProfilingPoints(project, false).size();
            while (this.keepRunning) {
                block8: {
                    try {
                        if (this.runner != null) {
                            ProfilerControlPanel2.getDefault().updateStatus();
                            final MonitoredData monitoredData = this.runner.getProfilerClient().getMonitoredData();
                            if (monitoredData != null) {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        try {
                                            UpdateThread.this.threadsDataManager.processData(monitoredData);
                                            UpdateThread.this.VMTelemetryManager.processData(monitoredData);
                                            if (!(!NetBeansProfiler.getDefaultNB().processesProfilingPoints() || n <= 0 || UpdateThread.this.doUpdateLiveResults && LiveResultsWindow.hasDefault())) {
                                                IDEUtils.runInProfilerRequestProcessor(new Runnable(){

                                                    public void run() {
                                                        try {
                                                            ProfilerClient profilerClient = Profiler.getDefault().getTargetAppRunner().getProfilerClient();
                                                            if (profilerClient.getCurrentInstrType() != 1) {
                                                                profilerClient.forceObtainedResultsDump(true);
                                                            }
                                                        }
                                                        catch (Exception exception) {
                                                            // empty catch block
                                                        }
                                                    }
                                                });
                                            }
                                            if (UpdateThread.this.doUpdateLiveResults && LiveResultsWindow.hasDefault()) {
                                                LiveResultsWindow.getDefault().refreshLiveResults();
                                            }
                                            UpdateThread.this.doUpdateLiveResults = !UpdateThread.this.doUpdateLiveResults;
                                        }
                                        catch (Exception exception) {
                                            Profiler.getDefault().notifyException(8, exception);
                                        }
                                    }
                                });
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        ((NetBeansProfiler)Profiler.getDefault()).checkAndUpdateState();
                                    }
                                });
                                this.runner = null;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof ThreadDeath)) break block8;
                        throw (ThreadDeath)throwable;
                    }
                }
                try {
                    UpdateThread.sleep(1200L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }

        private void stopThread() {
            this.keepRunning = false;
        }
    }
}

