/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import java.io.File;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.php.project.PhpProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataObject;

public class PhpSourcesFilter
implements ChangeListener,
ChangeableDataFilter {
    private static final long serialVersionUID = -7439706583318056955L;
    private File projectXML;
    private final EventListenerList ell = new EventListenerList();

    public PhpSourcesFilter(PhpProject phpProject) {
        this.projectXML = phpProject.getHelper().resolveFile("nbproject/project.xml");
        VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
    }

    public boolean acceptDataObject(DataObject dataObject) {
        return this.isNotProjectFile(dataObject) && VisibilityQuery.getDefault().isVisible(dataObject.getPrimaryFile());
    }

    private boolean isNotProjectFile(DataObject dataObject) {
        try {
            if (this.projectXML != null) {
                File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile()).getCanonicalFile();
                File file2 = this.projectXML.getParentFile().getCanonicalFile();
                return file2 != null && !file2.equals(file);
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object[] objectArray = this.ell.getListenerList();
        ChangeEvent changeEvent2 = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent2 == null) {
                changeEvent2 = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent2);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.ell.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.ell.remove(ChangeListener.class, changeListener);
    }
}

