/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class RunAsRemoteWeb
extends RunAsPanel.InsidePanel {
    private static final long serialVersionUID = -5593346955414591271L;
    private static final RemoteConfiguration NO_REMOTE_CONFIGURATION = new RemoteConfiguration(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_NoRemoteConfiguration"));
    private static final RemoteConfiguration MISSING_REMOTE_CONFIGURATION = new RemoteConfiguration(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_MissingRemoteConfiguration"));
    private static final PhpProjectProperties.UploadFiles DEFAULT_UPLOAD_FILES = PhpProjectProperties.UploadFiles.ON_RUN;
    private final PhpProjectProperties properties;
    private final PhpProject project;
    private final JLabel[] labels;
    private final JTextField[] textFields;
    private final String[] propertyNames;
    private final String displayName;
    final ProjectCustomizer.Category category;
    private JLabel argsLabel;
    private JTextField argsTextField;
    private JButton indexFileBrowseButton;
    private JLabel indexFileLabel;
    private JTextField indexFileTextField;
    private JButton manageRemoteConnectionButton;
    private JComboBox remoteConnectionComboBox;
    private JLabel remoteConnectionHintLabel;
    private JLabel remoteConnectionLabel;
    private JComboBox runAsComboBox;
    private JLabel runAsLabel;
    private JLabel uploadDirectoryLabel;
    private JTextField uploadDirectoryTextField;
    private JComboBox uploadFilesComboBox;
    private JLabel uploadFilesHintLabel;
    private JLabel uploadFilesLabel;
    private JTextArea urlHintLabel;
    private JLabel urlLabel;
    private JTextField urlTextField;

    public RunAsRemoteWeb(PhpProjectProperties phpProjectProperties, ConfigManager configManager, ProjectCustomizer.Category category) {
        super(configManager);
        this.properties = phpProjectProperties;
        this.category = category;
        this.project = phpProjectProperties.getProject();
        this.displayName = NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_ConfigRemoteWeb");
        this.initComponents();
        this.labels = new JLabel[]{this.urlLabel, this.indexFileLabel, this.argsLabel, this.uploadDirectoryLabel};
        this.textFields = new JTextField[]{this.urlTextField, this.indexFileTextField, this.argsTextField, this.uploadDirectoryTextField};
        this.propertyNames = new String[]{"url", "index.file", "script.arguments", "remote.directory"};
        assert (this.labels.length == this.textFields.length && this.labels.length == this.propertyNames.length);
        this.populateRemoteConnectionComboBox();
        this.remoteConnectionComboBox.setRenderer(new RemoteConnectionRenderer());
        for (PhpProjectProperties.UploadFiles uploadFiles : PhpProjectProperties.UploadFiles.values()) {
            this.uploadFilesComboBox.addItem(uploadFiles);
        }
        this.uploadFilesComboBox.setRenderer(new RemoteUploadRenderer());
        for (int i = 0; i < this.textFields.length; ++i) {
            FieldUpdater fieldUpdater = new FieldUpdater(this.propertyNames[i], this.labels[i], this.textFields[i]);
            this.textFields[i].getDocument().addDocumentListener(fieldUpdater);
        }
        ComboBoxSelectedItemConvertor comboBoxSelectedItemConvertor = new ComboBoxSelectedItemConvertor(){

            public String convert(JComboBox jComboBox) {
                RemoteConfiguration remoteConfiguration = (RemoteConfiguration)jComboBox.getSelectedItem();
                assert (remoteConfiguration != null);
                return remoteConfiguration.getName();
            }
        };
        this.remoteConnectionComboBox.addActionListener(new ComboBoxUpdater("remote.connection", this.remoteConnectionLabel, this.remoteConnectionComboBox, comboBoxSelectedItemConvertor));
        ComboBoxSelectedItemConvertor comboBoxSelectedItemConvertor2 = new ComboBoxSelectedItemConvertor(){

            public String convert(JComboBox jComboBox) {
                PhpProjectProperties.UploadFiles uploadFiles = (PhpProjectProperties.UploadFiles)((Object)jComboBox.getSelectedItem());
                assert (uploadFiles != null);
                RunAsRemoteWeb.this.uploadFilesHintLabel.setText(uploadFiles.getDescription());
                return uploadFiles.name();
            }
        };
        this.uploadFilesComboBox.addActionListener(new ComboBoxUpdater("remote.upload", this.uploadFilesLabel, this.uploadFilesComboBox, comboBoxSelectedItemConvertor2));
        this.remoteConnectionComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsRemoteWeb.this.updateRemoteConnectionHint();
            }
        });
        this.uploadDirectoryTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            private void processUpdate() {
                RunAsRemoteWeb.this.updateRemoteConnectionHint();
            }
        });
        this.updateRemoteConnectionHint();
    }

    protected PhpProjectProperties.RunAsType getRunAsType() {
        return PhpProjectProperties.RunAsType.REMOTE;
    }

    protected String getDisplayName() {
        return this.displayName;
    }

    protected JComboBox getRunAsCombo() {
        return this.runAsComboBox;
    }

    protected JLabel getRunAsLabel() {
        return this.runAsLabel;
    }

    protected void loadFields() {
        for (int i = 0; i < this.textFields.length; ++i) {
            this.textFields[i].setText(this.getValue(this.propertyNames[i]));
        }
        this.selectRemoteConnection();
        PhpProjectProperties.UploadFiles uploadFiles = null;
        String string = this.getValue("remote.upload");
        if (string == null) {
            uploadFiles = DEFAULT_UPLOAD_FILES;
        } else {
            try {
                uploadFiles = PhpProjectProperties.UploadFiles.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                uploadFiles = DEFAULT_UPLOAD_FILES;
            }
        }
        this.uploadFilesComboBox.setSelectedItem((Object)uploadFiles);
    }

    protected void validateFields() {
        String string = this.urlTextField.getText();
        String string2 = this.indexFileTextField.getText();
        String string3 = this.argsTextField.getText();
        String string4 = RunAsValidator.validateWebFields(string, FileUtil.toFile((FileObject)this.getWebRoot()), string2, string3);
        if (string4 != null) {
            this.validateCategory(string4);
            return;
        }
        RemoteConfiguration remoteConfiguration = (RemoteConfiguration)this.remoteConnectionComboBox.getSelectedItem();
        assert (remoteConfiguration != null);
        if (remoteConfiguration == NO_REMOTE_CONFIGURATION) {
            this.validateCategory(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"MSG_NoConfigurationSelected"));
            return;
        }
        if (remoteConfiguration == MISSING_REMOTE_CONFIGURATION) {
            this.validateCategory(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"MSG_NonExistingConfigurationSelected"));
            return;
        }
        string4 = RunAsValidator.validateUploadDirectory(this.uploadDirectoryTextField.getText(), true);
        if (string4 != null) {
            this.validateCategory(string4);
            return;
        }
        this.validateCategory(null);
    }

    private void validateCategory(String string) {
        this.category.setErrorMessage(string);
        this.category.setValid(true);
    }

    private FileObject getWebRoot() {
        return ProjectPropertiesSupport.getSourceSubdirectory(this.project, this.properties.getWebRoot());
    }

    private void populateRemoteConnectionComboBox() {
        List<RemoteConfiguration> list = RemoteConnections.get().getRemoteConfigurations();
        if (list.isEmpty()) {
            list = Arrays.asList(NO_REMOTE_CONFIGURATION);
        }
        DefaultComboBoxModel<RemoteConfiguration> defaultComboBoxModel = new DefaultComboBoxModel<RemoteConfiguration>(new Vector<RemoteConfiguration>(list));
        this.remoteConnectionComboBox.setModel(defaultComboBoxModel);
    }

    private void selectRemoteConnection() {
        String string = this.getValue("remote.connection");
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.remoteConnectionComboBox.getModel();
        if (string == null && defaultComboBoxModel.getIndexOf(NO_REMOTE_CONFIGURATION) != -1) {
            this.remoteConnectionComboBox.setSelectedItem(NO_REMOTE_CONFIGURATION);
            return;
        }
        int n = this.remoteConnectionComboBox.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            RemoteConfiguration remoteConfiguration = (RemoteConfiguration)this.remoteConnectionComboBox.getItemAt(i);
            if (string != null && !"".equals(string) && !string.equals(remoteConfiguration.getName())) continue;
            this.remoteConnectionComboBox.setSelectedItem(remoteConfiguration);
            return;
        }
        this.remoteConnectionComboBox.addItem(MISSING_REMOTE_CONFIGURATION);
        this.remoteConnectionComboBox.setSelectedItem(MISSING_REMOTE_CONFIGURATION);
    }

    void updateRemoteConnectionHint() {
        RemoteConfiguration remoteConfiguration = (RemoteConfiguration)this.remoteConnectionComboBox.getSelectedItem();
        if (remoteConfiguration == NO_REMOTE_CONFIGURATION || remoteConfiguration == MISSING_REMOTE_CONFIGURATION) {
            this.remoteConnectionHintLabel.setText(" ");
            return;
        }
        this.remoteConnectionHintLabel.setText(RunAsValidator.composeUploadDirectoryHint(remoteConfiguration.getHost(), remoteConfiguration.getInitialDirectory(), this.uploadDirectoryTextField.getText()));
    }

    private void initComponents() {
        this.runAsLabel = new JLabel();
        this.runAsComboBox = new JComboBox();
        this.urlLabel = new JLabel();
        this.urlTextField = new JTextField();
        this.indexFileLabel = new JLabel();
        this.indexFileTextField = new JTextField();
        this.indexFileBrowseButton = new JButton();
        this.argsLabel = new JLabel();
        this.argsTextField = new JTextField();
        this.urlHintLabel = new JTextArea();
        this.remoteConnectionLabel = new JLabel();
        this.remoteConnectionComboBox = new JComboBox();
        this.manageRemoteConnectionButton = new JButton();
        this.uploadDirectoryLabel = new JLabel();
        this.uploadDirectoryTextField = new JTextField();
        this.remoteConnectionHintLabel = new JLabel();
        this.uploadFilesLabel = new JLabel();
        this.uploadFilesComboBox = new JComboBox();
        this.uploadFilesHintLabel = new JLabel();
        this.setFocusTraversalPolicy(null);
        this.runAsLabel.setLabelFor(this.runAsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_RunAs"));
        this.urlLabel.setLabelFor(this.urlTextField);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_ProjectUrl"));
        this.indexFileLabel.setLabelFor(this.indexFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.indexFileLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_IndexFile"));
        this.indexFileTextField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.indexFileBrowseButton, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_Browse"));
        this.indexFileBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsRemoteWeb.this.indexFileBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.argsLabel.setLabelFor(this.argsTextField);
        Mnemonics.setLocalizedText((JLabel)this.argsLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_Arguments"));
        this.urlHintLabel.setEditable(false);
        this.urlHintLabel.setLineWrap(true);
        this.urlHintLabel.setRows(2);
        this.urlHintLabel.setWrapStyleWord(true);
        this.urlHintLabel.setBorder(null);
        this.urlHintLabel.setDisabledTextColor(UIManager.getDefaults().getColor("Label.disabledForeground"));
        this.urlHintLabel.setEnabled(false);
        this.urlHintLabel.setOpaque(false);
        this.remoteConnectionLabel.setLabelFor(this.remoteConnectionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.remoteConnectionLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_FtpConnection"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageRemoteConnectionButton, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_Manage"));
        this.manageRemoteConnectionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsRemoteWeb.this.manageRemoteConnectionButtonActionPerformed(actionEvent);
            }
        });
        this.uploadDirectoryLabel.setLabelFor(this.uploadDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.uploadDirectoryLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_UploadDirectory"));
        Mnemonics.setLocalizedText((JLabel)this.remoteConnectionHintLabel, (String)"dummy");
        this.remoteConnectionHintLabel.setEnabled(false);
        this.uploadFilesLabel.setLabelFor(this.uploadFilesComboBox);
        Mnemonics.setLocalizedText((JLabel)this.uploadFilesLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_UploadFiles"));
        Mnemonics.setLocalizedText((JLabel)this.uploadFilesHintLabel, (String)"dummy");
        this.uploadFilesHintLabel.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.remoteConnectionLabel).add((Component)this.uploadDirectoryLabel).add((Component)this.uploadFilesLabel).add((Component)this.urlLabel).add((Component)this.runAsLabel).add((Component)this.indexFileLabel).add((Component)this.argsLabel, -2, 72, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.remoteConnectionHintLabel).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.urlTextField, -1, 229, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.indexFileTextField, -1, 132, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.indexFileBrowseButton)).add((Component)this.argsTextField, -1, 229, Short.MAX_VALUE).add((Component)this.urlHintLabel).add(1, (Component)this.uploadFilesHintLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.remoteConnectionComboBox, 0, 132, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.manageRemoteConnectionButton)).add(1, (Component)this.uploadDirectoryTextField, -1, 229, Short.MAX_VALUE).add(1, (Component)this.uploadFilesComboBox, 0, 229, Short.MAX_VALUE).add(1, (Component)this.runAsComboBox, 0, 229, Short.MAX_VALUE)).add(0, 0, 0)))));
        groupLayout.linkSize(new Component[]{this.indexFileBrowseButton, this.manageRemoteConnectionButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.runAsLabel).add((Component)this.runAsComboBox, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.urlLabel).add((Component)this.urlTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.indexFileLabel).add((Component)this.indexFileTextField, -2, -1, -2).add((Component)this.indexFileBrowseButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.argsLabel).add((Component)this.argsTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.urlHintLabel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.remoteConnectionLabel).add((Component)this.manageRemoteConnectionButton).add((Component)this.remoteConnectionComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.uploadDirectoryLabel).add((Component)this.uploadDirectoryTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.remoteConnectionHintLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.uploadFilesLabel).add((Component)this.uploadFilesComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.uploadFilesHintLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.runAsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsLabel.AccessibleContext.accessibleName"));
        this.runAsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsLabel.AccessibleContext.accessibleDescription"));
        this.runAsComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsComboBox.AccessibleContext.accessibleName"));
        this.runAsComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsComboBox.AccessibleContext.accessibleDescription"));
        this.urlLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlLabel.AccessibleContext.accessibleName"));
        this.urlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlLabel.AccessibleContext.accessibleDescription"));
        this.urlTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlTextField.AccessibleContext.accessibleName"));
        this.urlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlTextField.AccessibleContext.accessibleDescription"));
        this.indexFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileLabel.AccessibleContext.accessibleName"));
        this.indexFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileLabel.AccessibleContext.accessibleDescription"));
        this.indexFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileTextField.AccessibleContext.accessibleName"));
        this.indexFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileTextField.AccessibleContext.accessibleDescription"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileBrowseButton.AccessibleContext.accessibleName"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.argsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.argsLabel.AccessibleContext.accessibleName"));
        this.argsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.argsLabel.AccessibleContext.accessibleDescription"));
        this.argsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.argsTextField.AccessibleContext.accessibleName"));
        this.argsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.argsTextField.AccessibleContext.accessibleDescription"));
        this.urlHintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlHintLabel.AccessibleContext.accessibleName"));
        this.urlHintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlHintLabel.AccessibleContext.accessibleDescription"));
        this.remoteConnectionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionLabel.AccessibleContext.accessibleName"));
        this.remoteConnectionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionLabel.AccessibleContext.accessibleDescription"));
        this.remoteConnectionComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionComboBox.AccessibleContext.accessibleName"));
        this.remoteConnectionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionComboBox.AccessibleContext.accessibleDescription"));
        this.manageRemoteConnectionButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.manageRemoteConnectionButton.AccessibleContext.accessibleName"));
        this.manageRemoteConnectionButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.manageRemoteConnectionButton.AccessibleContext.accessibleDescription"));
        this.uploadDirectoryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryLabel.AccessibleContext.accessibleName"));
        this.uploadDirectoryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryLabel.AccessibleContext.accessibleDescription"));
        this.uploadDirectoryTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryTextField.AccessibleContext.accessibleName"));
        this.uploadDirectoryTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryTextField.AccessibleContext.accessibleDescription"));
        this.remoteConnectionHintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionHintLabel.AccessibleContext.accessibleName"));
        this.remoteConnectionHintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionHintLabel.AccessibleContext.accessibleDescription"));
        this.uploadFilesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesLabel.AccessibleContext.accessibleName"));
        this.uploadFilesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesLabel.AccessibleContext.accessibleDescription"));
        this.uploadFilesComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesComboBox.AccessibleContext.accessibleName"));
        this.uploadFilesComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesComboBox.AccessibleContext.accessibleDescription"));
        this.uploadFilesHintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesHintLabel.AccessibleContext.accessibleName"));
        this.uploadFilesHintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesHintLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.AccessibleContext.accessibleDescription"));
    }

    private void manageRemoteConnectionButtonActionPerformed(ActionEvent actionEvent) {
        if (RemoteConnections.get().openManager((RemoteConfiguration)this.remoteConnectionComboBox.getSelectedItem())) {
            this.populateRemoteConnectionComboBox();
            this.selectRemoteConnection();
        }
    }

    private void indexFileBrowseButtonActionPerformed(ActionEvent actionEvent) {
        Utils.browseFolderFile(this.getWebRoot(), this.indexFileTextField);
    }

    private static class RemoteUploadRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 86192358777523629L;

        public RemoteUploadRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof PhpProjectProperties.UploadFiles);
            this.setName("ComboBox.listRenderer");
            this.setText(((PhpProjectProperties.UploadFiles)((Object)object)).getLabel());
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private static class RemoteConnectionRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 93621381917558630L;

        public RemoteConnectionRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof RemoteConfiguration);
            this.setName("ComboBox.listRenderer");
            RemoteConfiguration remoteConfiguration = (RemoteConfiguration)object;
            this.setText(remoteConfiguration.getDisplayName());
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setBackground(jList.getBackground());
            }
            this.setForeground(this.getForeground(remoteConfiguration, jList, bl));
            return this;
        }

        private Color getForeground(RemoteConfiguration remoteConfiguration, JList jList, boolean bl) {
            if (remoteConfiguration == MISSING_REMOTE_CONFIGURATION || remoteConfiguration == NO_REMOTE_CONFIGURATION) {
                return UIManager.getColor("nb.errorForeground");
            }
            return bl ? jList.getSelectionForeground() : jList.getForeground();
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private class ComboBoxUpdater
    implements ActionListener {
        private final JLabel label;
        private final JComboBox field;
        private final String propName;
        private final ComboBoxSelectedItemConvertor comboBoxConvertor;

        public ComboBoxUpdater(String string, JLabel jLabel, JComboBox jComboBox, ComboBoxSelectedItemConvertor comboBoxSelectedItemConvertor) {
            this.propName = string;
            this.label = jLabel;
            this.field = jComboBox;
            this.comboBoxConvertor = comboBoxSelectedItemConvertor;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.comboBoxConvertor.convert(this.field);
            RunAsRemoteWeb.this.putValue(this.propName, string);
            RunAsRemoteWeb.this.markAsModified(this.label, this.propName, string);
            RunAsRemoteWeb.this.validateFields();
        }
    }

    static interface ComboBoxSelectedItemConvertor {
        public String convert(JComboBox var1);
    }

    private class FieldUpdater
    extends RunAsPanel.InsidePanel.TextFieldUpdater {
        public FieldUpdater(String string, JLabel jLabel, JTextField jTextField) {
            super(string, jLabel, jTextField);
        }

        protected final String getDefaultValue() {
            return RunAsRemoteWeb.this.getDefaultValue(this.getPropName());
        }

        protected void processUpdate() {
            super.processUpdate();
            String string = "";
            try {
                string = RunAsValidator.composeUrlHint(RunAsRemoteWeb.this.urlTextField.getText(), RunAsRemoteWeb.this.indexFileTextField.getText(), RunAsRemoteWeb.this.argsTextField.getText());
            }
            catch (RunAsValidator.InvalidUrlException invalidUrlException) {
                RunAsRemoteWeb.this.category.setErrorMessage(invalidUrlException.getMessage());
                RunAsRemoteWeb.this.category.setValid(false);
            }
            RunAsRemoteWeb.this.urlHintLabel.setText(string);
        }
    }
}

