/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.extexecution.api.ExecutionDescriptor;
import org.netbeans.modules.extexecution.api.ExecutionService;
import org.netbeans.modules.extexecution.api.ExternalProcessBuilder;
import org.netbeans.modules.extexecution.api.input.InputProcessor;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.actions.Displayable;
import org.netbeans.modules.php.project.ui.actions.RunCommand;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.php.project.util.PhpInterpreter;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunLocalCommand
extends Command
implements Displayable {
    public static final String ID = "run.local";

    public RunLocalCommand(PhpProject phpProject) {
        super(phpProject);
    }

    @Override
    public void invokeAction(Lookup lookup) throws IllegalArgumentException {
        try {
            this.getCallable(lookup).call();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public final Callable<Cancellable> getCallable(final Lookup lookup) {
        return new Callable<Cancellable>(){

            @Override
            public Cancellable call() throws Exception {
                File file;
                PhpInterpreter phpInterpreter = ProjectPropertiesSupport.getPhpInterpreter(RunLocalCommand.this.getProject());
                FileObject fileObject = lookup == null ? RunLocalCommand.this.fileForProject(false) : RunLocalCommand.this.fileForContext(lookup);
                File file2 = file = fileObject != null ? FileUtil.toFile((FileObject)fileObject) : null;
                if (!phpInterpreter.isValid() || file == null) {
                    return new Cancellable(){

                        public boolean cancel() {
                            return true;
                        }
                    };
                }
                ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().controllable(RunLocalCommand.this.isControllable()).frontWindow(true).inputVisible(false).showProgress(true).optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory");
                InOutPostRedirector inOutPostRedirector = new InOutPostRedirector(file);
                executionDescriptor = executionDescriptor.outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)inOutPostRedirector);
                executionDescriptor = executionDescriptor.postExecution((Runnable)inOutPostRedirector);
                ExecutionService executionService = ExecutionService.newService((Callable)RunLocalCommand.this.getBuilder(phpInterpreter, file), (ExecutionDescriptor)executionDescriptor, (String)RunLocalCommand.this.getOutputTabTitle(phpInterpreter.getInterpreter(), file));
                final Future future = executionService.run();
                return new Cancellable(){

                    public boolean cancel() {
                        return future.cancel(true);
                    }
                };
            }
        };
    }

    private ExternalProcessBuilder getBuilder(PhpInterpreter phpInterpreter, File file) {
        ExternalProcessBuilder externalProcessBuilder = new ExternalProcessBuilder(phpInterpreter.getInterpreter());
        for (String string : phpInterpreter.getParameters()) {
            externalProcessBuilder = externalProcessBuilder.addArgument(string);
        }
        externalProcessBuilder = externalProcessBuilder.addArgument(file.getName());
        String string = ProjectPropertiesSupport.getArguments(this.getProject());
        if (string != null && string.length() > 0) {
            for (String string2 : Arrays.asList(string.split(" "))) {
                externalProcessBuilder = externalProcessBuilder.addArgument(string2);
            }
        }
        externalProcessBuilder = externalProcessBuilder.workingDirectory(file.getParentFile());
        externalProcessBuilder = this.initProcessBuilder(externalProcessBuilder);
        return externalProcessBuilder;
    }

    @Override
    public boolean isActionEnabled(Lookup lookup) throws IllegalArgumentException {
        return (lookup == null ? this.fileForProject(false) : this.fileForContext(lookup)) != null;
    }

    @Override
    public String getCommandId() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(RunCommand.class, (String)"LBL_RunLocalCommand");
    }

    protected boolean isControllable() {
        return true;
    }

    protected ExternalProcessBuilder initProcessBuilder(ExternalProcessBuilder externalProcessBuilder) {
        return externalProcessBuilder;
    }

    private static File tempFileForScript(File file) throws IOException {
        File file2 = File.createTempFile(file.getName(), ".html");
        file2.deleteOnExit();
        return file2;
    }

    private static class InOutPostRedirector
    implements ExecutionDescriptor.InputProcessorFactory,
    Runnable {
        private BufferedWriter fileWriter;
        private final File tmpFile;
        private Charset encoding;

        public InOutPostRedirector(File file) throws IOException {
            this.tmpFile = FileUtil.normalizeFile((File)RunLocalCommand.tempFileForScript(file));
            this.encoding = FileEncodingQuery.getEncoding((FileObject)FileUtil.toFileObject((File)file));
        }

        public InputProcessor newInputProcessor() {
            return new InputProcessor(){

                public void processInput(char[] cArray) throws IOException {
                    InOutPostRedirector.this.getFileWriter().write(cArray);
                }

                public void reset() throws IOException {
                }

                public void close() throws IOException {
                    InOutPostRedirector.this.getFileWriter().flush();
                    InOutPostRedirector.this.getFileWriter().close();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: {
                try {
                    block8: {
                        try {
                            PhpOptions phpOptions = PhpOptions.getInstance();
                            if (phpOptions.isOpenResultInBrowser()) {
                                HtmlBrowser.URLDisplayer.getDefault().showURL(this.tmpFile.toURL());
                            }
                            if (!phpOptions.isOpenResultInEditor()) break block8;
                            FileObject fileObject = FileUtil.toFileObject((File)this.tmpFile);
                            DataObject dataObject = DataObject.find((FileObject)fileObject);
                            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                            editorCookie.open();
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                            Object var6_10 = null;
                            this.setFileWriter(null);
                            break block9;
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                            Object var6_11 = null;
                            this.setFileWriter(null);
                            break block9;
                        }
                        catch (CancellationException cancellationException) {
                            Object var6_12 = null;
                            this.setFileWriter(null);
                            break block9;
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                            Object var6_13 = null;
                            this.setFileWriter(null);
                        }
                    }
                    Object var6_9 = null;
                    this.setFileWriter(null);
                }
                catch (Throwable throwable) {
                    Object var6_14 = null;
                    this.setFileWriter(null);
                    throw throwable;
                }
            }
        }

        public synchronized BufferedWriter getFileWriter() throws FileNotFoundException {
            if (this.fileWriter == null) {
                this.fileWriter = Command.writer(new FileOutputStream(this.tmpFile), this.encoding);
            }
            return this.fileWriter;
        }

        public synchronized void setFileWriter(BufferedWriter bufferedWriter) {
            this.fileWriter = bufferedWriter;
        }
    }
}

