/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.spi.XDebugStarter;
import org.netbeans.modules.php.project.ui.actions.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.DebugCommand;
import org.netbeans.modules.php.project.ui.actions.DebugLocalCommand;
import org.netbeans.modules.php.project.ui.actions.XDebugStarterFactory;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DebugSingleCommand
extends DebugCommand {
    public static final String ID = "debug.single";
    public static String DISPLAY_NAME = DebugCommand.DISPLAY_NAME;
    private final DebugLocalCommand debugLocalCommand;

    public DebugSingleCommand(PhpProject phpProject) {
        super(phpProject);
        this.debugLocalCommand = new DebugLocalCommand(phpProject);
    }

    public void invokeAction(Lookup lookup) throws IllegalArgumentException {
        if (!this.isRunConfigurationValid()) {
            return;
        }
        if (this.isScriptSelected()) {
            this.debugLocalCommand.invokeAction(lookup);
        } else {
            boolean bl;
            FileObject fileObject = this.fileForContext(lookup);
            final URL[] uRLArray = new URL[1];
            try {
                uRLArray[0] = this.getURLForDebug(lookup, true);
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            this.eventuallyUploadFiles(CommandUtils.filesForSelectedNodes());
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        DebugSingleCommand.this.showURLForDebug(uRLArray[0]);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                }
            };
            boolean bl2 = WebClientToolsSessionStarterService.isAvailable();
            if (bl2 && !(bl = WebClientToolsProjectUtils.showDebugDialog((Project)this.getProject()))) {
                return;
            }
            if (!bl2 || WebClientToolsProjectUtils.getServerDebugProperty((Project)this.getProject())) {
                XDebugStarter xDebugStarter = XDebugStarterFactory.getInstance();
                if (xDebugStarter != null) {
                    if (xDebugStarter.isAlreadyRunning()) {
                        String string = NbBundle.getMessage(DebugSingleCommand.class, (String)"MSG_NoMoreDebugSession");
                        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 2);
                        boolean bl3 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.OK_OPTION);
                        if (bl3) {
                            xDebugStarter.stop();
                            this.invokeAction(lookup);
                        }
                    } else {
                        this.startDebugger(xDebugStarter, runnable, fileObject, this.isScriptSelected());
                    }
                }
            } else {
                runnable.run();
            }
        }
    }

    public boolean isActionEnabled(Lookup lookup) throws IllegalArgumentException {
        boolean bl;
        FileObject fileObject = this.fileForContext(lookup);
        boolean bl2 = bl = fileObject != null;
        if (this.isScriptSelected()) {
            bl = this.isPhpFileSelected(fileObject);
        }
        return bl && XDebugStarterFactory.getInstance() != null;
    }

    public String getCommandId() {
        return ID;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }
}

