/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.io.File;
import java.util.concurrent.Callable;
import org.netbeans.modules.extexecution.api.ExternalProcessBuilder;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.spi.XDebugStarter;
import org.netbeans.modules.php.project.ui.actions.RunCommand;
import org.netbeans.modules.php.project.ui.actions.RunLocalCommand;
import org.netbeans.modules.php.project.ui.actions.XDebugStarterFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DebugLocalCommand
extends RunLocalCommand {
    public static final String ID = "debug.local";

    public DebugLocalCommand(PhpProject phpProject) {
        super(phpProject);
    }

    public void invokeAction(Lookup lookup) throws IllegalArgumentException {
        Callable<Cancellable> callable = this.getCallable(lookup);
        XDebugStarter xDebugStarter = XDebugStarterFactory.getInstance();
        if (xDebugStarter != null) {
            if (xDebugStarter.isAlreadyRunning()) {
                String string = NbBundle.getMessage(DebugLocalCommand.class, (String)"MSG_NoMoreDebugSession");
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 2);
                boolean bl = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.OK_OPTION);
                if (bl) {
                    xDebugStarter.stop();
                    this.invokeAction(lookup);
                }
            } else {
                xDebugStarter.start(this.getProject(), callable, lookup == null ? this.fileForProject(false) : this.fileForContext(lookup), this.isScriptSelected());
            }
        }
    }

    protected boolean isControllable() {
        return false;
    }

    protected String getOutputTabTitle(String string, File file) {
        return super.getOutputTabTitle(string, file) + " " + NbBundle.getMessage(DebugLocalCommand.class, (String)"MSG_Suffix_Debug");
    }

    public boolean isActionEnabled(Lookup lookup) throws IllegalArgumentException {
        return (lookup == null ? this.fileForProject(false) : this.fileForContext(lookup)) != null && XDebugStarterFactory.getInstance() != null;
    }

    public String getCommandId() {
        return ID;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RunCommand.class, (String)"LBL_DebugLocalCommand");
    }

    protected ExternalProcessBuilder initProcessBuilder(ExternalProcessBuilder externalProcessBuilder) {
        ExternalProcessBuilder externalProcessBuilder2 = super.initProcessBuilder(externalProcessBuilder);
        return externalProcessBuilder2.addEnvironmentVariable("XDEBUG_CONFIG", "idekey=netbeans-xdebug");
    }
}

