/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.text.actions;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.UIManager;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.ModelViewMapper;
import org.netbeans.modules.visualweb.designer.SelectionManager;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.text.DesignerPaneBase;
import org.netbeans.modules.visualweb.text.actions.TextAction;
import org.w3c.dom.Element;

public class NextVisualPositionAction
extends TextAction {
    private boolean select;
    private int direction;

    public NextVisualPositionAction(String string, boolean bl, int n) {
        super(string);
        this.select = bl;
        this.direction = n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DesignerPaneBase designerPaneBase = this.getTextComponent(actionEvent);
        if (designerPaneBase != null) {
            Object object;
            if (!designerPaneBase.hasCaret()) {
                boolean bl = this.select;
                this.moveSelection(designerPaneBase.getWebForm(), this.direction, bl);
                return;
            }
            DomProvider.DomPosition domPosition = designerPaneBase.getCaretDot();
            Point point = designerPaneBase.getCaretMagicPosition();
            if (point == null && (this.direction == 1 || this.direction == 5)) {
                object = designerPaneBase.getWebForm();
                Rectangle rectangle = ((WebForm)object).modelToView(domPosition);
                point = new Point(rectangle.x, rectangle.y);
            }
            object = domPosition;
            domPosition = designerPaneBase.getUI().getNextVisualPositionFrom(designerPaneBase, domPosition, this.direction);
            if (domPosition == DomProvider.DomPosition.NONE || !designerPaneBase.getWebForm().isInsideEditableRegion(domPosition)) {
                designerPaneBase.setCaretDot((DomProvider.DomPosition)object);
                UIManager.getLookAndFeel().provideErrorFeedback(designerPaneBase);
                return;
            }
            if (this.select) {
                designerPaneBase.moveCaretDot(domPosition);
            } else {
                designerPaneBase.setCaretDot(domPosition);
            }
            if (point != null && (this.direction == 1 || this.direction == 5)) {
                designerPaneBase.setCaretMagicPosition(point);
            }
        }
    }

    private void moveSelection(WebForm webForm, int n, boolean bl) {
        SelectionManager selectionManager = webForm.getSelection();
        if (selectionManager.isSelectionEmpty()) {
            return;
        }
        int n2 = selectionManager.getNumSelected();
        ArrayList<Point> arrayList = new ArrayList<Point>(n2);
        ArrayList<CssBox> arrayList2 = new ArrayList<CssBox>(n2);
        for (Element element : selectionManager.getSelectedComponentRootElements()) {
            CssBox cssBox = ModelViewMapper.findBoxForComponentRootElement(webForm.getPane().getPageBox(), element);
            if (cssBox == null || !cssBox.getBoxType().isAbsolutelyPositioned()) continue;
            arrayList2.add(cssBox);
            arrayList.add(new Point(cssBox.getAbsoluteX(), cssBox.getAbsoluteY()));
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        switch (n) {
            case 3: {
                if (bl) {
                    n3 = n5;
                    break;
                }
                n3 = webForm.getGridWidth();
                break;
            }
            case 7: {
                if (bl) {
                    n3 = -n5;
                    break;
                }
                n3 = -webForm.getGridWidth();
                break;
            }
            case 1: {
                if (bl) {
                    n4 = -n5;
                    break;
                }
                n4 = -webForm.getGridHeight();
                break;
            }
            case 5: {
                n4 = bl ? n5 : webForm.getGridHeight();
            }
        }
        webForm.getDomDocument().moveComponents(webForm, arrayList2.toArray(new CssBox[arrayList2.size()]), arrayList.toArray(new Point[arrayList.size()]), DomProvider.DomPosition.NONE, n3, n4, !bl);
    }
}

