/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.Keymap;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.css2.ModelViewMapper;
import org.netbeans.modules.visualweb.css2.PageBox;
import org.netbeans.modules.visualweb.designer.BasicDragGestureRecognizer;
import org.netbeans.modules.visualweb.designer.BasicDropTargetListener;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.text.DesignerPaneBase;
import org.netbeans.modules.visualweb.text.DesignerPaneBaseUI;
import org.w3c.dom.Element;

public class DesignerPaneUI
extends DesignerPaneBaseUI {
    private static TextDropTargetListener defaultDropTargetListener = null;
    private long prev1 = 0L;
    private long prev2 = 0L;
    private long prev3 = 0L;
    transient PageBox pageBox;
    transient DesignerPane editor;
    transient boolean painted = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new DesignerPaneUI();
    }

    public PageBox getPageBox() {
        return this.pageBox;
    }

    protected String getPropertyPrefix() {
        return "EditorPane";
    }

    ActionMap getActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("requestFocus", new FocusAction());
        Action[] actionArray = this.getComponent().getActions();
        if (actionArray != null) {
            this.addActions(actionMapUIResource, actionArray);
        }
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return actionMapUIResource;
    }

    void removeActions(ActionMap actionMap, Action[] actionArray) {
        if (DesignerUtils.DEBUG) {
            DesignerUtils.debugLog(this.getClass().getName() + ".removeActions(ActionMap, Action[])");
        }
        if (actionMap == null) {
            throw new IllegalArgumentException("Null action map.");
        }
        if (actionArray == null) {
            throw new IllegalArgumentException("Null action array.");
        }
        for (Action action : actionArray) {
            actionMap.remove(action.getValue("Name"));
        }
    }

    void addActions(ActionMap actionMap, Action[] actionArray) {
        if (DesignerUtils.DEBUG) {
            DesignerUtils.debugLog(this.getClass().getName() + ".addActions(ActionMap, Action[])");
        }
        if (actionMap == null) {
            throw new IllegalArgumentException("Null action map.");
        }
        if (actionArray == null) {
            throw new IllegalArgumentException("Null action array.");
        }
        for (Action action : actionArray) {
            actionMap.put(action.getValue("Name"), action);
        }
    }

    protected String getKeymapName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    protected Keymap createKeymap() {
        String string = this.getKeymapName();
        Keymap keymap = DesignerPaneBase.getKeymap(string);
        if (keymap == null) {
            Keymap keymap2 = DesignerPaneBase.getKeymap("default");
            keymap = DesignerPaneBase.addKeymap(string, keymap2);
            String string2 = this.getPropertyPrefix();
            Object object = UIManager.get(string2 + ".keyBindings");
            if (object != null && object instanceof DesignerPaneBase.KeyBinding[]) {
                DesignerPaneBase.KeyBinding[] keyBindingArray = (DesignerPaneBase.KeyBinding[])object;
                DesignerPaneBase.loadKeymap(keymap, keyBindingArray, this.getComponent().getActions());
            }
        }
        return keymap;
    }

    protected void installDefaults() {
        DropTarget dropTarget;
        Border border;
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Color color5;
        WebForm webForm = this.editor.getWebForm();
        this.editor.addMouseListener(webForm.getManager().getMouseHandler());
        this.editor.addMouseMotionListener(webForm.getManager().getMouseHandler());
        String string = this.getPropertyPrefix();
        Font font = this.editor.getFont();
        if (font == null || font instanceof UIResource) {
            this.editor.setFont(UIManager.getFont(string + ".font"));
        }
        if ((color5 = this.editor.getBackground()) == null || color5 instanceof UIResource) {
            this.editor.setBackground(UIManager.getColor(string + ".background"));
        }
        if ((color4 = this.editor.getForeground()) == null || color4 instanceof UIResource) {
            this.editor.setForeground(UIManager.getColor(string + ".foreground"));
        }
        if ((color3 = this.editor.getCaretColor()) == null || color3 instanceof UIResource) {
            this.editor.setCaretColor(UIManager.getColor(string + ".caretForeground"));
        }
        if ((color2 = this.editor.getSelectionColor()) == null || color2 instanceof UIResource) {
            this.editor.setSelectionColor(UIManager.getColor(string + ".selectionBackground"));
        }
        if ((color = this.editor.getSelectedTextColor()) == null || color instanceof UIResource) {
            this.editor.setSelectedTextColor(UIManager.getColor(string + ".selectionForeground"));
        }
        if ((border = this.editor.getBorder()) == null || border instanceof UIResource) {
            this.editor.setBorder(UIManager.getBorder(string + ".border"));
        }
        if ((dropTarget = this.editor.getDropTarget()) != null) {
            this.getDropTargetListener();
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                DesignerPaneUI.log(tooManyListenersException);
            }
        }
    }

    private TextDropTargetListener getDropTargetListener() {
        if (defaultDropTargetListener == null) {
            defaultDropTargetListener = new TextDropTargetListener();
        }
        return defaultDropTargetListener;
    }

    protected void uninstallDefaults() {
        DropTarget dropTarget;
        WebForm webForm = this.editor.getWebForm();
        this.editor.removeMouseListener(webForm.getManager().getMouseHandler());
        this.editor.removeMouseMotionListener(webForm.getManager().getMouseHandler());
        if (this.editor.getCaretColor() instanceof UIResource) {
            this.editor.setCaretColor(null);
        }
        if (this.editor.getSelectionColor() instanceof UIResource) {
            this.editor.setSelectionColor(null);
        }
        if (this.editor.getSelectedTextColor() instanceof UIResource) {
            this.editor.setSelectedTextColor(null);
        }
        if (this.editor.getBorder() instanceof UIResource) {
            this.editor.setBorder(null);
        }
        if (this.editor.getTransferHandler() instanceof UIResource) {
            this.editor.setTransferHandler(null);
        }
        if ((dropTarget = this.editor.getDropTarget()) != null && defaultDropTargetListener != null) {
            dropTarget.removeDropTargetListener(defaultDropTargetListener);
        }
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installKeyboardActions() {
        ActionMap actionMap;
        this.editor.setKeymap(this.createKeymap());
        InputMap inputMap = this.getInputMap();
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.editor, 0, inputMap);
        }
        if ((actionMap = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.editor, actionMap);
        }
    }

    InputMap getInputMap() {
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        InputMap inputMap = (InputMap)UIManager.get(this.getPropertyPrefix() + ".focusInputMap");
        if (inputMap != null) {
            inputMapUIResource.setParent(inputMap);
        }
        return inputMapUIResource;
    }

    void updateFocusTraversalKeys() {
        Set<AWTKeyStroke> set = this.editor.getFocusTraversalKeys(0);
        Set<AWTKeyStroke> set2 = this.editor.getFocusTraversalKeys(1);
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(set);
        HashSet<AWTKeyStroke> hashSet2 = new HashSet<AWTKeyStroke>(set2);
        hashSet.remove(KeyStroke.getKeyStroke(9, 0));
        hashSet2.remove(KeyStroke.getKeyStroke(9, 1));
        this.editor.setFocusTraversalKeys(0, hashSet);
        this.editor.setFocusTraversalKeys(1, hashSet2);
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        for (Action action : this.editor.getActions()) {
            actionMapUIResource.put(action.getValue("Name"), action);
        }
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        this.editor.setKeymap(null);
        SwingUtilities.replaceUIInputMap(this.editor, 2, null);
        SwingUtilities.replaceUIActionMap(this.editor, null);
    }

    protected final DesignerPaneBase getComponent() {
        return this.editor;
    }

    public void resetPageBox() {
        WebForm webForm = this.editor.getWebForm();
        Element element = webForm.getHtmlBody();
        if (element == null) {
            this.setPageBox(null);
        } else {
            this.setPageBox(PageBox.getPageBox(this.editor, webForm, element));
        }
        webForm.getManager().setInsertBox(null, null);
    }

    protected final void setPageBox(PageBox pageBox) {
        if (DesignerUtils.DEBUG) {
            DesignerUtils.debugLog(this.getClass().getName() + ".setPageBox(PageBox)");
        }
        if (this.pageBox != null) {
            this.pageBox.boxRemoved();
        }
        this.pageBox = pageBox;
        this.updateViewport();
        this.painted = false;
        this.editor.repaint();
        if (this.pageBox != null) {
            this.pageBox.boxAdded();
        }
    }

    protected void paintSafely(Graphics graphics) {
        this.painted = true;
        long l = 0L;
        Graphics2D graphics2D = (Graphics2D)graphics;
        WebForm webForm = this.editor.getWebForm();
        graphics.getClipBounds(DesignerPane.clip);
        DesignerPane.clipBr.x = DesignerPane.clip.x + DesignerPane.clip.width;
        DesignerPane.clipBr.y = DesignerPane.clip.y + DesignerPane.clip.height;
        this.pageBox.paint(graphics2D);
        webForm.getManager().paint(graphics2D);
        if (this.editor.hasCaret()) {
            this.editor.paintCaret(graphics);
        }
    }

    public void installUI(JComponent jComponent) {
        if (DesignerUtils.DEBUG) {
            DesignerUtils.debugLog(this.getClass().getName() + ".installUI(JComponent)");
        }
        if (jComponent == null) {
            throw new IllegalArgumentException("Null component.");
        }
        if (!(jComponent instanceof DesignerPane)) {
            throw new Error("DesignerPaneBaseUI needs DesignerPaneBase");
        }
        this.editor = (DesignerPane)jComponent;
        this.installDefaults();
        this.editor.setOpaque(false);
        this.editor.setAutoscrolls(true);
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        if (DesignerUtils.DEBUG) {
            DesignerUtils.debugLog(this.getClass().getName() + ".uninstallUI(JComponent)");
        }
        if (jComponent == null) {
            throw new IllegalArgumentException("Null component.");
        }
        this.painted = false;
        this.uninstallDefaults();
        this.uninstallKeyboardActions();
        this.uninstallListeners();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public final void paint(Graphics graphics, JComponent jComponent) {
        if (this.pageBox != null) {
            WebForm webForm = this.editor.getWebForm();
            try {
                this.paintSafely(graphics);
            }
            catch (Exception exception) {
                DesignerPaneUI.log(exception);
            }
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (DesignerUtils.DEBUG) {
            DesignerUtils.debugLog(this.getClass().getName() + ".getPreferredSize(JComponent)");
        }
        if (jComponent == null) {
            throw new IllegalArgumentException("Null component.");
        }
        Insets insets = jComponent.getInsets();
        Dimension dimension = jComponent.getSize();
        if (this.pageBox == null) {
            return dimension;
        }
        if (dimension.width > insets.left + insets.right && dimension.height > insets.top + insets.bottom) {
            this.pageBox.setSize(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        } else if (dimension.width == 0 && dimension.height == 0) {
            this.pageBox.setSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        dimension.width = (int)Math.min((long)this.pageBox.getPreferredSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)this.pageBox.getPreferredSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (DesignerUtils.DEBUG) {
            DesignerUtils.debugLog(this.getClass().getName() + ".getMinimumSize(JComponent)");
        }
        if (jComponent == null) {
            throw new IllegalArgumentException("Null component.");
        }
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension();
        if (this.pageBox == null) {
            return dimension;
        }
        dimension.width = (int)this.pageBox.getMinimumSpan(0) + insets.left + insets.right;
        dimension.height = (int)this.pageBox.getMinimumSpan(1) + insets.top + insets.bottom;
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (DesignerUtils.DEBUG) {
            DesignerUtils.debugLog(this.getClass().getName() + ".getMaximumSize(JComponent)");
        }
        if (jComponent == null) {
            throw new IllegalArgumentException("Null component.");
        }
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension();
        if (this.pageBox == null) {
            return dimension;
        }
        dimension.width = (int)Math.min((long)this.pageBox.getMaximumSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)this.pageBox.getMaximumSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return dimension;
    }

    public DomProvider.DomPosition getNextVisualPositionFrom(DesignerPaneBase designerPaneBase, DomProvider.DomPosition domPosition, int n) {
        if (DesignerUtils.DEBUG) {
            DesignerUtils.debugLog(this.getClass().getName() + ".getNextVisualPositionFrom(DesignerPaneBase, Position, int)");
        }
        if (designerPaneBase == null) {
            throw new IllegalArgumentException("Null designer pane.");
        }
        if (domPosition == null) {
            throw new IllegalArgumentException("Null position.");
        }
        if (this.painted) {
            WebForm webForm = this.editor.getWebForm();
            switch (n) {
                case 7: {
                    return ModelViewMapper.computeArrowLeft(webForm, domPosition);
                }
                case 3: {
                    return ModelViewMapper.computeArrowRight(webForm, domPosition);
                }
                case 1: {
                    return ModelViewMapper.computeArrowUp(webForm, domPosition);
                }
                case 5: {
                    return ModelViewMapper.computeArrowDown(webForm, domPosition);
                }
            }
            return DomProvider.DomPosition.NONE;
        }
        return DomProvider.DomPosition.NONE;
    }

    void updateViewport() {
        JViewport jViewport = null;
        Container container = this.editor.getParent();
        if (container instanceof JViewport) {
            jViewport = (JViewport)container;
        }
        if (this.pageBox != null) {
            this.pageBox.setViewport(jViewport);
        }
    }

    private static void log(Exception exception) {
        Logger logger = DesignerPaneUI.getLogger();
        logger.log(Level.INFO, null, exception);
    }

    private static Logger getLogger() {
        return Logger.getLogger(DesignerPaneUI.class.getName());
    }

    static class TextDropTargetListener
    extends BasicDropTargetListener {
        DomProvider.DomPosition dot = DomProvider.DomPosition.NONE;
        DomProvider.DomPosition mark = DomProvider.DomPosition.NONE;
        boolean visible;

        TextDropTargetListener() {
        }

        protected void saveComponentState(JComponent jComponent) {
            DesignerPaneBase designerPaneBase = (DesignerPaneBase)jComponent;
            if (designerPaneBase.hasCaret()) {
                this.dot = designerPaneBase.getCaretPosition();
                this.mark = designerPaneBase.getCaretMark();
                this.visible = designerPaneBase.isCaretVisible();
            }
            DesignerPane designerPane = (DesignerPane)jComponent;
            if (designerPaneBase.hasCaret() && !designerPane.getWebForm().isGridMode()) {
                designerPaneBase.setCaretVisible(true);
            }
        }

        protected void restoreComponentState(JComponent jComponent) {
            DesignerPaneBase designerPaneBase = (DesignerPaneBase)jComponent;
            if (designerPaneBase.hasCaret()) {
                designerPaneBase.setCaretDot(this.mark);
                designerPaneBase.moveCaretDot(this.dot);
                designerPaneBase.setCaretVisible(this.visible);
            }
        }

        protected void restoreComponentStateForDrop(JComponent jComponent) {
            DesignerPaneBase designerPaneBase = (DesignerPaneBase)jComponent;
            if (designerPaneBase.hasCaret()) {
                designerPaneBase.setCaretVisible(this.visible);
            }
        }
    }

    static class TextDragGestureRecognizer
    extends BasicDragGestureRecognizer {
        TextDragGestureRecognizer() {
        }

        protected boolean isDragPossible(MouseEvent mouseEvent) {
            if (super.isDragPossible(mouseEvent)) {
                DomProvider.DomPosition domPosition;
                DesignerPaneBase designerPaneBase = (DesignerPaneBase)this.getComponent(mouseEvent);
                if (!designerPaneBase.hasCaret()) {
                    return false;
                }
                DomProvider.DomPosition domPosition2 = designerPaneBase.getCaretDot();
                if (!domPosition2.equals(domPosition = designerPaneBase.getCaretMark())) {
                    Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                    WebForm webForm = ((DesignerPane)designerPaneBase).getWebForm();
                    DomProvider.DomPosition domPosition3 = webForm.viewToModel(point);
                    if (webForm.getManager().getInlineEditor() == null || !webForm.getManager().getInlineEditor().isDocumentEditor()) {
                        boolean bl = !webForm.isGridMode();
                        domPosition3 = ModelViewMapper.findValidPosition(webForm, domPosition3, bl, webForm.getManager().getInlineEditor());
                    }
                    DomProvider.DomPosition domPosition4 = webForm.first(domPosition2, domPosition);
                    DomProvider.DomPosition domPosition5 = webForm.last(domPosition2, domPosition);
                    if (domPosition3.isLaterThan(domPosition4) && domPosition3.isStrictlyEarlierThan(domPosition5)) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    class FocusAction
    extends AbstractAction {
        FocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DesignerPaneUI.this.editor.requestFocus();
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

