/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.DesignerTransferHandler;

public class DesignerPaneDropTarget
extends DropTarget {
    private static final DropTargetListener DEFAULT_TRANSFER_HANDLER_DROP_TARGET_LISTENER = new DefaultTransferHandlerDropTargetListener();
    private EventListenerList listenerList;

    public DesignerPaneDropTarget(DesignerPane designerPane) {
        this.setComponent(designerPane);
        try {
            super.addDropTargetListener(DEFAULT_TRANSFER_HANDLER_DROP_TARGET_LISTENER);
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DropTargetListener.class, dropTargetListener);
    }

    public void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(DropTargetListener.class, dropTargetListener);
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        super.dragEnter(dropTargetDragEvent);
        if (this.listenerList != null) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DropTargetListener.class) continue;
                ((DropTargetListener)objectArray[i + 1]).dragEnter(dropTargetDragEvent);
            }
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        super.dragOver(dropTargetDragEvent);
        if (this.listenerList != null) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DropTargetListener.class) continue;
                ((DropTargetListener)objectArray[i + 1]).dragOver(dropTargetDragEvent);
            }
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        super.dragExit(dropTargetEvent);
        if (this.listenerList != null) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DropTargetListener.class) continue;
                ((DropTargetListener)objectArray[i + 1]).dragExit(dropTargetEvent);
            }
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.listenerList != null) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DropTargetListener.class) continue;
                ((DropTargetListener)objectArray[i + 1]).drop(dropTargetDropEvent);
            }
        }
        super.drop(dropTargetDropEvent);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        super.dropActionChanged(dropTargetDragEvent);
        if (this.listenerList != null) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DropTargetListener.class) continue;
                ((DropTargetListener)objectArray[i + 1]).dropActionChanged(dropTargetDragEvent);
            }
        }
    }

    private static class DefaultTransferHandlerDropTargetListener
    implements DropTargetListener {
        private boolean canImport;

        private DefaultTransferHandlerDropTargetListener() {
        }

        private boolean actionSupported(int n) {
            return (n & 0x40000003) != 0;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
            JComponent jComponent = (JComponent)dropTargetDragEvent.getDropTargetContext().getComponent();
            TransferHandler transferHandler = jComponent.getTransferHandler();
            boolean bl = transferHandler instanceof DesignerTransferHandler ? ((DesignerTransferHandler)transferHandler).canImport(jComponent, dataFlavorArray, dropTargetDragEvent.getTransferable()) : (transferHandler == null ? false : transferHandler.canImport(jComponent, dataFlavorArray));
            this.canImport = bl;
            int n = dropTargetDragEvent.getDropAction();
            if (this.canImport && this.actionSupported(n)) {
                dropTargetDragEvent.acceptDrag(n);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            int n = dropTargetDragEvent.getDropAction();
            if (this.canImport && this.actionSupported(n)) {
                dropTargetDragEvent.acceptDrag(n);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            int n = dropTargetDropEvent.getDropAction();
            JComponent jComponent = (JComponent)dropTargetDropEvent.getDropTargetContext().getComponent();
            TransferHandler transferHandler = jComponent.getTransferHandler();
            if (this.canImport && transferHandler != null && this.actionSupported(n)) {
                dropTargetDropEvent.acceptDrop(n);
                try {
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    dropTargetDropEvent.dropComplete(transferHandler.importData(jComponent, transferable));
                }
                catch (RuntimeException runtimeException) {
                    dropTargetDropEvent.dropComplete(false);
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            int n = dropTargetDragEvent.getDropAction();
            if (this.canImport && this.actionSupported(n)) {
                dropTargetDragEvent.acceptDrag(n);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }
    }
}

