/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.css2.ModelViewMapper;
import org.netbeans.modules.visualweb.css2.PageBox;
import org.netbeans.modules.visualweb.designer.DesignerPaneDropTarget;
import org.netbeans.modules.visualweb.designer.DesignerPaneUI;
import org.netbeans.modules.visualweb.designer.DesignerTransferHandler;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.DndHandler;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.netbeans.modules.visualweb.text.DesignerPaneBase;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DesignerPane
extends DesignerPaneBase {
    static boolean useAlpha = true;
    private static int adjustX = 0;
    private static int adjustY = 0;
    public static final Rectangle clip = new Rectangle();
    public static final Point clipBr = new Point();
    private Rectangle dirty = new Rectangle();
    public static boolean INCREMENTAL_LAYOUT = System.getProperty("rave.designer.noclip") == null;
    public static final boolean DEBUG_REPAINT = false;
    private DndHandler dndHandler;
    private final DesignerTransferHandler designerTransferHandler;
    private boolean grid = false;
    private DropTargetListener gridDropListener = null;
    private final WebForm webform;
    private FontMetrics metrics;
    private FontMetrics boldMetrics;
    private long lastEscape = -1L;

    public DesignerPane(WebForm webForm) {
        this.webform = webForm;
        this.designerTransferHandler = new DesignerTransferHandler(webForm);
        this.installActions();
        this.init();
    }

    private void installActions() {
        this.installEscapeAction();
    }

    private void installEscapeAction() {
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "escape-multiplex");
        actionMap.put("escape-multiplex", new EscapeAction(this));
    }

    private void init() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        CellRendererPane cellRendererPane = this.webform.getRenderPane();
        this.add(cellRendererPane);
        this.setDropTarget(new DesignerPaneDropTarget(this));
        this.dndHandler = new DndHandler(this.webform);
        this.setTransferHandler(this.designerTransferHandler);
        this.updateUI();
        this.setGridDropListener(true);
        this.initA11Y();
    }

    private void initA11Y() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DesignerPane.class, (String)"ACSN_DesignerPane"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DesignerPane.class, (String)"ACSD_DesignerPane"));
    }

    public void updateUI() {
        DesignerPane.fine("Updating UI, ui=" + this.ui);
        PageBox pageBox = this.ui instanceof DesignerPaneUI ? ((DesignerPaneUI)this.ui).getPageBox() : null;
        DesignerPane.fine("pageBox=" + pageBox);
        this.setUI(DesignerPaneUI.createUI(this));
        DesignerPane.fine("after update, ui=" + this.ui);
        if (pageBox != null && this.ui instanceof DesignerPaneUI) {
            ((DesignerPaneUI)this.ui).setPageBox(pageBox);
        }
        this.invalidate();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (DesignerPane.isDocumentEmpty(this.webform.getHtmlBody())) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.paintCenteredText(graphics2D);
        }
    }

    private void paintCenteredText(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4;
        String string = this.isGridMode() ? NbBundle.getMessage(DesignerPane.class, (String)"GridText") : NbBundle.getMessage(DesignerPane.class, (String)"FlowText");
        int n5 = 1;
        int n6 = string.length();
        for (n4 = 0; n4 < n6; ++n4) {
            if (string.charAt(n4) != '\n') continue;
            ++n5;
        }
        n4 = this.getWidth();
        n6 = this.getHeight();
        if (this.webform.getPageSizeWidth() != -1) {
            n4 = this.webform.getPageSizeWidth();
            n6 = this.webform.getPageSizeHeight();
        }
        int n7 = n6 / 2;
        Font font = UIManager.getFont("Label.font");
        graphics2D.setFont(font);
        FontMetrics fontMetrics = DesignerUtils.getFontMetrics(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        int n8 = fontMetrics.getHeight() + 3;
        int n9 = n7 - n8 * n5 / 2;
        int n10 = n4;
        int n11 = 0;
        int n12 = 0;
        for (int i = 0; i < n5; ++i) {
            String string2;
            n3 = string.indexOf(10, n12);
            if (n3 != -1) {
                string2 = string.substring(n12, n3);
                n12 = n3 + 1;
            } else {
                string2 = string.substring(n12);
            }
            Rectangle2D rectangle2D = font.getStringBounds(string2, fontRenderContext);
            n2 = (n4 - (int)rectangle2D.getWidth()) / 2;
            if (n2 < n10) {
                n10 = n2;
            }
            if ((n = n2 + (int)rectangle2D.getWidth()) <= n11) continue;
            n11 = n;
        }
        Color color = null;
        if (this.webform.getHtmlBody() != null) {
            color = CssProvider.getValueService().getColorForElement(this.webform.getHtmlBody(), 0);
        }
        if (color == null) {
            color = this.getBackground();
        }
        graphics2D.setColor(color);
        n3 = n9;
        int n13 = n9 + n5 * n8;
        graphics2D.fillRect(n10 - 5, n3, n11 - n10 + 10, n13 - n3 + 10);
        graphics2D.setColor(this.webform.getColors().gridColor);
        n12 = 0;
        int n14 = n9 + 10;
        n14 += fontMetrics.getHeight() - fontMetrics.getDescent();
        for (n2 = 0; n2 < n5; ++n2) {
            String string3;
            n = string.indexOf(10, n12);
            if (n != -1) {
                string3 = string.substring(n12, n);
                n12 = n + 1;
            } else {
                string3 = string.substring(n12);
            }
            Rectangle2D rectangle2D = font.getStringBounds(string3, fontRenderContext);
            int n15 = (n4 - (int)rectangle2D.getWidth()) / 2;
            graphics2D.drawString(string3, n15, n14);
            n14 += n8;
        }
    }

    void setGridMode(boolean bl) {
        if (this.grid == bl) {
            return;
        }
        this.grid = bl;
        this.webform.getSelection().clearSelection(true);
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(2));
        }
        this.webform.getManager().setInsertBox(null, null);
        DomProvider.DomPosition domPosition = this.getCaretPosition();
        this.select(domPosition, domPosition);
        if (bl) {
            this.hideCaret();
        } else {
            this.showCaretAtBeginning();
        }
        if (this.isShowing()) {
            this.invalidate();
            this.revalidate();
            this.getParent().validate();
            this.repaint();
        }
    }

    private void setGridDropListener(boolean bl) {
        DropTarget dropTarget = this.getDropTarget();
        if (dropTarget != null) {
            if (bl) {
                if (this.gridDropListener == null) {
                    this.gridDropListener = new DesignerDropHandler(this);
                }
                try {
                    dropTarget.addDropTargetListener(this.gridDropListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    tooManyListenersException.printStackTrace();
                }
            } else if (this.gridDropListener != null) {
                dropTarget.removeDropTargetListener(this.gridDropListener);
            }
        }
    }

    public void showCaretAtBeginning() {
        DomProvider.DomPosition domPosition = ModelViewMapper.getFirstDocumentPosition(this.webform, true);
        if (domPosition == DomProvider.DomPosition.NONE) {
            this.hideCaret();
        } else {
            this.showCaret(domPosition);
        }
    }

    public void hideCaret() {
        if (this.hasCaret()) {
            this.setCaret(null);
        }
    }

    public void showCaret(DomProvider.DomPosition domPosition) {
        if (domPosition == DomProvider.DomPosition.NONE) {
            this.hideCaret();
            return;
        }
        if (!this.hasCaret()) {
            this.createCaret();
        }
        this.setCaretDot(domPosition);
    }

    public void repaint() {
        super.repaint();
    }

    public boolean isGridMode() {
        return this.grid;
    }

    public static int getAdjustX() {
        return adjustX;
    }

    public static int getAdjustY() {
        return adjustY;
    }

    public WebForm getWebForm() {
        return this.webform;
    }

    public DesignerPaneUI getPaneUI() {
        DesignerPaneUI designerPaneUI = (DesignerPaneUI)this.getUI();
        return designerPaneUI;
    }

    public void updateViewport() {
        DesignerPaneUI designerPaneUI = (DesignerPaneUI)this.getUI();
        designerPaneUI.updateViewport();
    }

    public DndHandler getDndHandler() {
        return this.dndHandler;
    }

    public FontMetrics getMetrics() {
        if (this.metrics == null) {
            Font font = this.getFont();
            this.metrics = DesignerUtils.getFontMetrics(font);
        }
        return this.metrics;
    }

    public FontMetrics getBoldMetrics() {
        if (this.boldMetrics == null) {
            Font font = this.getFont();
            font = font.deriveFont(1);
            this.boldMetrics = DesignerUtils.getFontMetrics(font);
        }
        return this.boldMetrics;
    }

    public PageBox getPageBox() {
        return ((DesignerPaneUI)this.getUI()).getPageBox();
    }

    public static boolean isOutsideClip(int n, int n2, int n3, int n4) {
        return clip != null && n4 < DesignerPane.clip.y || n3 < DesignerPane.clip.x || DesignerPane.clipBr.y < n2 || DesignerPane.clipBr.x < n;
    }

    void clearDirty() {
        this.dirty = null;
    }

    void addDirtyPoint(int n, int n2) {
        if (this.dirty == null) {
            this.dirty = new Rectangle(n, n2, 0, 0);
        } else {
            this.dirty.add(n, n2);
        }
    }

    void addDirtyRectangle(int n, int n2, int n3, int n4) {
        if (this.dirty == null) {
            this.dirty = new Rectangle(n, n2, n3, n4);
        } else {
            this.dirty.add(n, n2);
            this.dirty.add(n + n3 + 1, n2 + n4 + 1);
        }
    }

    public void repaintDirty(boolean bl) {
        if (this.dirty != null) {
            this.repaint(this.dirty);
            this.clearDirty();
        } else if (bl) {
            this.repaint();
        }
    }

    private static boolean isDocumentEmpty(Element element) {
        Element element2;
        if (DesignerUtils.DEBUG) {
            DesignerUtils.debugLog(DesignerUtils.class.getName() + ".isDocumentEmpty(Document)");
        }
        if ((element2 = element) == null) {
            return true;
        }
        if (!element2.getTagName().equals(HtmlTag.BODY.name)) {
            return false;
        }
        if (element2.hasAttribute("background")) {
            return false;
        }
        if ((element2 = MarkupService.getSourceElementForElement((Element)element2)) == null) {
            return false;
        }
        NodeList nodeList = element2.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Element element3 = (Element)node;
                String string = element3.getTagName();
                if (string.equals(HtmlTag.BR.name)) continue;
                if (!string.endsWith("form")) {
                    return false;
                }
                if (++n2 > 1) {
                    return false;
                }
                if (element3.getChildNodes().getLength() == 0) continue;
                NodeList nodeList2 = element3.getChildNodes();
                int n3 = nodeList2.getLength();
                int n4 = 0;
                for (int j = 0; j < n3; ++j) {
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() == 1) {
                        if (HtmlTag.BR.name.equals(((Element)node2).getTagName())) {
                            if (++n4 <= 2) continue;
                            return false;
                        }
                        return false;
                    }
                    if (node2.getNodeType() != 3 || DesignerUtils.onlyWhitespace(node2.getNodeValue())) continue;
                    return false;
                }
                continue;
            }
            if (node.getNodeType() != 3 || DesignerUtils.onlyWhitespace(node.getNodeValue())) continue;
            return false;
        }
        return true;
    }

    public void list(PrintStream printStream, int n) {
        super.list(printStream, n);
        PageBox pageBox = this.getPageBox();
        if (pageBox == null) {
            return;
        }
        pageBox.list(printStream, n + 1);
    }

    public void list(PrintWriter printWriter, int n) {
        super.list(printWriter, n);
        PageBox pageBox = this.getPageBox();
        if (pageBox == null) {
            return;
        }
        pageBox.list(printWriter, n + 1);
    }

    private boolean seenEscape(long l) {
        if (this.lastEscape == l) {
            return true;
        }
        this.lastEscape = l;
        return false;
    }

    public void escape(long l) {
        if (!this.seenEscape(l)) {
            this.webform.getManager().getMouseHandler().escape();
        }
    }

    private static void fine(String string) {
        Logger logger = DesignerPane.getLogger();
        logger.fine(string);
    }

    private static void log(Throwable throwable) {
        Logger logger = DesignerPane.getLogger();
        logger.log(Level.INFO, null, throwable);
    }

    private static Logger getLogger() {
        return Logger.getLogger(DesignerPane.class.getName());
    }

    private static class EscapeAction
    extends DesignerPaneAction {
        public EscapeAction(DesignerPane designerPane) {
            super(designerPane);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.getDesignerPane().escape(actionEvent.getWhen());
        }
    }

    private static abstract class DesignerPaneAction
    extends AbstractAction {
        private final DesignerPane designerPane;

        public DesignerPaneAction(DesignerPane designerPane) {
            this.designerPane = designerPane;
        }

        protected DesignerPane getDesignerPane() {
            return this.designerPane;
        }
    }

    class DesignerDropHandler
    implements DropTargetListener {
        Component pane;
        Cursor org_cursor;

        public DesignerDropHandler(Component component) {
            this.pane = component;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DesignerPane.this.webform.getManager().setIgnoreCnC(true);
            if (DesignerPane.this.webform.isGridMode()) {
                ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/visualweb/designer/resources/drop_position.gif"));
                this.org_cursor = this.pane.getCursor();
                this.pane.setCursor(DragSource.DefaultCopyDrop);
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            this.pane.setCursor(this.org_cursor);
            DesignerPane.this.dndHandler.clearDropMatch();
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            Point point = dropTargetDragEvent.getLocation();
            Transferable transferable = dropTargetDragEvent.getTransferable();
            if (transferable != null) {
                try {
                    int n = DesignerPane.this.webform.getManager().updateDropState(point, false, transferable);
                    if (n == 0) {
                        dropTargetDragEvent.rejectDrag();
                    } else {
                        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                    }
                }
                catch (Throwable throwable) {
                    DesignerPane.log(throwable);
                }
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            DesignerPane.this.webform.getManager().setIgnoreCnC(false);
            Point point = dropTargetDropEvent.getLocation();
            DesignerPane.this.webform.getManager().updateDropState(point, true, null);
            DesignerPane.this.dndHandler.setDropAction(dropTargetDropEvent.getDropAction());
            DesignerPane.this.dndHandler.clearDropMatch();
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }
}

