/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssComputedValue;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssValue;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.ContainerBox;
import org.netbeans.modules.visualweb.css2.CreateContext;
import org.netbeans.modules.visualweb.css2.CssBorder;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.FloatingBoxInfo;
import org.netbeans.modules.visualweb.css2.FormatContext;
import org.netbeans.modules.visualweb.css2.LineBoxGroup;
import org.netbeans.modules.visualweb.designer.CssUtilities;
import org.netbeans.modules.visualweb.designer.Interaction;
import org.netbeans.modules.visualweb.designer.TableResizer;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlAttribute;
import org.netbeans.modules.visualweb.spi.designer.Decoration;
import org.openide.ErrorManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableBox
extends ContainerBox {
    private static final CellBox OCCUPIED = new OccupiedBox();
    private static final int BORDER_RESIZE_DISTANCE = 5;
    private Element table;
    private int columns = -1;
    private int rows = -1;
    private int cellPadding = 1;
    private int cellSpacing = 1;
    private int borderWidth = 0;
    private int frame = 143;
    private int rules = 143;
    private boolean fixedLayout;
    private CellBox[][] cells;
    private int[][] rowspans;
    private int[][] colspans;
    private Element[] rowElements;
    private int[] rowHeights;
    private boolean computingPrefWidth = false;
    private List<CssBox> captionBoxes;
    private boolean captionAbove;
    private int tableLeft;
    private int tableTop;
    private int tableRight;
    private int tableBottom;

    private TableBox(WebForm webForm, Element element, BoxType boxType, boolean bl, boolean bl2) {
        super(webForm, element, boxType, bl, bl2);
        this.table = element;
    }

    public static CssBox getTableBox(WebForm webForm, Element element, BoxType boxType, boolean bl, boolean bl2) {
        return new TableBox(webForm, element, boxType, bl, bl2);
    }

    protected void computeHorizNonInlineNormalFlow(FormatContext formatContext, int n) {
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.getElement(), 50);
        if (CssProvider.getValueService().isRaveCenterValue(cssValue)) {
            this.leftMargin = 0x7FFFFFFE;
            this.rightMargin = 0x7FFFFFFE;
            if (this.contentWidth == 0x7FFFFFFE) {
                int n2 = n - 0 - 0 - 0 - 0;
                this.contentWidth = this.shrinkToFit(n2, formatContext);
                this.contentWidth -= this.leftPadding + this.rightPadding + this.leftBorderWidth + this.rightBorderWidth;
            }
        }
        super.computeHorizNonInlineNormalFlow(formatContext, n);
    }

    private void fixedLayout(int[] nArray, FormatContext formatContext) {
        assert (this.rows > 0 && this.columns > 0);
        this.computeFixedColumnWidths(nArray, false);
        this.formatCells(nArray, formatContext);
        this.positionCells(nArray, formatContext);
    }

    private void computeFixedColumnWidths(int[] nArray, boolean bl) {
        int n;
        int n2;
        Object object;
        Object object2;
        int n3;
        int n4;
        for (n4 = 0; n4 < this.columns; ++n4) {
            nArray[n4] = 0x7FFFFFFE;
        }
        n4 = this.getTableWidth(bl);
        NodeList nodeList = this.table.getChildNodes();
        int n5 = nodeList.getLength();
        int n6 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            Node node = nodeList.item(n3);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            object2 = CssProvider.getEngineService().getComputedValueForElement(element, 22);
            if (CssProvider.getValueService().isTableColumnGroupValue((CssValue)object2)) {
                object = element.getChildNodes();
                int n7 = object.getLength();
                for (int i = 0; i < n7; ++i) {
                    Node node2 = object.item(i);
                    if (node2.getNodeType() != 1) continue;
                    Element element2 = (Element)node2;
                    if (!CssProvider.getValueService().isTableColumnValue(CssProvider.getEngineService().getComputedValueForElement(element2, 22))) continue;
                    int n8 = HtmlAttribute.getIntegerAttributeValue((Element)element2, (String)"span", (int)1);
                    if (n8 <= 0) {
                        n8 = 1;
                    }
                    this.computeFixedColumnWidth(nArray, n6, element2, n8, n4);
                    n6 += n8;
                }
                continue;
            }
            if (!CssProvider.getValueService().isTableColumnValue((CssValue)object2)) continue;
            int n9 = HtmlAttribute.getIntegerAttributeValue((Element)element, (String)"span", (int)1);
            if (n9 <= 0) {
                n9 = 1;
            }
            this.computeFixedColumnWidth(nArray, n6, element, n9, n4);
            n6 += n9;
        }
        n3 = 0;
        for (n2 = 0; n2 < this.columns; ++n2) {
            if (nArray[n2] != 0x7FFFFFFE) continue;
            n3 = 1;
            break;
        }
        if (n3 != 0) {
            n2 = 0;
            block4: for (int i = 0; i < n5 && n2 == 0; ++i) {
                object2 = nodeList.item(i);
                if (object2.getNodeType() != 1) continue;
                object = (Element)object2;
                CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement((Element)object, 22);
                if (CssProvider.getValueService().isTableRowValue(cssValue)) {
                    this.computeFixedColumnWidth(nArray, (Element)object, n4);
                    break;
                }
                if (!CssProvider.getValueService().isTableRowGroupValue(cssValue) && !CssProvider.getValueService().isTableHeaderGroupValue(cssValue) && !CssProvider.getValueService().isTableFooterGroupValue(cssValue)) continue;
                NodeList nodeList2 = object.getChildNodes();
                int n10 = nodeList2.getLength();
                for (int j = 0; j < n10; ++j) {
                    Node node = nodeList2.item(j);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    if (!CssProvider.getValueService().isTableRowValue(CssProvider.getEngineService().getComputedValueForElement(element, 22))) continue;
                    this.computeFixedColumnWidth(nArray, element, n4);
                    n2 = 1;
                    continue block4;
                }
            }
        }
        if ((n2 = this.countUnassignedColumns(nArray)) > 0) {
            int n11 = n4 / n2;
            int n12 = n4 % n2;
            int n13 = 0;
            for (int i = 0; i < n2; ++i) {
                while (nArray[n13] != 0x7FFFFFFE) {
                    ++n13;
                }
                nArray[n13] = n11;
                if (i == 0) {
                    int n14 = n13;
                    nArray[n14] = nArray[n14] + n12;
                }
                ++n13;
            }
        }
        int n15 = 0;
        for (n = 0; n < this.columns; ++n) {
            n15 += nArray[n];
        }
        if (n15 >= n4) {
            n4 = n15;
        } else {
            n = n4 - n15;
            int n16 = 0;
            int n17 = 0;
            while (n17 < this.columns) {
                int n18 = nArray[n17] * n / n15;
                int n19 = n17++;
                nArray[n19] = nArray[n19] + n18;
                n16 += n18;
            }
            nArray[0] = nArray[0] + (n - n16);
        }
    }

    private void positionCells(int[] nArray, FormatContext formatContext) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray2 = null;
        int n8 = this.getTableHeight();
        if (n8 == 0x7FFFFFFE) {
            n8 = 0;
        } else {
            nArray2 = new int[this.rows];
        }
        this.rowHeights = new int[this.rows];
        for (n7 = 0; n7 < this.rows; ++n7) {
            n6 = 0;
            if (this.rowElements[n7] != null) {
                CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.rowElements[n7], 31);
                if (CssProvider.getValueService().isAutoValue(cssValue)) {
                    n6 = 0;
                    if (nArray2 != null) {
                        nArray2[n7] = 0x7FFFFFFE;
                    }
                } else {
                    int n9 = n5 = cssValue instanceof CssComputedValue && CssProvider.getValueService().isOfPrimitivePercentageType(((CssComputedValue)cssValue).getCascadedValue()) ? 1 : 0;
                    if (n5 != 0) {
                        n6 = 0;
                        n4 = (int)((CssComputedValue)cssValue).getCascadedValue().getFloatValue();
                        if (n4 < 0) {
                            n4 = 0;
                        }
                        if (nArray2 != null) {
                            nArray2[n7] = -n4;
                        }
                    } else {
                        n6 = (int)cssValue.getFloatValue();
                        if (n6 < 0) {
                            n6 = 0;
                        }
                        if (nArray2 != null) {
                            nArray2[n7] = n6;
                        }
                    }
                }
            }
            for (int i = 0; i < this.columns; ++i) {
                CellBox cellBox = this.cells[n7][i];
                if (cellBox == null || cellBox == OCCUPIED) continue;
                n4 = this.rowspans[n7][i];
                if (n4 == 1 && cellBox.getHeight() > n6) {
                    n6 = cellBox.getHeight();
                }
                n3 = this.colspans[n7][i];
                n2 = 0;
                for (n = 0; n < n3; ++n) {
                    n2 += nArray[i + n];
                }
                cellBox.width = n2 - this.cellSpacing;
                cellBox.contentWidth = cellBox.width - (cellBox.leftBorderWidth + cellBox.leftPadding + cellBox.rightPadding + cellBox.rightBorderWidth);
            }
            this.rowHeights[n7] = n6;
        }
        for (n7 = 0; n7 < this.rows; ++n7) {
            for (n6 = 0; n6 < this.columns; ++n6) {
                CellBox cellBox = this.cells[n7][n6];
                if (cellBox == null || cellBox == OCCUPIED || (n5 = this.rowspans[n7][n6]) <= 1) continue;
                n4 = 0;
                for (n3 = 0; n3 < n5; ++n3) {
                    n4 += this.rowHeights[n7 + n3];
                }
                if (cellBox.getHeight() <= n4) continue;
                n3 = cellBox.getHeight() - n4;
                n2 = 0;
                for (n = 0; n < n5; ++n) {
                    int n10 = n4 == 0 ? 0 : this.rowHeights[n7 + n] * n3 / n4;
                    int n11 = n7 + n;
                    this.rowHeights[n11] = this.rowHeights[n11] + n10;
                    n2 += n10;
                }
                int n12 = n7;
                this.rowHeights[n12] = this.rowHeights[n12] + (n3 - n2);
            }
        }
        this.contentHeight = 0;
        for (n7 = 0; n7 < this.rows; ++n7) {
            this.contentHeight += this.rowHeights[n7];
        }
        if (n8 > this.contentHeight) {
            int n13;
            n7 = n8 - this.contentHeight;
            n6 = 0;
            for (n13 = 0; n13 < this.rows; ++n13) {
                if (nArray2[n13] >= 0) continue;
                n5 = -nArray2[n13];
                n4 = n5 * n7 / 100;
                int n14 = n13;
                this.rowHeights[n14] = this.rowHeights[n14] + n4;
                if ((n6 += n4) <= n7) continue;
                int n15 = n13;
                this.rowHeights[n15] = this.rowHeights[n15] - (n6 - n7);
                n6 = n7;
                break;
            }
            if (n6 < n7) {
                n7 -= n6;
                n6 = 0;
                n13 = 0;
                for (n5 = 0; n5 < this.rows; ++n5) {
                    if (nArray2[n5] != 0x7FFFFFFE) continue;
                    n13 += this.rowHeights[n5];
                }
                if (n13 > 0) {
                    n5 = -1;
                    for (n4 = 0; n4 < this.rows; ++n4) {
                        if (nArray2[n4] != 0x7FFFFFFE) continue;
                        n3 = this.rowHeights[n4] * n7 / n13;
                        int n16 = n4;
                        this.rowHeights[n16] = this.rowHeights[n16] + n3;
                        n6 += n3;
                        n5 = n4;
                    }
                    int n17 = n5;
                    this.rowHeights[n17] = this.rowHeights[n17] + (n7 - n6);
                } else {
                    n5 = 0;
                    for (n4 = 0; n4 < this.rows; ++n4) {
                        if (nArray2[n4] >= 0) continue;
                        n3 = -nArray2[n4];
                        n5 += n3;
                    }
                    if (n5 > 0) {
                        n4 = -1;
                        for (n3 = 0; n3 < this.rows; ++n3) {
                            if (nArray2[n3] >= 0) continue;
                            n2 = -nArray2[n3];
                            n = n2 * n7 / n5;
                            int n18 = n3;
                            this.rowHeights[n18] = this.rowHeights[n18] + n;
                            n6 += n;
                            n4 = n3;
                        }
                        int n19 = n4;
                        this.rowHeights[n19] = this.rowHeights[n19] + (n7 - n6);
                    }
                }
            }
            this.contentHeight = 0;
            for (n13 = 0; n13 < this.rows; ++n13) {
                this.contentHeight += this.rowHeights[n13];
            }
        }
        this.contentHeight += this.cellSpacing;
        this.height = this.topBorderWidth + this.topPadding + this.contentHeight + this.bottomPadding + this.bottomBorderWidth;
        this.contentWidth = 0;
        for (n7 = 0; n7 < this.columns; ++n7) {
            this.contentWidth += nArray[n7];
        }
        this.contentWidth += this.cellSpacing;
        this.width = this.leftBorderWidth + this.leftPadding + this.contentWidth + this.rightPadding + this.rightBorderWidth;
        for (n7 = 0; n7 < this.rows; ++n7) {
            for (n6 = 0; n6 < this.columns; ++n6) {
                CellBox cellBox = this.cells[n7][n6];
                if (cellBox == null || cellBox == OCCUPIED) continue;
                n5 = this.rowspans[n7][n6];
                n4 = 0;
                for (n3 = 0; n3 < n5; ++n3) {
                    n4 += this.rowHeights[n7 + n3];
                }
                cellBox.height = n4 - this.cellSpacing;
                cellBox.contentHeight = cellBox.height - (cellBox.topBorderWidth + cellBox.topPadding + cellBox.bottomPadding + cellBox.bottomBorderWidth);
            }
        }
        this.formatCaption(formatContext, true, this.width, this.height);
        n7 = this.tableTop + this.topBorderWidth + this.topPadding + this.cellSpacing;
        for (n6 = 0; n6 < this.rows; ++n6) {
            int n20 = this.leftBorderWidth + this.leftPadding + this.cellSpacing + this.tableLeft;
            for (n5 = 0; n5 < this.columns; ++n5) {
                CellBox cellBox = this.cells[n6][n5];
                if (cellBox != null && cellBox != OCCUPIED) {
                    cellBox.setLocation(n20, n7);
                    cellBox.align();
                }
                n20 += nArray[n5];
            }
            n7 += this.rowHeights[n6];
        }
        this.formatCaption(formatContext, false, this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatCaption(FormatContext formatContext, boolean bl, int n, int n2) {
        if (this.captionBoxes == null) {
            return;
        }
        if (bl && this.captionAbove) {
            int n3;
            CssBox cssBox = null;
            int n4 = 0;
            int n5 = 0;
            int n6 = this.captionBoxes.size();
            for (n3 = 0; n3 < n6; ++n3) {
                CssBox cssBox2 = this.captionBoxes.get(n3);
                if (cssBox2.getBoxType().isNormalFlow()) {
                    cssBox = cssBox2;
                }
                cssBox2.setX(n4);
                cssBox2.setY(n5);
                int n7 = this.contentWidth;
                this.contentWidth = n;
                try {
                    this.layoutChild(cssBox2, formatContext, true);
                }
                finally {
                    this.contentWidth = n7;
                }
                this.height += cssBox2.height;
                this.contentHeight += cssBox2.height;
                n5 += cssBox2.height;
                if (cssBox2.width <= this.width) continue;
                int n8 = cssBox2.width - this.width;
                this.contentWidth += n8;
                this.width = cssBox2.width;
                this.tableRight = this.width - n;
            }
            if (cssBox != null) {
                n6 = cssBox.getCollapsedBottomMargin();
                int n9 = this.getCollapsedTopMargin();
                if (n6 >= 0 && n9 >= 0) {
                    n3 = Math.max(n6, n9);
                } else if (n6 < 0 && n9 < 0) {
                    n3 = Math.min(n6, n9);
                } else if (n6 >= 0 && n9 < 0) {
                    n3 = n6 + n9;
                } else {
                    assert (n6 < 0 && n9 >= 0);
                    n3 = n9 + n6;
                }
                this.tableTop = cssBox.getY() + cssBox.getHeight();
                this.effectiveTopMargin = n3;
                cssBox.effectiveTopMargin = 0;
            }
            this.tableRight = this.tableLeft + n;
            this.tableBottom = this.tableTop + n2;
        } else if (!bl && !this.captionAbove) {
            this.tableTop = 0;
            this.tableLeft = 0;
            this.tableBottom = this.height;
            int n10 = 0;
            int n11 = this.height;
            int n12 = this.captionBoxes.size();
            for (int i = 0; i < n12; ++i) {
                CssBox cssBox = this.captionBoxes.get(i);
                cssBox.setX(n10);
                cssBox.setY(n11);
                int n13 = this.contentWidth;
                this.contentWidth = n;
                try {
                    this.layoutChild(cssBox, formatContext, true);
                }
                finally {
                    this.contentWidth = n13;
                }
                this.height += cssBox.height;
                this.contentHeight += cssBox.height;
                n11 += cssBox.height;
                if (cssBox.width <= this.width) continue;
                int n14 = cssBox.width - this.width;
                this.contentWidth += n14;
                this.width = cssBox.width;
                this.tableRight = this.width - n;
            }
            this.tableRight = this.tableLeft + n;
        }
    }

    private int countUnassignedColumns(int[] nArray) {
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            if (nArray[i] != 0x7FFFFFFE) continue;
            ++n;
        }
        return n;
    }

    private void computeFixedColumnWidth(int[] nArray, int n, Element element, int n2, int n3) {
        int n4;
        int n5;
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 58);
        if (CssProvider.getValueService().isAutoValue(cssValue)) {
            n5 = 0x7FFFFFFE;
        } else {
            n4 = cssValue instanceof CssComputedValue && CssProvider.getValueService().isOfPrimitivePercentageType(((CssComputedValue)cssValue).getCascadedValue()) ? 1 : 0;
            n5 = n4 != 0 ? (int)((CssComputedValue)cssValue).getCascadedValue().getFloatValue() * n3 / 100 : (int)cssValue.getFloatValue();
        }
        if (n5 != 0x7FFFFFFE) {
            if (n2 > 1) {
                n4 = n5 / n2;
                for (int i = 0; i < n2 && n + i < this.columns; ++i) {
                    nArray[n + i] = n4;
                    if (i != 0) continue;
                    int n6 = n;
                    nArray[n6] = nArray[n6] + n5 % n2;
                }
            } else {
                nArray[n] = n5;
            }
        }
    }

    private void computeFixedColumnWidth(int[] nArray, Element element, int n) {
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element2, 22);
            if (CssProvider.getValueService().isTableCellValue(cssValue)) continue;
            int n4 = HtmlAttribute.getIntegerAttributeValue((Element)element2, (String)"colspan", (int)1);
            if (n4 <= 0) {
                n4 = 1;
            }
            this.computeFixedColumnWidth(nArray, n3, element2, n4, n);
            n3 += n4;
        }
    }

    protected void initializeBorder() {
        int n = this.borderWidth == 0 ? 0 : 8;
        this.border = CssBorder.getBorder(this.getElement(), this.borderWidth, n, this.frame);
        if (this.border != null) {
            this.leftBorderWidth = this.border.getLeftBorderWidth();
            this.topBorderWidth = this.border.getTopBorderWidth();
            this.bottomBorderWidth = this.border.getBottomBorderWidth();
            this.rightBorderWidth = this.border.getRightBorderWidth();
        }
        this.considerDesignBorder();
    }

    protected void createChildren(CreateContext createContext) {
        int n;
        int n2;
        Element element = TableBox.findCaption(this.getElement());
        this.captionAbove = true;
        if (element != null) {
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 17);
            if (CssProvider.getValueService().isBottomValue(cssValue)) {
                this.captionAbove = false;
            }
            this.finishLineBox(createContext);
            if (this.captionAbove) {
                this.addNode(createContext, element, null, null, null);
                int n3 = this.getBoxCount();
                this.captionBoxes = new ArrayList<CssBox>(n3);
                for (n2 = 0; n2 < n3; ++n2) {
                    this.captionBoxes.add(this.getBox(n2));
                }
            }
        }
        this.columns = TableBox.computeColumnCount(this.table);
        this.rows = TableBox.computeRowCount(this.table);
        this.cellSpacing = HtmlAttribute.getIntegerAttributeValue((Element)this.table, (String)"cellspacing", (int)2);
        this.cellPadding = HtmlAttribute.getIntegerAttributeValue((Element)this.table, (String)"cellpadding", (int)1);
        int n4 = 0;
        if (this.table.hasAttribute("frame")) {
            String string = this.table.getAttribute("frame");
            if (string.equals("above")) {
                this.frame = 1;
            } else if (string.equals("below")) {
                this.frame = 2;
            } else if (string.equals("hsides")) {
                this.frame = 3;
            } else if (string.equals("vsides")) {
                this.frame = 12;
            } else if (string.equals("lhs")) {
                this.frame = 4;
            } else if (string.equals("rhs")) {
                this.frame = 8;
            } else if (string.equals("void")) {
                this.frame = 0;
            } else if (string.length() == 0 || string.equals("box") || string.equals("border")) {
                this.frame = 15;
            }
            n4 = this.frame != 0 ? 1 : 0;
        }
        this.borderWidth = HtmlAttribute.getIntegerAttributeValue((Element)this.table, (String)"border", (int)n4);
        if (this.borderWidth < 0) {
            this.borderWidth = 0;
        }
        if (this.frame == 0) {
            this.borderWidth = 0;
        }
        this.fixedLayout = false;
        if (this.contentWidth != 0x7FFFFFFE) {
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.table, 49);
            if (CssProvider.getValueService().isFixedValue(cssValue)) {
                this.fixedLayout = true;
            }
        }
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.table, 4);
        if (this.table.hasAttribute("rules")) {
            String string = this.table.getAttribute("rules");
            if (string.equals("groups")) {
                this.rules = 15;
            } else if (string.equals("rows")) {
                this.rules = 3;
                cssValue = CssProvider.getValueService().getCollapseCssValueConstant();
            } else if (string.equals("cols")) {
                this.rules = 12;
                cssValue = CssProvider.getValueService().getCollapseCssValueConstant();
            } else if (string.equals("all")) {
                this.rules = 15;
                cssValue = CssProvider.getValueService().getCollapseCssValueConstant();
            }
        }
        if (CssProvider.getValueService().isCollapseValue(cssValue)) {
            this.cellSpacing = 0;
        }
        this.cells = new CellBox[this.rows][this.columns];
        this.rowspans = new int[this.rows][this.columns];
        this.colspans = new int[this.rows][this.columns];
        this.rowElements = new Element[this.rows];
        this.createCells();
        this.finishLineBox(createContext);
        for (n2 = this.rows - 1; n2 >= 0; --n2) {
            for (n = 0; n < this.columns; ++n) {
                CellBox cellBox = this.cells[n2][n];
                if (cellBox == null || cellBox == OCCUPIED) continue;
                cellBox.createChildren(createContext);
                this.finishLineBox(createContext);
            }
        }
        if (element != null && !this.captionAbove) {
            this.addNode(createContext, element, null, null, null);
            this.finishLineBox(createContext);
            n = this.getBoxCount();
            this.captionBoxes = new ArrayList<CssBox>(n - n2);
            for (n2 = this.getBoxCount(); n2 < n; ++n2) {
                this.captionBoxes.add(this.getBox(n2));
            }
        }
    }

    private static Element findCaption(Element element) {
        NodeList nodeList = element.getChildNodes();
        Element element2 = null;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element3 = (Element)node;
            if (!CssProvider.getValueService().isTableCaptionValue(CssProvider.getEngineService().getComputedValueForElement(element3, 22))) break;
            element2 = (Element)node;
            break;
        }
        return element2;
    }

    private void createCells() {
        int n;
        this.setProbableChildCount(this.rows * this.columns);
        int n2 = 0;
        NodeList nodeList = this.table.getChildNodes();
        int n3 = nodeList.getLength();
        int n4 = -1;
        int n5 = -1;
        for (n = 0; n < n3; ++n) {
            Node node = nodeList.item(n);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 22);
            if (CssProvider.getValueService().isTableRowValue(cssValue)) {
                this.createRowCells(n2, element);
                ++n2;
                continue;
            }
            if (!CssProvider.getValueService().isTableRowGroupValue(cssValue) && !CssProvider.getValueService().isTableHeaderGroupValue(cssValue) && !CssProvider.getValueService().isTableFooterGroupValue(cssValue)) continue;
            boolean bl = CssProvider.getValueService().isTableFooterGroupValue(cssValue);
            if (bl) {
                assert (n4 == -1);
                n4 = n2;
            }
            NodeList nodeList2 = element.getChildNodes();
            int n6 = nodeList2.getLength();
            for (int i = 0; i < n6; ++i) {
                Node node2 = nodeList2.item(i);
                if (node2.getNodeType() != 1) continue;
                Element element2 = (Element)node2;
                if (!CssProvider.getValueService().isTableRowValue(CssProvider.getEngineService().getComputedValueForElement(element2, 22))) continue;
                this.createRowCells(n2, element2);
                ++n2;
            }
            if (!bl) continue;
            n5 = n2;
        }
        if (n4 != -1 && n4 != n5) {
            n = n5 - n4;
            int n7 = this.rows - n;
            for (int i = 0; i < n; ++i) {
                this.swapRow(n4 + i, n7 + i);
            }
        }
    }

    private void swapRow(int n, int n2) {
        for (int i = 0; i < this.columns; ++i) {
            CellBox cellBox = this.cells[n2][i];
            this.cells[n2][i] = this.cells[n][i];
            this.cells[n][i] = cellBox;
            int n3 = this.rowspans[n2][i];
            this.rowspans[n2][i] = this.rowspans[n][i];
            this.rowspans[n][i] = n3;
            n3 = this.colspans[n2][i];
            this.colspans[n2][i] = this.colspans[n][i];
            this.colspans[n][i] = n3;
        }
        Element element = this.rowElements[n];
        this.rowElements[n] = this.rowElements[n2];
        this.rowElements[n2] = element;
    }

    private void createRowCells(int n, Element element) {
        this.rowElements[n] = element;
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element2, 22);
            if (!CssProvider.getValueService().isTableCellValue(cssValue)) continue;
            while (n3 < this.columns && this.cells[n][n3] == OCCUPIED) {
                ++n3;
            }
            n3 += this.createCell(element2, n, n3);
        }
    }

    private int createCell(Element element, int n, int n2) {
        if (n2 == this.columns) {
            return 0;
        }
        int n3 = HtmlAttribute.getIntegerAttributeValue((Element)element, (String)"colspan", (int)1);
        int n4 = HtmlAttribute.getIntegerAttributeValue((Element)element, (String)"rowspan", (int)1);
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        if (n2 + n3 > this.columns) {
            n3 = this.columns - n2;
        }
        if (n + n4 > this.rows) {
            n4 = this.rows - n;
        }
        this.colspans[n][n2] = n3;
        this.rowspans[n][n2] = n4;
        CellBox cellBox = new CellBox(this.webform, element, BoxType.STATIC, false, this);
        cellBox.row = n;
        cellBox.col = n2;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                this.cells[n + i][n2 + j] = OCCUPIED;
            }
        }
        this.cells[n][n2] = cellBox;
        cellBox.initialize();
        this.addBox(cellBox, null, null);
        return n3;
    }

    private void formatCells(int[] nArray, FormatContext formatContext) {
        List<FloatingBoxInfo> list = formatContext.floats;
        formatContext.floats = null;
        boolean bl = formatContext.floating;
        formatContext.floating = false;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                CellBox cellBox = this.cells[i][j];
                if (cellBox == null || cellBox == OCCUPIED) continue;
                this.formatCell(i, j, nArray, formatContext);
            }
        }
        formatContext.floats = list;
        formatContext.floating = bl;
    }

    private void formatCell(int n, int n2, int[] nArray, FormatContext formatContext) {
        int n3;
        CellBox cellBox = this.cells[n][n2];
        int n4 = this.colspans[n][n2];
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            n5 += nArray[n2 + n3];
        }
        n3 = n5;
        int n6 = this.containingBlockHeight / this.columns;
        cellBox.setContainingBlock(0, 0, n3, n6);
        cellBox.contentWidth = n3 - cellBox.leftBorderWidth - cellBox.leftPadding - cellBox.rightPadding - cellBox.rightBorderWidth;
        cellBox.contentHeight = n6 - cellBox.topBorderWidth - cellBox.topPadding - cellBox.bottomPadding - cellBox.bottomBorderWidth;
        cellBox.relayout(formatContext);
        cellBox.contentWidth = n3;
        cellBox.contentHeight = 0x7FFFFFFE;
        cellBox.inline = false;
        cellBox.replaced = false;
        cellBox.boxType = BoxType.STATIC;
        cellBox.computeVerticalLengths(formatContext);
        cellBox.height = cellBox.topBorderWidth + cellBox.topPadding + cellBox.contentHeight + cellBox.bottomPadding + cellBox.bottomBorderWidth + this.cellSpacing;
        cellBox.clearBottom(formatContext, CssProvider.getValueService().getBothCssValueConstant());
        cellBox.originalHeight = cellBox.height;
        int n7 = CssUtilities.getCssLength(cellBox.getElement(), 31);
        if (n7 != 0x7FFFFFFE && n7 > cellBox.contentHeight) {
            cellBox.contentHeight = n7;
            cellBox.height = cellBox.topBorderWidth + cellBox.topPadding + cellBox.contentHeight + cellBox.bottomPadding + cellBox.bottomBorderWidth + this.cellSpacing;
        }
        cellBox.finishAllRelatives(formatContext);
    }

    private static int countRow(Element element) {
        int n = 0;
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element2, 22);
            if (!CssProvider.getValueService().isTableCellValue(cssValue)) continue;
            int n3 = HtmlAttribute.getIntegerAttributeValue((Element)element2, (String)"colspan", (int)1);
            if (n3 <= 0) {
                n3 = 1;
            }
            n += n3;
        }
        return n;
    }

    private static int computeColumnCount(Element element) {
        Node node;
        int n;
        CssValue cssValue;
        Element element2;
        Node node2;
        int n2;
        int n3 = 0;
        NodeList nodeList = element.getChildNodes();
        int n4 = nodeList.getLength();
        for (n2 = 0; n2 < n4; ++n2) {
            node2 = nodeList.item(n2);
            if (node2.getNodeType() != 1) continue;
            element2 = (Element)node2;
            cssValue = CssProvider.getEngineService().getComputedValueForElement(element2, 22);
            if (CssProvider.getValueService().isTableColumnGroupValue(cssValue)) {
                boolean bl = true;
                NodeList nodeList2 = element2.getChildNodes();
                n = nodeList2.getLength();
                for (int i = 0; i < n; ++i) {
                    node = nodeList2.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element3 = (Element)node;
                    if (!CssProvider.getValueService().isTableColumnValue(CssProvider.getEngineService().getComputedValueForElement(element3, 22))) continue;
                    bl = false;
                    n3 += HtmlAttribute.getIntegerAttributeValue((Element)element3, (String)"span", (int)1);
                }
                if (!bl) continue;
                n3 += HtmlAttribute.getIntegerAttributeValue((Element)element2, (String)"span", (int)1);
                continue;
            }
            if (!CssProvider.getValueService().isTableColumnValue(cssValue)) continue;
            n3 += HtmlAttribute.getIntegerAttributeValue((Element)element2, (String)"span", (int)1);
        }
        if (n3 > 0) {
            return n3;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            node2 = nodeList.item(n2);
            if (node2.getNodeType() != 1) continue;
            element2 = (Element)node2;
            cssValue = CssProvider.getEngineService().getComputedValueForElement(element2, 22);
            if (CssProvider.getValueService().isTableRowValue(cssValue)) {
                int n5 = TableBox.countRow(element2);
                if (n5 <= n3) continue;
                n3 = n5;
                continue;
            }
            if (!CssProvider.getValueService().isTableRowGroupValue(cssValue) && !CssProvider.getValueService().isTableHeaderGroupValue(cssValue) && !CssProvider.getValueService().isTableFooterGroupValue(cssValue)) continue;
            NodeList nodeList3 = element2.getChildNodes();
            int n6 = nodeList3.getLength();
            for (n = 0; n < n6; ++n) {
                int n7;
                Node node3 = nodeList3.item(n);
                if (node3.getNodeType() != 1) continue;
                node = (Element)node3;
                if (!CssProvider.getValueService().isTableRowValue(CssProvider.getEngineService().getComputedValueForElement((Element)node, 22)) || (n7 = TableBox.countRow((Element)node)) <= n3) continue;
                n3 = n7;
            }
        }
        return n3;
    }

    private static int computeRowCount(Element element) {
        int n = 0;
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element2, 22);
            if (CssProvider.getValueService().isTableRowValue(cssValue)) {
                ++n;
                continue;
            }
            if (!CssProvider.getValueService().isTableRowGroupValue(cssValue) && !CssProvider.getValueService().isTableHeaderGroupValue(cssValue) && !CssProvider.getValueService().isTableFooterGroupValue(cssValue)) continue;
            NodeList nodeList2 = element2.getChildNodes();
            int n3 = nodeList2.getLength();
            for (int j = 0; j < n3; ++j) {
                Node node2 = nodeList2.item(j);
                if (node2.getNodeType() != 1) continue;
                Element element3 = (Element)node2;
                if (!CssProvider.getValueService().isTableRowValue(CssProvider.getEngineService().getComputedValueForElement(element3, 22))) continue;
                ++n;
            }
        }
        return n;
    }

    protected String paramString() {
        return "rows=" + this.rows + ", " + "columns=" + this.columns + ", element=" + this.table + ", x=" + this.x + ", y=" + this.y + ", size=" + this.width + ":" + this.height + ", contentWidth=" + this.contentWidth + ", containingBlockWidth=" + this.containingBlockWidth;
    }

    public void relayout(FormatContext formatContext) {
        assert (this.rows != -1 && this.columns != -1);
        if (this.columns == 0 || this.rows == 0) {
            this.columns = 0;
            this.rows = 0;
            this.positionCells(new int[0], formatContext);
            int n = CssUtilities.getCssLength(this.table, 58);
            int n2 = CssUtilities.getCssLength(this.table, 31);
            if (n != 0x7FFFFFFE) {
                this.contentWidth = this.width = n;
            }
            if (n2 != 0x7FFFFFFE) {
                this.contentHeight = this.height = n2;
            }
            return;
        }
        int[] nArray = new int[this.columns];
        this.effectiveTopMargin = this.topMargin;
        this.effectiveBottomMargin = this.bottomMargin;
        if (this.fixedLayout) {
            this.fixedLayout(nArray, formatContext);
        } else {
            this.autoLayout(nArray, formatContext);
        }
    }

    private void autoLayout(int[] nArray, FormatContext formatContext) {
        assert (this.rows > 0 && this.columns > 0);
        this.computeAutoColumnWidths(nArray, formatContext, false);
        this.formatCells(nArray, formatContext);
        this.positionCells(nArray, formatContext);
    }

    private int getTableWidth(boolean bl) {
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.table, 58);
        if (CssProvider.getValueService().isAutoValue(cssValue)) {
            return 0x7FFFFFFE;
        }
        int n = (int)cssValue.getFloatValue();
        n -= this.leftBorderWidth + this.leftPadding + this.rightPadding + this.rightBorderWidth;
        n -= this.cellSpacing;
        if (bl) {
            boolean bl2;
            boolean bl3 = bl2 = cssValue instanceof CssComputedValue && CssProvider.getValueService().isOfPrimitivePercentageType(((CssComputedValue)cssValue).getCascadedValue());
            if (bl2) {
                CssProvider.getEngineService().uncomputeValueForElement(this.table, 58);
            }
        }
        return n;
    }

    private void computeAutoColumnWidths(int[] nArray, FormatContext formatContext, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.getTableWidth(bl);
        int[][] nArray2 = new int[this.rows][this.columns];
        int[][] nArray3 = new int[this.rows][this.columns];
        int n8 = 0;
        boolean[] blArray = new boolean[this.columns];
        int[] nArray4 = new int[this.columns];
        for (n6 = 0; n6 < this.columns; ++n6) {
            nArray[n6] = 0x7FFFFFFE;
            nArray4[n6] = 0x7FFFFFFE;
        }
        for (n6 = 0; n6 < this.rows; ++n6) {
            for (int i = 0; i < this.columns; ++i) {
                CellBox cellBox = this.cells[n6][i];
                if (cellBox == null || cellBox == OCCUPIED) continue;
                if (formatContext != null) {
                    cellBox.initializeHorizontalWidths(formatContext);
                }
                n5 = cellBox.getPrefMinWidth();
                Element element = cellBox.getElement();
                CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 58);
                n4 = 0;
                if (!CssProvider.getValueService().isAutoValue(cssValue)) {
                    if (this.colspans[n6][i] == 1) {
                        ++n8;
                        if (!blArray[i]) {
                            blArray[i] = true;
                        }
                    }
                    int n9 = n4 = cssValue instanceof CssComputedValue && CssProvider.getValueService().isOfPrimitivePercentageType(((CssComputedValue)cssValue).getCascadedValue()) ? 1 : 0;
                    if (n4 != 0) {
                        n3 = (int)((CssComputedValue)cssValue).getCascadedValue().getFloatValue();
                        if (n3 < 0) {
                            n3 = 0;
                        }
                        if (nArray4[i] == 0x7FFFFFFE || nArray4[i] >= 0 || n3 > -nArray4[i]) {
                            nArray4[i] = -n3;
                        }
                    } else {
                        n3 = cssValue == null ? null : Integer.valueOf((int)cssValue.getFloatValue());
                        if (n3 < 0) {
                            n3 = 0;
                        }
                        if (nArray4[i] == 0x7FFFFFFE || nArray4[i] >= 0 && nArray4[i] < n3) {
                            nArray4[i] = n3;
                        }
                    }
                }
                nArray2[n6][i] = n5 + cellBox.leftBorderWidth + cellBox.leftPadding + cellBox.rightPadding + cellBox.rightBorderWidth + this.cellSpacing;
                n3 = cellBox.getPrefWidth();
                if (n3 < n5) {
                    n3 = n5;
                }
                nArray3[n6][i] = n3 + cellBox.leftBorderWidth + cellBox.leftPadding + cellBox.rightPadding + cellBox.rightBorderWidth + this.cellSpacing;
            }
        }
        int[] nArray5 = new int[this.columns];
        int[] nArray6 = new int[this.columns];
        for (n2 = 0; n2 < this.columns; ++n2) {
            n5 = 0;
            int n10 = 0;
            for (int i = 0; i < this.rows; ++i) {
                if (this.cells[i][n2] == null || this.cells[i][n2] == OCCUPIED || this.colspans[i][n2] != 1) continue;
                if (nArray3[i][n2] > n5) {
                    n5 = nArray3[i][n2];
                }
                if (nArray2[i][n2] <= n10) continue;
                n10 = nArray2[i][n2];
            }
            nArray5[n2] = n5;
            nArray6[n2] = n10;
        }
        for (n2 = 0; n2 < this.columns; ++n2) {
            for (n5 = 0; n5 < this.rows; ++n5) {
                int n11;
                int n12;
                if (this.cells[n5][n2] == null || this.cells[n5][n2] == OCCUPIED || this.colspans[n5][n2] <= 1) continue;
                int n13 = nArray2[n5][n2];
                int n14 = nArray3[n5][n2];
                n4 = this.colspans[n5][n2];
                n3 = 0;
                n = 0;
                for (n12 = 0; n12 < n4; ++n12) {
                    n3 += nArray6[n12];
                    n += nArray5[n12];
                }
                if (n3 < n13) {
                    n12 = (n13 - n3) / n4;
                    n11 = 0;
                    while (n11 < n4) {
                        int n15 = n11++;
                        nArray6[n15] = nArray6[n15] + n12;
                    }
                }
                if (n >= n14) continue;
                n12 = (n14 - n) / n4;
                n11 = 0;
                while (n11 < n4) {
                    int n16 = n11++;
                    nArray5[n16] = nArray5[n16] + n12;
                }
            }
        }
        if (n7 != 0x7FFFFFFE) {
            n2 = 0;
            for (n5 = 0; n5 < this.columns; ++n5) {
                n2 += nArray6[n5];
            }
            if (n2 >= n7) {
                n7 = n2;
                for (n5 = 0; n5 < this.columns; ++n5) {
                    nArray[n5] = nArray6[n5];
                }
            } else if (n2 < n7) {
                int n17;
                n5 = 0;
                for (n17 = 0; n17 < this.columns; ++n17) {
                    if (nArray4[n17] == 0x7FFFFFFE) {
                        n5 += nArray5[n17];
                        continue;
                    }
                    int n18 = 0;
                    if (nArray4[n17] < 0) {
                        n4 = -nArray4[n17];
                        n18 = n7 == 0x7FFFFFFE ? n4 * nArray5[n17] / 100 : n4 * n7 / 100;
                    } else {
                        n18 = nArray4[n17];
                    }
                    if (n18 > nArray6[n17]) {
                        n5 += n18;
                        continue;
                    }
                    n5 += nArray6[n17];
                }
                if (n5 < n7) {
                    for (n17 = 0; n17 < this.columns; ++n17) {
                        if (nArray4[n17] == 0x7FFFFFFE) {
                            nArray[n17] = nArray5[n17];
                            continue;
                        }
                        int n19 = 0;
                        if (nArray4[n17] < 0) {
                            n4 = -nArray4[n17];
                            n19 = n7 == 0x7FFFFFFE ? n4 * nArray5[n17] / 100 : n4 * n7 / 100;
                        } else {
                            n19 = nArray4[n17];
                        }
                        nArray[n17] = n19 > nArray6[n17] ? n19 : nArray6[n17];
                    }
                    n17 = n7 - n5;
                    int n20 = 0;
                    if (n5 == 0) {
                        this.distribute(nArray, n17, this.columns);
                    } else if (n8 == this.columns || n8 == 0) {
                        n4 = 0;
                        while (n4 < this.columns) {
                            n3 = nArray[n4] * n17 / n5;
                            int n21 = n4++;
                            nArray[n21] = nArray[n21] + n3;
                            n20 += n3;
                        }
                        nArray[0] = nArray[0] + (n17 - n20);
                    } else {
                        n4 = 0;
                        for (n3 = 0; n3 < this.columns; ++n3) {
                            if (blArray[n3]) continue;
                            n4 += nArray[n3];
                        }
                        if (n4 == 0) {
                            n3 = 0;
                            while (n3 < this.columns) {
                                n = nArray[n3] * n17 / n5;
                                int n22 = n3++;
                                nArray[n22] = nArray[n22] + n;
                                n20 += n;
                            }
                        } else {
                            for (n3 = 0; n3 < this.columns; ++n3) {
                                if (blArray[n3]) continue;
                                n = nArray[n3] * n17 / n4;
                                int n23 = n3;
                                nArray[n23] = nArray[n23] + n;
                                n20 += n;
                            }
                        }
                        nArray[0] = nArray[0] + (n17 - n20);
                    }
                } else {
                    this.assignColumnWidths(n7, n2, nArray, nArray6, nArray5, nArray4);
                }
            }
        } else {
            int n24;
            n2 = this.containingBlockWidth - (this.leftBorderWidth + this.leftPadding + this.rightPadding + this.rightBorderWidth + this.cellSpacing);
            if (this.computingPrefWidth) {
                n2 = Integer.MAX_VALUE;
            }
            n5 = 0;
            for (n24 = 0; n24 < this.columns; ++n24) {
                if (nArray4[n24] == 0x7FFFFFFE) {
                    n5 += nArray5[n24];
                    continue;
                }
                int n25 = 0;
                if (nArray4[n24] < 0) {
                    n4 = -nArray4[n24];
                    n25 = n7 == 0x7FFFFFFE ? n4 * nArray5[n24] / 100 : n4 * n7 / 100;
                } else {
                    n25 = nArray4[n24];
                }
                if (n25 > nArray6[n24]) {
                    n5 += n25;
                    continue;
                }
                n5 += nArray6[n24];
            }
            if (n5 <= n2) {
                n7 = n5;
                for (n24 = 0; n24 < this.columns; ++n24) {
                    if (nArray4[n24] == 0x7FFFFFFE) {
                        nArray[n24] = nArray5[n24];
                        continue;
                    }
                    int n26 = 0;
                    if (nArray4[n24] < 0) {
                        n4 = -nArray4[n24];
                        n26 = n7 == 0x7FFFFFFE ? n4 * nArray5[n24] / 100 : n4 * n7 / 100;
                    } else {
                        n26 = nArray4[n24];
                    }
                    nArray[n24] = n26 > nArray6[n24] ? n26 : nArray6[n24];
                }
            } else {
                int n27;
                n24 = 0;
                for (n27 = 0; n27 < this.columns; ++n27) {
                    n24 += nArray6[n27];
                }
                if (n24 >= n2) {
                    n7 = n24;
                    for (n27 = 0; n27 < this.columns; ++n27) {
                        nArray[n27] = nArray6[n27];
                    }
                } else {
                    n7 = n2;
                    this.assignColumnWidths(n7, n24, nArray, nArray6, nArray5, nArray4);
                }
            }
        }
    }

    private void distribute(int[] nArray, int n, int n2) {
        int n3 = n / n2;
        int n4 = n % n2;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n3;
        }
        nArray[0] = nArray[0] + n4;
    }

    private void assignColumnWidths(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        for (n8 = 0; n8 < this.columns; ++n8) {
            nArray[n8] = nArray2[n8];
        }
        n8 = n - n2;
        int n9 = 0;
        for (n7 = 0; n7 < this.columns; ++n7) {
            n6 = nArray4[n7];
            if (n6 == 0x7FFFFFFE || n6 < 0 || (n5 = n6) < (n4 = nArray[n7])) continue;
            n3 = n8 + nArray[n7];
            if (n5 > n3) {
                n5 = n3;
            }
            nArray[n7] = n5;
            n9 += n5 - n4;
            n8 = n3 - n5;
            if (n8 <= 0) break;
        }
        for (n7 = 0; n7 < this.columns; ++n7) {
            if (nArray4[n7] == 0x7FFFFFFE || nArray4[n7] >= 0 || (n4 = (n5 = -nArray4[n7]) * n / 100) < (n6 = nArray[n7])) continue;
            n3 = n8 + nArray[n7];
            if (n4 > n3) {
                n4 = n3;
            }
            nArray[n7] = n4;
            n9 += n4 - n6;
            n8 = n3 - n4;
            if (n8 <= 0) break;
        }
        if (n8 <= 0) {
            return;
        }
        n7 = 0;
        n6 = 0;
        for (n5 = 0; n5 < this.columns; ++n5) {
            if (nArray4[n5] == 0x7FFFFFFE) {
                ++n7;
                continue;
            }
            if (nArray4[n5] >= 0) continue;
            ++n6;
        }
        if (n7 == 0) {
            if (n6 == 0) {
                n5 = n8 / this.columns;
                n4 = n8 % this.columns;
                n3 = 0;
                while (n3 < this.columns) {
                    int n10 = n3++;
                    nArray[n10] = nArray[n10] + n5;
                }
                nArray[0] = nArray[0] + n4;
            } else {
                n5 = n8 / n6;
                n4 = n8 % n6;
                for (n3 = 0; n3 < this.columns; ++n3) {
                    if (nArray4[n3] == 0x7FFFFFFE || nArray4[n3] >= 0) continue;
                    int n11 = n3;
                    nArray[n11] = nArray[n11] + n5;
                    int n12 = n3;
                    nArray[n12] = nArray[n12] + n4;
                    n4 = 0;
                }
            }
            return;
        }
        while (true) {
            int n13;
            int n14;
            n5 = 0;
            n4 = 0;
            for (n3 = 0; n3 < this.columns; ++n3) {
                if (nArray4[n3] != 0x7FFFFFFE || nArray[n3] >= nArray3[n3]) continue;
                n5 += nArray[n3];
                ++n4;
            }
            if (n5 == 0 && n4 != 0) {
                n3 = n8 / n4;
                n14 = n8 % n4;
                for (n13 = 0; n13 < this.columns; ++n13) {
                    if (nArray4[n13] != 0x7FFFFFFE || nArray[n13] >= nArray3[n13]) continue;
                    int n15 = n13;
                    nArray[n15] = nArray[n15] + n3;
                    if (n14 == 0) continue;
                    int n16 = n13;
                    nArray[n16] = nArray[n16] + n14;
                    n14 = 0;
                }
                return;
            }
            n9 = 0;
            n3 = 0;
            for (n14 = 0; n14 < this.columns; ++n14) {
                if (nArray4[n14] != 0x7FFFFFFE || nArray[n14] >= nArray3[n14]) continue;
                n13 = nArray[n14] * n8 / n5;
                int n17 = n14;
                nArray[n17] = nArray[n17] + n13;
                if (nArray[n14] >= nArray3[n14]) {
                    n3 += nArray[n14] - nArray3[n14];
                    nArray[n14] = nArray3[n14];
                    continue;
                }
                n9 += n13;
            }
            if (n3 == 0) break;
            n8 = n3;
        }
    }

    public boolean isBorderSizeIncluded() {
        return true;
    }

    public Insets getCssSizeInsets() {
        if (this.captionBoxes != null) {
            return new Insets(this.tableTop, this.tableLeft, this.height - this.tableBottom, this.width - this.tableRight);
        }
        return new Insets(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPrefWidth() {
        try {
            this.computingPrefWidth = true;
            int n = this.getPrefMinWidth();
            return n;
        }
        finally {
            this.computingPrefWidth = false;
        }
    }

    public int getPrefMinWidth() {
        if (this.columns == 0 || this.rows == 0) {
            int n = CssUtilities.getCssLength(this.table, 58);
            CssProvider.getEngineService().uncomputeValueForElement(this.table, 58);
            if (n != 0x7FFFFFFE) {
                return n;
            }
            return 0;
        }
        int[] nArray = new int[this.columns];
        if (this.fixedLayout) {
            this.computeFixedColumnWidths(nArray, true);
        } else {
            this.computeAutoColumnWidths(nArray, null, true);
        }
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            n += nArray[i];
        }
        n += this.leftPadding + this.rightPadding;
        if (this.leftMargin != 0x7FFFFFFE) {
            n += this.leftMargin;
        }
        if (this.rightMargin != 0x7FFFFFFE) {
            n += this.rightMargin;
        }
        return n += this.leftBorderWidth + this.rightBorderWidth;
    }

    private int getTableHeight() {
        boolean bl;
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.table, 31);
        if (CssProvider.getValueService().isAutoValue(cssValue)) {
            return 0x7FFFFFFE;
        }
        boolean bl2 = bl = cssValue instanceof CssComputedValue && CssProvider.getValueService().isOfPrimitivePercentageType(((CssComputedValue)cssValue).getCascadedValue());
        if (bl) {
            return 0;
        }
        int n = (int)cssValue.getFloatValue();
        n -= this.topBorderWidth + this.topPadding + this.bottomPadding + this.bottomBorderWidth;
        return n -= this.cellSpacing;
    }

    protected void paintBackground(Graphics graphics, int n, int n2) {
        if (this.hidden) {
            return;
        }
        if (this.captionBoxes != null) {
            this.paintBox(graphics, n + this.tableLeft, n2 + this.tableTop, this.tableRight - this.tableLeft, this.tableBottom - this.tableTop);
        } else {
            this.paintBox(graphics, n, n2, this.getWidth(), this.getHeight());
        }
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public CssBox getCell(int n, int n2) {
        return this.cells[n][n2];
    }

    public int getCellSpan(int n, int n2, int n3) {
        return n == 0 ? this.rowspans[n2][n3] : this.colspans[n2][n3];
    }

    static class OccupiedBox
    extends CellBox {
        OccupiedBox() {
            super(null, null, BoxType.NONE, true, null);
        }

        public void initialize() {
        }

        protected void initializeInvariants() {
        }

        protected void initializeBackgroundDelayed() {
        }

        public boolean isPlaceHolder() {
            return true;
        }
    }

    private static class CellBox
    extends ContainerBox {
        private TableBox tableBox;
        int row;
        int col;
        int originalHeight;

        public CellBox(WebForm webForm, Element element, BoxType boxType, boolean bl, TableBox tableBox) {
            super(webForm, element, boxType, bl, false);
            this.tableBox = tableBox;
            this.initializeBackgroundDelayed();
        }

        public Decoration getDecoration() {
            return null;
        }

        protected void initializeMargins() {
            this.bottomMargin = 0;
            this.topMargin = 0;
            this.rightMargin = 0;
            this.leftMargin = 0;
            this.effectiveBottomMargin = 0;
            this.effectiveTopMargin = 0;
        }

        protected void initializePadding() {
            this.rightPadding = 0x7FFFFFFE;
            this.leftPadding = 0x7FFFFFFE;
            this.bottomPadding = 0x7FFFFFFE;
            this.topPadding = 0x7FFFFFFE;
            super.initializePadding();
            int n = this.tableBox.cellPadding;
            this.leftPadding = this.leftPadding == 0x7FFFFFFE ? n : Math.max(this.leftPadding, n);
            this.rightPadding = this.rightPadding == 0x7FFFFFFE ? n : Math.max(this.rightPadding, n);
            this.topPadding = this.topPadding == 0x7FFFFFFE ? n : Math.max(this.topPadding, n);
            this.bottomPadding = this.bottomPadding == 0x7FFFFFFE ? n : Math.max(this.bottomPadding, n);
        }

        protected void initializeBorder() {
            int n = -1;
            int n2 = 0;
            int n3 = this.tableBox.rules;
            if (this.tableBox.borderWidth > 0) {
                n = 1;
                n2 = 7;
            } else if (this.tableBox.rules != 143) {
                n = 1;
                if (this.row == 0) {
                    n3 &= 0xFFFFFFFE;
                }
                if (this.row + this.tableBox.colspans[this.row][this.col] == this.tableBox.rows) {
                    n3 &= 0xFFFFFFFD;
                }
                if (this.col == 0) {
                    n3 &= 0xFFFFFFFB;
                }
                if (this.col + this.tableBox.colspans[this.row][this.col] == this.tableBox.columns) {
                    n3 &= 0xFFFFFFF7;
                }
                n2 = 1;
            }
            this.border = CssBorder.getBorder(this.getElement(), n, n2, n3);
            if (this.border != null) {
                this.leftBorderWidth = this.border.getLeftBorderWidth();
                this.topBorderWidth = this.border.getTopBorderWidth();
                this.bottomBorderWidth = this.border.getBottomBorderWidth();
                this.rightBorderWidth = this.border.getRightBorderWidth();
            }
        }

        protected void initializeBackground() {
        }

        protected void initializeBackgroundDelayed() {
            this.initializeBackgroundImage();
            Element element = this.getElement();
            this.bg = CssProvider.getValueService().getColorForElement(element, 0);
            if (this.bg != null) {
                return;
            }
            Element element2 = this.findParent(element, CssProvider.getValueService().getTableRowValueConstant());
            if (element2 == null) {
                return;
            }
            this.bg = CssProvider.getValueService().getColorForElement(element2, 0);
            if (this.bg != null) {
                return;
            }
            Element element3 = this.findParent(element2, CssProvider.getValueService().getTableRowGroupValueConstant());
            if (element3 == null && (element3 = this.findParent(element2, CssProvider.getValueService().getTableHeaderGroupValueConstant())) == null && (element3 = this.findParent(element2, CssProvider.getValueService().getTableFooterGroupValueConstant())) == null && (element3 = MarkupService.getTBodyElementForTableElement((Element)this.tableBox.table)) == null) {
                return;
            }
            this.bg = CssProvider.getValueService().getColorForElement(element3, 0);
            if (this.bg != null) {
                return;
            }
        }

        public boolean isBorderSizeIncluded() {
            return false;
        }

        public Insets getCssSizeInsets() {
            return new Insets(0, 0, 0, 0);
        }

        public int getPrefMinWidth() {
            int n;
            if (this.inline) {
                CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.getElement(), 57);
                if (CssProvider.getValueService().isPreValue(cssValue) || CssProvider.getValueService().isNoWrapValue(cssValue)) {
                    return this.getPrefWidth();
                }
            }
            int n2 = 0;
            int n3 = this.getBoxCount();
            for (n = 0; n < n3; ++n) {
                int n4;
                CssBox cssBox = this.getBox(n);
                if (cssBox.getBoxType().isAbsolutelyPositioned() || (n4 = cssBox.getPrefMinWidth()) <= n2) continue;
                n2 = n4;
            }
            if (this.leftMargin != 0x7FFFFFFE) {
                n2 += this.leftMargin;
            }
            if (this.rightMargin != 0x7FFFFFFE) {
                n2 += this.rightMargin;
            }
            n2 += this.leftBorderWidth + this.leftPadding + this.rightBorderWidth + this.rightPadding;
            n = this.leftBorderWidth + this.leftPadding + this.rightPadding + this.rightBorderWidth;
            if (this.leftMargin != 0x7FFFFFFE) {
                n += this.leftMargin;
            }
            if (this.rightMargin != 0x7FFFFFFE) {
                n += this.rightMargin;
            }
            if (n > n2) {
                n2 = n;
            }
            return n2;
        }

        public int getPrefWidth() {
            int n = 0;
            int n2 = this.getBoxCount();
            if (this.inline && !this.boxType.isAbsolutelyPositioned()) {
                ContainerBox containerBox;
                for (containerBox = this.getParent(); containerBox != null && !(containerBox instanceof LineBoxGroup); containerBox = containerBox.getParent()) {
                }
                if (containerBox != null) {
                    n = ((LineBoxGroup)containerBox).getPrefWidth(this.boxes);
                } else {
                    for (int i = 0; i < n2; ++i) {
                        CssBox cssBox = this.getBox(i);
                        if (cssBox.getBoxType().isAbsolutelyPositioned()) continue;
                        n += cssBox.getPrefWidth();
                    }
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    int n3;
                    CssBox cssBox = this.getBox(i);
                    if (cssBox.getBoxType().isAbsolutelyPositioned() || (n3 = cssBox.getPrefWidth()) <= n) continue;
                    n = n3;
                }
            }
            if (this.leftMargin != 0x7FFFFFFE) {
                n += this.leftMargin;
            }
            if (this.rightMargin != 0x7FFFFFFE) {
                n += this.rightMargin;
            }
            n += this.leftBorderWidth + this.leftPadding + this.rightBorderWidth + this.rightPadding;
            int n4 = this.leftBorderWidth + this.leftPadding + this.rightPadding + this.rightBorderWidth;
            if (this.leftMargin != 0x7FFFFFFE) {
                n4 += this.leftMargin;
            }
            if (this.rightMargin != 0x7FFFFFFE) {
                n4 += this.rightMargin;
            }
            if (n4 > n) {
                n = n4;
            }
            return n;
        }

        private Element findParent(Element element, CssValue cssValue) {
            while (element != null) {
                Node node = element.getParentNode();
                if (node.getNodeType() != 1) {
                    return null;
                }
                element = (Element)node;
                if (element == null || element == this.tableBox.table) {
                    return null;
                }
                if (!cssValue.equals(CssProvider.getEngineService().getComputedValueForElement(element, 22))) continue;
                return element;
            }
            return null;
        }

        void align() {
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.getElement(), 55);
            if (!(CssProvider.getValueService().isBaseLineValue(cssValue) || CssProvider.getValueService().isSubValue(cssValue) || CssProvider.getValueService().isSuperValue(cssValue) || CssProvider.getValueService().isTextTopValue(cssValue) || CssProvider.getValueService().isTextTopValue(cssValue) || CssProvider.getValueService().isTopValue(cssValue))) {
                if (CssProvider.getValueService().isBottomValue(cssValue)) {
                    int n = this.originalHeight;
                    int n2 = this.height - n;
                    int n3 = this.getBoxCount();
                    for (int i = 0; i < n3; ++i) {
                        CssBox cssBox = this.getBox(i);
                        cssBox.setY(cssBox.getY() + n2);
                    }
                } else if (CssProvider.getValueService().isMiddleValue(cssValue)) {
                    int n = this.originalHeight;
                    int n4 = (this.height - n) / 2;
                    int n5 = this.getBoxCount();
                    for (int i = 0; i < n5; ++i) {
                        CssBox cssBox = this.getBox(i);
                        cssBox.setY(cssBox.getY() + n4);
                    }
                } else {
                    ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unexpected alignment value, cssAlign=" + cssValue));
                }
            }
        }

        protected CssBox notifyChildResize(CssBox cssBox, FormatContext formatContext) {
            ContainerBox containerBox = this.getParent();
            assert (containerBox instanceof TableBox);
            containerBox.relayout(formatContext);
            return containerBox.getParent().notifyChildResize(containerBox, formatContext);
        }

        public int getInternalResizeDirection(int n, int n2) {
            Element element = CssBox.getElementForComponentRootCssBox(this.tableBox);
            if (!this.webform.getDomProviderService().hasTableResizeSupport(element)) {
                return 0;
            }
            int n3 = this.getAbsoluteX();
            int n4 = this.getAbsoluteY();
            int n5 = this.tableBox.cellSpacing / 2;
            if (this.col > 0 && Math.abs(n - n3) < 5 + n5 && this.webform.getDomProviderService().testResizeColumn(element, this.row, this.col - 1, 50) != -1) {
                return 10;
            }
            if (this.col < this.tableBox.columns - 1 && Math.abs(n - (n3 + this.width)) < 5 + n5 && this.webform.getDomProviderService().testResizeColumn(element, this.row, this.col, 50) != -1) {
                return 11;
            }
            if (this.row > 0 && Math.abs(n2 - n4) < 5 + n5 && this.webform.getDomProviderService().testResizeRow(element, this.row - 1, this.col, 50) != -1) {
                return 8;
            }
            if (this.row < this.tableBox.rows - 1 && Math.abs(n2 - (n4 + this.height)) < 5 + n5 && this.webform.getDomProviderService().testResizeRow(element, this.row, this.col, 50) != -1) {
                return 9;
            }
            return 0;
        }

        public Interaction getInternalResizer(int n, int n2) {
            Element element = CssBox.getElementForComponentRootCssBox(this.tableBox);
            if (!this.webform.getDomProviderService().hasTableResizeSupport(element)) {
                return null;
            }
            int n3 = 0;
            int n4 = Integer.MAX_VALUE;
            int n5 = this.getAbsoluteX();
            int n6 = this.getAbsoluteY();
            int n7 = this.tableBox.cellSpacing / 2;
            Element element2 = this.getElement();
            if (Math.abs(n - n5) < 5 + n7 && this.webform.getDomProviderService().testResizeColumn(element, this.row, this.col - 1, 50) != -1) {
                TableResizer tableResizer = new TableResizer(this.webform, element, 1, true, n5, this.tableBox.getAbsoluteY(), this.getWidth(), this.tableBox.getHeight(), n3, n4, this.row, this.col, element2);
                return tableResizer;
            }
            if (Math.abs(n - (n5 + this.width)) < 5 + n7 && this.webform.getDomProviderService().testResizeColumn(element, this.row, this.col, 50) != -1) {
                TableResizer tableResizer = new TableResizer(this.webform, element, 1, false, n5, this.tableBox.getAbsoluteY(), this.getWidth(), this.tableBox.getHeight(), n3, n4, this.row, this.col, element2);
                return tableResizer;
            }
            if (Math.abs(n2 - n6) < 5 + n7 && this.webform.getDomProviderService().testResizeRow(element, this.row - 1, this.col, 50) != -1) {
                System.out.println("Probably should use row before here!");
                TableResizer tableResizer = new TableResizer(this.webform, element, 0, true, this.tableBox.getAbsoluteX(), n6, this.getHeight(), this.tableBox.getWidth(), n3, n4, this.row, this.col, element2);
                return tableResizer;
            }
            if (Math.abs(n2 - (n6 + this.height)) < 5 + n7 && this.webform.getDomProviderService().testResizeRow(element, this.row, this.col, 50) != -1) {
                TableResizer tableResizer = new TableResizer(this.webform, element, 0, false, this.tableBox.getAbsoluteX(), n6, this.getHeight(), this.tableBox.getWidth(), n3, n4, this.row, this.col, element2);
                return tableResizer;
            }
            return null;
        }
    }
}

