/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssValue;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.ContainerBox;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.LineBox;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.w3c.dom.Element;

public class ListBox
extends ContainerBox {
    private static final int SHAPE_SIZE = 5;
    private static final char[][] romanChars = new char[][]{{'i', 'v'}, {'x', 'l'}, {'c', 'd'}, {'m', '?'}};
    private boolean checkedForStart;
    private int start;
    private CssValue cssType;
    Icon img = null;
    private int bulletgap = 5;

    public ListBox(WebForm webForm, Element element, BoxType boxType, boolean bl, boolean bl2) {
        super(webForm, element, boxType, bl, bl2);
        this.img = ListBox.getListStyleImage(webForm, element);
        if (this.img == null) {
            this.cssType = CssProvider.getEngineService().getComputedValueForElement(element, 34);
        }
        this.start = 1;
    }

    public void paint(Graphics graphics, int n, int n2) {
        super.paint(graphics, n, n2);
        n += this.getX();
        n2 += this.getY();
        n += this.leftMargin;
        n2 += this.effectiveTopMargin;
        int n3 = this.getBoxCount();
        for (int i = 0; i < n3; ++i) {
            CssBox cssBox = this.getBox(i);
            if (cssBox.hidden) continue;
            this.paintBullet(graphics, n + cssBox.getX() + cssBox.leftMargin, n2 + cssBox.getY(), cssBox.getWidth(), cssBox.getHeight(), this, i);
        }
    }

    private static ImageIcon getListStyleImage(WebForm webForm, Element element) {
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 33);
        if (CssProvider.getValueService().isNoneValue(cssValue)) {
            return null;
        }
        String string = cssValue.getStringValue();
        URL uRL = webForm.getBaseUrl();
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(uRL2);
        return imageIcon;
    }

    private CssValue getChildType(CssBox cssBox) {
        Element element = cssBox.getElement();
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 34);
        if (cssValue == null) {
            if (this.cssType == null) {
                ContainerBox containerBox = cssBox.getParent();
                cssValue = containerBox.tag == HtmlTag.OL ? CssProvider.getValueService().getDecimalCssValueConstant() : CssProvider.getValueService().getDiscCssValueConstant();
            } else {
                cssValue = this.cssType;
            }
        }
        return cssValue;
    }

    private void getStart(CssBox cssBox) {
        String string;
        this.checkedForStart = true;
        Element element = cssBox.getElement();
        if (element != null && (string = element.getAttribute("start")) != null && string.length() > 0) {
            try {
                this.start = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.start = 1;
            }
        }
    }

    private int getRenderIndex(CssBox cssBox, int n) {
        if (!this.checkedForStart) {
            this.getStart(cssBox);
        }
        int n2 = n;
        for (int i = n; i >= 0; --i) {
            CssBox cssBox2 = cssBox.getBox(i);
            if (cssBox2.tag != HtmlTag.LI) {
                --n2;
                continue;
            }
            String string = cssBox2.getElement().getAttribute("value");
            if (string == null || string.length() <= 0) continue;
            try {
                int n3 = Integer.parseInt(string);
                return n2 - i + n3;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2 + this.start;
    }

    public void paintBullet(Graphics graphics, float f, float f2, float f3, float f4, CssBox cssBox, int n) {
        CssBox cssBox2 = cssBox.getBox(n);
        if (cssBox2.tag != HtmlTag.LI) {
            return;
        }
        float f5 = 0.0f;
        LineBox lineBox = this.findFirstLineBox(cssBox2);
        if (lineBox != null) {
            f4 = lineBox.getHeight();
            f2 = lineBox.getAbsoluteY();
            f5 = 0.5f;
        }
        if (this.img != null) {
            this.drawIcon(graphics, (int)f, (int)f2, (int)f4, f5, this.webform.getPane());
            return;
        }
        CssValue cssValue = this.getChildType(cssBox2);
        if (CssProvider.getValueService().isSquareValue(cssValue) || CssProvider.getValueService().isCircleValue(cssValue) || CssProvider.getValueService().isDiscValue(cssValue)) {
            this.drawShape(graphics, cssValue, (int)f, (int)f2, (int)f4, f5);
        } else if (CssProvider.getValueService().isDecimalValue(cssValue)) {
            this.drawLetter(graphics, '1', (int)f, (int)f2, (int)f4, f5, this.getRenderIndex(cssBox, n));
        } else if (CssProvider.getValueService().isLowerLatinValue(cssValue) || CssProvider.getValueService().isLowerAlphaValue(cssValue)) {
            this.drawLetter(graphics, 'a', (int)f, (int)f2, (int)f4, f5, this.getRenderIndex(cssBox, n));
        } else if (CssProvider.getValueService().isUpperLatinValue(cssValue) || CssProvider.getValueService().isUpperAlphaValue(cssValue)) {
            this.drawLetter(graphics, 'A', (int)f, (int)f2, (int)f4, f5, this.getRenderIndex(cssBox, n));
        } else if (CssProvider.getValueService().isLowerRomanValue(cssValue)) {
            this.drawLetter(graphics, 'i', (int)f, (int)f2, (int)f4, f5, this.getRenderIndex(cssBox, n));
        } else if (CssProvider.getValueService().isUpperRomanValue(cssValue)) {
            this.drawLetter(graphics, 'I', (int)f, (int)f2, (int)f4, f5, this.getRenderIndex(cssBox, n));
        }
    }

    private LineBox findFirstLineBox(CssBox cssBox) {
        if (cssBox instanceof LineBox) {
            return (LineBox)cssBox;
        }
        CssBox cssBox2 = cssBox.getFirstNormalBox();
        if (cssBox2 == null) {
            return null;
        }
        return this.findFirstLineBox(cssBox2);
    }

    void drawIcon(Graphics graphics, int n, int n2, int n3, float f, Component component) {
        graphics.setColor(Color.black);
        int n4 = n - this.img.getIconWidth() - this.bulletgap;
        int n5 = Math.max(n2, n2 + (int)(f * (float)n3) - this.img.getIconHeight());
        this.img.paintIcon(component, graphics, n4, n5);
    }

    void drawShape(Graphics graphics, CssValue cssValue, int n, int n2, int n3, float f) {
        Color color = CssProvider.getValueService().getColorForElement(this.getElement(), 20);
        if (color == null) {
            color = Color.black;
        }
        graphics.setColor(color);
        int n4 = n - this.bulletgap - 5;
        int n5 = Math.max(n2, n2 + (int)(f * (float)n3) - 2);
        if (CssProvider.getValueService().isSquareValue(cssValue)) {
            graphics.fillRect(n4, n5, 5, 5);
        } else if (CssProvider.getValueService().isCircleValue(cssValue)) {
            graphics.drawOval(n4, n5, 5, 5);
        } else {
            graphics.fillOval(n4, n5, 5, 5);
        }
    }

    void drawLetter(Graphics graphics, char c, int n, int n2, int n3, float f, int n4) {
        Color color = CssProvider.getValueService().getColorForElement(this.getElement(), 20);
        if (color == null) {
            color = Color.black;
        }
        graphics.setColor(color);
        String string = this.formatItemNum(n4, c) + ".";
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = n - n5 - this.bulletgap;
        int n7 = Math.max(n2 + fontMetrics.getAscent(), n2 + (int)((float)n3 * f));
        graphics.drawString(string, n6, n7);
    }

    String formatItemNum(int n, char c) {
        String string;
        boolean bl = false;
        switch (c) {
            default: {
                string = String.valueOf(n);
                break;
            }
            case 'A': {
                bl = true;
            }
            case 'a': {
                string = this.formatAlphaNumerals(n);
                break;
            }
            case 'I': {
                bl = true;
            }
            case 'i': {
                string = ListBox.formatRomanNumerals(n);
            }
        }
        if (bl) {
            string = string.toUpperCase();
        }
        return string;
    }

    String formatAlphaNumerals(int n) {
        String string = "";
        string = n > 26 ? this.formatAlphaNumerals(n / 26) + this.formatAlphaNumerals(n % 26) : String.valueOf((char)(97 + n - 1));
        return string;
    }

    private static String formatRomanNumerals(int n) {
        return ListBox.formatRomanNumerals(0, n);
    }

    private static String formatRomanNumerals(int n, int n2) {
        if (n2 < 10) {
            return ListBox.formatRomanDigit(n, n2);
        }
        return ListBox.formatRomanNumerals(n + 1, n2 / 10) + ListBox.formatRomanDigit(n, n2 % 10);
    }

    private static String formatRomanDigit(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 9) {
            stringBuffer.append(romanChars[n][0]);
            stringBuffer.append(romanChars[n + 1][0]);
            return stringBuffer.toString();
        }
        if (n2 == 4) {
            stringBuffer.append(romanChars[n][0]);
            stringBuffer.append(romanChars[n][1]);
            return stringBuffer.toString();
        }
        if (n2 >= 5) {
            stringBuffer.append(romanChars[n][1]);
            n2 -= 5;
        }
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(romanChars[n][0]);
        }
        return stringBuffer.toString();
    }
}

