/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.FormatContext;
import org.netbeans.modules.visualweb.designer.CssUtilities;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.openide.ErrorManager;
import org.w3c.dom.Element;

public class LineBreakBox
extends CssBox {
    private FontMetrics metrics;

    public LineBreakBox(WebForm webForm, Element element, HtmlTag htmlTag) {
        super(webForm, element, BoxType.LINEBREAK, true, true);
        this.width = 0;
        this.contentWidth = 0;
        this.contentHeight = this.height = this.getMetrics().getHeight();
        this.tag = htmlTag;
    }

    protected void initialize() {
    }

    protected void initializeInvariants() {
        Element element = this.getElement();
        if (this.tag == HtmlTag.BR && element.getChildNodes().getLength() > 0) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Element <br> may not contain children, children=" + element.getChildNodes()));
        }
    }

    protected void initializeHorizontalWidths(FormatContext formatContext) {
    }

    protected String paramString() {
        return super.paramString() + ", " + "font ascent=" + this.metrics.getAscent() + ", descent=" + this.metrics.getDescent() + ", height=" + this.metrics.getHeight() + ", " + "font=" + this.metrics.getFont();
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (CssBox.paintSpaces) {
            graphics.setColor(Color.RED);
            graphics.drawRect(this.getAbsoluteX(), this.getAbsoluteY(), this.width, this.height);
            int n3 = this.getAbsoluteX() + 3;
            int n4 = this.getAbsoluteY() + this.height / 2 + 3;
            graphics.drawLine(n3, n4, n3 + 5, n4);
            graphics.drawLine(n3 + 5, n4, n3 + 5, n4 - 5);
        }
    }

    public FontMetrics getMetrics() {
        if (this.metrics == null) {
            this.metrics = CssUtilities.getDesignerFontMetricsForElement(this.getElement(), null, this.webform.getDefaultFontSize());
        }
        return this.metrics;
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }
}

