/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssComputedValue;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssValue;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.CssBorder;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.FormatContext;
import org.netbeans.modules.visualweb.css2.StringBox;
import org.netbeans.modules.visualweb.designer.CssUtilities;
import org.netbeans.modules.visualweb.designer.ImageCache;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlAttribute;
import org.openide.ErrorManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;

public class ImageBox
extends CssBox {
    private static boolean sIsInc = false;
    private static int sIncRate = 100;
    private static final int DEFAULT_WIDTH = 38;
    private static final int DEFAULT_HEIGHT = 38;
    private static final int LOADING_FLAG = 1;
    private static final int LINK_FLAG = 2;
    private static final int WIDTH_FLAG = 4;
    private static final int HEIGHT_FLAG = 8;
    private static final int RELOAD_FLAG = 16;
    private static final int RELOAD_IMAGE_FLAG = 32;
    private Image image;
    private int width;
    private int height;
    private int state;
    private Container container;
    private Rectangle fBounds;
    private ImageObserver imageObserver;

    public ImageBox(WebForm webForm, Element element, Container container, BoxType boxType, boolean bl) {
        super(webForm, element, boxType, bl, true);
        this.container = container;
        this.fBounds = new Rectangle();
        this.imageObserver = new ImageHandler();
        this.state = 48;
        this.preloadImage();
    }

    public static CssBox getImageBox(WebForm webForm, Element element, Container container, BoxType boxType, boolean bl) {
        ImageBox imageBox = new ImageBox(webForm, element, container, boxType, bl);
        if (imageBox.isValidUrl()) {
            return imageBox;
        }
        String string = element.getAttribute("alt");
        if (string.length() == 0 && element.hasAttribute("alt") && !element.hasAttribute("src")) {
            return new CssBox(webForm, element, boxType, bl, true);
        }
        if ((string == null || string.length() == 0) && CssBox.getElementForComponentRootCssBox(imageBox) != null) {
            string = NbBundle.getMessage(ImageBox.class, (String)"LBL_Image");
        }
        if (string != null) {
            int n = CssUtilities.getCssLength(element, 58);
            int n2 = CssUtilities.getCssLength(element, 31);
            if (n == 0) {
                n = 0x7FFFFFFE;
            }
            if (n2 == 0) {
                n2 = 0x7FFFFFFE;
            }
            imageBox.initializeBorder();
            StringBox stringBox = new StringBox(webForm, element, boxType, string, imageBox.border, n, n2);
            return stringBox;
        }
        return imageBox;
    }

    protected void initializeHorizontalWidths(FormatContext formatContext) {
        super.initializeHorizontalWidths(formatContext);
        if (((CssBox)this).width == 0x7FFFFFFD) {
            this.relayout(formatContext);
        }
    }

    protected void initializeBorder() {
        Element element = this.getElement();
        int n = HtmlAttribute.getIntegerAttributeValue((Element)element, (String)"border", (int)0);
        if (n < 0) {
            n = 0;
        }
        int n2 = n == 0 ? 0 : 8;
        this.border = CssBorder.getBorder(element, n, n2, 15);
        if (this.border != null) {
            this.leftBorderWidth = this.border.getLeftBorderWidth();
            this.topBorderWidth = this.border.getTopBorderWidth();
            this.bottomBorderWidth = this.border.getBottomBorderWidth();
            this.rightBorderWidth = this.border.getRightBorderWidth();
        }
        this.considerDesignBorder();
    }

    public void relayout(FormatContext formatContext) {
        this.sync();
        this.width = (int)this.getPreferredSpan(0);
        this.height = (int)this.getPreferredSpan(1);
        this.contentWidth = this.width;
        this.contentHeight = this.height;
        ((CssBox)this).width = this.leftBorderWidth + this.leftPadding + this.contentWidth + this.rightPadding + this.rightBorderWidth;
        ((CssBox)this).height = this.topBorderWidth + this.topPadding + this.contentHeight + this.bottomPadding + this.bottomBorderWidth;
    }

    public String getAltText() {
        Element element = this.getElement();
        return element == null ? null : element.getAttribute("alt");
    }

    public URL getImageURL() {
        String string;
        Element element = this.getElement();
        String string2 = string = element == null ? null : element.getAttribute("src");
        if (string == null || string.length() == 0) {
            return null;
        }
        return this.webform.resolveUrl(string);
    }

    private static Icon getNoImageIcon() {
        return ImageBox.loadIcon("org/netbeans/modules/visualweb/designer/resources/image-failed.gif");
    }

    private static Icon getLoadingImageIcon() {
        return ImageBox.loadIcon("org/netbeans/modules/visualweb/designer/resources/image-delayed.gif");
    }

    public Image getImage() {
        this.sync();
        return this.image;
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (this.hidden) {
            return;
        }
        this.sync();
        n += this.getX();
        n2 += this.getY();
        Image image = this.getImage();
        if (Math.abs(n += this.leftMargin) > 50000 || Math.abs(n2 += this.effectiveTopMargin) > 50000 || Math.abs(this.width) > 50000 || Math.abs(this.height) > 50000) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Fatal painting error:\nbad box=" + this + "\nparent of bad box=" + this.getParent()));
            return;
        }
        this.paintBackground(graphics, n, n2);
        int n3 = n + this.leftBorderWidth + this.leftPadding;
        int n4 = n2 + this.topBorderWidth + this.topPadding;
        this.fBounds.setBounds(n3, n4, this.getWidth(), this.getHeight());
        if (image != null) {
            if (!this.hasPixels(image)) {
                Icon icon = ImageBox.getLoadingImageIcon();
                if (icon != null) {
                    icon.paintIcon(this.container, graphics, n3, n4);
                }
            } else {
                graphics.drawImage(image, n3, n4, this.width, this.height, this.imageObserver);
            }
        } else {
            Icon icon = ImageBox.getNoImageIcon();
            if (icon != null) {
                icon.paintIcon(this.container, graphics, n3, n4);
            }
        }
        if (paintPositioning) {
            this.paintDebugPositioning(graphics);
        }
    }

    public float getPreferredSpan(int n) {
        this.sync();
        if (n == 0 && (this.state & 4) == 4) {
            return this.width;
        }
        if (n == 1 && (this.state & 8) == 8) {
            return this.height;
        }
        Image image = this.getImage();
        if (image != null) {
            switch (n) {
                case 0: {
                    return this.width;
                }
                case 1: {
                    return this.height;
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }
        return 0.0f;
    }

    private boolean hasPixels(Image image) {
        return image != null && image.getHeight(this.imageObserver) > 0 && image.getWidth(this.imageObserver) > 0;
    }

    private static Icon loadIcon(String string) {
        Image image = ImageUtilities.loadImage((String)string);
        if (image == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("No image for iconResource=" + string));
        }
        return image == null ? null : new ImageIcon(image);
    }

    private void repaint(long l) {
        if (this.container != null && this.fBounds != null) {
            this.container.repaint(l, this.fBounds.x, this.fBounds.y, this.fBounds.width, this.fBounds.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        int n = this.state;
        if ((n & 0x20) != 0) {
            this.refreshImage();
        }
        if (((n = this.state) & 0x10) != 0) {
            ImageBox imageBox = this;
            synchronized (imageBox) {
                this.state = (this.state | 0x10) ^ 0x10;
            }
        }
    }

    private boolean isValidUrl() {
        return this.image != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshImage() {
        ImageBox imageBox = this;
        synchronized (imageBox) {
            this.state = (this.state | 1 | 0x20 | 4 | 8) ^ 0x2C;
            this.image = null;
            this.height = 0;
            this.width = 0;
        }
        try {
            this.loadImage();
            boolean bl = this.updateImageSize();
            return bl;
        }
        finally {
            ImageBox imageBox2 = this;
            synchronized (imageBox2) {
                this.state = (this.state | 1) ^ 1;
            }
        }
    }

    private void preloadImage() {
        boolean bl = this.refreshImage();
        if (bl) {
            this.state = 48;
            CssProvider.getEngineService().clearComputedStylesForElement(this.getElement());
        }
    }

    private void loadImage() {
        URL uRL = this.getImageURL();
        Image image = null;
        if (uRL != null) {
            ImageCache imageCache = this.webform.getImageCache();
            ImageIcon imageIcon = imageCache.get(uRL);
            if (imageIcon == null) {
                image = Toolkit.getDefaultToolkit().createImage(uRL);
                if (image != null) {
                    imageIcon = new ImageIcon();
                    imageIcon.setImage(image);
                    imageCache.put(uRL, imageIcon);
                }
            } else {
                image = imageIcon.getImage();
            }
        }
        this.image = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateImageSize() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Image image = this.getImage();
        boolean bl = false;
        if (image != null) {
            Element element = this.getElement();
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 58);
            if (CssProvider.getValueService().isAutoValue(cssValue)) {
                n = 0x7FFFFFFE;
            } else {
                n = (int)cssValue.getFloatValue();
                boolean bl2 = bl = bl || cssValue instanceof CssComputedValue && CssProvider.getValueService().isOfPrimitivePercentageType(((CssComputedValue)cssValue).getCascadedValue());
            }
            if (n > 0 && n != 0x7FFFFFFE) {
                n3 |= 4;
            }
            CssValue cssValue2 = CssProvider.getEngineService().getComputedValueForElement(element, 31);
            if (CssProvider.getValueService().isAutoValue(cssValue2)) {
                n2 = 0x7FFFFFFE;
            } else {
                n2 = (int)cssValue2.getFloatValue();
                boolean bl3 = bl = bl || cssValue2 instanceof CssComputedValue && CssProvider.getValueService().isOfPrimitivePercentageType(((CssComputedValue)cssValue2).getCascadedValue());
            }
            if (n2 > 0 && n2 != 0x7FFFFFFE) {
                n3 |= 8;
            }
            if ((n <= 0 || n == 0x7FFFFFFE) && (n = image.getWidth(this.imageObserver)) <= 0) {
                n = 38;
            }
            if ((n2 <= 0 || n2 == 0x7FFFFFFE) && (n2 = image.getHeight(this.imageObserver)) <= 0) {
                n2 = 38;
            }
            if ((n3 & 0xC) != 0) {
                Toolkit.getDefaultToolkit().prepareImage(image, n, n2, this.imageObserver);
            } else {
                Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, this.imageObserver);
            }
            boolean bl4 = false;
            ImageBox imageBox = this;
            synchronized (imageBox) {
                if (this.image != null) {
                    if ((n3 & 4) == 4 || this.width == 0) {
                        this.width = n;
                    }
                    if ((n3 & 8) == 8 || this.height == 0) {
                        this.height = n2;
                    }
                } else {
                    bl4 = true;
                    if ((n3 & 4) == 4) {
                        this.width = n;
                    }
                    if ((n3 & 8) == 8) {
                        this.height = n2;
                    }
                }
                this.state |= n3;
                this.state = (this.state | 1) ^ 1;
            }
        } else {
            this.height = 38;
            this.width = 38;
            this.updateBorderForNoImage();
        }
        return bl;
    }

    private void safePreferenceChanged() {
        Thread.dumpStack();
    }

    private void updateBorderForNoImage() {
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    public int getBaseline() {
        return this.getHeight();
    }

    public int getContributingBaseline() {
        return 0;
    }

    private class ImageHandler
    implements ImageObserver {
        private ImageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if (ImageBox.this.image == null || ImageBox.this.image != image) {
                return false;
            }
            if ((n & 0xC0) != 0) {
                ImageBox.this.repaint(0L);
                ImageBox imageBox = ImageBox.this;
                synchronized (imageBox) {
                    if (ImageBox.this.image == image) {
                        ImageBox.this.image = null;
                        if ((ImageBox.this.state & 4) != 4) {
                            ImageBox.this.width = 38;
                        }
                        if ((ImageBox.this.state & 8) != 8) {
                            ImageBox.this.height = 38;
                        }
                        ImageBox.this.updateBorderForNoImage();
                    }
                    if ((ImageBox.this.state & 1) == 1) {
                        return false;
                    }
                }
                ImageBox.this.safePreferenceChanged();
                return false;
            }
            short s = 0;
            Element element = ImageBox.this.getElement();
            if ((n & 2) != 0 && !element.hasAttribute("height")) {
                s = (short)(s | 1);
            }
            if ((n & 1) != 0 && !element.hasAttribute("width")) {
                s = (short)(s | 2);
            }
            ImageBox imageBox = ImageBox.this;
            synchronized (imageBox) {
                if (ImageBox.this.image != image) {
                    return false;
                }
                if ((s & 1) == 1 && (ImageBox.this.state & 4) == 0) {
                    ImageBox.this.width = n4;
                }
                if ((s & 2) == 2 && (ImageBox.this.state & 8) == 0) {
                    ImageBox.this.height = n5;
                }
                if ((ImageBox.this.state & 1) == 1) {
                    return true;
                }
            }
            if ((n & 0x30) != 0) {
                ImageBox.this.repaint(0L);
            } else if ((n & 8) != 0 && sIsInc) {
                ImageBox.this.repaint(sIncRate);
            }
            return (n & 0x20) == 0;
        }
    }
}

