/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import javax.swing.JViewport;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssValue;
import org.netbeans.modules.visualweb.css2.BoxList;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.ContainerBox;
import org.netbeans.modules.visualweb.css2.CreateContext;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.FormatContext;
import org.netbeans.modules.visualweb.css2.LineBox;
import org.netbeans.modules.visualweb.css2.LineBoxGroup;
import org.netbeans.modules.visualweb.css2.ModelViewMapper;
import org.netbeans.modules.visualweb.css2.ViewportBox;
import org.netbeans.modules.visualweb.designer.CssUtilities;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DocumentBox
extends ContainerBox {
    private static final boolean debugstats = System.getProperty("designer.stats") != null;
    private static int numBoxes;
    private static int numLeaves;
    private static int maxChildren;
    private static int maxDepth;
    private static int maxElementDepth;
    private static int numElements;
    private static int textNodes;
    private static int textBoxes;
    private static int spaceBoxes;
    private static int blankTextNodes;
    protected FormatContext context;
    protected int layoutWidth;
    protected int layoutHeight;
    protected DesignerPane pane;
    protected JViewport viewport;
    protected int currWidth = -1;
    protected Element body;
    protected int maxWidth = -1;
    protected boolean layoutValid = false;
    protected BoxList fixedBoxes;
    protected int viewportX;
    protected int viewportY;

    public DocumentBox(DesignerPane designerPane, WebForm webForm, Element element, BoxType boxType, boolean bl, boolean bl2) {
        super(webForm, element, boxType, bl, bl2);
        this.pane = designerPane;
        this.body = element;
        this.x = 0;
        this.y = 0;
        this.width = 0;
        this.height = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createChildren(CreateContext createContext) {
        CreateContext createContext2 = createContext != null ? new CreateContext(createContext) : new CreateContext();
        createContext2.pushPage(this.webform);
        try {
            createContext2.metrics = CssUtilities.getDesignerFontMetricsForElement(this.body, null, this.webform.getDefaultFontSize());
            super.createChildren(createContext2);
            this.fixedBoxes = createContext2.getFixedBoxes();
        }
        finally {
            createContext2.popPage();
        }
    }

    public void relayout(FormatContext formatContext) {
        this.relayout(null, this.contentWidth, this.contentHeight, -1);
    }

    public void relayout(JViewport jViewport, int n, int n2, int n3) {
        long l;
        this.layoutValid = true;
        if (n == this.currWidth) {
            return;
        }
        if (n == Integer.MAX_VALUE) {
            return;
        }
        this.currWidth = n;
        int n4 = -1;
        if (n3 != -1) {
            n4 = n;
            n = n3;
        }
        if (debugstats) {
            CssProvider.getEngineService().clearEngineStyleLookupCount();
        }
        long l2 = 0L;
        long l3 = 0L;
        if (this.getBoxCount() == 0) {
            if (debugstats) {
                l3 = System.currentTimeMillis();
            }
            CssProvider.getEngineService().clearComputedStylesForElement(this.body);
            this.createChildren(null);
            if (debugstats) {
                l = System.currentTimeMillis();
                l2 = l - l3;
            }
        }
        if (debugstats) {
            l3 = System.currentTimeMillis();
        }
        this.initialize();
        if (this.leftMargin == 0x7FFFFFFE) {
            this.leftMargin = 0;
        }
        if (this.rightMargin == 0x7FFFFFFE) {
            this.rightMargin = 0;
        }
        if (this.topMargin == 0x7FFFFFFE) {
            this.topMargin = 0;
        }
        if (this.bottomMargin == 0x7FFFFFFE) {
            this.bottomMargin = 0;
        }
        this.width = n;
        this.height = n2;
        this.contentWidth = this.width != 0x7FFFFFFE ? this.width - (this.leftPadding + this.leftBorderWidth + this.leftMargin + this.rightMargin + this.rightBorderWidth + this.rightPadding) : 0x7FFFFFFE;
        this.contentHeight = this.height != 0x7FFFFFFE ? this.height - (this.topPadding + this.topBorderWidth + this.topMargin + this.bottomMargin + this.bottomBorderWidth + this.bottomPadding) : 0x7FFFFFFE;
        this.setContainingBlock(this.leftBorderWidth + this.leftPadding, this.topBorderWidth + this.topPadding, this.contentWidth, this.contentHeight);
        this.context = new FormatContext();
        this.context.initialCB = new ViewportBox(jViewport, n, n2);
        this.context.initialWidth = n;
        this.context.initialHeight = n2;
        try {
            this.layoutContext(this.context);
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
            throwable.printStackTrace();
            this.layoutValid = false;
            if (this.pane != null) {
                this.pane.repaint();
            }
            return;
        }
        if (n4 > this.width) {
            this.width = n4;
            this.contentWidth = this.width - (this.leftPadding + this.leftBorderWidth + this.leftMargin + this.rightMargin + this.rightBorderWidth + this.rightPadding);
        }
        this.updateSizeInfo();
        l = 0L;
        if (debugstats) {
            long l4 = System.currentTimeMillis();
            l = l4 - l3;
            StatusDisplayer.getDefault().setStatusText("Box Creation: " + l2 + " ms, layout: " + l + " ms");
        }
        if (debugstats) {
            this.gatherStatistics();
            System.out.println("\nLayout Statistics:\n");
            System.out.println("Number of boxes: " + numBoxes);
            System.out.println("Number of leaf boxes: " + numLeaves);
            System.out.println("Number of elements: " + numElements);
            System.out.println("Number of CSS style lookups: " + CssProvider.getEngineService().getEngineStyleLookupCount());
            System.out.println("Average lookups per box: " + CssProvider.getEngineService().getEngineStyleLookupCount() / numBoxes);
            if (numBoxes > numLeaves) {
                System.out.println("Average lookups per non-leaf box: " + CssProvider.getEngineService().getEngineStyleLookupCount() / (numBoxes - numLeaves));
            }
            System.out.println("Maximum box tree depth: " + maxDepth);
            System.out.println("Maximum element tree depth: " + maxElementDepth);
            System.out.println("Maximum child count: " + maxChildren);
            if (numBoxes > numLeaves) {
                System.out.println("Average child count: " + (numBoxes - 1) / (numBoxes - numLeaves));
            }
            System.out.println("Number of text nodes: " + textNodes);
            System.out.println("Number of blank-only text nodes: " + blankTextNodes);
            System.out.println("Number of text boxes: " + textBoxes);
            System.out.println("Number of space boxes: " + spaceBoxes);
            System.out.println("Box Creation: " + (double)l2 / 1000.0 + " sec");
            System.out.println("Layout Computation: " + (double)l / 1000.0 + " sec");
        }
    }

    protected void layoutContext(FormatContext formatContext) {
        super.relayout(formatContext);
        this.adjustFixedBoxesIssue99918();
    }

    private void adjustFixedBoxesIssue99918() {
        BoxList boxList = this.fixedBoxes;
        if (boxList == null) {
            return;
        }
        int n = boxList.size();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = boxList.get(i);
            this.adjustFixedBoxLeftIssue99918(cssBox);
            this.adjustFixedBoxTopIssue99918(cssBox);
        }
    }

    private void adjustFixedBoxLeftIssue99918(CssBox cssBox) {
        ContainerBox containerBox;
        if (CssProvider.getValueService().isAutoValue(CssProvider.getEngineService().getComputedValueForElement(cssBox.getElement(), 39)) && (containerBox = cssBox.getParent()) != null && containerBox != cssBox.getPositionedBy()) {
            cssBox.left += containerBox.getAbsoluteX();
            cssBox.setX(cssBox.left);
        }
    }

    private void adjustFixedBoxTopIssue99918(CssBox cssBox) {
        ContainerBox containerBox;
        if (CssProvider.getValueService().isAutoValue(CssProvider.getEngineService().getComputedValueForElement(cssBox.getElement(), 41)) && (containerBox = cssBox.getParent()) != null && containerBox != cssBox.getPositionedBy()) {
            cssBox.top += containerBox.getAbsoluteY();
            cssBox.setY(cssBox.top);
        }
    }

    protected void updateSizeInfo() {
        this.updateExtents(0, 0, 0);
        int n = this.extentX2 - this.extentX;
        int n2 = this.extentY2 - this.extentY;
        this.width = n;
        this.height = n2;
        this.contentWidth = this.width - (this.leftPadding + this.leftBorderWidth + this.leftMargin + this.rightMargin + this.rightBorderWidth + this.rightPadding);
        this.contentHeight = this.height - (this.topPadding + this.topBorderWidth + this.topMargin + this.bottomMargin + this.bottomBorderWidth + this.bottomPadding);
        this.layoutWidth = this.width;
        this.layoutHeight = this.height;
    }

    public void redoLayout(boolean bl) {
        this.currWidth = -1;
        this.removeBoxes();
        this.layoutValid = false;
        this.webform.getManager().updateInsertBox();
        if (bl) {
            this.relayout(null);
        }
    }

    public void printLayout(StringBuffer stringBuffer) {
        stringBuffer.append("\nLAYOUT for " + this + "\n----------------\n");
        stringBuffer.append("\nInline Content/Lineboxes:");
        DocumentBox.printLayout(this, stringBuffer, 0);
    }

    public int getAbsoluteX() {
        return this.leftMargin;
    }

    public int getAbsoluteY() {
        return this.effectiveTopMargin;
    }

    public void inserted(Node node, Node node2) {
        Object object;
        int n;
        Object object2;
        Node node3;
        Object object3;
        Node node4;
        ContainerBox containerBox;
        Element element;
        assert (node2 != null);
        assert (node2.getNodeType() == 1);
        assert (node.getNodeType() == 1);
        if (!this.layoutValid) {
            this.redoLayout(false);
            return;
        }
        if (this.context == null) {
            return;
        }
        Element element2 = null;
        CssBox cssBox = null;
        if (node.getNodeType() == 3 || node.getNodeType() == 4 || node.getNodeType() == 5) {
            this.redoLayout(true);
            return;
        }
        if (node.getNodeType() == 1) {
            element2 = (Element)node;
            element = CssProvider.getEngineService().getComputedValueForElement(element2, 22);
            if (CssProvider.getValueService().isTableRowValue((CssValue)element) || CssProvider.getValueService().isTableCellValue((CssValue)element)) {
                while (element2 != null && !CssProvider.getValueService().isTableValue(CssProvider.getEngineService().getComputedValueForElement(element2, 22))) {
                    element2 = (Element)node2;
                    node2 = element2.getParentNode();
                }
                if (element2 == null) {
                    ErrorManager.getDefault().log("Unexpected <td> outside of a table: " + node);
                    this.redoLayout(true);
                    return;
                }
                if (node != element2) {
                    this.changed(node, node.getParentNode(), null);
                    return;
                }
                node = element2;
            }
            cssBox = this.getWebForm().findCssBoxForElement(element2);
        }
        element = (Element)node2;
        CssBox cssBox2 = ModelViewMapper.findBox(this.webform.getPane().getPageBox(), element);
        if (cssBox2 instanceof ContainerBox) {
            containerBox = (ContainerBox)cssBox2;
        } else {
            if (cssBox2 != null) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("There was expected ContainerBox for parent element=" + element + ", but it is box=" + cssBox2));
            }
            containerBox = null;
        }
        if (containerBox == null) {
            this.redoLayout(true);
            return;
        }
        if (containerBox instanceof LineBox) {
            containerBox = containerBox.getParent();
        }
        CreateContext createContext = new CreateContext();
        createContext.pushPage(this.webform);
        createContext.metrics = CssUtilities.getDesignerFontMetricsForElement(this.body, null, this.webform.getDefaultFontSize());
        for (node4 = node.getPreviousSibling(); node4 != null && (node4.getNodeType() == 3 && DesignerUtils.onlyWhitespace(node4.getNodeValue()) || node4.getNodeType() == 1 && ((object3 = HtmlTag.getTag((String)(node3 = (Element)node4).getTagName())) != null && object3.isHiddenTag() || object3 == HtmlTag.INPUT && node3.getAttribute("type").equals("hidden"))); node4 = node4.getPreviousSibling()) {
        }
        for (node3 = node.getNextSibling(); node3 != null && (node3.getNodeType() == 3 && DesignerUtils.onlyWhitespace(node3.getNodeValue()) || node3.getNodeType() == 1 && ((object2 = HtmlTag.getTag((String)(object3 = (Element)node3).getTagName())) != null && object2.isHiddenTag() || object2 == HtmlTag.INPUT && object3.getAttribute("type").equals("hidden"))); node3 = node3.getNextSibling()) {
        }
        object3 = null;
        if (node4 != null) {
            object3 = node4.getNodeType() == 1 ? this.getWebForm().findCssBoxForElement((Element)node4) : ModelViewMapper.findBox(containerBox, node4, 0);
        }
        object2 = null;
        if (node3 != null) {
            object2 = node3.getNodeType() == 1 ? this.getWebForm().findCssBoxForElement((Element)node3) : ModelViewMapper.findBox(containerBox, node3, 0);
        }
        if (object2 == null && object3 != null) {
            n = ((CssBox)object3).getParentIndex() + 1;
            if (((CssBox)object3).getParent() instanceof LineBoxGroup) {
                object = ((LineBoxGroup)((CssBox)object3).getParent()).getManagedBoxes();
                if (((BoxList)object).size() > n) {
                    object2 = ((BoxList)object).get(n);
                }
            } else if (((CssBox)object3).getParent().getBoxCount() > n) {
                object2 = ((CssBox)object3).getParent().getBox(n);
            }
            if (object2 != null && (object = ModelViewMapper.findClosestComponentRootElement(this.webform, ((CssBox)object3).getElement())) == ModelViewMapper.findClosestComponentRootElement(this.webform, ((CssBox)object2).getElement()) && object != ModelViewMapper.findClosestComponentRootElement(this.webform, node)) {
                object3 = this.getWebForm().findCssBoxForElement((Element)object);
                object2 = null;
            }
        } else if (object2 != null && object3 == null) {
            n = ((CssBox)object2).getParentIndex() - 1;
            if (n >= 0) {
                object3 = ((CssBox)object2).getParent() instanceof LineBoxGroup ? ((LineBoxGroup)((CssBox)object2).getParent()).getManagedBoxes().get(n) : ((CssBox)object2).getParent().getBox(n);
            }
            if (object3 != null && (object = ModelViewMapper.findClosestComponentRootElement(this.webform, ((CssBox)object2).getElement())) == ModelViewMapper.findClosestComponentRootElement(this.webform, ((CssBox)object3).getElement()) && object != ModelViewMapper.findClosestComponentRootElement(this.webform, node)) {
                object3 = null;
                object2 = this.getWebForm().findCssBoxForElement((Element)object);
            }
        }
        if (object3 != null && ((CssBox)object3).isInlineBox() && object2 != null && ((CssBox)object2).isInlineBox()) {
            this.redoLayout(true);
            return;
        }
        try {
            containerBox.addNode(createContext, node, null, (CssBox)object3, (CssBox)object2);
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(16, throwable);
            this.redoLayout(true);
            return;
        }
        if (createContext.getFixedBoxes() != null) {
            if (this.fixedBoxes == null) {
                this.fixedBoxes = createContext.getFixedBoxes();
            } else {
                BoxList boxList = createContext.getFixedBoxes();
                int n2 = boxList.size();
                for (int i = 0; i < n2; ++i) {
                    this.fixedBoxes.add(boxList.get(i), null, null);
                }
            }
        }
        if (cssBox == null && (cssBox = this.getWebForm().findCssBoxForElement(element2)) == null) {
            this.redoLayout(true);
            return;
        }
        if (createContext.prevChangedBox != null) {
            this.updateLayout(createContext.prevChangedBox);
        }
        CssProvider.getEngineService().clearComputedStylesForElement(cssBox.getElement());
        this.updateLayout(cssBox);
        if (createContext.nextChangedBox != null) {
            this.updateLayout(createContext.nextChangedBox);
        }
        this.adjustFixedBoxesIssue99918();
        this.updateSizeInfo();
        if (Math.abs(this.extentX) > 50000 || Math.abs(this.extentY) > 50000 || Math.abs(this.extentX2) > 50000 || Math.abs(this.extentY2) > 50000) {
            this.redoLayout(true);
            return;
        }
        this.webform.getManager().updateInsertBox();
        if (this.pane != null) {
            this.pane.repaint();
        }
    }

    public void removed(Node node, Node node2) {
        this.boxes = null;
        this.redoLayout(false);
    }

    public void changed(Node node, Node node2, Element[] elementArray) {
        boolean bl;
        Object object2;
        assert (node2 != null);
        if (!this.layoutValid) {
            this.redoLayout(false);
            return;
        }
        if (this.context == null) {
            return;
        }
        Element element = null;
        CssBox cssBox = null;
        if (node.getNodeType() == 3 || node.getNodeType() == 4 || node.getNodeType() == 5) {
            this.redoLayout(true);
            return;
        }
        if (node.getNodeType() == 1) {
            element = (Element)node;
            object2 = CssProvider.getEngineService().getComputedValueForElement(element, 22);
            if (CssProvider.getValueService().isTableRowValue((CssValue)object2) || CssProvider.getValueService().isTableCellValue((CssValue)object2)) {
                while (element != null && node2 instanceof Element && !CssProvider.getValueService().isTableValue(CssProvider.getEngineService().getComputedValueForElement(element, 22))) {
                    element = (Element)node2;
                    node2 = element.getParentNode();
                }
                if (element == null) {
                    this.redoLayout(true);
                    return;
                }
                node = element;
            }
        } else {
            this.redoLayout(true);
            return;
        }
        cssBox = this.getWebForm().findCssBoxForElement(element);
        if (elementArray == null || elementArray.length == 0) {
            CssProvider.getEngineService().clearComputedStylesForElement(element);
        } else {
            for (Element object3 : elementArray) {
                CssProvider.getEngineService().clearComputedStylesForElement(object3);
            }
        }
        if (cssBox == null) {
            this.redoLayout(true);
            return;
        }
        object2 = cssBox.getParent();
        if (object2 instanceof LineBox) {
            object2 = ((CssBox)object2).getParent();
        }
        CreateContext createContext = new CreateContext();
        createContext.pushPage(this.webform);
        createContext.metrics = CssUtilities.getDesignerFontMetricsForElement(this.body, null, this.webform.getDefaultFontSize());
        CssBox[] cssBoxArray = ((ContainerBox)object2).getBoxesToRemove(cssBox);
        ((ContainerBox)object2).addNode(createContext, node, null, cssBox, null);
        CssBox cssBox2 = cssBox;
        boolean bl2 = false;
        for (CssBox cssBox3 : cssBoxArray) {
            if (!((ContainerBox)object2).removeBox(cssBox3)) continue;
            bl2 = true;
        }
        if (!bl2) {
            this.redoLayout(true);
            return;
        }
        if (this.fixedBoxes != null) {
            this.fixedBoxes.remove(cssBox);
            if (this.fixedBoxes.size() == 0) {
                this.fixedBoxes = null;
            }
        }
        if (createContext.getFixedBoxes() != null) {
            if (this.fixedBoxes == null) {
                this.fixedBoxes = createContext.getFixedBoxes();
            } else {
                BoxList bl3 = createContext.getFixedBoxes();
                int n = bl3.size();
                for (int i = 0; i < n; ++i) {
                    this.fixedBoxes.add(bl3.get(i), null, null);
                }
            }
        }
        if ((cssBox = this.getWebForm().findCssBoxForElement(element)) == null) {
            this.redoLayout(true);
            return;
        }
        if (createContext.prevChangedBox != null) {
            this.updateLayout(createContext.prevChangedBox);
        }
        boolean bl4 = bl = cssBox.getParent() != object2;
        if (bl) {
            this.redoLayout(true);
            return;
        }
        this.updateLayout(cssBox);
        if (createContext.nextChangedBox != null) {
            assert (false);
            this.updateLayout(createContext.nextChangedBox);
        }
        this.adjustFixedBoxesIssue99918();
        this.updateSizeInfo();
        if (Math.abs(this.extentX) > 50000 || Math.abs(this.extentY) > 50000 || Math.abs(this.extentX2) > 50000 || Math.abs(this.extentY2) > 50000) {
            this.redoLayout(true);
            return;
        }
        this.webform.getManager().updateInsertBox();
        if (this.pane != null) {
            this.pane.repaint();
        }
    }

    protected CssBox updateLayout(CssBox cssBox) {
        ContainerBox containerBox = cssBox.getParent();
        if (containerBox instanceof LineBoxGroup && containerBox.containingBlockWidth <= 0) {
            containerBox.getParent().setContainingBlock(containerBox, this.context);
        }
        containerBox.layoutChild(cssBox, this.context, true);
        return containerBox.notifyChildResize(cssBox, this.context);
    }

    private void gatherStatistics() {
        numBoxes = 0;
        maxChildren = 0;
        maxDepth = 0;
        maxElementDepth = 0;
        numLeaves = 0;
        numElements = 0;
        textNodes = 0;
        textBoxes = 0;
        spaceBoxes = 0;
        blankTextNodes = 0;
        this.gatherStatisticsBoxTree(this, 0);
        this.gatherStatisticsElementTree(this.body, 0);
    }

    private void gatherStatisticsBoxTree(CssBox cssBox, int n) {
        int n2 = cssBox.getBoxCount();
        for (int i = 0; i < n2; ++i) {
            CssBox cssBox2 = cssBox.getBox(i);
            this.gatherStatisticsBoxTree(cssBox2, n + 1);
        }
        ++numBoxes;
        if (n > maxDepth) {
            maxDepth = n;
        }
        if (n2 > maxChildren) {
            maxChildren = n2;
        }
        if (n2 == 0) {
            ++numLeaves;
        }
        if (cssBox.getBoxType() == BoxType.TEXT) {
            ++textBoxes;
        } else if (cssBox.getBoxType() == BoxType.SPACE) {
            ++spaceBoxes;
        }
    }

    private void gatherStatisticsElementTree(Node node, int n) {
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node2 = nodeList.item(i);
            this.gatherStatisticsElementTree(node2, n + 1);
        }
        ++numElements;
        if (n > maxElementDepth) {
            maxElementDepth = n;
        }
        if (node.getNodeType() == 3 || node.getNodeType() == 4) {
            ++textNodes;
            if (DesignerUtils.onlyWhitespace(node.getNodeValue())) {
                ++blankTextNodes;
            }
        }
    }
}

