/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.SpaceBox;
import org.netbeans.modules.visualweb.css2.TextBox;
import org.openide.ErrorManager;
import org.w3c.dom.Element;

public class BoxList {
    private CssBox[] boxes;
    private int size = 0;
    private boolean keepSorted;
    private boolean isSorted;
    private boolean mustSort;
    private boolean syncParentIndices = true;

    public BoxList(int n) {
        if (n < 1) {
            n = 2;
        }
        this.boxes = new CssBox[n];
    }

    public int size() {
        return this.size;
    }

    public void setKeepSorted(boolean bl) {
        this.keepSorted = bl;
    }

    public void setSyncParentIndices(boolean bl) {
        this.syncParentIndices = bl;
    }

    public CssBox get(int n) {
        if (this.keepSorted && !this.isSorted) {
            this.zsort();
        }
        if (n < 0 || n >= this.size) {
            ErrorManager.getDefault().notify(1, (Throwable)new IndexOutOfBoundsException("Index=" + n + ", expected to be in [0," + (this.size - 1) + "]."));
            return null;
        }
        return this.boxes[n];
    }

    public int indexOf(CssBox cssBox) {
        if (this.keepSorted && !this.isSorted) {
            this.zsort();
        }
        List<CssBox> list = Arrays.asList(this.boxes);
        return list.indexOf(cssBox);
    }

    public boolean remove(CssBox cssBox) {
        int n;
        this.isSorted = false;
        for (n = 0; n < this.size && this.boxes[n] != cssBox; ++n) {
        }
        if (n < this.size) {
            int n2 = this.size - n - 1;
            if (n2 > 0) {
                System.arraycopy(this.boxes, n + 1, this.boxes, n, n2);
            }
            this.boxes[--this.size] = null;
            if (this.syncParentIndices) {
                for (int i = n; i < this.size; ++i) {
                    this.boxes[i].setParentIndex(i);
                }
            }
        } else {
            ErrorManager.getDefault().log("Didn't find box " + cssBox + " in the box list - illegal remove call");
            return false;
        }
        if (this.syncParentIndices) {
            cssBox.setParentIndex(-1);
        }
        return true;
    }

    public void add(CssBox cssBox, CssBox cssBox2, CssBox cssBox3) {
        int n;
        this.isSorted = false;
        if (this.keepSorted && cssBox.getElement() != null) {
            cssBox.initializeZOrder();
            if (cssBox.z != 0x7FFFFFFE) {
                this.mustSort = true;
            }
        }
        if (cssBox2 == null && cssBox3 == null) {
            this.ensureCapacity(this.size + 1);
            this.boxes[this.size++] = cssBox;
            if (this.syncParentIndices) {
                cssBox.setParentIndex(this.size - 1);
            }
            return;
        }
        if (cssBox2 != null) {
            for (n = 0; n < this.size; ++n) {
                if (this.boxes[n] != cssBox2) continue;
                ++n;
                break;
            }
        }
        if (cssBox3 != null) {
            while (n < this.size && this.boxes[n] != cssBox3) {
                ++n;
            }
        }
        if (n < this.size) {
            this.ensureCapacity(this.size + 1);
            System.arraycopy(this.boxes, n, this.boxes, n + 1, this.size - n);
            this.boxes[n] = cssBox;
            if (this.syncParentIndices) {
                cssBox.setParentIndex(n);
            }
            ++this.size;
            if (this.syncParentIndices) {
                for (int i = n + 1; i < this.size; ++i) {
                    this.boxes[i].setParentIndex(i);
                }
            }
        } else {
            this.ensureCapacity(this.size + 1);
            this.boxes[this.size++] = cssBox;
            if (this.syncParentIndices) {
                cssBox.setParentIndex(this.size - 1);
            }
            return;
        }
    }

    private void ensureCapacity(int n) {
        int n2 = this.boxes.length;
        if (n > n2) {
            CssBox[] cssBoxArray = this.boxes;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.boxes = new CssBox[n3];
            System.arraycopy(cssBoxArray, 0, this.boxes, 0, this.size);
        }
    }

    public void zsort() {
        if (!this.keepSorted || !this.mustSort || this.boxes == null || this.size < 2) {
            this.isSorted = true;
            return;
        }
        Arrays.sort(this.boxes, 0, this.size, new CssBoxComparator());
        if (this.syncParentIndices) {
            for (int i = 0; i < this.size; ++i) {
                this.boxes[i].setParentIndex(i);
            }
        }
        this.isSorted = true;
    }

    public void truncate(int n) {
        assert (n <= this.size);
        for (int i = n + 1; i < this.size; ++i) {
            this.boxes[i] = null;
        }
        this.size = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            CssBox cssBox = this.get(i);
            String string = cssBox.getClass().getName();
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            stringBuffer.append(string2);
            stringBuffer.append(':');
            Element element = cssBox.getElement();
            if (element != null) {
                stringBuffer.append(element.toString());
                continue;
            }
            if (cssBox instanceof TextBox) {
                stringBuffer.append(((TextBox)cssBox).getText());
                continue;
            }
            if (cssBox instanceof SpaceBox) {
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(cssBox.toString());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CssBoxComparator
    implements Comparator<CssBox> {
        private CssBoxComparator() {
        }

        @Override
        public int compare(CssBox cssBox, CssBox cssBox2) {
            if (cssBox.z == cssBox2.z) {
                return 0;
            }
            if (cssBox.z == 0x7FFFFFFE) {
                return -1;
            }
            if (cssBox2.z == 0x7FFFFFFE) {
                return 1;
            }
            return cssBox.z - cssBox2.z;
        }
    }
}

