/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.junit.output.CallstackFrameNode;
import org.netbeans.modules.junit.output.Report;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TestMethodNodeChildren
extends Children.Array {
    private final Report.Testcase testcase;
    private final Collection<Node> childNodes;

    private TestMethodNodeChildren(Collection<Node> collection, Report.Testcase testcase) {
        super(collection);
        this.childNodes = collection;
        this.testcase = testcase;
    }

    public TestMethodNodeChildren(Report.Testcase testcase) {
        this(new ArrayList<Node>(TestMethodNodeChildren.getChildrenCount(testcase)), testcase);
    }

    static int getChildrenCount(Report.Testcase testcase) {
        Report.Trouble trouble = testcase.trouble;
        if (trouble == null) {
            return 0;
        }
        int n = 0;
        if (trouble.message != null) {
            ++n;
        }
        if (trouble.exceptionClsName != null) {
            ++n;
        }
        if (trouble.stackTrace != null) {
            n += trouble.stackTrace.length;
        }
        return n;
    }

    protected void addNotify() {
        Report.Trouble trouble = this.testcase.trouble;
        if (trouble.message != null) {
            this.childNodes.add((Node)new CallstackFrameNode(trouble, trouble.message));
        }
        if (trouble.exceptionClsName != null) {
            this.childNodes.add((Node)new CallstackFrameNode(trouble, trouble.exceptionClsName));
        }
        if (trouble.stackTrace != null) {
            for (String string : trouble.stackTrace) {
                this.childNodes.add((Node)new CallstackFrameNode(string));
            }
        }
        if (trouble.nestedTrouble != null) {
            trouble = trouble.nestedTrouble;
            do {
                String[] stringArray = trouble.stackTrace;
                StringBuilder stringBuilder = new StringBuilder(200);
                stringBuilder.append("Caused by: ");
                stringBuilder.append(trouble.exceptionClsName);
                if (trouble.message != null) {
                    stringBuilder.append(": ").append(trouble.message);
                }
                this.childNodes.add((Node)new CallstackFrameNode(trouble, stringBuilder.toString()));
                if (stringArray == null) continue;
                for (String string : stringArray) {
                    this.childNodes.add((Node)new CallstackFrameNode(string));
                }
            } while ((trouble = trouble.nestedTrouble) != null);
        }
        super.addNotify();
    }
}

