/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.DeviceTheme;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfoPresenter;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.filesystems.FileObject;

public final class ScreenSupport {
    private ScreenSupport() {
    }

    public static Font getFont(DesignComponent designComponent) {
        if (designComponent == null) {
            return null;
        }
        return ScreenSupport.getFont(ScreenSupport.getDeviceInfo(designComponent.getDocument()), designComponent);
    }

    public static Font getFont(DesignDocument designDocument, int n, int n2, int n3, int n4) {
        ScreenDeviceInfo screenDeviceInfo = ScreenSupport.getDeviceInfo(designDocument);
        if (n == 0) {
            return screenDeviceInfo.getDeviceTheme().getFont(DeviceTheme.FontType.DEFAULT);
        }
        if (n == 2) {
            return screenDeviceInfo.getDeviceTheme().getFont(DeviceTheme.FontType.STATIC_TEXT);
        }
        if (n == 3) {
            return screenDeviceInfo.getDeviceTheme().getFont(DeviceTheme.FontType.INPUT_TEXT);
        }
        DeviceTheme.FontFace fontFace = DeviceTheme.FontFace.SYSTEM;
        if (n2 == 32) {
            fontFace = DeviceTheme.FontFace.MONOSPACE;
        } else if (n2 == 64) {
            fontFace = DeviceTheme.FontFace.PROPORTIONAL;
        }
        EnumSet<DeviceTheme.FontStyle> enumSet = EnumSet.of(DeviceTheme.FontStyle.PLAIN);
        if ((n3 & 1) != 0) {
            enumSet.add(DeviceTheme.FontStyle.BOLD);
        }
        if ((n3 & 2) != 0) {
            enumSet.add(DeviceTheme.FontStyle.ITALIC);
        }
        if ((n3 & 4) != 0) {
            enumSet.add(DeviceTheme.FontStyle.UNDERLINED);
        }
        DeviceTheme.FontSize fontSize = DeviceTheme.FontSize.MEDIUM;
        if (n4 == 8) {
            fontSize = DeviceTheme.FontSize.SMALL;
        } else if (n4 == 16) {
            fontSize = DeviceTheme.FontSize.LARGE;
        }
        return screenDeviceInfo.getDeviceTheme().getFont(fontFace, enumSet, fontSize);
    }

    public static ScreenDeviceInfo getDeviceInfo(final DesignDocument designDocument) {
        final ScreenDeviceInfo[] screenDeviceInfoArray = new ScreenDeviceInfo[1];
        if (designDocument == null) {
            return null;
        }
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = designDocument.getRootComponent();
                ScreenDeviceInfoPresenter screenDeviceInfoPresenter = (ScreenDeviceInfoPresenter)designComponent.getPresenter(ScreenDeviceInfoPresenter.class);
                if (screenDeviceInfoPresenter == null) {
                    throw Debug.error((Object[])new Object[]{"No ScreenDevice attached to the root component"});
                }
                screenDeviceInfoArray[0] = screenDeviceInfoPresenter.getScreenDeviceInfo();
            }
        });
        return screenDeviceInfoArray[0];
    }

    public static Font getFont(ScreenDeviceInfo screenDeviceInfo, DesignComponent designComponent) {
        if (designComponent == null) {
            return screenDeviceInfo.getDeviceTheme().getFont(DeviceTheme.FontType.DEFAULT);
        }
        PropertyValue propertyValue = designComponent.readProperty("fontKind");
        int n = !PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind()) ? MidpTypes.getInteger(propertyValue) : 0;
        propertyValue = designComponent.readProperty("face");
        int n2 = !PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind()) ? MidpTypes.getInteger(propertyValue) : 0;
        propertyValue = designComponent.readProperty("style");
        int n3 = !PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind()) ? MidpTypes.getInteger(propertyValue) : 0;
        propertyValue = designComponent.readProperty("bold");
        int n4 = !PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind()) ? MidpTypes.getInteger(propertyValue) : 0;
        return ScreenSupport.getFont(designComponent.getDocument(), n, n2, n3, n4);
    }

    public static Icon getIconFromImageComponent(DesignComponent designComponent) {
        if (designComponent == null) {
            return null;
        }
        PropertyValue propertyValue = designComponent.readProperty("resourcePath");
        String string = null;
        if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) {
            string = MidpTypes.getString(designComponent.readProperty("resourcePath"));
        }
        if (string == null) {
            return null;
        }
        DesignDocument designDocument = designComponent.getDocument();
        Map<FileObject, FileObject> map = MidpProjectSupport.getFileObjectsForRelativeResourcePath(designDocument, string);
        if (map == null || !map.keySet().iterator().hasNext()) {
            return null;
        }
        FileObject fileObject = map.keySet().iterator().next();
        if (fileObject != null) {
            return ScreenSupport.resolveImageForRoot(fileObject, string);
        }
        Debug.warning((Object[])new Object[]{"Resource path property in", designComponent, "contains incorrect value"});
        return null;
    }

    public static FileObject getFileObjectFromImageComponent(DesignComponent designComponent) {
        if (designComponent == null) {
            return null;
        }
        PropertyValue propertyValue = designComponent.readProperty("resourcePath");
        String string = null;
        if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) {
            string = MidpTypes.getString(designComponent.readProperty("resourcePath"));
        }
        if (string == null) {
            return null;
        }
        DesignDocument designDocument = designComponent.getDocument();
        Map<FileObject, FileObject> map = MidpProjectSupport.getFileObjectsForRelativeResourcePath(designDocument, string);
        if (map == null || !map.keySet().iterator().hasNext()) {
            return null;
        }
        FileObject fileObject = map.keySet().iterator().next();
        if (fileObject != null) {
            return fileObject;
        }
        Debug.warning((Object[])new Object[]{"Resource path property in", designComponent, "contains incorrect value"});
        return null;
    }

    public static int getFontHeight(Graphics graphics, Font font) {
        assert (graphics != null && font != null);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        return fontMetrics.getHeight();
    }

    private static Icon resolveImageForRoot(FileObject fileObject, String string) {
        try {
            BufferedImage bufferedImage = ImageIO.read(fileObject.getInputStream());
            if (bufferedImage != null) {
                return new ImageIcon(bufferedImage);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }
}

