/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.timezone;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.netbeans.modules.vmd.midp.propertyeditors.timezone.TimeZoneComboboxModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorTimeZone
extends PropertyEditorUserCode {
    private TimeZoneEditor timeZoneEditor = new TimeZoneEditor();

    private PropertyEditorTimeZone() {
        super(NbBundle.getMessage(PropertyEditorTimeZone.class, (String)"LBL_TIME_ZONE_UCLABEL"));
        this.initElements(Collections.singleton(this.timeZoneEditor));
    }

    public static PropertyEditorTimeZone createInstance() {
        return new PropertyEditorTimeZone();
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.timeZoneEditor != null) {
            this.timeZoneEditor.cleanUp();
            this.timeZoneEditor = null;
        }
    }

    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return (String)propertyValue.getPrimitiveValue();
    }

    private void saveValue(String string) {
        if (string.length() > 0) {
            super.setValue((Object)MidpTypes.createStringValue(string));
        }
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.timeZoneEditor.getRadioButton().isSelected()) {
            this.saveValue(this.timeZoneEditor.getTextForPropertyValue());
        }
    }

    private final class TimeZoneEditor
    implements PropertyEditorElement,
    ActionListener {
        private JRadioButton radioButton = new JRadioButton();
        private TimeZoneComboboxModel model;
        private JComboBox combobox;

        public TimeZoneEditor() {
            Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorTimeZone.class, (String)"LBL_TIMEZONE"));
            this.model = new TimeZoneComboboxModel();
            this.combobox = new JComboBox(this.model);
            this.combobox.setEditable(true);
            this.combobox.addActionListener(this);
        }

        void cleanUp() {
            this.radioButton = null;
            this.model = null;
            if (this.combobox != null) {
                this.combobox.removeActionListener(this);
                this.combobox = null;
            }
        }

        public void updateState(PropertyValue propertyValue) {
            if (!PropertyEditorTimeZone.this.isCurrentValueANull() && propertyValue != null) {
                for (int i = 0; i < this.model.getSize(); ++i) {
                    String string = (String)this.model.getElementAt(i);
                    if (!string.equals(propertyValue.getPrimitiveValue())) continue;
                    this.model.setSelectedItem(string);
                    break;
                }
            }
        }

        public void setTextForPropertyValue(String string) {
            PropertyEditorTimeZone.this.saveValue(string);
        }

        public String getTextForPropertyValue() {
            return (String)this.combobox.getSelectedItem();
        }

        public JComponent getCustomEditorComponent() {
            return this.combobox;
        }

        public JRadioButton getRadioButton() {
            return this.radioButton;
        }

        public boolean isInitiallySelected() {
            return true;
        }

        public boolean isVerticallyResizable() {
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.radioButton.setSelected(true);
        }
    }
}

